/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.workflow.local.dto.ProcessValidateDto;
import com.biz.crm.workflow.local.entity.ProcessTemplate;
import com.biz.crm.workflow.local.entity.ProcessTemplateNode;
import com.biz.crm.workflow.local.repository.ProcessTemplateNodeRepository;
import com.biz.crm.workflow.local.service.BpmValidateService;
import com.biz.crm.workflow.local.service.ProcessService;
import com.biz.crm.workflow.local.service.ProcessTaskService;
import com.biz.crm.workflow.local.service.ProcessTemplateNodeUserTaskService;
import com.biz.crm.workflow.local.service.ProcessTemplateService;
import com.biz.crm.workflow.local.validator.MyFlowableValidator;
import com.biz.crm.workflow.local.vo.BpmValidateVo;
import com.biz.crm.workflow.local.vo.ProcessCheckRecordItemVo;
import com.biz.crm.workflow.local.vo.ProcessCheckRecordVo;
import com.biz.crm.workflow.local.vo.ProcessTracingStrategyVo;
import com.biz.crm.workflow.local.vo.ValidateSequenceVo;
import com.biz.crm.workflow.sdk.constant.ProcessConstant;
import com.biz.crm.workflow.sdk.dto.ProcessInstanceDto;
import com.biz.crm.workflow.sdk.dto.ProcessTemplateDto;
import com.biz.crm.workflow.sdk.dto.ProcessUserDto;
import com.biz.crm.workflow.sdk.service.ProcessTemplateNodeService;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateNodeAssigneeVo;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateNodeUserTaskVo;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateNodeVo;
import com.biz.crm.workflow.sdk.vo.UserVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.bpmn.model.UserTask;
import org.flowable.common.engine.impl.identity.Authentication;
import org.flowable.engine.HistoryService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.TaskService;
import org.flowable.engine.history.HistoricActivityInstanceQuery;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskQuery;
import org.flowable.validation.ProcessValidator;
import org.flowable.validation.ProcessValidatorFactory;
import org.flowable.validation.ValidationError;
import org.flowable.validation.validator.Validator;
import org.flowable.validation.validator.ValidatorSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
public class BpmValidateServiceImpl
implements BpmValidateService {
    @Autowired
    protected RuntimeService runtimeService;
    @Autowired
    protected TaskService taskService;
    @Autowired
    private ProcessService processService;
    @Autowired
    private MyFlowableValidator myFlowableValidator;
    @Autowired
    private ProcessTemplateService processTemplateService;
    @Autowired
    private ProcessTemplateNodeUserTaskService processTemplateNodeUserTaskService;
    @Autowired
    private ProcessTemplateNodeService processTemplateNodeService;
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private ProcessTaskService processTaskService;
    @Autowired
    private ProcessTemplateNodeRepository processTemplateNodeRepository;
    @Autowired
    private HistoryService historyService;
    @Value(value="#{'${simpleExpression.functionCodes:}'.split(',')}")
    private List<String> simpleExpressions;
    private static final String GATEWAY = "Gateway";
    private static final String EVENT = "Event";
    private static final String ACTIVITY = "Activity";
    private static final String FLOW = "Flow";

    @Override
    @Transactional
    public BpmValidateVo bpmValidate(ProcessTemplateDto dto) {
        BpmValidateVo bpmValidateVo = new BpmValidateVo();
        Validate.notNull((Object)dto.getProcessTemplateXmlDto(), (String)"xmlStr\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.initTemplate(dto);
        dto.setReleaseStatus(EnableStatusEnum.DISABLE.getCode());
        ProcessTemplate processTemplate = this.processTemplateService.create(dto);
        BpmnModel bpmnModel = this.processService.xmlToBpmnModel(dto.getProcessTemplateXmlDto().getProcessDesc());
        ProcessValidator validator = new ProcessValidatorFactory().createDefaultProcessValidator();
        ValidatorSet validatorSet = new ValidatorSet("My Validator");
        validatorSet.addValidator((Validator)this.myFlowableValidator);
        validator.getValidatorSets().add(validatorSet);
        ((Process)bpmnModel.getProcesses().get(0)).setDocumentation(processTemplate.getId());
        List errorList = validator.validate(bpmnModel);
        ArrayList processTracingStrategyVos = Lists.newArrayList();
        ArrayList validateSequenceVos = Lists.newArrayList();
        this.validateUserTask((Process)bpmnModel.getProcesses().get(0), errorList, processTracingStrategyVos, validateSequenceVos, dto.getSubmitUserCode());
        List<ValidationError> errors = errorList.stream().filter(ValidationError::isWarning).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(errors)) {
            bpmValidateVo.setErrors(errors);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return bpmValidateVo;
        }
        bpmValidateVo.setValidateSequenceVos(validateSequenceVos);
        bpmValidateVo.setTaskVos(processTracingStrategyVos);
        TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        return bpmValidateVo;
    }

    @Override
    @Transactional
    public ProcessCheckRecordVo processValidate(ProcessValidateDto dto) {
        ProcessInstance processInstance;
        ProcessCheckRecordVo recordVo = new ProcessCheckRecordVo();
        this.initTemplate(dto.getTemplateDto());
        dto.getTemplateDto().setReleaseStatus(EnableStatusEnum.ENABLE.getCode());
        ProcessTemplate processTemplate = this.processTemplateService.create(dto.getTemplateDto());
        BpmnModel bpmn = this.processService.xmlToBpmnModel(dto.getTemplateDto().getProcessTemplateXmlDto().getProcessDesc());
        Validate.notNull((Object)bpmn, (String)"\u6d41\u7a0b\u56fe\u7ed8\u5236\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Process process = (Process)bpmn.getProcesses().get(0);
        this.validateCountersign(process, (Map<String, Object>)dto.getVariables());
        String processId = process.getId();
        recordVo.setParams(JSON.toJSONString((Object)dto.getVariables()));
        recordVo.setProcessDefId(processId);
        recordVo.setTestProcessDefId(processId);
        recordVo.setProjectName(process.getName());
        recordVo.setTitle(StringUtils.join((Object[])new String[]{process.getName(), "_\u68c0\u6d4b\u62a5\u544a"}));
        ProcessInstanceDto processInstanceDto = new ProcessInstanceDto();
        HashMap taskAssignees = new HashMap();
        dto.getTaskVos().forEach(taskVo -> {
            if (CollectionUtils.isNotEmpty(taskVo.getUserVos())) {
                ArrayList processUserDtos = new ArrayList();
                taskVo.getUserVos().forEach(s -> {
                    ProcessUserDto processUserDto = new ProcessUserDto();
                    processUserDto.setUserCode(s.getUserCode());
                    processUserDto.setUserName(s.getUserName());
                    processUserDtos.add(processUserDto);
                });
                taskAssignees.put(taskVo.getNodeId(), processUserDtos);
            }
        });
        processInstanceDto.setTaskAssignees(taskAssignees);
        processInstanceDto.setProcessValidate(true);
        try {
            HashMap variables = Maps.newHashMap();
            variables.put(ProcessConstant.PROCESS_INSTANCE_FORM_DATA_CODE, dto.getVariables());
            variables.put(ProcessConstant.PROCESS_INSTANCE_PARAM_CODE, processInstanceDto);
            if (StringUtils.isNotBlank((CharSequence)dto.getSubmitUserName())) {
                Authentication.setAuthenticatedUserId((String)StringUtils.join((Object[])new String[]{"u", ":", dto.getSubmitUserName()}));
            } else {
                UserIdentity userIdentity = this.loginUserService.getLoginUser();
                String accout = StringUtils.join((Object[])new String[]{userIdentity.getIdentityType(), ":", userIdentity.getAccount()});
                Authentication.setAuthenticatedUserId((String)accout);
            }
            processInstance = this.runtimeService.startProcessInstanceById(processTemplate.getProcessDefinitionId(), (Map)variables);
        }
        catch (Exception e) {
            recordVo.setState(2);
            recordVo.setResult(String.format("\u6a21\u7248\u683c\u5f0f\u9519\u8bef\uff1a%s", e.getMessage()));
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return recordVo;
        }
        boolean haveException = false;
        long startTime = System.nanoTime();
        try {
            this.complete(processInstance, recordVo, dto, processTemplate);
        }
        catch (Exception e) {
            haveException = true;
        }
        long endTime = System.nanoTime();
        boolean processEnd = this.processService.isProcessEnd(processInstance.getProcessInstanceId());
        if (haveException) {
            recordVo.setState(2);
        } else if (processEnd) {
            recordVo.setState(1);
        } else {
            recordVo.setState(0);
        }
        recordVo.setProcessInstanceId(processInstance.getId());
        this.getBpmnChart(recordVo);
        this.initRecordResult(process, recordVo, (endTime - startTime) / 1000000L);
        TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        return recordVo;
    }

    protected void complete(ProcessInstance processInstance, ProcessCheckRecordVo recordVo, ProcessValidateDto dto, ProcessTemplate template) {
        if (this.processService.isProcessEnd(processInstance.getProcessInstanceId())) {
            return;
        }
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstance.getProcessInstanceId())).list();
        if (CollectionUtils.isEmpty((Collection)tasks)) {
            return;
        }
        for (Task task : tasks) {
            List<String> assignees;
            TaskQuery taskQuery = this.taskService.createTaskQuery();
            task = (Task)((TaskQuery)taskQuery.taskId(task.getId())).singleResult();
            if (task == null) continue;
            StringBuilder result = new StringBuilder("<p>\u5f00\u59cb\u5ba1\u6279\u6d41\u7a0b\u8282\u70b9\uff1a");
            result.append(task.getName()).append("</p>");
            String assignee = this.processService.getAssigneeByTask(task.getTaskDefinitionKey(), dto.getTaskVos());
            if (StringUtils.isBlank((CharSequence)assignee) && CollectionUtils.isNotEmpty(assignees = this.processService.getAssigneeByTask(template.getId(), task.getId(), task.getTaskDefinitionKey(), processInstance.getProcessInstanceId(), processInstance.getStartUserId()))) {
                assignee = assignees.get(0);
            }
            ProcessTemplateNodeVo nodeVo = this.processTemplateNodeService.findByTemplateIdAndTaskId(template.getId(), task.getTaskDefinitionKey());
            ProcessTemplateNodeUserTaskVo processTemplateNodeUserTaskVo = this.processTemplateNodeUserTaskService.findByNodeId(nodeVo.getId());
            boolean nullSkip = processTemplateNodeUserTaskVo.getNullSkip();
            if (StringUtils.isBlank((CharSequence)assignee)) {
                if (nullSkip) {
                    result.append("<p>\u6d41\u7a0b\u8282\u70b9\u672a\u627e\u5230\u5ba1\u6279\u4eba\uff0c\u4e3a\u7a7a\u8df3\u8fc7</p>");
                    this.addItem(recordVo, this.initRecordItem(task, result.toString(), 1));
                    continue;
                }
                ProcessCheckRecordItemVo itemVo = new ProcessCheckRecordItemVo();
                itemVo.setTaskId(task.getTaskDefinitionKey());
                itemVo.setResult("\u7528\u6237\u8282\u70b9\u65e0\u6cd5\u627e\u5230\u6b63\u786e\u7684\u5ba1\u6279\u4eba\uff0c\u8bf7\u68c0\u67e5");
                recordVo.setErrorItem(itemVo);
                throw new IllegalArgumentException("\u6d41\u7a0b\u8282\u70b9\u672a\u627e\u5230\u5ba1\u6279\u4eba");
            }
            task.setAssignee(assignee);
            result.append("<p>\u8282\u70b9\u5ba1\u6279\u4eba\uff1a").append(assignee).append("</p>").append("<p>\u6d41\u7a0b\u8282\u70b9\u5ba1\u6279\u6210\u529f</p>");
            try {
                this.taskService.complete(task.getId());
            }
            catch (Exception e) {
                e.printStackTrace();
                this.addErrorItem(recordVo, e.getMessage());
                this.addItem(recordVo, this.initRecordItem(task, result.toString(), 2));
                throw e;
            }
            this.addItem(recordVo, this.initRecordItem(task, result.toString(), 1));
        }
        this.complete(processInstance, recordVo, dto, template);
    }

    protected void addItem(ProcessCheckRecordVo recordVo, ProcessCheckRecordItemVo item) {
        Set<ProcessCheckRecordItemVo> items = recordVo.getProcessCheckRecordItems();
        if (items == null) {
            items = new LinkedHashSet<ProcessCheckRecordItemVo>();
        }
        items.add(item);
        recordVo.setProcessCheckRecordItems(items);
    }

    protected ProcessCheckRecordItemVo initRecordItem(Task task, String result, Integer state) {
        ProcessCheckRecordItemVo item = new ProcessCheckRecordItemVo();
        item.setCheckType("PASS");
        item.setCreateTime(new Date());
        item.setNodeKey(task.getTaskDefinitionKey());
        item.setNodeName(task.getName());
        item.setResult(result);
        item.setState(state);
        item.setTaskId(task.getId());
        return item;
    }

    protected void initRecordResult(Process process, ProcessCheckRecordVo recordVo, long time) {
        StringBuilder result = new StringBuilder("\u672c\u6b21\u68c0\u6d4b\u5171\u8017\u65f6<span style=\"color:green;font-weight: bolder;\">");
        result.append((double)time / 1000.0).append("</span>\u79d2,\u5b8c\u6210\u5ea6<span style=\"color:green;font-weight: bolder;\">");
        recordVo.setResult(result.toString());
    }

    protected int[] calculateCompleteness(Process process, ProcessCheckRecordVo record) {
        int competedTasks = 0;
        HashSet<String> taskDefKeys = new HashSet<String>();
        int totalTasks = (int)process.getFlowElements().stream().filter(e -> e instanceof UserTask).count();
        Set<ProcessCheckRecordItemVo> items = record.getProcessCheckRecordItems();
        if (!CollectionUtils.isEmpty(items)) {
            for (ProcessCheckRecordItemVo item : items) {
                if (taskDefKeys.contains(item.getNodeKey())) continue;
                if (item.getState().equals(1)) {
                    ++competedTasks;
                }
                taskDefKeys.add(item.getNodeKey());
            }
        }
        int completeness = new BigDecimal(competedTasks).divide(new BigDecimal(totalTasks), 2, 5).multiply(new BigDecimal(100)).intValue();
        if (record.getState() == 1) {
            completeness = 100;
        }
        return new int[]{completeness, competedTasks, totalTasks};
    }

    private void validateCountersign(Process process, Map<String, Object> variables) {
        List userTaskList = process.findFlowElementsOfType(UserTask.class);
        if (CollectionUtils.isEmpty((Collection)userTaskList)) {
            return;
        }
        userTaskList.forEach(s -> {
            if (ObjectUtils.isNotEmpty((Object)s.getLoopCharacteristics()) && StringUtils.isNotBlank((CharSequence)s.getLoopCharacteristics().getInputDataItem())) {
                String pattern = "[a-zA-Z]+\\d*\\b";
                Pattern r = Pattern.compile(pattern);
                Matcher m = r.matcher(s.getLoopCharacteristics().getInputDataItem());
                ArrayList groups = Lists.newArrayList();
                while (m.find()) {
                    String group = m.group();
                    groups.add(group);
                }
                ArrayList assignee = Lists.newArrayList();
                assignee.addAll(s.getCandidateUsers());
                if (StringUtils.isNotBlank((CharSequence)s.getAssignee())) {
                    assignee.add(s.getAssignee());
                }
                variables.put((String)groups.get(0), assignee);
            }
        });
    }

    private void initTemplate(ProcessTemplateDto dto) {
        dto.setId(null);
        dto.getProcessTemplateBusinessDto().setId(null);
        dto.getProcessTemplateScopeDtos().forEach(dto1 -> dto1.setId(null));
        dto.getProcessTemplateNodes().forEach(node -> node.setId(null));
        dto.getProcessTemplateXmlDto().setId(null);
    }

    private void validateUserTask(Process process, List<ValidationError> errors, List<ProcessTracingStrategyVo> strategyVoList, List<ValidateSequenceVo> validateSequenceVos, String startUserName) {
        List userTaskList = process.findFlowElementsOfType(UserTask.class);
        if (CollectionUtils.isEmpty((Collection)userTaskList)) {
            errors.add(this.validationErrorFactory(UserTask.class.getName(), null, null, "\u6ca1\u6709\u8bbe\u7f6e\u4efb\u52a1", true));
        }
        userTaskList.forEach(s -> {
            if (StringUtils.isBlank((CharSequence)s.getName())) {
                errors.add(this.validationErrorFactory(UserTask.class.getName(), s.getId(), s.getName(), "\u4efb\u52a1\u540d\u79f0\u7f3a\u5931", true));
            }
            ProcessTemplateNode processTemplateNode = this.processTemplateNodeRepository.findByTemplateIdAndTaskId(process.getDocumentation(), s.getId());
            ProcessTemplateNodeUserTaskVo taskVo = this.processTemplateNodeUserTaskService.findByNodeId(processTemplateNode.getId());
            ProcessTracingStrategyVo processTracingStrategyVo = new ProcessTracingStrategyVo();
            processTracingStrategyVo.setSignType(taskVo.getSignType());
            processTracingStrategyVo.setNodeId(s.getId());
            if (Boolean.TRUE.equals(taskVo.getSignOptional())) {
                processTracingStrategyVo.setSignConditions(Lists.newArrayList((Object[])new String[]{"\u81ea\u9009\u5ba1\u6279\u4eba"}));
                strategyVoList.add(processTracingStrategyVo);
            } else if (ObjectUtils.isNotEmpty((Object)taskVo) && CollectionUtils.isNotEmpty((Collection)taskVo.getProcessTemplateNodeAssignees())) {
                Collection<UserVo> userVos = this.processTaskService.findUserVoByTaskNodeId(taskVo.getNodeId(), startUserName);
                processTracingStrategyVo.setUserVos(userVos);
                Collection processTemplateNodeAssignees = taskVo.getProcessTemplateNodeAssignees();
                List<String> collect = processTemplateNodeAssignees.stream().map(ProcessTemplateNodeAssigneeVo::getStrategyName).collect(Collectors.toList());
                processTracingStrategyVo.setSignConditions(collect);
                strategyVoList.add(processTracingStrategyVo);
            } else {
                errors.add(this.validationErrorFactory(UserTask.class.getName(), s.getId(), s.getName(), "\u4efb\u52a1\u6ca1\u6709\u8bbe\u7f6e\u5ba1\u6279\u4eba\u5458", true));
            }
        });
        List sequenceFlowList = process.findFlowElementsOfType(SequenceFlow.class);
        if (CollectionUtils.isNotEmpty((Collection)sequenceFlowList)) {
            sequenceFlowList.forEach(sequenceFlow -> {
                if (StringUtils.isNotBlank((CharSequence)sequenceFlow.getConditionExpression())) {
                    validateSequenceVos.add(this.validationSequenceFlowFactory(sequenceFlow.getId(), sequenceFlow.getConditionExpression()));
                }
            });
        }
    }

    private ValidationError validationErrorFactory(String elementType, String activityId, String activityName, String msg, boolean warning) {
        ValidationError validationError = new ValidationError();
        validationError.setActivityId(activityId);
        validationError.setActivityName(activityName);
        validationError.setDefaultDescription(msg);
        validationError.setWarning(warning);
        validationError.setProcessDefinitionName(elementType);
        return validationError;
    }

    private ValidateSequenceVo validationSequenceFlowFactory(String sequenceId, String expression) {
        boolean contain = false;
        ArrayList groups = Lists.newArrayList();
        if (CollectionUtils.isEmpty(this.simpleExpressions)) {
            this.findFormula(expression, groups);
        } else {
            for (String simpleExpression : this.simpleExpressions) {
                if (contain) continue;
                contain = expression.contains(simpleExpression);
            }
            if (contain) {
                this.findSimpleExpression(expression, groups);
            } else {
                this.findFormula(expression, groups);
            }
        }
        return ValidateSequenceVo.builder().sequenceId(sequenceId).paramsCodes(groups).build();
    }

    private void getBpmnChart(ProcessCheckRecordVo recordVo) {
        List historicActivityInstances = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(recordVo.getProcessInstanceId()).activityTenantId(TenantUtils.getTenantCode()).orderByHistoricActivityInstanceStartTime().asc()).list();
        HashSet<ProcessCheckRecordItemVo> itemVos = new HashSet<ProcessCheckRecordItemVo>();
        historicActivityInstances.forEach(hi -> {
            if (ObjectUtils.isEmpty((Object)recordVo.getErrorItem()) || ObjectUtils.isNotEmpty((Object)recordVo.getErrorItem()) && !hi.getActivityId().equals(recordVo.getErrorItem().getTaskId())) {
                String activityType = hi.getActivityType();
                ProcessCheckRecordItemVo itemVo = new ProcessCheckRecordItemVo();
                itemVo.setTaskId(hi.getActivityId());
                itemVo.setNodeType(activityType);
                itemVos.add(itemVo);
            }
        });
        recordVo.setProcessCheckRecordItems(itemVos);
    }

    private void addErrorItem(ProcessCheckRecordVo recordVo, String errorMessage) {
        if (StringUtils.isBlank((CharSequence)errorMessage)) {
            return;
        }
        errorMessage = errorMessage.replace("'", "").replace("[", " ").replace("]", " ");
        List<String> strings = Arrays.asList(errorMessage.split(" "));
        List<String> nodeId = strings.stream().filter(s -> s.startsWith(GATEWAY) || s.startsWith(EVENT) || s.startsWith(ACTIVITY) || s.startsWith(FLOW)).collect(Collectors.toList());
        nodeId.forEach(node -> {
            ProcessCheckRecordItemVo itemVo = new ProcessCheckRecordItemVo();
            itemVo.setTaskId((String)node);
            if (node.startsWith(GATEWAY)) {
                itemVo.setResult("\u7f51\u5173\u65e0\u6cd5\u627e\u5230\u6b63\u786e\u7684\u51fa\u53e3\uff0c\u8bf7\u68c0\u67e5");
            } else if (node.startsWith(ACTIVITY)) {
                itemVo.setResult("\u7528\u6237\u8282\u70b9\u65e0\u6cd5\u627e\u5230\u6b63\u786e\u7684\u5ba1\u6279\u4eba\u6216\u5176\u4ed6\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5");
            }
            recordVo.setErrorItem(itemVo);
        });
    }

    private void findFormula(String expression, List<String> groups) {
        String pattern = "[a-zA-Z]+\\d*\\b";
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(expression);
        ArrayList groupList = Lists.newArrayList();
        while (m.find()) {
            String group = m.group();
            if (StringUtils.equals((CharSequence)group, (CharSequence)ProcessConstant.PROCESS_VALIDATE_FORM_DATA_CODE)) continue;
            groupList.add(group);
        }
        groups.add((String)groupList.get(0));
    }

    private void findSimpleExpression(String expression, List<String> groups) {
        String[] exprs;
        String substring = expression.substring(expression.indexOf("_formData."));
        for (String expr : exprs = substring.split(",")[0].split("\\.")) {
            groups.add(expr.replace("_", ""));
        }
    }
}

