/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.service.internal;

import com.biz.crm.workflow.local.entity.ProcessInstanceEntity;
import com.biz.crm.workflow.local.service.ProcessBackableNodeVoService;
import com.biz.crm.workflow.local.service.ProcessInstanceService;
import com.biz.crm.workflow.local.service.ProcessTemplateNodeUserTaskService;
import com.biz.crm.workflow.local.vo.ProcessBackableNodeVo;
import com.biz.crm.workflow.sdk.service.ProcessTemplateNodeService;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateNodeUserTaskVo;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateNodeVo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.flowable.engine.HistoryService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.TaskService;
import org.flowable.task.api.TaskInfo;
import org.flowable.task.api.TaskQuery;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.flowable.task.api.history.HistoricTaskInstanceQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ProcessBackableNodeVoServiceImpl
implements ProcessBackableNodeVoService {
    @Autowired
    private ProcessTemplateNodeService processTemplateNodeService;
    @Autowired
    private ProcessInstanceService processInstanceService;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private ProcessTemplateNodeUserTaskService processTemplateNodeUserTaskService;

    @Override
    public List<ProcessBackableNodeVo> findBackableNodes(String processInstanceId) {
        if (StringUtils.isBlank((CharSequence)processInstanceId)) {
            return null;
        }
        ProcessInstanceEntity processInstanceEntity = this.processInstanceService.findByProcessInstanceId(processInstanceId);
        List runtasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).list();
        if (Objects.isNull((Object)processInstanceEntity)) {
            return null;
        }
        if (CollectionUtils.isEmpty((Collection)runtasks)) {
            return null;
        }
        List runtaskDefinitionKeys = runtasks.stream().map(TaskInfo::getTaskDefinitionKey).collect(Collectors.toList());
        List<ProcessTemplateNodeUserTaskVo> processTemplateNodeUserTaskVos = this.processTemplateNodeUserTaskService.findByTemplateId(processInstanceEntity.getProcessTemplateId());
        if (CollectionUtils.isEmpty(processTemplateNodeUserTaskVos)) {
            return null;
        }
        List nodeIds = processTemplateNodeUserTaskVos.stream().filter(processTemplateNodeUserTaskVo -> processTemplateNodeUserTaskVo.getCanBack()).map(ProcessTemplateNodeUserTaskVo::getNodeId).collect(Collectors.toList());
        List processTemplateNodeVos = this.processTemplateNodeService.findByIds(nodeIds);
        if (CollectionUtils.isEmpty((Collection)processTemplateNodeVos)) {
            return null;
        }
        List tasks = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId)).taskDeleteReason(null).orderByHistoricTaskInstanceEndTime().desc()).list();
        List activeActivityIds = this.runtimeService.getActiveActivityIds(processInstanceId);
        if (CollectionUtils.isEmpty((Collection)activeActivityIds)) {
            return null;
        }
        if (CollectionUtils.isEmpty((Collection)tasks)) {
            return null;
        }
        ArrayList<ProcessBackableNodeVo> list = new ArrayList<ProcessBackableNodeVo>();
        for (ProcessTemplateNodeVo processTemplateNodeVo : processTemplateNodeVos) {
            String processTaskId = processTemplateNodeVo.getProcessTaskId();
            List historicTaskInstances = tasks.stream().filter(historicTaskInstance -> historicTaskInstance.getTaskDefinitionKey().equals(processTaskId) && !runtaskDefinitionKeys.contains(historicTaskInstance.getTaskDefinitionKey()) && Objects.nonNull(historicTaskInstance.getEndTime())).collect(Collectors.toList());
            List taskInstances = historicTaskInstances.stream().filter(historicTaskInstance -> StringUtils.isNotBlank((CharSequence)historicTaskInstance.getDeleteReason()) && historicTaskInstance.getDeleteReason().contains("Change activity to")).map(TaskInfo::getId).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(taskInstances)) {
                historicTaskInstances = historicTaskInstances.stream().filter(historicTaskInstance -> !taskInstances.contains(historicTaskInstance.getId())).collect(Collectors.toList());
            }
            if (CollectionUtils.isEmpty(historicTaskInstances)) continue;
            historicTaskInstances.sort(Comparator.comparing(HistoricTaskInstance::getEndTime).reversed());
            ProcessBackableNodeVo processBackableNodeVo = new ProcessBackableNodeVo();
            processBackableNodeVo.setTaskId(((HistoricTaskInstance)historicTaskInstances.get(0)).getId());
            processBackableNodeVo.setProcessName(processInstanceEntity.getProcessName());
            processBackableNodeVo.setProcessTitle(processInstanceEntity.getProcessTitle());
            processBackableNodeVo.setAssignee(((HistoricTaskInstance)historicTaskInstances.get(0)).getAssignee());
            processBackableNodeVo.setProcessNodeName(processTemplateNodeVo.getProcessTaskName());
            list.add(processBackableNodeVo);
        }
        return list;
    }
}

