/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.service.internal;

import com.biz.crm.workflow.local.entity.ProcessButtonGroupDetail;
import com.biz.crm.workflow.local.repository.ProcessButtonGroupDetailRepository;
import com.biz.crm.workflow.local.service.ProcessButtonGroupDetailService;
import com.biz.crm.workflow.sdk.dto.ProcessButtonGroupDetailDto;
import com.biz.crm.workflow.sdk.enums.EffectiveScopeEnum;
import com.biz.crm.workflow.sdk.register.ProcessTemplateRegister;
import com.biz.crm.workflow.sdk.strategy.button.ProcessButtonStrategy;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ProcessButtonGroupDetailServiceImpl
implements ProcessButtonGroupDetailService {
    @Autowired
    private ProcessButtonGroupDetailRepository processButtonGroupDetailRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private ProcessTemplateRegister processTemplateRegister;
    @Autowired(required=false)
    private ApplicationContext applicationContext;

    @Override
    @Transactional
    public void createButtonGroupId(String buttonGroupId, List<ProcessButtonGroupDetailDto> buttonGroupDetails) {
        Validate.notBlank((CharSequence)buttonGroupId, (String)"\u65b0\u589e\u6309\u94ae\u660e\u7ec6\u65f6\uff0c\u6309\u94ae\u7ec4\u7f16\u7801\u4e0d\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.createValidateList(buttonGroupDetails);
        buttonGroupDetails.forEach(processButtonGroupDetailDto -> processButtonGroupDetailDto.setButtonGroupId(buttonGroupId));
        List entities = (List)this.nebulaToolkitService.copyCollectionByWhiteList(buttonGroupDetails, ProcessButtonGroupDetailDto.class, ProcessButtonGroupDetail.class, HashSet.class, ArrayList.class, new String[0]);
        this.processButtonGroupDetailRepository.saveBatch(entities);
    }

    @Override
    @Transactional
    public void updateByButtonGroupId(String buttonGroupId, List<ProcessButtonGroupDetailDto> buttonGroupDetails) {
        Validate.notBlank((CharSequence)buttonGroupId, (String)"\u65b0\u589e\u6309\u94ae\u660e\u7ec6\u65f6\uff0c\u6309\u94ae\u7ec4\u7f16\u7801\u4e0d\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.createValidateList(buttonGroupDetails);
        buttonGroupDetails.forEach(processButtonGroupDetailDto -> processButtonGroupDetailDto.setButtonGroupId(buttonGroupId));
        List entities = (List)this.nebulaToolkitService.copyCollectionByWhiteList(buttonGroupDetails, ProcessButtonGroupDetailDto.class, ProcessButtonGroupDetail.class, HashSet.class, ArrayList.class, new String[0]);
        this.processButtonGroupDetailRepository.deleteByButtonGroupIds(Collections.singleton(buttonGroupId));
        this.processButtonGroupDetailRepository.saveBatch(entities);
    }

    @Override
    @Transactional
    public void deleteByButtonGroupIds(Collection<String> buttonGroupIds) {
        Validate.isTrue((!CollectionUtils.isEmpty(buttonGroupIds) ? 1 : 0) != 0, (String)"\u5220\u9664\u64cd\u4f5c\u65f6\uff0c\u6309\u94ae\u7ec4id\u96c6\u5408\u4e0d\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.processButtonGroupDetailRepository.deleteByButtonGroupIds(buttonGroupIds);
    }

    @Override
    public List<ProcessButtonGroupDetail> findByByButtonGroupId(String buttonGroupId) {
        if (StringUtils.isBlank((CharSequence)buttonGroupId)) {
            return null;
        }
        return this.processButtonGroupDetailRepository.findByByButtonGroupId(buttonGroupId);
    }

    @Override
    public List<ProcessButtonGroupDetail> findByButtonGroupIdAndProcessButtonType(String buttonGroupId, String processButtonType) {
        if (StringUtils.isBlank((CharSequence)buttonGroupId)) {
            return null;
        }
        List<ProcessButtonGroupDetail> processButtonGroupDetails = this.processButtonGroupDetailRepository.findByByButtonGroupId(buttonGroupId);
        if (EffectiveScopeEnum.ALL.getDictCode().equals(processButtonType)) {
            return processButtonGroupDetails;
        }
        List<ProcessButtonGroupDetail> buttonGroupDetails = processButtonGroupDetails.stream().filter(processButtonGroupDetail -> processButtonType.equals(processButtonGroupDetail.getProcessButtonType()) || EffectiveScopeEnum.ALL.getDictCode().equals(processButtonGroupDetail.getProcessButtonType())).collect(Collectors.toList());
        return buttonGroupDetails;
    }

    private void createValidateList(List<ProcessButtonGroupDetailDto> buttonGroupDetails) {
        Validate.isTrue((!CollectionUtils.isEmpty(buttonGroupDetails) ? 1 : 0) != 0, (String)"\u6570\u636e\u64cd\u4f5c\u65f6\uff0c\u6309\u94ae\u7ec4\u7f16\u7801\u4e0d\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Collection processButtonStrategies = this.processTemplateRegister.getProcessButtonStrategies();
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)processButtonStrategies) ? 1 : 0) != 0, (String)"\u6b64\u6a21\u677f\u4e2d\u6ca1\u6709\u6d41\u7a0b\u6309\u94ae\u914d\u7f6e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01", (Object[])new Object[0]);
        ArrayList<String> processButtonCodes = new ArrayList<String>(processButtonStrategies.size());
        for (Class processButtonStrategy : processButtonStrategies) {
            ProcessButtonStrategy applicationUserScopeStrategy = (ProcessButtonStrategy)this.applicationContext.getBean(processButtonStrategy);
            processButtonCodes.add(applicationUserScopeStrategy.getProcessButtonCode());
        }
        buttonGroupDetails.forEach(processButtonGroupDetailDto -> {
            Validate.notNull((Object)processButtonGroupDetailDto, (String)"\u6570\u636e\u64cd\u4f5c\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)processButtonGroupDetailDto.getProcessButtonCode(), (String)"\u6570\u636e\u64cd\u4f5c\u65f6\uff0c\u6309\u94ae\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)processButtonGroupDetailDto.getProcessButtonDesc(), (String)"\u6570\u636e\u64cd\u4f5c\u65f6\uff0c\u6309\u94ae\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)processButtonGroupDetailDto.getProcessButtonType(), (String)"\u6570\u636e\u64cd\u4f5c\u65f6\uff0c\u6309\u94ae\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            processButtonGroupDetailDto.setId(null);
            Validate.isTrue((boolean)processButtonCodes.contains(processButtonGroupDetailDto.getProcessButtonCode()), (String)"\u6b64\u6a21\u677f\u4e2d\u6ca1\u6709\u3010%s\u3011\u6d41\u7a0b\u6309\u94ae\u914d\u7f6e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01", (Object[])new Object[]{processButtonGroupDetailDto.getProcessButtonDesc()});
        });
        Set processButton = buttonGroupDetails.stream().map(ProcessButtonGroupDetailDto::getProcessButtonCode).collect(Collectors.toSet());
        Validate.isTrue((processButton.size() == buttonGroupDetails.size() ? 1 : 0) != 0, (String)"\u672c\u6b21\u63d0\u4ea4\u5b58\u5728\u91cd\u590d\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
    }
}

