/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.workflow.local.entity.ProcessButtonGroup;
import com.biz.crm.workflow.local.repository.ProcessButtonGroupRepository;
import com.biz.crm.workflow.local.service.ProcessButtonGroupDetailService;
import com.biz.crm.workflow.local.service.ProcessButtonGroupService;
import com.biz.crm.workflow.sdk.constant.ProcessConstant;
import com.biz.crm.workflow.sdk.dto.ProcessButtonGroupDto;
import com.biz.crm.workflow.sdk.listener.ProcessButtonGroupEventListener;
import com.biz.crm.workflow.sdk.vo.ProcessButtonGroupVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import javax.transaction.Transactional;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ProcessButtonGroupServiceImpl
implements ProcessButtonGroupService {
    @Autowired
    private ProcessButtonGroupRepository processButtonGroupRepository;
    @Autowired
    private ProcessButtonGroupDetailService processButtonGroupDetailService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private List<ProcessButtonGroupEventListener> bpmProcessButtonGroupEventListeners;

    @Override
    public Page<ProcessButtonGroup> findByConditions(Pageable pageable, ProcessButtonGroupDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(dto)) {
            dto = new ProcessButtonGroupDto();
        }
        return this.processButtonGroupRepository.findByConditions(pageable, dto);
    }

    @Override
    @Transactional
    public ProcessButtonGroup create(ProcessButtonGroupDto processButtonGroupDto) {
        this.createValidate(processButtonGroupDto);
        ProcessButtonGroup processButtonGroup = (ProcessButtonGroup)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)processButtonGroupDto, ProcessButtonGroup.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        processButtonGroup.setTenantCode(TenantUtils.getTenantCode());
        this.processButtonGroupRepository.save((Object)processButtonGroup);
        List groupDetailDtoList = processButtonGroupDto.getGroupDetailDtoList();
        this.processButtonGroupDetailService.createButtonGroupId(processButtonGroup.getId(), groupDetailDtoList);
        ProcessButtonGroupVo processButtonGroupVo = (ProcessButtonGroupVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)processButtonGroup, ProcessButtonGroupVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        processButtonGroupVo.setId(processButtonGroup.getId());
        if (!CollectionUtils.isEmpty(this.bpmProcessButtonGroupEventListeners)) {
            for (ProcessButtonGroupEventListener bpmProcessButtonGroupEventListener : this.bpmProcessButtonGroupEventListeners) {
                bpmProcessButtonGroupEventListener.onCreated(processButtonGroupVo);
            }
        }
        return processButtonGroup;
    }

    @Override
    @Transactional
    public ProcessButtonGroup update(ProcessButtonGroupDto bpmProcessButtonGroupDto) {
        this.updateValidate(bpmProcessButtonGroupDto);
        ProcessButtonGroup bpmProcessButtonGroup = this.processButtonGroupRepository.findByIdAndTenantCode(bpmProcessButtonGroupDto.getId(), TenantUtils.getTenantCode());
        Validate.notNull((Object)((Object)bpmProcessButtonGroup), (String)"\u4fee\u6539\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        ProcessButtonGroupVo oldBpmProcessButtonGroupVo = (ProcessButtonGroupVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)bpmProcessButtonGroup, ProcessButtonGroupVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        ProcessButtonGroup newBpmProcessButtonGroup = (ProcessButtonGroup)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)bpmProcessButtonGroupDto, ProcessButtonGroup.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        this.processButtonGroupRepository.updateByIdAndTenantCode(newBpmProcessButtonGroup, TenantUtils.getTenantCode());
        List groupDetailDtoList = bpmProcessButtonGroupDto.getGroupDetailDtoList();
        this.processButtonGroupDetailService.updateByButtonGroupId(newBpmProcessButtonGroup.getId(), groupDetailDtoList);
        ProcessButtonGroupVo bpmProcessButtonGroupVo = (ProcessButtonGroupVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)newBpmProcessButtonGroup, ProcessButtonGroupVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        if (!CollectionUtils.isEmpty(this.bpmProcessButtonGroupEventListeners)) {
            for (ProcessButtonGroupEventListener bpmProcessButtonGroupEventListener : this.bpmProcessButtonGroupEventListeners) {
                bpmProcessButtonGroupEventListener.onUpdate(oldBpmProcessButtonGroupVo, bpmProcessButtonGroupVo);
            }
        }
        return bpmProcessButtonGroup;
    }

    @Override
    @Transactional
    public void delete(Collection<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<ProcessButtonGroup> bpmProcessButtonGroups = this.processButtonGroupRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(bpmProcessButtonGroups)) {
            return;
        }
        Collection bpmProcessButtonGroupVos = this.nebulaToolkitService.copyCollectionByWhiteList(bpmProcessButtonGroups, ProcessButtonGroup.class, ProcessButtonGroupVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.processButtonGroupRepository.removeByIdsAndTenantCode(ids, TenantUtils.getTenantCode());
        this.processButtonGroupDetailService.deleteByButtonGroupIds(ids);
        if (!CollectionUtils.isEmpty(this.bpmProcessButtonGroupEventListeners)) {
            for (ProcessButtonGroupEventListener bpmProcessButtonGroupEventListener : this.bpmProcessButtonGroupEventListeners) {
                for (ProcessButtonGroupVo bpmProcessButtonGroupVo : bpmProcessButtonGroupVos) {
                    bpmProcessButtonGroupEventListener.onDeleted(bpmProcessButtonGroupVo);
                }
            }
        }
    }

    private void createValidate(ProcessButtonGroupDto bpmProcessButtonGroupDto) {
        Validate.notNull((Object)bpmProcessButtonGroupDto, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((bpmProcessButtonGroupDto.getId() == null ? 1 : 0) != 0, (String)"\u65b0\u589e\u6570\u636e\u65f6,\u6570\u636e\u4e3b\u952e\u4e0d\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)bpmProcessButtonGroupDto.getButtonGroupDesc(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6309\u94ae\u7ec4\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)bpmProcessButtonGroupDto.getGroupDetailDtoList()) ? 1 : 0) != 0, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6309\u94ae\u7ec4\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        bpmProcessButtonGroupDto.setTenantCode(TenantUtils.getTenantCode());
        bpmProcessButtonGroupDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        bpmProcessButtonGroupDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        bpmProcessButtonGroupDto.setButtonGroupCode((String)this.generateCodeService.generateCode(ProcessConstant.PROCESS_BUTTON_GROUP_CODE, 1).get(0));
    }

    private void updateValidate(ProcessButtonGroupDto bpmProcessButtonGroupDto) {
        Validate.notNull((Object)bpmProcessButtonGroupDto, (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)bpmProcessButtonGroupDto.getId(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)bpmProcessButtonGroupDto.getButtonGroupCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u6309\u94ae\u7ec4\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)bpmProcessButtonGroupDto.getButtonGroupDesc(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u6309\u94ae\u7ec4\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)bpmProcessButtonGroupDto.getGroupDetailDtoList()) ? 1 : 0) != 0, (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u6309\u94ae\u7ec4\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        bpmProcessButtonGroupDto.setTenantCode(TenantUtils.getTenantCode());
    }
}

