/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.service.internal;

import com.biz.crm.workflow.local.entity.ProcessButtonGroup;
import com.biz.crm.workflow.local.entity.ProcessButtonGroupDetail;
import com.biz.crm.workflow.local.repository.ProcessButtonGroupRepository;
import com.biz.crm.workflow.local.service.ProcessButtonGroupDetailService;
import com.biz.crm.workflow.sdk.service.ProcessButtonGroupVoService;
import com.biz.crm.workflow.sdk.vo.ProcessButtonGroupDetailVo;
import com.biz.crm.workflow.sdk.vo.ProcessButtonGroupVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ProcessButtonGroupVoServiceImpl
implements ProcessButtonGroupVoService {
    @Autowired
    private ProcessButtonGroupRepository processButtonGroupRepository;
    @Autowired
    private ProcessButtonGroupDetailService processButtonGroupDetailService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    public ProcessButtonGroupVo findById(String id) {
        List<ProcessButtonGroupDetail> processButtonGroupDetails;
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        ProcessButtonGroup bpmProcessButtonGroup = this.processButtonGroupRepository.findByIdAndTenantCode(id, TenantUtils.getTenantCode());
        if (bpmProcessButtonGroup == null) {
            return null;
        }
        ProcessButtonGroupVo bpmProcessButtonGroupVo = (ProcessButtonGroupVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)bpmProcessButtonGroup, ProcessButtonGroupVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        if (Objects.nonNull(bpmProcessButtonGroupVo) && !CollectionUtils.isEmpty(processButtonGroupDetails = this.processButtonGroupDetailService.findByByButtonGroupId(bpmProcessButtonGroup.getId()))) {
            List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(processButtonGroupDetails, ProcessButtonGroupDetail.class, ProcessButtonGroupDetailVo.class, HashSet.class, ArrayList.class, new String[0]);
            bpmProcessButtonGroupVo.setGroupDetailVoList(voList);
        }
        return bpmProcessButtonGroupVo;
    }

    public ProcessButtonGroupVo findByButtonGroupCode(String buttonGroupCode, String processButtonType) {
        List<ProcessButtonGroupDetail> processButtonGroupDetails;
        if (StringUtils.isBlank((CharSequence)buttonGroupCode)) {
            return null;
        }
        ProcessButtonGroup bpmProcessButtonGroup = this.processButtonGroupRepository.findByButtonGroupCode(buttonGroupCode);
        if (bpmProcessButtonGroup == null) {
            return null;
        }
        ProcessButtonGroupVo bpmProcessButtonGroupVo = (ProcessButtonGroupVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)bpmProcessButtonGroup, ProcessButtonGroupVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        if (Objects.nonNull(bpmProcessButtonGroupVo) && !CollectionUtils.isEmpty(processButtonGroupDetails = this.processButtonGroupDetailService.findByButtonGroupIdAndProcessButtonType(bpmProcessButtonGroup.getId(), processButtonType))) {
            Collection processButtonGroupDetailVos = this.nebulaToolkitService.copyCollectionByWhiteList(processButtonGroupDetails, ProcessButtonGroupDetail.class, ProcessButtonGroupDetailVo.class, HashSet.class, ArrayList.class, new String[0]);
            bpmProcessButtonGroupVo.setGroupDetailVoList((List)Lists.newArrayList((Iterable)processButtonGroupDetailVos));
        }
        return bpmProcessButtonGroupVo;
    }
}

