/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.workflow.local.entity.ProcessTaskCopyConfigEntity;
import com.biz.crm.workflow.local.repository.ProcessCopyConfigRepository;
import com.biz.crm.workflow.local.service.ProcessCopyConfigService;
import com.biz.crm.workflow.sdk.dto.ProcessTaskCopyConfigDto;
import com.biz.crm.workflow.sdk.vo.ProcessTaskCopyConfigVo;
import com.bizunited.nebula.common.entity.UuidEntity;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="processCopyConfigService")
public class ProcessCopyConfigServiceImpl
implements ProcessCopyConfigService {
    @Autowired
    private ProcessCopyConfigRepository processCopyConfigRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public Page<ProcessTaskCopyConfigVo> findByConditions(Pageable pageable, ProcessTaskCopyConfigDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(dto)) {
            dto = new ProcessTaskCopyConfigDto();
        }
        return this.processCopyConfigRepository.findByConditions(pageable, dto);
    }

    @Override
    public List<ProcessTaskCopyConfigVo> findByNodeId(String nodeId) {
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            return null;
        }
        List<ProcessTaskCopyConfigEntity> processCopyConfigs = this.processCopyConfigRepository.findByNodeIds(Collections.singleton(nodeId));
        if (processCopyConfigs == null) {
            return null;
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(processCopyConfigs, ProcessTaskCopyConfigEntity.class, ProcessTaskCopyConfigVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    @Override
    @Transactional
    public ProcessTaskCopyConfigVo create(ProcessTaskCopyConfigDto processCopyConfigDto) {
        this.createValidate(processCopyConfigDto);
        ProcessTaskCopyConfigEntity ProcessCopyConfigEntity = (ProcessTaskCopyConfigEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)processCopyConfigDto, ProcessTaskCopyConfigEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        ProcessCopyConfigEntity.setTenantCode(TenantUtils.getTenantCode());
        this.processCopyConfigRepository.saveOrUpdate((Object)ProcessCopyConfigEntity);
        return (ProcessTaskCopyConfigVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)ProcessCopyConfigEntity, ProcessTaskCopyConfigVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    @Override
    @Transactional
    public List<ProcessTaskCopyConfigVo> createBatch(Collection<ProcessTaskCopyConfigDto> processCopyConfigs) {
        if (CollectionUtils.isEmpty(processCopyConfigs)) {
            return Lists.newArrayList();
        }
        ArrayList processCopyConfigVos = Lists.newArrayList();
        for (ProcessTaskCopyConfigDto processCopyConfigDto : processCopyConfigs) {
            ProcessTaskCopyConfigVo processCopyConfigVo = this.create(processCopyConfigDto);
            processCopyConfigVos.add(processCopyConfigVo);
        }
        return processCopyConfigVos;
    }

    @Override
    @Transactional
    public void deleteByNodeIds(Collection<String> nodeIds) {
        Validate.isTrue((!CollectionUtils.isEmpty(nodeIds) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4efb\u52a1\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<ProcessTaskCopyConfigEntity> processCopyConfigs = this.processCopyConfigRepository.findByNodeIds(nodeIds);
        if (CollectionUtils.isEmpty(processCopyConfigs)) {
            return;
        }
        this.processCopyConfigRepository.removeByIdsAndTenantCode(processCopyConfigs.stream().map(UuidEntity::getId).collect(Collectors.toList()), TenantUtils.getTenantCode());
    }

    @Override
    public void delete(Collection<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<ProcessTaskCopyConfigEntity> processCopyConfigs = this.processCopyConfigRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(processCopyConfigs)) {
            return;
        }
        this.processCopyConfigRepository.removeByIdsAndTenantCode(ids, TenantUtils.getTenantCode());
    }

    private void createValidate(ProcessTaskCopyConfigDto processCopyConfigDto) {
        Validate.notNull((Object)processCopyConfigDto, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processCopyConfigDto.getTaskNodeId(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u4efb\u52a1\u8282\u70b9nodeId\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processCopyConfigDto.getUserCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u7528\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processCopyConfigDto.getUserName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u7528\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processCopyConfigDto.getPositionCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u804c\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }
}

