/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.service.internal;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.workflow.local.entity.ProcessInstanceEntity;
import com.biz.crm.workflow.local.entity.ProcessTaskLogEntity;
import com.biz.crm.workflow.local.entity.ProcessTemplateBusiness;
import com.biz.crm.workflow.local.repository.ProcessTaskLogRepository;
import com.biz.crm.workflow.local.service.ProcessDataDetailVoService;
import com.biz.crm.workflow.local.service.ProcessInstanceFilesService;
import com.biz.crm.workflow.local.service.ProcessInstanceService;
import com.biz.crm.workflow.local.service.ProcessTaskCommunicateService;
import com.biz.crm.workflow.local.service.ProcessTaskIndicatorsService;
import com.biz.crm.workflow.local.service.ProcessTemplateBusinessService;
import com.biz.crm.workflow.local.service.ProcessTemplateNodeUserTaskService;
import com.biz.crm.workflow.local.vo.ProcessSummaryDataDetailVo;
import com.biz.crm.workflow.local.vo.ProcessTaskLogVo;
import com.biz.crm.workflow.sdk.constant.ProcessConstant;
import com.biz.crm.workflow.sdk.enums.ProcessCommunicateStatusEnum;
import com.biz.crm.workflow.sdk.enums.ProcessOperateTypeEnum;
import com.biz.crm.workflow.sdk.register.ProcessTemplateRegister;
import com.biz.crm.workflow.sdk.service.ProcessTemplateNodeService;
import com.biz.crm.workflow.sdk.strategy.indicator.ProcessIndicatorStrategy;
import com.biz.crm.workflow.sdk.vo.ProcessDataDetailVo;
import com.biz.crm.workflow.sdk.vo.ProcessInstanceFilesVo;
import com.biz.crm.workflow.sdk.vo.ProcessTaskCommunicateVo;
import com.biz.crm.workflow.sdk.vo.ProcessTaskIndicatorsVo;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateNodeUserTaskVo;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateNodeVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.flowable.engine.HistoryService;
import org.flowable.engine.TaskService;
import org.flowable.engine.history.HistoricActivityInstanceQuery;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskQuery;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.flowable.task.api.history.HistoricTaskInstanceQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ProcessDataDetailVoServiceImpl
implements ProcessDataDetailVoService {
    private static final Logger log = LoggerFactory.getLogger(ProcessDataDetailVoServiceImpl.class);
    @Autowired
    private ProcessInstanceFilesService processInstanceFilesService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private ProcessTemplateNodeService processTemplateNodeService;
    @Autowired
    private ProcessTaskIndicatorsService processTaskIndicatorsService;
    @Autowired
    private ProcessTaskLogRepository processTaskLogRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private ProcessTemplateBusinessService processTemplateBusinessService;
    @Autowired
    private ProcessTemplateNodeUserTaskService processTemplateNodeUserTaskService;
    @Autowired
    private ProcessTemplateRegister processTemplateRegister;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private ProcessTaskCommunicateService taskCommunicateService;
    @Autowired
    private ProcessInstanceService processInstanceService;
    @Autowired(required=false)
    private ApplicationContext ac;
    private static final String NODE_NAME = "nodeName";
    private static final String INDICATORS = "indicators";

    @Override
    public ProcessDataDetailVo findByTaskId(String taskId) {
        ProcessTaskCommunicateVo processTaskCommunicateVo;
        Object formDate;
        String taskDefinitionKey;
        String processInstanceId;
        String processDefinitionId;
        ProcessDataDetailVo processDataDetailVo = new ProcessDataDetailVo();
        Task task = (Task)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskTenantId(TenantUtils.getTenantCode())).taskId(taskId)).singleResult();
        HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId)).taskTenantId(TenantUtils.getTenantCode())).singleResult();
        Validate.isTrue((Objects.nonNull(task) || Objects.nonNull(historicTaskInstance) ? 1 : 0) != 0, (String)"\u4e0d\u5b58\u5728\u6b64\u4efb\u52a1id\uff01", (Object[])new Object[0]);
        if (Objects.nonNull(task)) {
            processDefinitionId = task.getProcessDefinitionId();
            processInstanceId = task.getProcessInstanceId();
            taskDefinitionKey = task.getTaskDefinitionKey();
            formDate = task.getProcessVariables().get(ProcessConstant.PROCESS_INSTANCE_FORM_DATA_CODE);
        } else {
            processDefinitionId = historicTaskInstance.getProcessDefinitionId();
            processInstanceId = historicTaskInstance.getProcessInstanceId();
            taskDefinitionKey = historicTaskInstance.getTaskDefinitionKey();
            formDate = historicTaskInstance.getProcessVariables().get(ProcessConstant.PROCESS_INSTANCE_FORM_DATA_CODE);
        }
        processDataDetailVo.setTaskId(taskId);
        ProcessTemplateNodeVo processTemplateNodeVo = this.processTemplateNodeService.findByProcessInstanceIdAndTaskDefinitionKey(processInstanceId, taskDefinitionKey);
        if (Objects.isNull(processTemplateNodeVo)) {
            processTemplateNodeVo = this.processTemplateNodeService.findByProcessDefinitionIdAndTaskDefinitionKey(processDefinitionId, taskDefinitionKey);
        }
        ProcessTemplateNodeUserTaskVo processTemplateNodeUserTaskVo = this.processTemplateNodeUserTaskService.findByNodeId(processTemplateNodeVo.getId());
        ProcessTemplateBusiness processTemplateBusiness = this.processTemplateBusinessService.findByProcessTemplateId(processTemplateNodeVo.getTemplateId());
        if (!CollectionUtils.isEmpty((Collection)processTemplateNodeUserTaskVo.getProcessTaskButtons())) {
            processDataDetailVo.setProcessTaskButtons((List)Lists.newArrayList((Iterable)processTemplateNodeUserTaskVo.getProcessTaskButtons()));
        }
        if (!CollectionUtils.isEmpty((Collection)processTemplateNodeUserTaskVo.getProcessTaskIndicators())) {
            JSONArray jsonArray = new JSONArray();
            StringBuilder stringBuilder = new StringBuilder();
            JSONObject jsonObject = JsonUtils.toJSONObject(formDate);
            JSONObject indicatorsValue = new JSONObject();
            indicatorsValue.put(NODE_NAME, (Object)processTemplateNodeVo.getName());
            Map<String, String> indicatorsMap = processTemplateNodeUserTaskVo.getProcessTaskIndicators().stream().collect(Collectors.toMap(ProcessTaskIndicatorsVo::getIndicatorCode, ProcessTaskIndicatorsVo::getIndicatorName, (k1, k2) -> k2));
            List indicatorCodes = processTemplateNodeUserTaskVo.getProcessTaskIndicators().stream().map(ProcessTaskIndicatorsVo::getIndicatorCode).collect(Collectors.toList());
            String functionSubCode = (String)processTemplateNodeUserTaskVo.getProcessTaskIndicators().stream().map(ProcessTaskIndicatorsVo::getFunctionSubCode).collect(Collectors.toList()).get(0);
            for (String indicatorCode : indicatorCodes) {
                stringBuilder.append(indicatorsMap.get(indicatorCode)).append(":");
                ProcessIndicatorStrategy processIndicatorStrategy = this.getProcessIndicatorStrategy(functionSubCode, indicatorCode);
                if (Objects.nonNull(processIndicatorStrategy)) {
                    String value = StringUtils.isBlank((CharSequence)processIndicatorStrategy.onValidate(jsonObject)) ? "\u65e0" : processIndicatorStrategy.onValidate(jsonObject);
                    stringBuilder.append(value).append("\n");
                    continue;
                }
                stringBuilder.append("\n");
            }
            indicatorsValue.put(INDICATORS, (Object)stringBuilder.toString());
            jsonArray.add((Object)indicatorsValue);
            processDataDetailVo.setIndicatorsValue(jsonArray);
        }
        List<ProcessInstanceFilesVo> processInstanceFilesVos = this.processInstanceFilesService.findByProcessInstanceId(processInstanceId);
        processDataDetailVo.setProcessInstanceFilesVos(processInstanceFilesVos);
        processDataDetailVo.setTaskId(taskId);
        processDataDetailVo.setCanEdit(processTemplateNodeUserTaskVo.getCanEdit());
        processDataDetailVo.setFormCode(processTemplateBusiness.getFormCode());
        processDataDetailVo.setFormName(processTemplateBusiness.getFormName());
        processDataDetailVo.setProcessTaskEditFields(processTemplateNodeUserTaskVo.getProcessTaskEditFields());
        processDataDetailVo.setCanComplete(true);
        List<ProcessTaskCommunicateVo> processTaskCommunicateVos = this.taskCommunicateService.findByTaskIdAndStatus(taskId, ProcessCommunicateStatusEnum.untreated.getKey());
        if (!CollectionUtils.isEmpty(processTaskCommunicateVos) && StringUtils.isNotBlank((CharSequence)(processTaskCommunicateVo = processTaskCommunicateVos.get(0)).getNeedComplete()) && processTaskCommunicateVo.getNeedComplete().equals(EnableStatusEnum.ENABLE.getCode())) {
            processDataDetailVo.setCanComplete(false);
        }
        ProcessInstanceEntity processInstance = this.processInstanceService.findByProcessInstanceId(processInstanceId);
        processDataDetailVo.setRemarks(processInstance.getRemark());
        return processDataDetailVo;
    }

    @Override
    public ProcessDataDetailVo findByProcessInstanceId(String processInstanceId) {
        List historicActivityInstances;
        Validate.notBlank((CharSequence)processInstanceId, (String)"\u6d41\u7a0b\u5b9e\u4f8bid\u4e3a\u7a7a\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        ProcessDataDetailVo processDataDetailVo = new ProcessDataDetailVo();
        ProcessInstanceEntity processInstanceEntity = this.processInstanceService.findByProcessInstanceId(processInstanceId);
        Validate.notNull((Object)((Object)processInstanceEntity), (String)"\u6ca1\u6709\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u6d41\u7a0b\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        HashSet taskDefinitionKeys = Sets.newHashSet();
        Object formDate = null;
        List tasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).taskTenantId(TenantUtils.getTenantCode())).list();
        if (!CollectionUtils.isEmpty((Collection)tasks)) {
            tasks.forEach(task -> taskDefinitionKeys.add(task.getTaskDefinitionKey()));
            formDate = ((Task)tasks.get(0)).getProcessVariables().get(ProcessConstant.PROCESS_INSTANCE_FORM_DATA_CODE);
        }
        if (!CollectionUtils.isEmpty((Collection)(historicActivityInstances = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).activityTenantId(TenantUtils.getTenantCode()).orderByHistoricActivityInstanceStartTime().asc()).list()))) {
            historicActivityInstances.forEach(hi -> {
                String activityType = hi.getActivityType();
                if (activityType.equals("userTask")) {
                    taskDefinitionKeys.add(hi.getActivityId());
                }
            });
        }
        if (CollectionUtils.isEmpty((Collection)tasks)) {
            List list = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId)).taskTenantId(TenantUtils.getTenantCode())).list();
            if (CollectionUtils.isEmpty((Collection)list)) {
                return processDataDetailVo;
            }
            formDate = ((HistoricTaskInstance)list.get(0)).getProcessVariables().get(ProcessConstant.PROCESS_INSTANCE_FORM_DATA_CODE);
        }
        processDataDetailVo.setIndicatorsValue(this.setIndicators(processInstanceId, formDate, taskDefinitionKeys));
        ProcessTemplateBusiness processTemplateBusiness = this.processTemplateBusinessService.findByProcessTemplateId(processInstanceEntity.getProcessTemplateId());
        processDataDetailVo.setFormCode(processTemplateBusiness.getFormCode());
        processDataDetailVo.setFormName(processTemplateBusiness.getFormName());
        List<ProcessInstanceFilesVo> processInstanceFilesVos = this.processInstanceFilesService.findByProcessInstanceId(processInstanceId);
        processDataDetailVo.setProcessInstanceFilesVos(processInstanceFilesVos);
        processDataDetailVo.setCanComplete(false);
        List<ProcessTaskCommunicateVo> processTaskCommunicateVos = this.taskCommunicateService.findByProcessInstanceIdAndStatus(processInstanceId, ProcessCommunicateStatusEnum.untreated.getKey());
        if (!CollectionUtils.isEmpty(processTaskCommunicateVos)) {
            ProcessTaskCommunicateVo processTaskCommunicateVo = processTaskCommunicateVos.get(0);
            if (StringUtils.isNotBlank((CharSequence)processTaskCommunicateVo.getNeedComplete()) && processTaskCommunicateVo.getNeedComplete().equals(EnableStatusEnum.ENABLE.getCode())) {
                processDataDetailVo.setCanComplete(true);
            } else {
                processDataDetailVo.setCanComplete(false);
            }
        }
        ProcessInstanceEntity processInstance = this.processInstanceService.findByProcessInstanceId(processInstanceId);
        processDataDetailVo.setRemarks(processInstance.getRemark());
        return processDataDetailVo;
    }

    @Override
    public ProcessSummaryDataDetailVo findSummaryByProcessInstanceId(String processInstanceId) {
        List historicActivityInstances;
        Validate.notBlank((CharSequence)processInstanceId, (String)"\u6d41\u7a0b\u5b9e\u4f8bid\u4e3a\u7a7a\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        ProcessInstanceEntity processInstanceEntity = this.processInstanceService.findByProcessInstanceId(processInstanceId);
        Validate.notNull((Object)((Object)processInstanceEntity), (String)"\u6ca1\u6709\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u6d41\u7a0b\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        ProcessSummaryDataDetailVo processSummaryDataDetailVo = (ProcessSummaryDataDetailVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)processInstanceEntity, ProcessSummaryDataDetailVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        processSummaryDataDetailVo.setSubmitUserCode(processInstanceEntity.getCreateAccount());
        processSummaryDataDetailVo.setSubmitUserName(processInstanceEntity.getCreateName());
        List<ProcessTaskLogEntity> logs = this.processTaskLogRepository.findByProcessInstanceIds(Collections.singletonList(processInstanceId));
        if (!CollectionUtils.isEmpty(logs)) {
            List processTaskLogVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(logs, ProcessTaskLogEntity.class, ProcessTaskLogVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            List<ProcessTaskLogVo> collect = processTaskLogVos.stream().filter(processTaskLogVo -> ProcessOperateTypeEnum.COMMIT.getDictCode().equals(processTaskLogVo.getOperateType()) || ProcessOperateTypeEnum.APPROVED.getDictCode().equals(processTaskLogVo.getOperateType()) || ProcessOperateTypeEnum.REJECTED.getDictCode().equals(processTaskLogVo.getOperateType())).collect(Collectors.toList());
            processSummaryDataDetailVo.setProcessTaskLogs(collect);
        }
        HashSet taskDefinitionKeys = Sets.newHashSet();
        Object formDate = null;
        List tasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).taskTenantId(TenantUtils.getTenantCode())).list();
        if (!CollectionUtils.isEmpty((Collection)tasks)) {
            tasks.forEach(task -> taskDefinitionKeys.add(task.getTaskDefinitionKey()));
            formDate = ((Task)tasks.get(0)).getProcessVariables().get(ProcessConstant.PROCESS_INSTANCE_FORM_DATA_CODE);
        }
        if (!CollectionUtils.isEmpty((Collection)(historicActivityInstances = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).activityTenantId(TenantUtils.getTenantCode()).orderByHistoricActivityInstanceStartTime().asc()).list()))) {
            historicActivityInstances.forEach(hi -> {
                String activityType = hi.getActivityType();
                if (activityType.equals("userTask")) {
                    taskDefinitionKeys.add(hi.getActivityId());
                }
            });
        }
        if (CollectionUtils.isEmpty((Collection)tasks)) {
            List list = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId)).taskTenantId(TenantUtils.getTenantCode())).list();
            if (CollectionUtils.isEmpty((Collection)list)) {
                return processSummaryDataDetailVo;
            }
            formDate = ((HistoricTaskInstance)list.get(0)).getProcessVariables().get(ProcessConstant.PROCESS_INSTANCE_FORM_DATA_CODE);
        }
        processSummaryDataDetailVo.setIndicatorsValue(this.setIndicators(processInstanceId, formDate, taskDefinitionKeys));
        List<ProcessInstanceFilesVo> processInstanceFilesVos = this.processInstanceFilesService.findByProcessInstanceId(processInstanceId);
        processSummaryDataDetailVo.setProcessInstanceFilesVos(processInstanceFilesVos);
        return processSummaryDataDetailVo;
    }

    private JSONArray setIndicators(String processInstanceId, Object formDate, Set<String> taskDefinitionKeys) {
        List processTemplateNodeVos = this.processTemplateNodeService.findByProcessInstanceId(processInstanceId);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)processTemplateNodeVos) ? 1 : 0) != 0, (String)"\u6d41\u7a0b\u4e0b\u4e0d\u5b58\u5728\u8282\u70b9\u914d\u7f6e\uff01", (Object[])new Object[0]);
        List processTemplateNodeVoList = processTemplateNodeVos.stream().filter(processTemplateNodeVo -> taskDefinitionKeys.contains(processTemplateNodeVo.getProcessTaskId())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(processTemplateNodeVoList)) {
            List<String> nodeIds = processTemplateNodeVoList.stream().map(ProcessTemplateNodeVo::getId).collect(Collectors.toList());
            Map<String, String> nodeIdsMap = processTemplateNodeVoList.stream().collect(Collectors.toMap(ProcessTemplateNodeVo::getId, ProcessTemplateNodeVo::getName, (k1, k2) -> k2));
            List<ProcessTaskIndicatorsVo> processTaskIndicatorsVos = this.processTaskIndicatorsService.findByTaskNodeIds(nodeIds);
            if (!CollectionUtils.isEmpty(processTaskIndicatorsVos)) {
                Map<String, List<ProcessTaskIndicatorsVo>> indicatorsVoMap = processTaskIndicatorsVos.stream().collect(Collectors.groupingBy(ProcessTaskIndicatorsVo::getTaskNodeId));
                JSONArray jsonArray = new JSONArray();
                String functionSubCode = processTaskIndicatorsVos.get(0).getFunctionSubCode();
                JSONObject jsonObject = new JSONObject();
                if (Objects.nonNull(formDate)) {
                    jsonObject = JsonUtils.toJSONObject((Object)formDate);
                }
                ArrayList taskNodes = Lists.newArrayList();
                taskNodes.addAll(indicatorsVoMap.keySet());
                for (String taskNode : taskNodes) {
                    JSONObject indicatorsValue = new JSONObject();
                    String taskNodeName = nodeIdsMap.get(taskNode);
                    indicatorsValue.put(NODE_NAME, (Object)taskNodeName);
                    List<ProcessTaskIndicatorsVo> indicatorsVos = indicatorsVoMap.get(taskNode);
                    StringBuilder stringBuilder = new StringBuilder();
                    if (!CollectionUtils.isEmpty(indicatorsVos)) {
                        for (ProcessTaskIndicatorsVo indicatorsVo : indicatorsVos) {
                            stringBuilder.append(indicatorsVo.getIndicatorName()).append(":");
                            ProcessIndicatorStrategy processIndicatorStrategy = this.getProcessIndicatorStrategy(functionSubCode, indicatorsVo.getIndicatorCode());
                            if (Objects.nonNull(processIndicatorStrategy)) {
                                String value = StringUtils.isBlank((CharSequence)processIndicatorStrategy.onValidate(jsonObject)) ? "\u65e0" : processIndicatorStrategy.onValidate(jsonObject);
                                stringBuilder.append(value).append("\n");
                                continue;
                            }
                            stringBuilder.append("\n");
                        }
                    }
                    indicatorsValue.put(INDICATORS, (Object)stringBuilder.toString());
                    jsonArray.add((Object)indicatorsValue);
                }
                return jsonArray;
            }
        }
        return null;
    }

    private ProcessIndicatorStrategy getProcessIndicatorStrategy(String functionSubCode, String indicatorCode) {
        Collection processIndicatorStrategies = this.processTemplateRegister.getProcessIndicatorStrategies();
        for (Class clazz : processIndicatorStrategies) {
            ProcessIndicatorStrategy processIndicatorStrategy = (ProcessIndicatorStrategy)this.ac.getBean(clazz);
            if (!processIndicatorStrategy.getFunctionSubCode().equals(functionSubCode) || !processIndicatorStrategy.getProcessIndicatorCode().equals(indicatorCode)) continue;
            return processIndicatorStrategy;
        }
        return null;
    }
}

