/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.service.internal;

import com.biz.crm.workflow.local.entity.ProcessDelegateConfigDetail;
import com.biz.crm.workflow.local.repository.ProcessDelegateConfigDetailRepository;
import com.biz.crm.workflow.local.service.ProcessDelegateConfigDetailService;
import com.biz.crm.workflow.sdk.dto.ProcessDelegateConfigDetailDto;
import com.biz.crm.workflow.sdk.vo.ProcessDelegateConfigDetailVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="ProcessDelegateConfigDetailService")
public class ProcessDelegateConfigDetailServiceImpl
implements ProcessDelegateConfigDetailService {
    @Autowired
    private ProcessDelegateConfigDetailRepository processDelegateConfigDetailRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public List<ProcessDelegateConfigDetailVo> findByConfigIdAndProcessDelegateTypeCode(String configId, String processDelegateTypeCode) {
        if (StringUtils.isBlank((CharSequence)configId) || StringUtils.isBlank((CharSequence)processDelegateTypeCode)) {
            return null;
        }
        List<ProcessDelegateConfigDetail> processCopyConfigs = this.processDelegateConfigDetailRepository.findByConfigIdAndProcessDelegateTypeCode(configId, processDelegateTypeCode);
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(processCopyConfigs, ProcessDelegateConfigDetail.class, ProcessDelegateConfigDetailVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    @Override
    @Transactional
    public List<ProcessDelegateConfigDetailVo> createBatch(List<ProcessDelegateConfigDetailDto> processDelegateConfigDetailDtos) {
        this.createValidate(processDelegateConfigDetailDtos);
        List processDelegateConfigTemplateDetails = (List)this.nebulaToolkitService.copyCollectionByWhiteList(processDelegateConfigDetailDtos, ProcessDelegateConfigDetailDto.class, ProcessDelegateConfigDetail.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.processDelegateConfigDetailRepository.saveBatch(processDelegateConfigTemplateDetails);
        List processDelegateConfigDetailVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)processDelegateConfigTemplateDetails, ProcessDelegateConfigDetail.class, ProcessDelegateConfigDetailVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return processDelegateConfigDetailVos;
    }

    @Override
    @Transactional
    public List<ProcessDelegateConfigDetailVo> updateBatch(List<ProcessDelegateConfigDetailDto> processDelegateConfigDetailDtos) {
        this.updateValidate(processDelegateConfigDetailDtos);
        Set<String> collect = processDelegateConfigDetailDtos.stream().map(ProcessDelegateConfigDetailDto::getProcessDelegateConfigId).collect(Collectors.toSet());
        this.deleteByConfigId(collect);
        List processDelegateConfigTemplateDetails = (List)this.nebulaToolkitService.copyCollectionByWhiteList(processDelegateConfigDetailDtos, ProcessDelegateConfigDetailDto.class, ProcessDelegateConfigDetail.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.processDelegateConfigDetailRepository.saveBatch(processDelegateConfigTemplateDetails);
        List processDelegateConfigTemplateDetailVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)processDelegateConfigTemplateDetails, ProcessDelegateConfigDetail.class, ProcessDelegateConfigDetailVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return processDelegateConfigTemplateDetailVos;
    }

    @Override
    @Transactional
    public void deleteByConfigId(Collection<String> configIds) {
        Validate.isTrue((!CollectionUtils.isEmpty(configIds) ? 1 : 0) != 0, (String)"\u6d41\u7a0b\u914d\u7f6eid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.processDelegateConfigDetailRepository.deleteByConfigId(configIds);
    }

    @Override
    public List<ProcessDelegateConfigDetailVo> findByConfigIds(Collection<String> configIds) {
        List<ProcessDelegateConfigDetail> list = this.processDelegateConfigDetailRepository.findByConfigIds(configIds);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        List processDelegateConfigTemplateDetailVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(list, ProcessDelegateConfigDetail.class, ProcessDelegateConfigDetailVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return processDelegateConfigTemplateDetailVos;
    }

    private void createValidate(List<ProcessDelegateConfigDetailDto> processDelegateConfigDetailDtos) {
        Validate.isTrue((!CollectionUtils.isEmpty(processDelegateConfigDetailDtos) ? 1 : 0) != 0, (String)"\u4f20\u5165\u6d41\u7a0b\u6a21\u677f\u6570\u636e\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        processDelegateConfigDetailDtos.forEach(processDelegateConfigDetailDto -> {
            processDelegateConfigDetailDto.setId(null);
            Validate.notBlank((CharSequence)processDelegateConfigDetailDto.getCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)processDelegateConfigDetailDto.getName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)processDelegateConfigDetailDto.getProcessDelegateConfigId(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u59d4\u6258\u914d\u7f6eid \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        });
    }

    private void updateValidate(List<ProcessDelegateConfigDetailDto> processDelegateConfigDetailDtos) {
        Validate.isTrue((!CollectionUtils.isEmpty(processDelegateConfigDetailDtos) ? 1 : 0) != 0, (String)"\u4f20\u5165\u6d41\u7a0b\u6a21\u677f\u6570\u636e\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        processDelegateConfigDetailDtos.forEach(processDelegateConfigDetailDto -> {
            Validate.notNull((Object)processDelegateConfigDetailDto, (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            processDelegateConfigDetailDto.setId(null);
            Validate.notBlank((CharSequence)processDelegateConfigDetailDto.getCode(), (String)"\u4fee\u6539\u65f6\uff0c\u4e1a\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)processDelegateConfigDetailDto.getName(), (String)"\u4fee\u6539\u65f6\uff0c\u4e1a\u52a1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)processDelegateConfigDetailDto.getProcessDelegateConfigId(), (String)"\u4fee\u6539\u65f6\uff0c\u59d4\u6258\u914d\u7f6eid \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        });
    }
}

