/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.workflow.local.entity.ProcessDelegateConfig;
import com.biz.crm.workflow.local.entity.ProcessDelegateLog;
import com.biz.crm.workflow.local.repository.ProcessDelegateConfigRepository;
import com.biz.crm.workflow.local.repository.ProcessDelegateLogRepository;
import com.biz.crm.workflow.local.service.ProcessDelegateConfigDetailService;
import com.biz.crm.workflow.local.service.ProcessDelegateConfigService;
import com.biz.crm.workflow.local.service.ProcessDelegateConfigTemplateDetailService;
import com.biz.crm.workflow.local.service.ProcessDelegateMandataryConfigDetailService;
import com.biz.crm.workflow.local.service.ProcessTaskCopyService;
import com.biz.crm.workflow.local.service.ProcessTemplateVoService;
import com.biz.crm.workflow.sdk.constant.enums.DelegateConfigStatus;
import com.biz.crm.workflow.sdk.dto.ProcessDelegateConfigDto;
import com.biz.crm.workflow.sdk.dto.ProcessDelegateCopyDto;
import com.biz.crm.workflow.sdk.dto.ProcessTaskCopyDto;
import com.biz.crm.workflow.sdk.strategy.delegatetype.ProcessDelegateMandataryTypeStrategy;
import com.biz.crm.workflow.sdk.strategy.delegatetype.ProcessDelegateTypeStrategy;
import com.biz.crm.workflow.sdk.vo.ProcessDelegateConfigDetailVo;
import com.biz.crm.workflow.sdk.vo.ProcessDelegateConfigTemplateDetailVo;
import com.biz.crm.workflow.sdk.vo.ProcessDelegateConfigVo;
import com.biz.crm.workflow.sdk.vo.ProcessDelegateMandataryConfigDetailVo;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="ProcessDelegateConfigService")
public class ProcessDelegateConfigServiceImpl
implements ProcessDelegateConfigService {
    @Autowired
    private ProcessDelegateConfigRepository processDelegateConfigRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private List<ProcessDelegateTypeStrategy> processDelegateTypeStrategies;
    @Autowired
    private List<ProcessDelegateMandataryTypeStrategy> processDelegateMandataryTypeStrategies;
    @Autowired
    private GenerateCodeService generateCodeService;
    @Autowired
    private ProcessDelegateConfigDetailService processDelegateConfigDetailService;
    @Autowired
    private ProcessDelegateMandataryConfigDetailService processDelegateMandataryConfigDetailService;
    @Autowired
    private ProcessDelegateConfigTemplateDetailService processDelegateConfigTemplateDetailService;
    @Autowired
    private ProcessDelegateLogRepository processDelegateLogRepository;
    @Autowired
    private ProcessTaskCopyService processTaskCopyService;
    @Autowired
    private ProcessTemplateVoService processTemplateService;

    @Override
    public Page<ProcessDelegateConfig> findByConditions(Pageable pageable, ProcessDelegateConfig processDelegateConfig) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull((Object)processDelegateConfig)) {
            processDelegateConfig = new ProcessDelegateConfig();
        }
        processDelegateConfig.setTenantCode(TenantUtils.getTenantCode());
        return this.processDelegateConfigRepository.findByConditions(pageable, processDelegateConfig);
    }

    @Override
    public ProcessDelegateConfigVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        ProcessDelegateConfig processDelegateConfig = this.processDelegateConfigRepository.findByIdAndTenantCode(id, TenantUtils.getTenantCode());
        if (Objects.isNull((Object)processDelegateConfig)) {
            return null;
        }
        ProcessDelegateConfigVo processDelegateConfigVo = (ProcessDelegateConfigVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)processDelegateConfig, ProcessDelegateConfigVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        ArrayList processDelegateConfigDetailVos = Lists.newArrayList();
        ArrayList processDelegateMandataryConfigDetailVos = Lists.newArrayList();
        this.processDelegateTypeStrategies.forEach(processDelegateTypeStrategy -> {
            List list = processDelegateTypeStrategy.findByDelegateConfigId(processDelegateConfig.getId());
            if (!CollectionUtils.isEmpty((Collection)list)) {
                processDelegateConfigDetailVos.addAll(list);
            }
        });
        this.processDelegateMandataryTypeStrategies.forEach(processDelegateTypeStrategy -> {
            List list = processDelegateTypeStrategy.findByDelegateConfigId(processDelegateConfig.getId());
            if (!CollectionUtils.isEmpty((Collection)list)) {
                processDelegateMandataryConfigDetailVos.addAll(list);
            }
        });
        List<ProcessDelegateConfigTemplateDetailVo> processDelegateConfigTemplateDetailVos = this.processDelegateConfigTemplateDetailService.findByConfigId(processDelegateConfigVo.getId());
        processDelegateConfigVo.setDetails((List)processDelegateConfigDetailVos);
        processDelegateConfigVo.setMandataryDetails((List)processDelegateMandataryConfigDetailVos);
        processDelegateConfigVo.setTemplateDetails(processDelegateConfigTemplateDetailVos);
        return processDelegateConfigVo;
    }

    @Override
    @Transactional
    public ProcessDelegateConfigVo create(ProcessDelegateConfigDto processDelegateConfigDto) {
        List delegateMandataryConfigDetailVos;
        this.createValidate(processDelegateConfigDto);
        String code = (String)this.generateCodeService.generateCode("WTPZ", 1).get(0);
        processDelegateConfigDto.setDelegateConfigCode(code);
        ProcessDelegateConfig processDelegateConfig = (ProcessDelegateConfig)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)processDelegateConfigDto, ProcessDelegateConfig.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        processDelegateConfig.setTenantCode(TenantUtils.getTenantCode());
        this.processDelegateConfigRepository.saveOrUpdate((Object)processDelegateConfig);
        processDelegateConfigDto.setId(processDelegateConfig.getId());
        List processDelegateTypeStrategyList = this.processDelegateTypeStrategies.stream().filter(processDelegateTypeStrategy -> processDelegateTypeStrategy.getProcessDelegateTypeCode().equals(processDelegateConfigDto.getDelegatePersonType())).collect(Collectors.toList());
        List mandataryTypeStrategies = this.processDelegateMandataryTypeStrategies.stream().filter(processDelegateTypeStrategy -> processDelegateTypeStrategy.getProcessDelegateTypeCode().equals(processDelegateConfigDto.getProcessDelegateTypeCode())).collect(Collectors.toList());
        Validate.notNull(processDelegateTypeStrategyList, (String)"\u4e0d\u5b58\u5728\u59d4\u6258\u4eba\u6ce8\u518c\u4fe1\u606f\uff01", (Object[])new Object[0]);
        Validate.notNull(mandataryTypeStrategies, (String)"\u4e0d\u5b58\u5728\u59d4\u6258\u4eba\u6ce8\u518c\u4fe1\u606f\uff01", (Object[])new Object[0]);
        ProcessDelegateTypeStrategy processDelegateTypeStrategy2 = (ProcessDelegateTypeStrategy)processDelegateTypeStrategyList.get(0);
        ProcessDelegateMandataryTypeStrategy mandataryTypeStrategy = (ProcessDelegateMandataryTypeStrategy)mandataryTypeStrategies.get(0);
        ProcessDelegateConfigVo processDelegateConfigVo = (ProcessDelegateConfigVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)processDelegateConfig, ProcessDelegateConfigVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        List processDelegateConfigDetailVoList = processDelegateTypeStrategy2.onCreate(processDelegateConfigDto);
        if (!CollectionUtils.isEmpty((Collection)processDelegateConfigDetailVoList)) {
            processDelegateConfigVo.setDetails(processDelegateConfigDetailVoList);
        }
        if (!CollectionUtils.isEmpty((Collection)(delegateMandataryConfigDetailVos = mandataryTypeStrategy.onCreate(processDelegateConfigDto)))) {
            processDelegateConfigVo.setMandataryDetails(delegateMandataryConfigDetailVos);
        }
        if (!processDelegateConfigDto.getCanAllProcess().booleanValue()) {
            List templateDetails = processDelegateConfigDto.getTemplateDetails();
            Validate.isTrue((!CollectionUtils.isEmpty((Collection)templateDetails) ? 1 : 0) != 0, (String)"\u6d41\u7a0b\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            templateDetails.forEach(processDelegateConfigTemplateDetailDto -> processDelegateConfigTemplateDetailDto.setProcessDelegateConfigId(processDelegateConfig.getId()));
            List<ProcessDelegateConfigTemplateDetailVo> configTemplateDetailVo = this.processDelegateConfigTemplateDetailService.createBatch(processDelegateConfigDto.getTemplateDetails());
            processDelegateConfigVo.setTemplateDetails(configTemplateDetailVo);
        }
        return processDelegateConfigVo;
    }

    @Override
    @Transactional
    public ProcessDelegateConfigVo update(ProcessDelegateConfigDto processDelegateConfigDto) {
        List delegateMandataryConfigDetailVos;
        this.updateValidate(processDelegateConfigDto);
        ProcessDelegateConfig processDelegateConfig = (ProcessDelegateConfig)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)processDelegateConfigDto, ProcessDelegateConfig.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        processDelegateConfig.setTenantCode(TenantUtils.getTenantCode());
        this.processDelegateConfigRepository.saveOrUpdate((Object)processDelegateConfig);
        List processDelegateTypeStrategyList = this.processDelegateTypeStrategies.stream().filter(processDelegateTypeStrategy -> processDelegateTypeStrategy.getProcessDelegateTypeCode().equals(processDelegateConfigDto.getDelegatePersonType())).collect(Collectors.toList());
        List mandataryTypeStrategies = this.processDelegateMandataryTypeStrategies.stream().filter(processDelegateTypeStrategy -> processDelegateTypeStrategy.getProcessDelegateTypeCode().equals(processDelegateConfigDto.getProcessDelegateTypeCode())).collect(Collectors.toList());
        Validate.notNull(processDelegateTypeStrategyList, (String)"\u4e0d\u5b58\u5728\u59d4\u6258\u4eba\u6ce8\u518c\u4fe1\u606f\uff01", (Object[])new Object[0]);
        Validate.notNull(mandataryTypeStrategies, (String)"\u4e0d\u5b58\u5728\u59d4\u6258\u4eba\u6ce8\u518c\u4fe1\u606f\uff01", (Object[])new Object[0]);
        ProcessDelegateTypeStrategy processDelegateTypeStrategy2 = (ProcessDelegateTypeStrategy)processDelegateTypeStrategyList.get(0);
        ProcessDelegateMandataryTypeStrategy mandataryTypeStrategy = (ProcessDelegateMandataryTypeStrategy)mandataryTypeStrategies.get(0);
        ProcessDelegateConfigVo processDelegateConfigVo = (ProcessDelegateConfigVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)processDelegateConfig, ProcessDelegateConfigVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        List processDelegateConfigDetailVoList = processDelegateTypeStrategy2.onUpdate(processDelegateConfigDto);
        if (!CollectionUtils.isEmpty((Collection)processDelegateConfigDetailVoList)) {
            processDelegateConfigVo.setDetails(processDelegateConfigDetailVoList);
        }
        if (!CollectionUtils.isEmpty((Collection)(delegateMandataryConfigDetailVos = mandataryTypeStrategy.onUpdate(processDelegateConfigDto)))) {
            processDelegateConfigVo.setMandataryDetails(delegateMandataryConfigDetailVos);
        }
        processDelegateConfigDto.getTemplateDetails().forEach(processDelegateConfigTemplateDetailDto -> processDelegateConfigTemplateDetailDto.setProcessDelegateConfigId(processDelegateConfig.getId()));
        List<ProcessDelegateConfigTemplateDetailVo> configTemplateDetailVo = this.processDelegateConfigTemplateDetailService.updateBatch(processDelegateConfigDto.getTemplateDetails());
        processDelegateConfigVo.setTemplateDetails(configTemplateDetailVo);
        return processDelegateConfigVo;
    }

    @Override
    @Transactional
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.processDelegateConfigRepository.removeByIdsAndTenantCode(idList, TenantUtils.getTenantCode());
        this.processDelegateTypeStrategies.forEach(processDelegateTypeStrategy -> processDelegateTypeStrategy.deleteByDelegateConfigId(idList));
        this.processDelegateMandataryTypeStrategies.forEach(processDelegateTypeStrategy -> processDelegateTypeStrategy.deleteByDelegateConfigId(idList));
        this.processDelegateConfigTemplateDetailService.deleteByConfigId(idList);
    }

    @Override
    @Transactional
    public Collection<String> getUserName(ProcessDelegateCopyDto dto) {
        Validate.notNull((Object)dto, (String)"\u6d41\u7a0b\u8f6c\u529e\u65f6\u9a8c\u8bc1\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u5bfb\u4eba\u53c2\u6570!", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getCreateTime(), (String)"\u6d41\u7a0b\u8f6c\u529e\u65f6\u9a8c\u8bc1\u65f6\uff0c\u6d41\u7a0b\u521b\u5efa\u65f6\u95f4\u5fc5\u987b\u586b\u5199!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getProcessTemplateId(), (String)"\u6d41\u7a0b\u8f6c\u529e\u65f6\u9a8c\u8bc1\u65f6\uff0c\u6d41\u7a0b\u6a21\u677fid\u5fc5\u987b\u586b\u5199!", (Object[])new Object[0]);
        ProcessTemplateVo processTemplate = this.processTemplateService.findDetailById(dto.getProcessTemplateId(), false);
        Validate.notNull((Object)processTemplate, (String)"\u6d41\u7a0b\u59d4\u6258\u65f6\u9a8c\u8bc1\u65f6\uff0c\u6d41\u7a0b\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        dto.setProcessName(processTemplate.getProcessName());
        dto.setProcessKey(processTemplate.getProcessKey());
        if (CollectionUtils.isEmpty((Collection)dto.getUserNames())) {
            return null;
        }
        List<ProcessDelegateConfig> processDelegateConfigs = this.processDelegateConfigRepository.findByProcessCreateTimeAndProcessTemplateId(dto.getCreateTime(), dto.getProcessTemplateId());
        if (CollectionUtils.isEmpty(processDelegateConfigs)) {
            return dto.getUserNames();
        }
        List<ProcessDelegateConfigVo> list = this.buildData(processDelegateConfigs);
        HashSet userNameTypeAdd = new HashSet();
        HashSet<String> userNameTypeDel = new HashSet<String>();
        HashSet processDelegateLogs = Sets.newHashSet();
        HashSet processTaskCopyDtoList = Sets.newHashSet();
        String tenantCode = TenantUtils.getTenantCode();
        for (ProcessDelegateConfigVo processDelegateConfigVo : list) {
            String delegatePersonType = processDelegateConfigVo.getDelegatePersonType();
            String processDelegateTypeCode = processDelegateConfigVo.getProcessDelegateTypeCode();
            List details = processDelegateConfigVo.getDetails();
            List mandataryDetails = processDelegateConfigVo.getMandataryDetails();
            Set delegateUserNames = details.stream().map(ProcessDelegateConfigDetailVo::getCode).collect(Collectors.toSet());
            Set mandataryUserNames = mandataryDetails.stream().map(ProcessDelegateMandataryConfigDetailVo::getCode).collect(Collectors.toSet());
            List typeStrategies = this.processDelegateTypeStrategies.stream().filter(processDelegateTypeStrategy -> processDelegateTypeStrategy.getProcessDelegateTypeCode().equals(delegatePersonType)).collect(Collectors.toList());
            List mandataryTypeStrategies = this.processDelegateMandataryTypeStrategies.stream().filter(processDelegateTypeStrategy -> processDelegateTypeStrategy.getProcessDelegateTypeCode().equals(processDelegateTypeCode)).collect(Collectors.toList());
            Set delegates = ((ProcessDelegateTypeStrategy)typeStrategies.get(0)).onHandle(delegateUserNames);
            Set<String> oldAssignees = dto.getUserNames().stream().filter(delegates::contains).collect(Collectors.toSet());
            if (CollectionUtils.isEmpty(oldAssignees)) continue;
            Set newAssignees = ((ProcessDelegateMandataryTypeStrategy)mandataryTypeStrategies.get(0)).onHandle(mandataryUserNames);
            userNameTypeAdd.addAll(newAssignees);
            userNameTypeDel.addAll(oldAssignees);
            if (!dto.isSaveLog() || CollectionUtils.isEmpty((Collection)newAssignees) || !StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dto.getTaskDefinitionKey()}) || !StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dto.getTaskId()}) || !StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dto.getProcessInstanceId()})) continue;
            processDelegateLogs.addAll(this.buildProcessDelegateLog(processDelegateConfigVo, tenantCode, dto, newAssignees, oldAssignees));
            if (!processDelegateConfigVo.getCanCopy().booleanValue()) continue;
            oldAssignees.forEach(userName -> processTaskCopyDtoList.addAll(this.buildProcessTaskCopy(oldAssignees, dto)));
        }
        if (dto.isSaveLog() && !CollectionUtils.isEmpty((Collection)processDelegateLogs) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dto.getTaskDefinitionKey()}) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dto.getTaskId()}) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dto.getProcessInstanceId()})) {
            this.processDelegateLogRepository.saveBatch(processDelegateLogs);
            if (!CollectionUtils.isEmpty((Collection)processTaskCopyDtoList)) {
                this.processTaskCopyService.createBatch(processTaskCopyDtoList);
            }
        }
        dto.getUserNames().addAll(userNameTypeAdd);
        dto.getUserNames().removeAll(userNameTypeDel);
        return dto.getUserNames();
    }

    @Override
    @Transactional
    public void revocationBatch(List<String> ids) {
        this.processDelegateConfigRepository.updateDelegateConfigStatusByIds(ids, DelegateConfigStatus.CLOSE.getDictCode());
    }

    private void createValidate(ProcessDelegateConfigDto processDelegateConfigDto) {
        Validate.notNull((Object)processDelegateConfigDto, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        processDelegateConfigDto.setId(null);
        Validate.notNull((Object)processDelegateConfigDto.getCanAllProcess(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u662f\u5426\u5168\u90e8\u6d41\u7a0b \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)processDelegateConfigDto.getCanCopy(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u662f\u5426\u6284\u9001\u59d4\u6258\u4eba \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processDelegateConfigDto.getDelegatePersonType(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u59d4\u6258\u4eba\u7c7b\u578b \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processDelegateConfigDto.getProcessDelegateTypeCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u59d4\u6258\u65b9\u5f0f \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)processDelegateConfigDto.getEndTime(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d41\u7a0b\u5b9e\u4f8bid \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)processDelegateConfigDto.getStartTime(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5f00\u59cb\u65f6\u95f4 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        processDelegateConfigDto.setTenantCode(TenantUtils.getTenantCode());
        processDelegateConfigDto.setDelegateConfigStatus(DelegateConfigStatus.DELEGATION_ING.getDictCode());
        Validate.isTrue((processDelegateConfigDto.getEndTime().getTime() >= new Date().getTime() ? 1 : 0) != 0, (String)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u65f6\u95f4", (Object[])new Object[0]);
    }

    private void updateValidate(ProcessDelegateConfigDto processDelegateConfigDto) {
        Validate.notNull((Object)processDelegateConfigDto, (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processDelegateConfigDto.getId(), (String)"\u4fee\u6539\u65f6\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        processDelegateConfigDto.setTenantCode(TenantUtils.getTenantCode());
        Validate.notNull((Object)processDelegateConfigDto.getCanAllProcess(), (String)"\u4fee\u6539\u65f6\uff0c\u662f\u5426\u5168\u90e8\u6d41\u7a0b \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)processDelegateConfigDto.getCanCopy(), (String)"\u4fee\u6539\u65f6\uff0c\u662f\u5426\u6284\u9001\u59d4\u6258\u4eba \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processDelegateConfigDto.getDelegatePersonType(), (String)"\u4fee\u6539\u65f6\uff0c\u59d4\u6258\u4eba\u7c7b\u578b \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processDelegateConfigDto.getProcessDelegateTypeCode(), (String)"\u4fee\u6539\u65f6\uff0c\u59d4\u6258\u65b9\u5f0f \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)processDelegateConfigDto.getEndTime(), (String)"\u4fee\u6539\u65f6\uff0c\u6d41\u7a0b\u5b9e\u4f8bid \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)processDelegateConfigDto.getStartTime(), (String)"\u4fee\u6539\u65f6\uff0c\u5f00\u59cb\u65f6\u95f4 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        processDelegateConfigDto.setDelegateConfigStatus(DelegateConfigStatus.DELEGATION_ING.getDictCode());
        Validate.isTrue((processDelegateConfigDto.getEndTime().getTime() >= new Date().getTime() ? 1 : 0) != 0, (String)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u65f6\u95f4", (Object[])new Object[0]);
    }

    private List<ProcessDelegateConfigVo> buildData(List<ProcessDelegateConfig> processDelegateConfigs) {
        List<String> configIds = processDelegateConfigs.stream().map(UuidEntity::getId).collect(Collectors.toList());
        List<ProcessDelegateConfigDetailVo> delegateConfigDetailVos = this.processDelegateConfigDetailService.findByConfigIds(configIds);
        List<ProcessDelegateMandataryConfigDetailVo> mandataryConfigDetailVos = this.processDelegateMandataryConfigDetailService.findByConfigIds(configIds);
        List processDelegateConfigVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(processDelegateConfigs, ProcessDelegateConfig.class, ProcessDelegateConfigVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        Map<String, List<ProcessDelegateConfigDetailVo>> indicatorsVoMap = delegateConfigDetailVos.stream().collect(Collectors.groupingBy(ProcessDelegateConfigDetailVo::getProcessDelegateConfigId));
        Map<String, List<ProcessDelegateMandataryConfigDetailVo>> mandataryVoMap = mandataryConfigDetailVos.stream().collect(Collectors.groupingBy(ProcessDelegateMandataryConfigDetailVo::getProcessDelegateConfigId));
        for (ProcessDelegateConfigVo processDelegateConfigVo : processDelegateConfigVos) {
            String id = processDelegateConfigVo.getId();
            processDelegateConfigVo.setDetails(indicatorsVoMap.get(id));
            processDelegateConfigVo.setMandataryDetails(mandataryVoMap.get(id));
        }
        return processDelegateConfigVos;
    }

    private List<ProcessDelegateLog> buildProcessDelegateLog(ProcessDelegateConfigVo processDelegateConfigVo, String tenantCode, ProcessDelegateCopyDto dto, Set<String> newAssignees, Set<String> oldAssignees) {
        ArrayList<ProcessDelegateLog> processDelegateLogs = new ArrayList<ProcessDelegateLog>();
        String delegateConfigCode = processDelegateConfigVo.getDelegateConfigCode();
        Date startTime = processDelegateConfigVo.getStartTime();
        Date endTime = processDelegateConfigVo.getEndTime();
        ProcessDelegateLog processDelegateLog = new ProcessDelegateLog();
        processDelegateLog.setProcessInstanceId(dto.getProcessInstanceId());
        processDelegateLog.setProcessTaskId(dto.getTaskId());
        processDelegateLog.setProcessTaskKey(dto.getTaskDefinitionKey());
        processDelegateLog.setDelegateConfigCode(delegateConfigCode);
        processDelegateLog.setProcessTemplateId(dto.getProcessTemplateId());
        processDelegateLog.setStartTime(startTime);
        processDelegateLog.setEndTime(endTime);
        processDelegateLog.setProcessOldAssignee(oldAssignees.toString());
        processDelegateLog.setProcessNewAssignee(newAssignees.toString());
        processDelegateLog.setTenantCode(tenantCode);
        processDelegateLogs.add(processDelegateLog);
        return processDelegateLogs;
    }

    private List<ProcessTaskCopyDto> buildProcessTaskCopy(Set<String> userNames, ProcessDelegateCopyDto dto) {
        ArrayList<ProcessTaskCopyDto> list = new ArrayList<ProcessTaskCopyDto>();
        userNames.forEach(userName -> {
            ProcessTaskCopyDto copyDto = new ProcessTaskCopyDto();
            copyDto.setProcessName(dto.getProcessName());
            copyDto.setProcessInstanceId(dto.getProcessInstanceId());
            copyDto.setCommitTime(dto.getCreateTime());
            copyDto.setCommitUserCode(dto.getCommitUserCode());
            copyDto.setCommitUserName(dto.getCommitUserName());
            copyDto.setBusinessFormNo(dto.getBusinessFormNo());
            copyDto.setProcessTitle(dto.getProcessTitle());
            copyDto.setProcessKey(dto.getProcessKey());
            copyDto.setTenantCode(TenantUtils.getTenantCode());
            copyDto.setTaskId(dto.getTaskId());
            copyDto.setTaskName(dto.getTaskName());
            copyDto.setUserCode(userName);
            list.add(copyDto);
        });
        return list;
    }
}

