/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.service.internal;

import com.biz.crm.workflow.local.entity.ProcessDelegateMandataryConfigDetail;
import com.biz.crm.workflow.local.repository.ProcessDelegateMandataryConfigDetailRepository;
import com.biz.crm.workflow.local.service.ProcessDelegateMandataryConfigDetailService;
import com.biz.crm.workflow.sdk.dto.ProcessDelegateMandataryConfigDetailDto;
import com.biz.crm.workflow.sdk.vo.ProcessDelegateMandataryConfigDetailVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="ProcessDelegateMandataryConfigDetailService")
public class ProcessDelegateMandataryConfigDetailServiceImpl
implements ProcessDelegateMandataryConfigDetailService {
    @Autowired
    private ProcessDelegateMandataryConfigDetailRepository processDelegateMandataryConfigDetailRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public List<ProcessDelegateMandataryConfigDetailVo> findByConfigIdAndProcessDelegateTypeCode(String configId, String processDelegateTypeCode) {
        if (StringUtils.isBlank((CharSequence)configId) || StringUtils.isBlank((CharSequence)processDelegateTypeCode)) {
            return null;
        }
        List<ProcessDelegateMandataryConfigDetail> processCopyConfigs = this.processDelegateMandataryConfigDetailRepository.findByConfigIdAndProcessDelegateTypeCode(configId, processDelegateTypeCode);
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(processCopyConfigs, ProcessDelegateMandataryConfigDetail.class, ProcessDelegateMandataryConfigDetailVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    @Override
    @Transactional
    public List<ProcessDelegateMandataryConfigDetailVo> createBatch(List<ProcessDelegateMandataryConfigDetailDto> processDelegateMandataryConfigDetailDtos) {
        this.createValidate(processDelegateMandataryConfigDetailDtos);
        List processDelegateConfigTemplateDetails = (List)this.nebulaToolkitService.copyCollectionByWhiteList(processDelegateMandataryConfigDetailDtos, ProcessDelegateMandataryConfigDetailDto.class, ProcessDelegateMandataryConfigDetail.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.processDelegateMandataryConfigDetailRepository.saveBatch(processDelegateConfigTemplateDetails);
        List processDelegateConfigTemplateDetailVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)processDelegateConfigTemplateDetails, ProcessDelegateMandataryConfigDetail.class, ProcessDelegateMandataryConfigDetailVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return processDelegateConfigTemplateDetailVos;
    }

    @Override
    @Transactional
    public List<ProcessDelegateMandataryConfigDetailVo> updateBatch(List<ProcessDelegateMandataryConfigDetailDto> processDelegateMandataryConfigDetailDtos) {
        this.updateValidate(processDelegateMandataryConfigDetailDtos);
        Set<String> collect = processDelegateMandataryConfigDetailDtos.stream().map(ProcessDelegateMandataryConfigDetailDto::getProcessDelegateConfigId).collect(Collectors.toSet());
        this.deleteByConfigId(collect);
        List processDelegateConfigTemplateDetails = (List)this.nebulaToolkitService.copyCollectionByWhiteList(processDelegateMandataryConfigDetailDtos, ProcessDelegateMandataryConfigDetailDto.class, ProcessDelegateMandataryConfigDetail.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.processDelegateMandataryConfigDetailRepository.saveBatch(processDelegateConfigTemplateDetails);
        List processDelegateConfigTemplateDetailVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)processDelegateConfigTemplateDetails, ProcessDelegateMandataryConfigDetail.class, ProcessDelegateMandataryConfigDetailVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return processDelegateConfigTemplateDetailVos;
    }

    @Override
    @Transactional
    public void deleteByConfigId(Collection<String> configIds) {
        Validate.isTrue((!CollectionUtils.isEmpty(configIds) ? 1 : 0) != 0, (String)"\u6d41\u7a0b\u914d\u7f6eid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.processDelegateMandataryConfigDetailRepository.deleteByConfig(configIds);
    }

    @Override
    public List<ProcessDelegateMandataryConfigDetailVo> findByConfigIds(Collection<String> configIds) {
        List<ProcessDelegateMandataryConfigDetail> list = this.processDelegateMandataryConfigDetailRepository.findByConfigIds(configIds);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        List processDelegateConfigTemplateDetailVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(list, ProcessDelegateMandataryConfigDetail.class, ProcessDelegateMandataryConfigDetailVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return processDelegateConfigTemplateDetailVos;
    }

    private void createValidate(List<ProcessDelegateMandataryConfigDetailDto> processDelegateMandataryConfigDetailDtos) {
        Validate.isTrue((!CollectionUtils.isEmpty(processDelegateMandataryConfigDetailDtos) ? 1 : 0) != 0, (String)"\u4f20\u5165\u6d41\u7a0b\u6a21\u677f\u6570\u636e\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        processDelegateMandataryConfigDetailDtos.forEach(processDelegateMandataryConfigDetailDto -> {
            Validate.notNull((Object)processDelegateMandataryConfigDetailDto, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            processDelegateMandataryConfigDetailDto.setId(null);
            Validate.notBlank((CharSequence)processDelegateMandataryConfigDetailDto.getCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u59d4\u6258\u914d\u7f6e\u7b56\u7565\u4e2d\u9009\u62e9\u7684\u4e1a\u52a1\u7f16\u7801 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)processDelegateMandataryConfigDetailDto.getName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u59d4\u6258\u914d\u7f6e\u7b56\u7565\u4e2d\u9009\u62e9\u7684\u4e1a\u52a1\u540d\u79f0 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)processDelegateMandataryConfigDetailDto.getProcessDelegateConfigId(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u59d4\u6258\u914d\u7f6eid \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)processDelegateMandataryConfigDetailDto.getProcessDelegateTypeCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u59d4\u6258\u65b9\u5f0f \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        });
    }

    private void updateValidate(List<ProcessDelegateMandataryConfigDetailDto> processDelegateMandataryConfigDetailDtos) {
        Validate.isTrue((!CollectionUtils.isEmpty(processDelegateMandataryConfigDetailDtos) ? 1 : 0) != 0, (String)"\u4f20\u5165\u6d41\u7a0b\u6a21\u677f\u6570\u636e\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        processDelegateMandataryConfigDetailDtos.forEach(processDelegateMandataryConfigDetailDto -> {
            Validate.notNull((Object)processDelegateMandataryConfigDetailDto, (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            processDelegateMandataryConfigDetailDto.setId(null);
            Validate.notBlank((CharSequence)processDelegateMandataryConfigDetailDto.getCode(), (String)"\u4fee\u6539\u65f6\uff0c\u59d4\u6258\u914d\u7f6e\u7b56\u7565\u4e2d\u9009\u62e9\u7684\u4e1a\u52a1\u7f16\u7801 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)processDelegateMandataryConfigDetailDto.getName(), (String)"\u4fee\u6539\u65f6\uff0c\u59d4\u6258\u914d\u7f6e\u7b56\u7565\u4e2d\u9009\u62e9\u7684\u4e1a\u52a1\u540d\u79f0 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)processDelegateMandataryConfigDetailDto.getProcessDelegateConfigId(), (String)"\u4fee\u6539\u65f6\uff0c\u59d4\u6258\u914d\u7f6eid \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)processDelegateMandataryConfigDetailDto.getProcessDelegateTypeCode(), (String)"\u4fee\u6539\u65f6\uff0c\u59d4\u6258\u65b9\u5f0f \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        });
    }
}

