/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.workflow.local.entity.ProcessInstanceAssignee;
import com.biz.crm.workflow.local.repository.ProcessInstanceAssigneeRepository;
import com.biz.crm.workflow.local.service.ProcessInstanceAssigneeService;
import com.biz.crm.workflow.sdk.dto.ProcessInstanceAssigneeDto;
import com.biz.crm.workflow.sdk.vo.ProcessInstanceAssigneeVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import javax.transaction.Transactional;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="processInstanceAssigneeService")
public class ProcessInstanceAssigneeServiceImpl
implements ProcessInstanceAssigneeService {
    @Autowired
    private ProcessInstanceAssigneeRepository processInstanceAssigneeRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private RedisMutexService redisMutexService;
    @Autowired
    private GenerateCodeService generateCodeService;

    @Override
    public Page<ProcessInstanceAssigneeVo> findByConditions(Pageable pageable, ProcessInstanceAssigneeDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(dto)) {
            dto = new ProcessInstanceAssigneeDto();
        }
        return this.processInstanceAssigneeRepository.findByConditions(pageable, dto);
    }

    @Override
    public ProcessInstanceAssigneeVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        ProcessInstanceAssignee processInstanceAssignee = this.processInstanceAssigneeRepository.findByIdAndTenantCode(id, TenantUtils.getTenantCode());
        if (processInstanceAssignee == null) {
            return null;
        }
        ProcessInstanceAssigneeVo processInstanceAssigneeVo = (ProcessInstanceAssigneeVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)processInstanceAssignee, ProcessInstanceAssigneeVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return processInstanceAssigneeVo;
    }

    @Override
    public List<ProcessInstanceAssigneeVo> findByIds(Collection<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        List<ProcessInstanceAssignee> processInstanceAssignees = this.processInstanceAssigneeRepository.findByIds(ids);
        Collection processInstanceAssigneeVos = this.nebulaToolkitService.copyCollectionByWhiteList(processInstanceAssignees, ProcessInstanceAssignee.class, ProcessInstanceAssigneeVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)processInstanceAssigneeVos);
    }

    @Override
    @Transactional
    public ProcessInstanceAssigneeVo create(ProcessInstanceAssigneeDto processInstanceAssigneeDto) {
        this.createValidate(processInstanceAssigneeDto);
        ProcessInstanceAssignee processInstanceAssignee = (ProcessInstanceAssignee)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)processInstanceAssigneeDto, ProcessInstanceAssignee.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        processInstanceAssignee.setTenantCode(TenantUtils.getTenantCode());
        this.processInstanceAssigneeRepository.saveOrUpdate((Object)processInstanceAssignee);
        ProcessInstanceAssigneeVo processInstanceAssigneeVo = (ProcessInstanceAssigneeVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)processInstanceAssignee, ProcessInstanceAssigneeVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        processInstanceAssigneeVo.setId(processInstanceAssignee.getId());
        return processInstanceAssigneeVo;
    }

    @Override
    public List<ProcessInstanceAssigneeVo> findByProcessInstanceIdAndTaskId(String processInstanceId, String taskId) {
        List<ProcessInstanceAssignee> processInstanceAssignees = this.processInstanceAssigneeRepository.findByProcessInstanceIdAndTaskId(processInstanceId, taskId);
        if (CollectionUtils.isEmpty(processInstanceAssignees)) {
            return Lists.newArrayList();
        }
        Collection processInstanceAssigneeVos = this.nebulaToolkitService.copyCollectionByWhiteList(processInstanceAssignees, ProcessInstanceAssignee.class, ProcessInstanceAssigneeVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)processInstanceAssigneeVos);
    }

    private void createValidate(ProcessInstanceAssigneeDto processInstanceAssigneeDto) {
        Validate.notNull((Object)processInstanceAssigneeDto, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((processInstanceAssigneeDto.getId() == null ? 1 : 0) != 0, (String)"\u65b0\u589e\u6570\u636e\u65f6,\u6570\u636e\u4e3b\u952e\u4e0d\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processInstanceAssigneeDto.getProcessInstanceId(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d41\u7a0b\u5b9e\u4f8bid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processInstanceAssigneeDto.getProcessTaskId(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d41\u7a0b\u4efb\u52a1id\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processInstanceAssigneeDto.getAssigneeCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5ba1\u6279\u4eba\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processInstanceAssigneeDto.getAssigneeCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5ba1\u6279\u4eba\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }
}

