/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.workflow.local.entity.ProcessInstanceCopyConfig;
import com.biz.crm.workflow.local.repository.ProcessInstanceCopyConfigRepository;
import com.biz.crm.workflow.local.service.ProcessInstanceCopyConfigService;
import com.biz.crm.workflow.sdk.dto.ProcessInstanceCopyConfigDto;
import com.biz.crm.workflow.sdk.vo.ProcessInstanceCopyConfigVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import javax.transaction.Transactional;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="processInstanceCopyConfigService")
public class ProcessInstanceCopyConfigServiceImpl
implements ProcessInstanceCopyConfigService {
    @Autowired
    private ProcessInstanceCopyConfigRepository processInstanceCopyConfigRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public Page<ProcessInstanceCopyConfigVo> findByConditions(Pageable pageable, ProcessInstanceCopyConfigDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(dto)) {
            dto = new ProcessInstanceCopyConfigDto();
        }
        return this.processInstanceCopyConfigRepository.findByConditions(pageable, dto);
    }

    @Override
    public ProcessInstanceCopyConfigVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        ProcessInstanceCopyConfig processInstanceCopyConfig = this.processInstanceCopyConfigRepository.findByIdAndTenantCode(id, TenantUtils.getTenantCode());
        if (processInstanceCopyConfig == null) {
            return null;
        }
        ProcessInstanceCopyConfigVo processInstanceCopyConfigVo = (ProcessInstanceCopyConfigVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)processInstanceCopyConfig, ProcessInstanceCopyConfigVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return processInstanceCopyConfigVo;
    }

    @Override
    public List<ProcessInstanceCopyConfigVo> findByIds(Collection<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        List<ProcessInstanceCopyConfig> processInstanceCopyConfigs = this.processInstanceCopyConfigRepository.findByIds(ids);
        Collection processInstanceCopyConfigVos = this.nebulaToolkitService.copyCollectionByWhiteList(processInstanceCopyConfigs, ProcessInstanceCopyConfig.class, ProcessInstanceCopyConfigVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)processInstanceCopyConfigVos);
    }

    @Override
    public List<ProcessInstanceCopyConfigVo> findByProcessInstanceId(String processInstanceId) {
        if (StringUtils.isBlank((CharSequence)processInstanceId)) {
            return Lists.newArrayList();
        }
        List<ProcessInstanceCopyConfig> processInstanceCopyConfigs = this.processInstanceCopyConfigRepository.findByProcessInstanceId(processInstanceId);
        Collection processInstanceCopyConfigVos = this.nebulaToolkitService.copyCollectionByWhiteList(processInstanceCopyConfigs, ProcessInstanceCopyConfig.class, ProcessInstanceCopyConfigVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)processInstanceCopyConfigVos);
    }

    @Override
    @Transactional
    public ProcessInstanceCopyConfigVo create(ProcessInstanceCopyConfigDto processInstanceCopyConfigDto) {
        this.createValidate(processInstanceCopyConfigDto);
        ProcessInstanceCopyConfig processInstanceCopyConfig = (ProcessInstanceCopyConfig)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)processInstanceCopyConfigDto, ProcessInstanceCopyConfig.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        processInstanceCopyConfig.setTenantCode(TenantUtils.getTenantCode());
        this.processInstanceCopyConfigRepository.saveOrUpdate((Object)processInstanceCopyConfig);
        ProcessInstanceCopyConfigVo processInstanceCopyConfigVo = (ProcessInstanceCopyConfigVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)processInstanceCopyConfig, ProcessInstanceCopyConfigVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        processInstanceCopyConfigVo.setId(processInstanceCopyConfig.getId());
        return processInstanceCopyConfigVo;
    }

    @Override
    @Transactional
    public List<ProcessInstanceCopyConfigVo> createBatch(Collection<ProcessInstanceCopyConfigDto> processInstanceCopyConfigDtos) {
        if (CollectionUtils.isEmpty(processInstanceCopyConfigDtos)) {
            return Lists.newArrayList();
        }
        ArrayList processInstanceCopyConfigVos = Lists.newArrayList();
        for (ProcessInstanceCopyConfigDto processInstanceCopyConfigDto : processInstanceCopyConfigDtos) {
            ProcessInstanceCopyConfigVo processInstanceCopyConfigVo = this.create(processInstanceCopyConfigDto);
            processInstanceCopyConfigVos.add(processInstanceCopyConfigVo);
        }
        return processInstanceCopyConfigVos;
    }

    private void createValidate(ProcessInstanceCopyConfigDto processInstanceCopyConfigDto) {
        Validate.notNull((Object)processInstanceCopyConfigDto, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((processInstanceCopyConfigDto.getId() == null ? 1 : 0) != 0, (String)"\u65b0\u589e\u6570\u636e\u65f6,\u6570\u636e\u4e3b\u952e\u4e0d\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processInstanceCopyConfigDto.getProcessInstanceId(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d41\u7a0b\u5b9e\u4f8bid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processInstanceCopyConfigDto.getProcessTaskId(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d41\u7a0b\u4efb\u52a1id\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processInstanceCopyConfigDto.getUserCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6284\u9001\u4eba\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processInstanceCopyConfigDto.getUserName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6284\u9001\u4eba\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }
}

