/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.workflow.local.entity.ProcessInstanceFiles;
import com.biz.crm.workflow.local.repository.ProcessInstanceFilesRepository;
import com.biz.crm.workflow.local.service.ProcessInstanceFilesService;
import com.biz.crm.workflow.sdk.dto.ProcessInstanceFilesDto;
import com.biz.crm.workflow.sdk.vo.ProcessInstanceFilesVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import javax.transaction.Transactional;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="processInstanceFilesService")
public class ProcessInstanceFilesServiceImpl
implements ProcessInstanceFilesService {
    @Autowired
    private ProcessInstanceFilesRepository processInstanceFilesRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private RedisMutexService redisMutexService;
    @Autowired
    private GenerateCodeService generateCodeService;

    @Override
    public Page<ProcessInstanceFilesVo> findByConditions(Pageable pageable, ProcessInstanceFilesDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(dto)) {
            dto = new ProcessInstanceFilesDto();
        }
        return this.processInstanceFilesRepository.findByConditions(pageable, dto);
    }

    @Override
    public ProcessInstanceFilesVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        ProcessInstanceFiles processInstanceFiles = this.processInstanceFilesRepository.findByIdAndTenantCode(id, TenantUtils.getTenantCode());
        if (processInstanceFiles == null) {
            return null;
        }
        ProcessInstanceFilesVo processInstanceFilesVo = (ProcessInstanceFilesVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)processInstanceFiles, ProcessInstanceFilesVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return processInstanceFilesVo;
    }

    @Override
    public List<ProcessInstanceFilesVo> findByIds(Collection<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        List<ProcessInstanceFiles> processInstanceFiless = this.processInstanceFilesRepository.findByIds(ids);
        Collection processInstanceFilesVos = this.nebulaToolkitService.copyCollectionByWhiteList(processInstanceFiless, ProcessInstanceFiles.class, ProcessInstanceFilesVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)processInstanceFilesVos);
    }

    @Override
    public List<ProcessInstanceFilesVo> findByProcessInstanceId(String processInstanceId) {
        if (StringUtils.isBlank((CharSequence)processInstanceId)) {
            return Lists.newArrayList();
        }
        List<ProcessInstanceFiles> processInstanceFiles = this.processInstanceFilesRepository.findByProcessInstanceId(processInstanceId);
        Collection processInstanceFilesVos = this.nebulaToolkitService.copyCollectionByWhiteList(processInstanceFiles, ProcessInstanceFiles.class, ProcessInstanceFilesVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)processInstanceFilesVos);
    }

    @Override
    @Transactional
    public ProcessInstanceFilesVo create(ProcessInstanceFilesDto processInstanceFilesDto) {
        this.createValidate(processInstanceFilesDto);
        ProcessInstanceFiles processInstanceFiles = (ProcessInstanceFiles)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)processInstanceFilesDto, ProcessInstanceFiles.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        processInstanceFiles.setTenantCode(TenantUtils.getTenantCode());
        this.processInstanceFilesRepository.saveOrUpdate((Object)processInstanceFiles);
        ProcessInstanceFilesVo processInstanceFilesVo = (ProcessInstanceFilesVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)processInstanceFiles, ProcessInstanceFilesVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        processInstanceFilesVo.setId(processInstanceFiles.getId());
        return processInstanceFilesVo;
    }

    @Override
    @Transactional
    public List<ProcessInstanceFilesVo> createBatch(Collection<ProcessInstanceFilesDto> processInstanceFilesDtos) {
        if (CollectionUtils.isEmpty(processInstanceFilesDtos)) {
            return Lists.newArrayList();
        }
        ArrayList processInstanceFilesVos = Lists.newArrayList();
        for (ProcessInstanceFilesDto processInstanceFilesDto : processInstanceFilesDtos) {
            ProcessInstanceFilesVo processInstanceFilesVo = this.create(processInstanceFilesDto);
            processInstanceFilesVos.add(processInstanceFilesVo);
        }
        return processInstanceFilesVos;
    }

    @Override
    @Transactional
    public void delete(Collection<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<ProcessInstanceFiles> processInstanceFiless = this.processInstanceFilesRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(processInstanceFiless)) {
            return;
        }
        Collection processInstanceFilesVos = this.nebulaToolkitService.copyCollectionByWhiteList(processInstanceFiless, ProcessInstanceFiles.class, ProcessInstanceFilesVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.processInstanceFilesRepository.removeByIdsAndTenantCode(ids, TenantUtils.getTenantCode());
    }

    private void createValidate(ProcessInstanceFilesDto processInstanceFilesDto) {
        Validate.notNull((Object)processInstanceFilesDto, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((processInstanceFilesDto.getId() == null ? 1 : 0) != 0, (String)"\u65b0\u589e\u6570\u636e\u65f6,\u6570\u636e\u4e3b\u952e\u4e0d\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processInstanceFilesDto.getProcessInstanceId(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d41\u7a0b\u5b9e\u4f8bid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processInstanceFilesDto.getFileCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6587\u4ef6\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processInstanceFilesDto.getOriginalFileName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6587\u4ef6\u539f\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }
}

