/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.workflow.local.dto.ProcessInterventionDto;
import com.biz.crm.workflow.local.dto.ProcessTaskLogDto;
import com.biz.crm.workflow.local.entity.ProcessInstanceEntity;
import com.biz.crm.workflow.local.entity.ProcessTemplate;
import com.biz.crm.workflow.local.repository.ProcessInstanceRepository;
import com.biz.crm.workflow.local.service.ProcessInstanceAssigneeService;
import com.biz.crm.workflow.local.service.ProcessInstanceService;
import com.biz.crm.workflow.local.service.ProcessPreExecutionService;
import com.biz.crm.workflow.local.service.ProcessService;
import com.biz.crm.workflow.local.service.ProcessTaskLogService;
import com.biz.crm.workflow.local.service.ProcessTaskService;
import com.biz.crm.workflow.local.service.ProcessTemplateNodeUserTaskService;
import com.biz.crm.workflow.local.service.ProcessTemplateService;
import com.biz.crm.workflow.local.vo.ProcessInterventionVo;
import com.biz.crm.workflow.sdk.constant.ProcessConstant;
import com.biz.crm.workflow.sdk.constant.enums.ActApproveStatusEnum;
import com.biz.crm.workflow.sdk.constant.enums.ProcessInstanceStatusEnum;
import com.biz.crm.workflow.sdk.dto.ProcessInstanceAssigneeDto;
import com.biz.crm.workflow.sdk.dto.ProcessInstanceDto;
import com.biz.crm.workflow.sdk.dto.ProcessUserDto;
import com.biz.crm.workflow.sdk.dto.UserPositionEventDto;
import com.biz.crm.workflow.sdk.enums.ProcessOperateTypeEnum;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.listener.UserPositionEventListener;
import com.biz.crm.workflow.sdk.service.ProcessTemplateNodeService;
import com.biz.crm.workflow.sdk.vo.ProcessInstanceVo;
import com.biz.crm.workflow.sdk.vo.ProcessTaskVo;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateNodeUserTaskVo;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateNodeVo;
import com.biz.crm.workflow.sdk.vo.WorkflowUserIdentity;
import com.biz.crm.workflow.sdk.vo.response.UserPositionResponse;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.common.engine.impl.identity.Authentication;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.TaskService;
import org.flowable.engine.runtime.Execution;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ProcessInstanceServiceImpl
implements ProcessInstanceService {
    private static final Logger log = LoggerFactory.getLogger(ProcessInstanceServiceImpl.class);
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private ProcessTemplateService templateService;
    @Autowired
    private GenerateCodeService generateCodeService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private ProcessTemplateService processTemplateService;
    @Autowired
    private ProcessInstanceRepository processInstanceRepository;
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private ProcessTaskLogService processTaskLogService;
    @Autowired
    private ProcessInstanceAssigneeService processInstanceAssigneeService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private ProcessTemplateNodeService processTemplateNodeService;
    @Autowired
    private ProcessTemplateNodeUserTaskService processTemplateNodeUserTaskService;
    @Autowired
    private ProcessService processService;
    @Autowired
    private ProcessTaskService processTaskService;
    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired
    private ProcessPreExecutionService processPreExecutionService;

    @Override
    public ProcessInstance startWithKey(String key) {
        HashMap params = new HashMap();
        UserIdentity userIdentity = this.loginUserService.getLoginUser();
        String currentUserCode = StringUtils.join((Object[])new String[]{userIdentity.getIdentityType(), ":", userIdentity.getAccount()});
        Authentication.setAuthenticatedUserId((String)currentUserCode);
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKeyAndTenantId(key, key, params, TenantUtils.getTenantCode());
        return instance;
    }

    @Override
    @Transactional
    public ProcessInstanceVo create(ProcessInstanceDto dto) {
        this.validateDto(dto);
        HashSet processStatus = Sets.newHashSet();
        processStatus.add(ProcessStatusEnum.START.getDictCode());
        processStatus.add(ProcessStatusEnum.COMMIT.getDictCode());
        ProcessInstanceEntity processInstanceEntity = this.processInstanceRepository.findByBusinessNoAndIncludeStatus(dto.getBusinessFormNo(), processStatus);
        if (processInstanceEntity != null) {
            ProcessInstanceVo processInstanceVo = (ProcessInstanceVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)processInstanceEntity, ProcessInstanceVo.class, HashSet.class, ArrayList.class, new String[0]);
            processInstanceVo.setProcessNo(processInstanceEntity.getProcessNo());
            return processInstanceVo;
        }
        ProcessTemplate processTemplate = this.templateService.findUseProcessByProcessKey(dto.getProcessKey());
        Validate.notNull((Object)((Object)processTemplate), (String)"\u6d41\u7a0bkey\u4e0d\u6b63\u786e", (Object[])new Object[0]);
        if (ObjectUtils.isEmpty((Object)processTemplate.getCversion())) {
            List<ProcessTemplate> processTemplates = this.processTemplateService.findByProcessKeyAndReleaseStatus(dto.getProcessKey(), EnableStatusEnum.ENABLE.getCode());
            if (CollectionUtils.isEmpty(processTemplates)) {
                Validate.notNull((Object)((Object)processTemplate), (String)"\u5f53\u524d\u6d41\u7a0b\u6700\u65b0\u7248\u672c\u4e3a\u672a\u53d1\u5e03\u72b6\u6001\uff0c\u4e14\u6ca1\u6709\u5df2\u53d1\u5e03\u5386\u53f2\u7248\u672c\uff0c\u65e0\u6cd5\u53d1\u8d77\u6d41\u7a0b\uff01", (Object[])new Object[0]);
            } else {
                processTemplate = processTemplates.get(0);
            }
        }
        dto.setProcessInstanceStatus(ProcessInstanceStatusEnum.ENABLE.getCode());
        String date = DateFormatUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss");
        dto.setProcessNo((String)this.generateCodeService.generateCode(ProcessConstant.process_instance_no_key + date, 1).get(0));
        dto.setProcessTemplateId(processTemplate.getId());
        if (StringUtils.isBlank((CharSequence)dto.getTenantCode())) {
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
        dto.setProcessName(processTemplate.getProcessName());
        dto.setProcessStatus(ProcessStatusEnum.START.getDictCode());
        processInstanceEntity = (ProcessInstanceEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, ProcessInstanceEntity.class, HashSet.class, ArrayList.class, new String[0]));
        WorkflowUserIdentity loginDetails = (WorkflowUserIdentity)this.loginUserService.getAbstractLoginUser();
        processInstanceEntity.setOrgCode(loginDetails.getOrgCode());
        processInstanceEntity.setOrgName(loginDetails.getOrgName());
        processInstanceEntity.setPositionCode(loginDetails.getPostCode());
        processInstanceEntity.setPositionName(loginDetails.getPostName());
        this.processInstanceRepository.save((Object)processInstanceEntity);
        ProcessInstanceVo processInstanceVo = (ProcessInstanceVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)processInstanceEntity, ProcessInstanceVo.class, HashSet.class, ArrayList.class, new String[0]);
        processInstanceVo.setProcessNo(processInstanceEntity.getProcessNo());
        return processInstanceVo;
    }

    @Override
    @Transactional
    public ProcessInstanceVo startProcess(ProcessInstanceDto dto) {
        Validate.notNull((Object)dto, (String)"\u53d1\u8d77\u6d41\u7a0b\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getProcessNo(), (String)"\u53d1\u8d77\u6d41\u7a0b\u6d41\u7a0b\u7f16\u53f7\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        ProcessTemplate processTemplate = this.templateService.findUseProcessByProcessKey(dto.getProcessKey());
        Validate.notNull((Object)((Object)processTemplate), (String)"\u6d41\u7a0bkey\u4e0d\u6b63\u786e", (Object[])new Object[0]);
        if (ObjectUtils.isEmpty((Object)processTemplate.getCversion())) {
            List<ProcessTemplate> processTemplates = this.processTemplateService.findByProcessKeyAndReleaseStatus(dto.getProcessKey(), EnableStatusEnum.ENABLE.getCode());
            if (CollectionUtils.isEmpty(processTemplates)) {
                Validate.notNull((Object)((Object)processTemplate), (String)"\u5f53\u524d\u6d41\u7a0b\u6700\u65b0\u7248\u672c\u4e3a\u672a\u53d1\u5e03\u72b6\u6001\uff0c\u4e14\u6ca1\u6709\u5df2\u53d1\u5e03\u5386\u53f2\u7248\u672c\uff0c\u65e0\u6cd5\u53d1\u8d77\u6d41\u7a0b\uff01", (Object[])new Object[0]);
            } else {
                processTemplate = processTemplates.get(0);
            }
        }
        ProcessInstanceEntity processInstanceEntity = this.processInstanceRepository.findByProcessNo(dto.getProcessNo());
        Validate.notNull((Object)((Object)processInstanceEntity), (String)"\u6d41\u7a0b\u7f16\u53f7[%s]\u7684\u6d41\u7a0b\u5c1a\u672a\u521b\u5efa\uff0c\u65e0\u6cd5\u542f\u52a8\u6d41\u7a0b\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{dto.getProcessNo()});
        HashMap params = Maps.newHashMap();
        params.put(ProcessConstant.PROCESS_INSTANCE_PARAM_CODE, dto);
        if (StringUtils.isNotBlank((CharSequence)dto.getFormData())) {
            params.put(ProcessConstant.PROCESS_INSTANCE_FORM_DATA_CODE, JSON.parseObject((String)dto.getFormData()));
        }
        if (!CollectionUtils.isEmpty((Map)dto.getTaskAssignees())) {
            List processTemplateNodeVos = this.processTemplateNodeService.findByTemplateId(processTemplate.getId());
            Validate.isTrue((!CollectionUtils.isEmpty((Collection)processTemplateNodeVos) ? 1 : 0) != 0, (String)"\u6d41\u7a0b\u8282\u70b9\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Map processTemplateNodeVoMap = processTemplateNodeVos.stream().collect(Collectors.toMap(ProcessTemplateNodeVo::getProcessTaskId, Function.identity()));
            List<String> nodeIds = processTemplateNodeVos.stream().map(ProcessTemplateNodeVo::getId).collect(Collectors.toList());
            List<ProcessTemplateNodeUserTaskVo> processTemplateNodeUserTaskVos = this.processTemplateNodeUserTaskService.findByNodeIds(nodeIds);
            Validate.isTrue((!CollectionUtils.isEmpty(processTemplateNodeUserTaskVos) ? 1 : 0) != 0, (String)"\u6d41\u7a0b\u53d1\u8d77\u65f6\uff0c\u6d41\u7a0b\u56fe\u8282\u70b9\u6570\u636e\u9519\u8bef\uff01", (Object[])new Object[0]);
            Map processTemplateNodeUserTaskVoMap = processTemplateNodeUserTaskVos.stream().collect(Collectors.toMap(ProcessTemplateNodeUserTaskVo::getNodeId, Function.identity()));
            dto.getTaskAssignees().forEach((k, v) -> {
                ProcessTemplateNodeVo processTemplateNodeVo = (ProcessTemplateNodeVo)processTemplateNodeVoMap.get(k);
                ProcessTemplateNodeUserTaskVo processTemplateNodeUserTaskVo = (ProcessTemplateNodeUserTaskVo)processTemplateNodeUserTaskVoMap.get(processTemplateNodeVo.getId());
                String signType = processTemplateNodeUserTaskVo.getSignType();
                if (ProcessConstant.PROCESS_SIGN_TYPE_MULTI.equals(signType)) {
                    Validate.isTrue((!CollectionUtils.isEmpty((Collection)v) ? 1 : 0) != 0, (String)"\u5b58\u5728\u4f1a\u7b7e\u8282\u70b9\u65f6,\u81ea\u9009\u5ba1\u6279\u4eba\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                    String varKey = String.format("_%s_%s", "countersigns", k);
                    params.put(varKey, v);
                }
            });
        }
        WorkflowUserIdentity userIdentity = (WorkflowUserIdentity)this.loginUserService.getAbstractLoginUser();
        String currentUserCode = StringUtils.join((Object[])new String[]{userIdentity.getIdentityType(), ":", userIdentity.getAccount()});
        Authentication.setAuthenticatedUserId((String)currentUserCode);
        ProcessInstance instance = null;
        try {
            instance = this.runtimeService.startProcessInstanceById(processTemplate.getProcessDefinitionId(), (Map)params);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
        Validate.notNull((Object)instance, (String)"\u53d1\u8d77\u6d41\u7a0b\u5931\u8d25", (Object[])new Object[0]);
        processInstanceEntity = this.processInstanceRepository.findByProcessNo(dto.getProcessNo());
        processInstanceEntity.setProcessInstanceId(instance.getProcessInstanceId());
        if (processInstanceEntity.getProcessStatus().equals(ProcessStatusEnum.START.getDictCode())) {
            processInstanceEntity.setProcessStatus(ProcessStatusEnum.COMMIT.getDictCode());
        }
        processInstanceEntity.setRemark(dto.getRemark());
        processInstanceEntity.setOrgCode(userIdentity.getOrgCode());
        processInstanceEntity.setOrgName(userIdentity.getOrgName());
        processInstanceEntity.setPositionCode(userIdentity.getPostCode());
        processInstanceEntity.setPositionName(userIdentity.getPostName());
        this.processInstanceRepository.saveOrUpdate((Object)processInstanceEntity);
        if (dto != null && !CollectionUtils.isEmpty((Map)dto.getTaskAssignees())) {
            Map taskAssigneesMap = dto.getTaskAssignees();
            Set mapEntry = taskAssigneesMap.entrySet();
            for (Map.Entry entry : mapEntry) {
                String taskNodeId = (String)entry.getKey();
                Collection userDtos = (Collection)entry.getValue();
                for (ProcessUserDto userDto : userDtos) {
                    ProcessInstanceAssigneeDto processInstanceAssigneeDto = new ProcessInstanceAssigneeDto();
                    processInstanceAssigneeDto.setProcessInstanceId(processInstanceEntity.getProcessInstanceId());
                    processInstanceAssigneeDto.setAssigneeCode(userDto.getUserCode());
                    processInstanceAssigneeDto.setAssigneeName(userDto.getUserName());
                    processInstanceAssigneeDto.setTenantCode(TenantUtils.getTenantCode());
                    processInstanceAssigneeDto.setProcessTaskId(taskNodeId);
                    this.processInstanceAssigneeService.create(processInstanceAssigneeDto);
                }
            }
        }
        ProcessTaskLogDto processTaskLogDto = new ProcessTaskLogDto();
        processTaskLogDto.setProcessInstanceId(processInstanceEntity.getProcessInstanceId());
        processTaskLogDto.setOperateType(ProcessOperateTypeEnum.COMMIT.getDictCode());
        processTaskLogDto.setProcessKey(processInstanceEntity.getProcessKey());
        processTaskLogDto.setTenantCode(TenantUtils.getTenantCode());
        processTaskLogDto.setOperateRemark(ProcessOperateTypeEnum.COMMIT.getValue());
        this.processTaskLogService.create(processTaskLogDto);
        return (ProcessInstanceVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)processInstanceEntity, ProcessInstanceVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Override
    public void deleteById(String id) {
        this.runtimeService.deleteProcessInstance(id, "\u6d4b\u8bd5");
    }

    @Override
    public Page<ProcessInstance> findByConditions(Pageable pageable, String userCode) {
        List instances = this.runtimeService.createProcessInstanceQuery().processInstanceTenantId(TenantUtils.getTenantCode()).involvedUser(userCode).listPage((int)pageable.getOffset(), pageable.getPageSize());
        long total = this.runtimeService.createProcessInstanceQuery().processInstanceTenantId(TenantUtils.getTenantCode()).involvedUser(userCode).count();
        Page page = new Page(pageable.getOffset(), (long)pageable.getPageSize());
        page.setRecords(instances);
        page.setTotal(total);
        return page;
    }

    @Override
    public ProcessInstanceEntity findByProcessInstanceId(String processInstanceId) {
        return this.processInstanceRepository.findByInstanceId(processInstanceId);
    }

    @Override
    public List<ProcessInstanceEntity> findByFromNo(String formNo) {
        return this.processInstanceRepository.findByFormNo(formNo);
    }

    @Override
    public BpmnModel findBpmnModelByProcessInstanceId(String processInstanceId) {
        ProcessInstanceEntity processInstance = this.processInstanceRepository.findByInstanceId(processInstanceId);
        Validate.notNull((Object)((Object)processInstance), (String)"\u6d41\u7a0bid[%s]\u5bf9\u5e94\u6d41\u7a0b\u5b9e\u4f8b\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[]{processInstanceId});
        ProcessTemplate processTemplate = this.processTemplateService.findById(processInstance.getProcessTemplateId());
        Validate.notNull((Object)((Object)processTemplate), (String)"\u6d41\u7a0bid[%s]\u5bf9\u5e94\u6d41\u7a0b\u6a21\u677f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[]{processInstanceId});
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processTemplate.getProcessDefinitionId());
        return bpmnModel;
    }

    @Override
    public List<Execution> findExecutionsByProcessInstanceId(String processInstanceId) {
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).processInstanceTenantId(TenantUtils.getTenantCode()).singleResult();
        Validate.notNull((Object)processInstance, (String)"\u6d41\u7a0bid[%s]\u5bf9\u5e94\u6d41\u7a0b\u5b9e\u4f8b\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[]{processInstanceId});
        List executions = this.runtimeService.createExecutionQuery().processInstanceId(processInstanceId).executionTenantId(TenantUtils.getTenantCode()).list();
        return executions;
    }

    @Override
    public List<String> findActivitiesByProcessInstanceId(String processInstanceId) {
        ArrayList activityIds = Lists.newArrayList();
        List executions = this.runtimeService.createExecutionQuery().processInstanceId(processInstanceId).executionTenantId(TenantUtils.getTenantCode()).list();
        executions.forEach(execution -> {
            List ids = this.runtimeService.getActiveActivityIds(execution.getId());
            activityIds.addAll(ids);
        });
        return activityIds;
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        this.processInstanceRepository.updateInstanceStatusByIds(ids, EnableStatusEnum.ENABLE.getCode());
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        this.processInstanceRepository.updateInstanceStatusByIds(ids, EnableStatusEnum.DISABLE.getCode());
    }

    @Override
    public List<ProcessTaskVo> getRunTasks(String processInstanceId) {
        ArrayList taskVos = Lists.newArrayList();
        if (StringUtils.isBlank((CharSequence)processInstanceId)) {
            return taskVos;
        }
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).list();
        if (CollectionUtils.isEmpty((Collection)tasks)) {
            return taskVos;
        }
        ProcessInstanceEntity processInstance = this.processInstanceRepository.findByInstanceId(processInstanceId);
        if (ObjectUtils.isEmpty((Object)((Object)processInstance))) {
            return taskVos;
        }
        tasks.forEach(task -> {
            ProcessTaskVo taskVo = new ProcessTaskVo();
            taskVo.setProcessTitle(processInstance.getProcessTitle());
            taskVo.setProcessKey(processInstance.getProcessKey());
            taskVo.setProcessName(processInstance.getProcessName());
            taskVo.setTaskName(task.getName());
            taskVo.setTaskId(task.getId());
            taskVo.setRemark("\u5f53\u524d\u5f85\u529e\u8282\u70b9");
            taskVos.add(taskVo);
        });
        return taskVos;
    }

    @Override
    @Transactional
    public void closeProcessInstance(String processInstanceId) {
        if (StringUtils.isBlank((CharSequence)processInstanceId)) {
            return;
        }
        ProcessInstanceEntity processInstance = this.processInstanceRepository.findByInstanceId(processInstanceId);
        Validate.notNull((Object)((Object)processInstance), (String)"\u6d41\u7a0b\u5b9e\u4f8b\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Validate.isTrue((boolean)processInstance.getProcessStatus().equals(ProcessStatusEnum.COMMIT.getDictCode()), (String)"\u53ea\u6709\u5ba1\u6279\u4e2d\u7684\u6d41\u7a0b\u53ef\u4ee5\u5173\u95ed", (Object[])new Object[0]);
        UserIdentity userIdentity = this.loginUserService.getLoginUser();
        Validate.notNull((Object)userIdentity, (String)"\u83b7\u53d6\u767b\u5f55\u4eba\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)userIdentity.getTenantCode(), (String)"\u83b7\u53d6\u767b\u5f55\u4eba\u79df\u6237\u4fe1\u606f\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)userIdentity.getAccount(), (String)"\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u4eba\u4fe1\u606f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().executionTenantId(TenantUtils.getTenantCode()).processInstanceId(processInstanceId).singleResult();
        this.runtimeService.setVariable(execution.getId(), ProcessConstant.PROCESS_INSTANCE_OPERATE_CODE, (Object)ProcessStatusEnum.COLSE.getDictCode());
        String currentUserCode = StringUtils.join((Object[])new String[]{userIdentity.getIdentityType(), ":", userIdentity.getAccount()});
        this.taskService.addComment(null, processInstanceId, String.format("%s\u6d41\u7a0b\u5b9e\u4f8b\u5173\u95ed\uff0c\u6267\u884c\u4eba\uff1a%s", currentUserCode));
        this.runtimeService.deleteProcessInstance(processInstanceId, ActApproveStatusEnum.CLOSED.getCode());
    }

    @Override
    public ProcessInstanceVo findByProcessNo(String processNo) {
        if (StringUtils.isBlank((CharSequence)processNo)) {
            return null;
        }
        ProcessInstanceEntity processInstanceEntity = this.processInstanceRepository.findByProcessNo(processNo);
        if (Objects.isNull((Object)processInstanceEntity)) {
            return null;
        }
        ProcessInstanceVo processInstanceVo = (ProcessInstanceVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)processInstanceEntity, ProcessInstanceVo.class, HashSet.class, ArrayList.class, new String[0]);
        return processInstanceVo;
    }

    @Override
    public void processIntervention(ProcessInterventionDto processInterventionDto) {
        Validate.notNull((Object)processInterventionDto.getTaskId(), (String)"\u6d41\u7a0b\u5e72\u9884\u65f6\u5f53\u524d\u4efb\u52a1id\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)processInterventionDto.getTaskKey(), (String)"\u5e72\u9884\u76ee\u6807\u8282\u70b9\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)processInterventionDto.getProcessInstanceId(), (String)"\u6d41\u7a0b\u5e72\u9884\u5b9e\u4f8bid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty(processInterventionDto.getApprovedUsers()) ? 1 : 0) != 0, (String)"\u6d41\u7a0b\u5e72\u9884\u76ee\u6807\u7528\u6237\uff08\u5ba1\u6279\u4eba\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.processService.processIntervention(processInterventionDto);
    }

    @Override
    public List<ProcessInterventionVo> findInterventionNodesByProcessInstanceId(String processInstanceId) {
        List<ProcessTemplateNodeUserTaskVo> processTemplateNodeUserTaskVos;
        if (StringUtils.isBlank((CharSequence)processInstanceId)) {
            return null;
        }
        String[] roleCodes = this.loginUserService.getLoginUser().getRoleCodes();
        int count = 0;
        if (ObjectUtils.isNotEmpty((Object)roleCodes)) {
            for (String roleCode : roleCodes) {
                if (!roleCode.equals("ADMIN")) continue;
                ++count;
            }
        }
        Validate.isTrue((count > 0 ? 1 : 0) != 0, (String)"\u5f53\u524d\u767b\u5f55\u7528\u6237\u89d2\u8272\u4e0d\u5177\u5907\u6d41\u7a0b\u5e72\u9884\u6743\u9650\uff01", (Object[])new Object[0]);
        ProcessInstanceEntity processInstanceEntity = this.processInstanceRepository.findByInstanceId(processInstanceId);
        Validate.notNull((Object)((Object)processInstanceEntity), (String)"\u5f53\u524d\u6d41\u7a0b\u672a\u751f\u6210\u5b9e\u4f8b\uff0c\u6d41\u7a0b\u5e76\u672a\u53d1\u8d77\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        String processStatus = processInstanceEntity.getProcessStatus();
        if (StringUtils.isNotEmpty((CharSequence)processStatus)) {
            Validate.isTrue((boolean)processStatus.equals(ProcessStatusEnum.COMMIT.getDictCode()), (String)"\u5f53\u524d\u6d41\u7a0b\u5b9e\u4f8b\u5ba1\u6279\u72b6\u6001\u4e0d\u662f\u5ba1\u6279\u4e2d,\u65e0\u6cd5\u5e72\u9884\uff01", (Object[])new Object[0]);
        }
        if (CollectionUtils.isEmpty(processTemplateNodeUserTaskVos = this.processTemplateNodeUserTaskService.findByTemplateId(processInstanceEntity.getProcessTemplateId()))) {
            return null;
        }
        List nodeIds = processTemplateNodeUserTaskVos.stream().map(ProcessTemplateNodeUserTaskVo::getNodeId).distinct().collect(Collectors.toList());
        List processTemplateNodeVos = this.processTemplateNodeService.findByIds(nodeIds);
        List collect = processTemplateNodeVos.stream().filter(processTemplateNodeVo -> processTemplateNodeVo.getCode().equals("UserTaskProcessNode")).collect(Collectors.toList());
        List processTemplateNodeVoList = collect.stream().filter(processTemplateNodeVo -> StringUtils.isNotEmpty((CharSequence)processTemplateNodeVo.getProcessTaskName()) && !processTemplateNodeVo.getProcessTaskName().equals("\u4e34\u65f6\u5411\u540e\u52a0\u7b7e")).collect(Collectors.toList());
        Validate.isTrue((!CollectionUtils.isEmpty(processTemplateNodeVoList) ? 1 : 0) != 0, (String)"\u5f53\u524d\u6d41\u7a0b\u5b9e\u4f8b\u4e2d\u6ca1\u6709\u53ef\u5e72\u9884\u7684\u7528\u6237\u8282\u70b9\uff01", (Object[])new Object[0]);
        ArrayList<ProcessInterventionVo> list = new ArrayList<ProcessInterventionVo>();
        for (ProcessTemplateNodeVo processTemplateNodeVo2 : processTemplateNodeVoList) {
            String processTaskKey = processTemplateNodeVo2.getProcessTaskId();
            ProcessInterventionVo processInterventionVo = new ProcessInterventionVo();
            processInterventionVo.setTaskKey(processTaskKey);
            processInterventionVo.setProcessTitle(processInstanceEntity.getProcessTitle());
            processInterventionVo.setProcessName(processInstanceEntity.getProcessName());
            processInterventionVo.setProcessNodeName(processTemplateNodeVo2.getProcessTaskName());
            List nodeUserTaskVos = processTemplateNodeUserTaskVos.stream().filter(processTemplateNodeUserTaskVo -> processTemplateNodeUserTaskVo.getSignOptional().equals(true) && processTemplateNodeUserTaskVo.getNodeId().equals(processTemplateNodeVo2.getId())).collect(Collectors.toList());
            Task task = (Task)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).includeProcessVariables()).list().get(0);
            ProcessInstanceDto processInstanceDto = (ProcessInstanceDto)this.taskService.getVariable(task.getId(), ProcessConstant.PROCESS_INSTANCE_PARAM_CODE, ProcessInstanceDto.class);
            if (!CollectionUtils.isEmpty(nodeUserTaskVos)) {
                Set<String> assigneeCodes;
                Map taskAssigneesMap;
                Set mapEntry;
                Collection userDtos;
                if (ObjectUtils.isNotEmpty((Object)processInstanceDto) && !CollectionUtils.isEmpty((Map)processInstanceDto.getTaskAssignees()) && !CollectionUtils.isEmpty((Collection)(userDtos = (Collection)(mapEntry = (taskAssigneesMap = processInstanceDto.getTaskAssignees()).entrySet()).stream().filter(item -> ((String)item.getKey()).equals(processTaskKey)).map(Map.Entry::getValue).findFirst().orElse(null))) && !CollectionUtils.isEmpty(assigneeCodes = userDtos.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getUserName())).map(ProcessUserDto::getUserName).collect(Collectors.toSet()))) {
                    UserPositionResponse userPositionResponses = this.findUserPositionsByAssigneeCodes(assigneeCodes);
                    processInterventionVo.setAssignees(userPositionResponses.getUserPositions());
                }
            } else {
                Collection<String> assigneeCodes = this.processTaskService.findAssigneesByTaskNodeIdAndTaskId(processTemplateNodeVo2.getId(), task.getId(), task.getProcessInstanceId(), task.getTaskDefinitionKey(), null);
                UserPositionResponse userPositionResponses = this.findUserPositionsByAssigneeCodes(assigneeCodes);
                if (!ObjectUtils.isEmpty((Object)userPositionResponses)) {
                    processInterventionVo.setAssignees(userPositionResponses.getUserPositions());
                }
            }
            list.add(processInterventionVo);
        }
        return list;
    }

    @Override
    public Integer countByAccount(String account) {
        Validate.notNull((Object)account, (String)"\u67e5\u8be2\u5f85\u5904\u7406\u6d41\u7a0b\u65f6\u7528\u6237\u8d26\u6237\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        return this.processInstanceRepository.countByAccount(account);
    }

    private void validateDto(ProcessInstanceDto processInstanceDto) {
        Validate.notNull((Object)processInstanceDto, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((processInstanceDto.getId() == null ? 1 : 0) != 0, (String)"\u65b0\u589e\u6570\u636e\u65f6,\u6570\u636e\u4e3b\u952e\u4e0d\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processInstanceDto.getProcessKey(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d41\u7a0bkey\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processInstanceDto.getBusinessFormNo(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u4e1a\u52a1\u8868\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processInstanceDto.getProcessTitle(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d41\u7a0b\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private UserPositionResponse findUserPositionsByAssigneeCodes(Collection<String> assigneeCodes) {
        if (CollectionUtils.isEmpty(assigneeCodes)) {
            return null;
        }
        ArrayList userNames = Lists.newArrayList();
        assigneeCodes.forEach(assigneeCode -> {
            String[] split = assigneeCode.split(":");
            String username = split[1];
            userNames.add(username);
        });
        SerializableBiConsumer & Serializable sf = UserPositionEventListener::findUserPositionsByUserNames;
        UserPositionEventDto userPositionEventDto = UserPositionEventDto.builder().userNames((Collection)userNames).build();
        UserPositionResponse userPositions = (UserPositionResponse)this.nebulaNetEventClient.directPublish((NebulaEventDto)userPositionEventDto, UserPositionEventListener.class, (SerializableBiConsumer)sf);
        if (CollectionUtils.isEmpty((Collection)userPositions.getUserPositions())) {
            log.info("\u8c03\u7528\u4e8b\u4ef6\u67e5\u8be2\u7528\u6237\u804c\u4f4d\u4fe1\u606f\uff0c\u672a\u83b7\u53d6\u5230\u6570\u636e\uff01");
        }
        return userPositions;
    }
}

