/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.workflow.local.entity.ProcessInstanceEntity;
import com.biz.crm.workflow.local.entity.ProcessPreExecutionLogEntity;
import com.biz.crm.workflow.local.entity.ProcessTemplate;
import com.biz.crm.workflow.local.repository.ProcessPreExecutionRepository;
import com.biz.crm.workflow.local.service.ProcessInstanceService;
import com.biz.crm.workflow.local.service.ProcessPreExecutionService;
import com.biz.crm.workflow.local.service.ProcessTemplateNodeAssigneeService;
import com.biz.crm.workflow.local.service.ProcessTemplateService;
import com.biz.crm.workflow.local.service.ProcessTracingStrategyService;
import com.biz.crm.workflow.local.service.TaskMultiCacheVoService;
import com.biz.crm.workflow.local.vo.ProcessPreExecutionLogVo;
import com.biz.crm.workflow.sdk.dto.UserInfoEventDto;
import com.biz.crm.workflow.sdk.enums.PreExecutionStatusEnum;
import com.biz.crm.workflow.sdk.listener.UserInfoListener;
import com.biz.crm.workflow.sdk.service.ProcessTemplateNodeService;
import com.biz.crm.workflow.sdk.strategy.tracing.TracingStrategy;
import com.biz.crm.workflow.sdk.vo.ProcessInstanceVo;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateNodeAssigneeVarVo;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateNodeAssigneeVo;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateNodeVo;
import com.biz.crm.workflow.sdk.vo.UserVo;
import com.biz.crm.workflow.sdk.vo.response.UserInfoResponse;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.EndEvent;
import org.flowable.bpmn.model.ExclusiveGateway;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.InclusiveGateway;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.bpmn.model.ServiceTask;
import org.flowable.bpmn.model.UserTask;
import org.flowable.engine.HistoryService;
import org.flowable.engine.RepositoryService;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.flowable.task.api.history.HistoricTaskInstanceQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ProcessPreExecutionServiceImpl
implements ProcessPreExecutionService {
    @Autowired
    private ProcessTracingStrategyService processTracingStrategyService;
    @Autowired
    private ProcessTemplateNodeService processTemplateNodeService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private ProcessPreExecutionRepository processPreExecutionRepository;
    @Autowired
    private ProcessInstanceService processInstanceService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private ProcessTemplateService processTemplateService;
    @Autowired
    private ProcessTemplateNodeAssigneeService processTemplateNodeAssigneeService;
    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private List<TracingStrategy> tracingStrategies;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private TaskMultiCacheVoService taskMultiCacheVoService;

    @Override
    @Transactional
    public void create(String processInstanceId, String processTemplateId) {
        Validate.notNull((Object)processTemplateId, (String)"\u65b0\u589e\u6d41\u7a0b\u9884\u6267\u884c\u65e5\u5fd7\u65f6\uff0c\u6d41\u7a0b\u6a21\u677fid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<?> processTracingStrategyVoList = this.processTracingStrategyService.findProcessTracingAllByTemplateId(processTemplateId, processInstanceId);
        List<?> processPreExecutionLogVos = this.processTracingStrategyService.findProcessTracingsByTemplateId(processTemplateId);
        if (!CollectionUtils.isEmpty(processTracingStrategyVoList) && !CollectionUtils.isEmpty(processPreExecutionLogVos)) {
            List processTemplateNodeVos = this.processTemplateNodeService.findByTemplateId(processTemplateId);
            if (!CollectionUtils.isEmpty((Collection)processTemplateNodeVos)) {
                processPreExecutionLogVos.forEach(processPreExecutionLogVo -> processTemplateNodeVos.forEach(processTemplateNodeVo -> {
                    if (Objects.equals(processPreExecutionLogVo.getTaskDefinitionKey(), processTemplateNodeVo.getProcessTaskId())) {
                        processPreExecutionLogVo.setNodeId(processTemplateNodeVo.getId());
                        processPreExecutionLogVo.setProcessTemplateId(processTemplateId);
                        processPreExecutionLogVo.setProcessInstanceId(processInstanceId);
                        processPreExecutionLogVo.setTenantCode(TenantUtils.getTenantCode());
                        processPreExecutionLogVo.setProcessStatus(PreExecutionStatusEnum.PRE_EXECUTION_STATUS.getDictCode());
                    }
                }));
            }
            processPreExecutionLogVos.forEach(processPreExecutionLogVo -> processTracingStrategyVoList.forEach(processTracingStrategyVo -> {
                Collection<UserVo> userVos;
                if (Objects.equals(processPreExecutionLogVo.getNodeId(), processTracingStrategyVo.getNodeId()) && !CollectionUtils.isEmpty(userVos = processTracingStrategyVo.getUserVos())) {
                    StringBuffer stringBuffer = new StringBuffer();
                    userVos.forEach(userVo -> stringBuffer.append(",").append(userVo.getUserName()));
                    processPreExecutionLogVo.setTracingResult(stringBuffer.deleteCharAt(0).toString());
                }
            }));
            List processPreExecutionLogEntities = (List)this.nebulaToolkitService.copyCollectionByWhiteList(processPreExecutionLogVos, ProcessPreExecutionLogVo.class, ProcessPreExecutionLogEntity.class, HashSet.class, ArrayList.class, new String[0]);
            this.processPreExecutionRepository.saveOrUpdateBatch(processPreExecutionLogEntities);
        }
    }

    @Override
    @Transactional
    public List<ProcessPreExecutionLogVo> findPreExecutionLogByProcessNoOrProcessInstanceId(String processNo, String processInstanceId) {
        if (StringUtils.isNotBlank((CharSequence)processNo) && StringUtils.isBlank((CharSequence)processInstanceId)) {
            ProcessInstanceVo processInstanceVo = this.processInstanceService.findByProcessNo(processNo);
            if (ObjectUtils.isEmpty((Object)processInstanceVo)) {
                return new ArrayList<ProcessPreExecutionLogVo>();
            }
            processInstanceId = processInstanceVo.getProcessInstanceId();
        }
        Validate.notNull((Object)processInstanceId, (String)"\u67e5\u8be2\u6d41\u7a0b\u9884\u6267\u884c\u65e5\u5fd7\u65f6\uff0c\u6d41\u7a0b\u5b9e\u4f8bid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        ProcessInstanceEntity processInstanceEntity = this.processInstanceService.findByProcessInstanceId(processInstanceId);
        if (ObjectUtils.isEmpty((Object)((Object)processInstanceEntity))) {
            return new ArrayList<ProcessPreExecutionLogVo>();
        }
        String processTemplateId = processInstanceEntity.getProcessTemplateId();
        List<ProcessPreExecutionLogEntity> processPreExecutionLogEntities = this.processPreExecutionRepository.findPreExecutionLogByProcessInstanceIdAndTemplateId(processInstanceId, processTemplateId);
        if (CollectionUtils.isEmpty(processPreExecutionLogEntities)) {
            this.create(processInstanceId, processTemplateId);
            processPreExecutionLogEntities = this.processPreExecutionRepository.findPreExecutionLogByProcessInstanceIdAndTemplateId(processInstanceId, processTemplateId);
        }
        if (CollectionUtils.isEmpty(processPreExecutionLogEntities)) {
            return new ArrayList<ProcessPreExecutionLogVo>();
        }
        List processPreExecutionLogVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(processPreExecutionLogEntities, ProcessPreExecutionLogEntity.class, ProcessPreExecutionLogVo.class, HashSet.class, ArrayList.class, new String[0]);
        return processPreExecutionLogVos;
    }

    @Override
    @Transactional
    public void updatePreLogByProcessInstanceId(String processInstanceId, String taskDefinitionKey) {
        Validate.notNull((Object)processInstanceId, (String)"\u66f4\u65b0\u6d41\u7a0b\u9884\u6267\u884c\u65e5\u5fd7\u65f6\uff0c\u6d41\u7a0b\u5b9e\u4f8bid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        ProcessInstanceEntity processInstanceEntity = this.processInstanceService.findByProcessInstanceId(processInstanceId);
        if (ObjectUtils.isNotEmpty((Object)((Object)processInstanceEntity))) {
            List<HistoricTaskInstance> historicTaskInstances;
            List historicTaskInstanceList;
            String processTemplateId = processInstanceEntity.getProcessTemplateId();
            List<ProcessPreExecutionLogEntity> processPreExecutionLogEntities = this.processPreExecutionRepository.findPreExecutionLogByProcessInstanceIdAndTemplateId(processInstanceId, processTemplateId);
            if (CollectionUtils.isEmpty(processPreExecutionLogEntities)) {
                this.create(processInstanceId, processTemplateId);
                processPreExecutionLogEntities = this.processPreExecutionRepository.findPreExecutionLogByProcessInstanceIdAndTemplateId(processInstanceId, processTemplateId);
            }
            if (!(CollectionUtils.isEmpty(processPreExecutionLogEntities) || CollectionUtils.isEmpty((Collection)(historicTaskInstanceList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId)).taskTenantId(TenantUtils.getTenantCode())).taskDefinitionKey(taskDefinitionKey)).list())) || CollectionUtils.isEmpty(historicTaskInstances = historicTaskInstanceList.stream().filter(historicTaskInstance -> StringUtils.isNotBlank((CharSequence)historicTaskInstance.getAssignee()) && Objects.nonNull(historicTaskInstance.getEndTime())).sorted(Comparator.comparing(HistoricTaskInstance::getEndTime).reversed()).collect(Collectors.toList())))) {
                StringBuffer assigneeBuffer = new StringBuffer();
                historicTaskInstances.forEach(historicTaskInstance -> assigneeBuffer.append(",").append(historicTaskInstance.getAssignee().split(":")[1]));
                this.processPreExecutionRepository.updatePreLogAllByProcessInstanceIdAndTaskDefinitionKey(processInstanceId, taskDefinitionKey, assigneeBuffer.deleteCharAt(0).toString());
                String assignees = ((HistoricTaskInstance)historicTaskInstances.get(0)).getAssignee().split(":")[1];
                Map<String, Set<UserVo>> userVoMap = this.findPreTracingNextNode(processTemplateId, taskDefinitionKey, Collections.singleton(assignees), processInstanceId);
                if (MapUtils.isNotEmpty(userVoMap)) {
                    Set<String> taskNodeKeys = userVoMap.keySet();
                    for (String taskNodeKey : taskNodeKeys) {
                        Set<UserVo> userVos = userVoMap.get(taskNodeKey);
                        if (CollectionUtils.isEmpty(userVos)) continue;
                        StringBuffer buffer = new StringBuffer();
                        userVos.forEach(userVo -> buffer.append(",").append(userVo.getUserName()));
                        this.processPreExecutionRepository.updatePreLogByProcessInstanceIdAndTaskDefinitionKey(processInstanceId, taskNodeKey, buffer.deleteCharAt(0).toString());
                    }
                }
            }
        }
    }

    private Map<String, Set<UserVo>> findPreTracingNextNode(String processTemplateId, String taskDefinitionKey, Set<String> assignees, String processInstanceId) {
        ProcessTemplate processTemplate = this.processTemplateService.findById(processTemplateId);
        Validate.notNull((Object)((Object)processTemplate), (String)"\u6a21\u677f\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processTemplate.getProcessDefinitionId());
        Collection flowElements = bpmnModel.getMainProcess().getFlowElements();
        Map<String, Set<UserVo>> userVoMaps = new HashMap<String, Set<UserVo>>();
        block0: for (FlowElement flowElement : flowElements) {
            if (!(flowElement instanceof UserTask) || !flowElement.getId().equals(taskDefinitionKey)) continue;
            List outgoingFlows = ((UserTask)flowElement).getOutgoingFlows();
            for (SequenceFlow outgoingFlow : outgoingFlows) {
                FlowElement targetFlowElement = outgoingFlow.getTargetFlowElement();
                if (targetFlowElement instanceof UserTask) {
                    Map<String, Set<UserVo>> userTask = this.findPreNodeUserVosUserTask(processTemplateId, (UserTask)targetFlowElement, assignees, processInstanceId);
                    userVoMaps.putAll(userTask);
                    continue block0;
                }
                if (targetFlowElement instanceof ExclusiveGateway) {
                    userVoMaps = this.findPreNodeUserVosExclusive(processTemplateId, (ExclusiveGateway)targetFlowElement, assignees, processInstanceId);
                    continue block0;
                }
                if (targetFlowElement instanceof InclusiveGateway) {
                    userVoMaps = this.findPreNodeUserVosInclusive(processTemplateId, (InclusiveGateway)targetFlowElement, assignees, processInstanceId);
                    continue block0;
                }
                if (targetFlowElement instanceof ServiceTask) {
                    userVoMaps = this.findPreNodeUserVosServiceTask(processTemplateId, (ServiceTask)targetFlowElement, assignees, processInstanceId);
                    continue block0;
                }
                if (!(targetFlowElement instanceof EndEvent)) continue;
                return new HashMap<String, Set<UserVo>>();
            }
        }
        return userVoMaps;
    }

    private Map<String, Set<UserVo>> findPreNodeUserVosUserTask(String processTemplateId, UserTask userTask, Set<String> assignees, String processInstanceId) {
        HashMap<String, Set<UserVo>> userVoMaps = new HashMap<String, Set<UserVo>>();
        Set<UserVo> userVos = this.findPreNodeUserVos(processTemplateId, userTask.getId(), assignees, processInstanceId);
        userVoMaps.put(userTask.getId(), userVos);
        if (CollectionUtils.isEmpty(userVos)) {
            return userVoMaps;
        }
        List outgoingFlows = userTask.getOutgoingFlows();
        for (SequenceFlow outgoingFlow : outgoingFlows) {
            FlowElement targetFlowElement = outgoingFlow.getTargetFlowElement();
            if (targetFlowElement instanceof UserTask) {
                assignees = userVos.stream().map(UserVo::getUserName).collect(Collectors.toSet());
                Map<String, Set<UserVo>> preNodeUserVosUserTask = this.findPreNodeUserVosUserTask(processTemplateId, (UserTask)targetFlowElement, assignees, processInstanceId);
                userVoMaps.putAll(preNodeUserVosUserTask);
                continue;
            }
            if (targetFlowElement instanceof ExclusiveGateway) {
                Map<String, Set<UserVo>> preNodeUserVosExclusive = this.findPreNodeUserVosExclusive(processTemplateId, (ExclusiveGateway)targetFlowElement, assignees, processInstanceId);
                userVoMaps.putAll(preNodeUserVosExclusive);
                break;
            }
            if (targetFlowElement instanceof InclusiveGateway) {
                Map<String, Set<UserVo>> preNodeUserVosInclusive = this.findPreNodeUserVosInclusive(processTemplateId, (InclusiveGateway)targetFlowElement, assignees, processInstanceId);
                userVoMaps.putAll(preNodeUserVosInclusive);
                break;
            }
            if (!(targetFlowElement instanceof ServiceTask)) continue;
            Map<String, Set<UserVo>> preNodeUserVosServiceTask = this.findPreNodeUserVosServiceTask(processTemplateId, (ServiceTask)targetFlowElement, assignees, processInstanceId);
            userVoMaps.putAll(preNodeUserVosServiceTask);
            break;
        }
        return userVoMaps;
    }

    private Map<String, Set<UserVo>> findPreNodeUserVosServiceTask(String processTemplateId, ServiceTask serviceTask, Set<String> assignees, String processInstanceId) {
        List outgoingFlows = serviceTask.getOutgoingFlows();
        Map<String, Set<UserVo>> userVoMaps = new HashMap<String, Set<UserVo>>();
        for (SequenceFlow outgoingFlow : outgoingFlows) {
            FlowElement targetFlowElement = outgoingFlow.getTargetFlowElement();
            if (targetFlowElement instanceof UserTask) {
                Map<String, Set<UserVo>> userTask = this.findPreNodeUserVosUserTask(processTemplateId, (UserTask)targetFlowElement, assignees, processInstanceId);
                userVoMaps.putAll(userTask);
                continue;
            }
            if (targetFlowElement instanceof ExclusiveGateway) {
                userVoMaps = this.findPreNodeUserVosExclusive(processTemplateId, (ExclusiveGateway)targetFlowElement, assignees, processInstanceId);
                break;
            }
            if (targetFlowElement instanceof InclusiveGateway) {
                userVoMaps = this.findPreNodeUserVosInclusive(processTemplateId, (InclusiveGateway)targetFlowElement, assignees, processInstanceId);
                break;
            }
            if (!(targetFlowElement instanceof ServiceTask)) continue;
            userVoMaps = this.findPreNodeUserVosServiceTask(processTemplateId, (ServiceTask)targetFlowElement, assignees, processInstanceId);
            break;
        }
        return userVoMaps;
    }

    private Map<String, Set<UserVo>> findPreNodeUserVosExclusive(String processTemplateId, ExclusiveGateway exclusiveGateway, Set<String> assignees, String processInstanceId) {
        List outgoingFlows = exclusiveGateway.getOutgoingFlows();
        Map<String, Set<UserVo>> userVoMaps = new HashMap<String, Set<UserVo>>();
        for (SequenceFlow outgoingFlow : outgoingFlows) {
            FlowElement targetFlowElement = outgoingFlow.getTargetFlowElement();
            if (targetFlowElement instanceof UserTask) {
                Map<String, Set<UserVo>> userTask = this.findPreNodeUserVosUserTask(processTemplateId, (UserTask)targetFlowElement, assignees, processInstanceId);
                userVoMaps.putAll(userTask);
                continue;
            }
            if (targetFlowElement instanceof ExclusiveGateway) {
                userVoMaps = this.findPreNodeUserVosExclusive(processTemplateId, (ExclusiveGateway)targetFlowElement, assignees, processInstanceId);
                break;
            }
            if (targetFlowElement instanceof InclusiveGateway) {
                userVoMaps = this.findPreNodeUserVosInclusive(processTemplateId, (InclusiveGateway)targetFlowElement, assignees, processInstanceId);
                break;
            }
            if (!(targetFlowElement instanceof ServiceTask)) continue;
            userVoMaps = this.findPreNodeUserVosServiceTask(processTemplateId, (ServiceTask)targetFlowElement, assignees, processInstanceId);
        }
        return userVoMaps;
    }

    private Map<String, Set<UserVo>> findPreNodeUserVosInclusive(String processTemplateId, InclusiveGateway inclusiveGateway, Set<String> assignees, String processInstanceId) {
        List outgoingFlows = inclusiveGateway.getOutgoingFlows();
        Map<String, Set<UserVo>> userVoMaps = new HashMap<String, Set<UserVo>>();
        for (SequenceFlow outgoingFlow : outgoingFlows) {
            FlowElement targetFlowElement = outgoingFlow.getTargetFlowElement();
            if (targetFlowElement instanceof UserTask) {
                Map<String, Set<UserVo>> userTask = this.findPreNodeUserVosUserTask(processTemplateId, (UserTask)targetFlowElement, assignees, processInstanceId);
                userVoMaps.putAll(userTask);
                continue;
            }
            if (targetFlowElement instanceof ExclusiveGateway) {
                userVoMaps = this.findPreNodeUserVosExclusive(processTemplateId, (ExclusiveGateway)targetFlowElement, assignees, processInstanceId);
                break;
            }
            if (targetFlowElement instanceof InclusiveGateway) {
                userVoMaps = this.findPreNodeUserVosInclusive(processTemplateId, (InclusiveGateway)targetFlowElement, assignees, processInstanceId);
                break;
            }
            if (!(targetFlowElement instanceof ServiceTask)) continue;
            userVoMaps = this.findPreNodeUserVosServiceTask(processTemplateId, (ServiceTask)targetFlowElement, assignees, processInstanceId);
            break;
        }
        return userVoMaps;
    }

    private Set<UserVo> findTracingEvent(Set<String> assignees) {
        SerializableBiConsumer & Serializable sf = UserInfoListener::findByPositionUpperByUserCodes;
        UserInfoEventDto userInfoEventDto = UserInfoEventDto.builder().userCodes(assignees).build();
        UserInfoResponse userInfoResponse = (UserInfoResponse)this.nebulaNetEventClient.directPublish((NebulaEventDto)userInfoEventDto, UserInfoListener.class, (SerializableBiConsumer)sf);
        if (!Objects.isNull(userInfoResponse) && !CollectionUtils.isEmpty((Collection)userInfoResponse.getUserVos())) {
            Collection userVos = userInfoResponse.getUserVos();
            Set<UserVo> userVoList = userVos.stream().filter(userVo -> DelFlagStatusEnum.NORMAL.getCode().equals(userVo.getDelFlag()) && EnableStatusEnum.ENABLE.getCode().equals(userVo.getEnableStatus())).collect(Collectors.toSet());
            if (!CollectionUtils.isEmpty(userVoList)) {
                return userVoList;
            }
            return Collections.emptySet();
        }
        return Collections.emptySet();
    }

    private TracingStrategy findCurrentTracingStrategy(String code) {
        if (CollectionUtils.isEmpty(this.tracingStrategies)) {
            return null;
        }
        return this.tracingStrategies.stream().filter(item -> item.getCode().equals(code)).findFirst().orElse(null);
    }

    private Set<UserVo> findPreNodeUserVos(String processTemplateId, String taskDefinitionKey, Set<String> assignees, String processInstanceId) {
        ProcessTemplateNodeVo processTemplateNodeVo = this.processTemplateNodeService.findByTemplateIdAndTaskId(processTemplateId, taskDefinitionKey);
        List<ProcessTemplateNodeAssigneeVo> processTemplateNodeAssignees = this.processTemplateNodeAssigneeService.findByNodeId(processTemplateNodeVo.getId());
        if (CollectionUtils.isEmpty(processTemplateNodeAssignees)) {
            return Collections.emptySet();
        }
        List<ProcessTemplateNodeAssigneeVo> processTemplateNodeAssigneeList = processTemplateNodeAssignees.stream().filter(processTemplateNodeAssigneeVo -> processTemplateNodeAssigneeVo.getStrategyCode().equals("PreNodeApproverUpperTracingStrategy")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(processTemplateNodeAssigneeList)) {
            return Collections.emptySet();
        }
        HashSet userCodeColl = Sets.newHashSet();
        processTemplateNodeAssigneeList.forEach(processTemplateNodeAssignee -> {
            String strategyCode = processTemplateNodeAssignee.getStrategyCode();
            if (strategyCode.equals("PreNodeApproverUpperTracingStrategy")) {
                Set<UserVo> userVos = this.findTracingEvent(assignees);
                userCodeColl.add(userVos);
            } else {
                TracingStrategy tracingStrategy = this.findCurrentTracingStrategy(strategyCode);
                Collection processTemplateNodeAssigneeVarVos = processTemplateNodeAssignee.getProcessTemplateNodeAssigneeVars();
                Set<Object> codes = Sets.newHashSet();
                if (!CollectionUtils.isEmpty((Collection)processTemplateNodeAssigneeVarVos)) {
                    codes = processTemplateNodeAssigneeVarVos.stream().map(ProcessTemplateNodeAssigneeVarVo::getCode).collect(Collectors.toSet());
                }
                Set userVos = tracingStrategy.onHandleUserVos((Collection)codes, null, processInstanceId, null);
                userCodeColl.add(userVos);
            }
        });
        Optional result = userCodeColl.parallelStream().reduce((c1, c2) -> {
            c1.retainAll((Collection<?>)c2);
            return c1;
        });
        Set userVos = result.orElse(Sets.newHashSet());
        return userVos;
    }
}

