/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.service.internal;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.workflow.local.dto.ProcessTaskLogDto;
import com.biz.crm.workflow.local.entity.ProcessInstanceEntity;
import com.biz.crm.workflow.local.entity.ProcessTemplate;
import com.biz.crm.workflow.local.service.ProcessInstanceService;
import com.biz.crm.workflow.local.service.ProcessRetrieveService;
import com.biz.crm.workflow.local.service.ProcessTaskLogService;
import com.biz.crm.workflow.local.service.ProcessTemplateService;
import com.biz.crm.workflow.sdk.dto.TaskDto;
import com.biz.crm.workflow.sdk.enums.ProcessOperateTypeEnum;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.service.ProcessTemplateNodeService;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateNodeVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowNode;
import org.flowable.bpmn.model.ParallelGateway;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.bpmn.model.UserTask;
import org.flowable.engine.HistoryService;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.TaskService;
import org.flowable.engine.history.HistoricActivityInstance;
import org.flowable.engine.history.HistoricActivityInstanceQuery;
import org.flowable.engine.runtime.Execution;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.task.api.TaskQuery;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.flowable.task.api.history.HistoricTaskInstanceQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ProcessRetrieveServiceImpl
implements ProcessRetrieveService {
    @Autowired
    private TaskService taskService;
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private ProcessInstanceService processInstanceService;
    @Autowired
    private ProcessTemplateService processTemplateService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private ProcessTaskLogService processTaskLogService;
    @Autowired
    private ProcessTemplateNodeService processTemplateNodeService;

    @Override
    @Transactional
    public void handleTask(TaskDto taskDto) {
        Validate.notNull((Object)taskDto, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)taskDto.getProcessInstanceId(), (String)"\u6d41\u7a0b\u5b9e\u4f8bid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)taskDto.getTargetKey(), (String)"\u53d6\u56de\u4efb\u52a1id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ProcessInstanceEntity processInstance = this.processInstanceService.findByProcessInstanceId(taskDto.getProcessInstanceId());
        Validate.notNull((Object)((Object)processInstance), (String)"\u6570\u636e\u5f02\u5e38\uff0c\u672a\u627e\u5230\u6d41\u7a0b\u5b9e\u4f8b\u5bf9\u8c61", (Object[])new Object[0]);
        Validate.isTrue((boolean)ProcessStatusEnum.COMMIT.getDictCode().equals(processInstance.getProcessStatus()), (String)"\u6d41\u7a0b\u72b6\u6001\u4e0d\u662f\u5ba1\u6279\u4e2d,\u4e0d\u80fd\u53d6\u56de\uff01", (Object[])new Object[0]);
        ProcessInstance processInstancebpm = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(taskDto.getProcessInstanceId()).singleResult();
        Validate.notNull((Object)processInstancebpm, (String)"\u53d6\u56de\u65f6,\u6d41\u7a0b\u4e0d\u5728\u8fd0\u884c\u4e2d,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01", (Object[])new Object[0]);
        ProcessTemplate processTemplate = this.processTemplateService.findById(processInstance.getProcessTemplateId());
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processTemplate.getProcessDefinitionId());
        Validate.notNull((Object)bpmnModel, (String)"\u672a\u627e\u5230\u6d41\u7a0b\u5b9a\u4e49\u5bf9\u8c61", (Object[])new Object[0]);
        UserIdentity userIdentity = this.loginUserService.getLoginUser();
        Validate.notNull((Object)userIdentity, (String)"\u83b7\u53d6\u767b\u5f55\u4eba\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)userIdentity.getTenantCode(), (String)"\u83b7\u53d6\u767b\u5f55\u4eba\u79df\u6237\u4fe1\u606f\u4e3a\u7a7a", (Object[])new Object[0]);
        HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstance.getProcessInstanceId())).taskTenantId(TenantUtils.getTenantCode())).taskId(taskDto.getTargetKey())).singleResult();
        String currentUserCode = StringUtils.join((Object[])new String[]{userIdentity.getIdentityType(), ":", userIdentity.getAccount()});
        List<HistoricActivityInstance> activityInstances = this.findUserHistoricActivityInstances(currentUserCode, processInstance, historicTaskInstance.getTaskDefinitionKey());
        Validate.notEmpty(activityInstances, (String)"\u672a\u627e\u5230\u5386\u53f2\u4efb\u52a1\u8282\u70b9", (Object[])new Object[0]);
        List<String> currentActivities = this.validateTaskIsCanRetrieveAndFindCurrentTask(bpmnModel, processInstance, historicTaskInstance.getTaskDefinitionKey(), activityInstances);
        if (!CollectionUtils.isEmpty(currentActivities)) {
            this.runtimeService.createChangeActivityStateBuilder().processInstanceId(taskDto.getProcessInstanceId()).processVariable("currentOperateBtn", (Object)taskDto.getProcessButtonCode()).moveActivityIdsToSingleActivityId(currentActivities, historicTaskInstance.getTaskDefinitionKey()).changeState();
        } else {
            List<Execution> executions = this.getNextParallelExecutions(bpmnModel, processInstance, historicTaskInstance.getTaskDefinitionKey());
            Execution execution = executions.get(0);
            this.runtimeService.createChangeActivityStateBuilder().processInstanceId(taskDto.getProcessInstanceId()).processVariable("currentOperateBtn", (Object)taskDto.getProcessButtonCode()).moveExecutionToActivityId(execution.getId(), historicTaskInstance.getTaskDefinitionKey()).changeState();
        }
        ProcessTaskLogDto processTaskLogDto = new ProcessTaskLogDto();
        processTaskLogDto.setTaskId(taskDto.getTaskId());
        processTaskLogDto.setProcessInstanceId(taskDto.getProcessInstanceId());
        processTaskLogDto.setOperateType(ProcessOperateTypeEnum.RETRIEVE.getDictCode());
        this.addLog(processTaskLogDto);
    }

    protected List<HistoricActivityInstance> findUserHistoricActivityInstances(String username, ProcessInstanceEntity processInstance, String taskDefinitionKey) {
        List activityInstances;
        HistoricActivityInstanceQuery query = (HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstance.getProcessInstanceId()).activityTenantId(TenantUtils.getTenantCode()).orderByHistoricActivityInstanceEndTime().deleteReason(null).desc();
        if (StringUtils.isNotBlank((CharSequence)taskDefinitionKey)) {
            query.activityId(taskDefinitionKey);
        }
        if (!CollectionUtils.isEmpty((Collection)(activityInstances = query.list()))) {
            activityInstances = activityInstances.stream().filter(a -> username.equals(a.getAssignee()) && StringUtils.isBlank((CharSequence)a.getDeleteReason())).collect(Collectors.toList());
        }
        return activityInstances;
    }

    protected List<String> validateTaskIsCanRetrieveAndFindCurrentTask(BpmnModel bpmnModel, ProcessInstanceEntity processInstance, String taskDefinitionKey, List<HistoricActivityInstance> activityInstances) {
        Validate.notEmpty(activityInstances, (String)"\u672a\u627e\u5230\u5386\u53f2\u4efb\u52a1\u8282\u70b9", (Object[])new Object[0]);
        HistoricActivityInstance historicActivityInstance = activityInstances.get(0);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)historicActivityInstance.getDeleteReason()), (String)"\u8be5\u8282\u70b9\u4efb\u52a1\u975e\u6b63\u5e38\u5ba1\u6279\uff0c\u4e0d\u80fd\u53d6\u56de", (Object[])new Object[0]);
        List tasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstance.getProcessInstanceId())).taskDefinitionKey(taskDefinitionKey)).list();
        Validate.isTrue((boolean)CollectionUtils.isEmpty((Collection)tasks), (String)"\u5f53\u524d\u4efb\u52a1\u8282\u70b9\u6709\u6b63\u5728\u5ba1\u6279\u7684\u4efb\u52a1\uff0c\u4e0d\u80fd\u53d6\u56de\u8be5\u4efb\u52a1", (Object[])new Object[0]);
        Process process = (Process)bpmnModel.getProcesses().get(0);
        FlowElement flowElement = process.getFlowElement(taskDefinitionKey);
        List<UserTask> nextUserTasks = this.findNextUserTask(flowElement);
        ArrayList<String> currentTasks = new ArrayList<String>();
        for (UserTask userTask : nextUserTasks) {
            List taskInstances = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstance.getProcessInstanceId())).taskCompletedAfter(historicActivityInstance.getEndTime()).taskDefinitionKey(userTask.getId())).finished().list();
            if (!CollectionUtils.isEmpty((Collection)taskInstances)) {
                Iterator iterator = taskInstances.iterator();
                while (iterator.hasNext()) {
                    HistoricTaskInstance next = (HistoricTaskInstance)iterator.next();
                    if (!StringUtils.isNotBlank((CharSequence)next.getDeleteReason())) continue;
                    iterator.remove();
                }
            }
            Validate.isTrue((boolean)CollectionUtils.isEmpty((Collection)taskInstances), (String)"\u540e\u7eed\u4efb\u52a1\u5df2\u5ba1\u6279\uff0c\u4e0d\u80fd\u53d6\u56de\u8be5\u4efb\u52a1", (Object[])new Object[0]);
            List list = ((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstance.getProcessInstanceId())).taskTenantId(TenantUtils.getTenantCode())).taskDefinitionKey(userTask.getId())).list();
            if (CollectionUtils.isEmpty((Collection)list)) continue;
            currentTasks.add(userTask.getId());
        }
        return currentTasks;
    }

    protected List<UserTask> findNextUserTask(FlowElement flowElement) {
        ArrayList<UserTask> userTasks = new ArrayList<UserTask>();
        List<FlowElement> elements = this.getNextFlowElements(flowElement);
        if (!CollectionUtils.isEmpty(elements)) {
            for (FlowElement element : elements) {
                if (element instanceof UserTask) {
                    userTasks.add((UserTask)element);
                    continue;
                }
                userTasks.addAll(this.findNextUserTask(element));
            }
        }
        return userTasks;
    }

    protected List<FlowElement> getNextFlowElements(FlowElement flowElement) {
        ArrayList<FlowElement> nextFlowElements = new ArrayList<FlowElement>();
        if (flowElement instanceof FlowNode) {
            nextFlowElements.addAll(((FlowNode)flowElement).getOutgoingFlows());
        } else if (flowElement instanceof SequenceFlow) {
            nextFlowElements.add(((SequenceFlow)flowElement).getTargetFlowElement());
        }
        return nextFlowElements;
    }

    protected List<Execution> getNextParallelExecutions(BpmnModel bpmnModel, ProcessInstanceEntity processInstance, String activityId) {
        Process process = (Process)bpmnModel.getProcesses().get(0);
        FlowElement flowElement = process.getFlowElement(activityId);
        ParallelGateway parallelGateway = this.findNextParallelGateway(flowElement);
        Validate.notNull((Object)parallelGateway, (String)"\u672a\u627e\u5230\u6d3b\u52a8\u8282\u70b9\u7684\u4e0b\u4e00\u5e73\u884c\u7f51\u5173", (Object[])new Object[0]);
        List executions = this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getProcessInstanceId()).list();
        return executions.stream().filter(execution -> parallelGateway.getId().equals(execution.getActivityId())).collect(Collectors.toList());
    }

    protected ParallelGateway findNextParallelGateway(FlowElement flowElement) {
        List<FlowElement> elements = this.getNextFlowElements(flowElement);
        if (!CollectionUtils.isEmpty(elements)) {
            for (FlowElement element : elements) {
                if (element instanceof ParallelGateway) {
                    return (ParallelGateway)element;
                }
                ParallelGateway parallelGateway = this.findNextParallelGateway(element);
                if (parallelGateway == null) continue;
                return parallelGateway;
            }
        }
        return null;
    }

    private void addLog(ProcessTaskLogDto processTaskLogDto) {
        ProcessInstanceEntity processInstanceEntity = this.processInstanceService.findByProcessInstanceId(processTaskLogDto.getProcessInstanceId());
        Validate.notNull((Object)((Object)processInstanceEntity), (String)"\u65e5\u5fd7\u8bb0\u5f55\u6d41\u7a0b\u5b9e\u4f8b\u6570\u636e\u5f02\u5e38", (Object[])new Object[0]);
        if (!StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{processTaskLogDto.getProcessDefinitionId(), processTaskLogDto.getTaskDefinitionKey()})) {
            ProcessTemplateNodeVo processTemplateNodeVo = this.processTemplateNodeService.findByProcessInstanceIdAndTaskDefinitionKey(processInstanceEntity.getProcessInstanceId(), processTaskLogDto.getTaskDefinitionKey());
            Validate.notNull((Object)processTemplateNodeVo, (String)"\u65e5\u5fd7\u8bb0\u5f55\u8282\u70b9\u6570\u636e\u5f02\u5e38", (Object[])new Object[0]);
            processTaskLogDto.setTaskNodeId(processTemplateNodeVo.getId());
        }
        processTaskLogDto.setProcessKey(processInstanceEntity.getProcessKey());
        processTaskLogDto.setTenantCode(TenantUtils.getTenantCode());
        this.processTaskLogService.create(processTaskLogDto);
    }
}

