/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.workflow.local.dto.ProcessInterveneDto;
import com.biz.crm.workflow.local.dto.ProcessInterventionDto;
import com.biz.crm.workflow.local.dto.ProcessTaskLogDto;
import com.biz.crm.workflow.local.entity.ProcessInstanceEntity;
import com.biz.crm.workflow.local.entity.ProcessTemplate;
import com.biz.crm.workflow.local.service.ProcessInstanceService;
import com.biz.crm.workflow.local.service.ProcessService;
import com.biz.crm.workflow.local.service.ProcessTaskLogService;
import com.biz.crm.workflow.local.service.ProcessTaskService;
import com.biz.crm.workflow.local.service.ProcessTemplateNodeUserTaskService;
import com.biz.crm.workflow.local.service.ProcessTemplateService;
import com.biz.crm.workflow.local.service.TaskMultiCacheVoService;
import com.biz.crm.workflow.local.service.cmd.AfterSignUserTaskCmd;
import com.biz.crm.workflow.local.vo.BpmValidateUserTaskVo;
import com.biz.crm.workflow.sdk.constant.ProcessConstant;
import com.biz.crm.workflow.sdk.dto.ProcessTemplateNodeAssigneeDto;
import com.biz.crm.workflow.sdk.dto.ProcessTemplateNodeAssigneeVarDto;
import com.biz.crm.workflow.sdk.dto.ProcessTemplateNodeDto;
import com.biz.crm.workflow.sdk.dto.ProcessTemplateNodeUserTaskDto;
import com.biz.crm.workflow.sdk.dto.TaskDto;
import com.biz.crm.workflow.sdk.enums.ProcessOperateTypeEnum;
import com.biz.crm.workflow.sdk.service.ProcessTemplateNodeService;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateNodeVo;
import com.biz.crm.workflow.sdk.vo.UserVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.flowable.bpmn.converter.BpmnXMLConverter;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.CallActivity;
import org.flowable.bpmn.model.EndEvent;
import org.flowable.bpmn.model.ExclusiveGateway;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowNode;
import org.flowable.bpmn.model.Gateway;
import org.flowable.bpmn.model.ParallelGateway;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.ReceiveTask;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.bpmn.model.ServiceTask;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.bpmn.model.SubProcess;
import org.flowable.bpmn.model.Task;
import org.flowable.bpmn.model.UserTask;
import org.flowable.common.engine.impl.de.odysseus.el.ExpressionFactoryImpl;
import org.flowable.common.engine.impl.de.odysseus.el.util.SimpleContext;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.javax.el.ELContext;
import org.flowable.common.engine.impl.javax.el.ValueExpression;
import org.flowable.engine.HistoryService;
import org.flowable.engine.ManagementService;
import org.flowable.engine.ProcessEngine;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.TaskService;
import org.flowable.engine.history.HistoricProcessInstance;
import org.flowable.engine.impl.dynamic.DynamicUserTaskBuilder;
import org.flowable.engine.repository.Deployment;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.task.api.TaskInfo;
import org.flowable.task.api.TaskQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProcessServiceImpl
implements ProcessService {
    private static final Logger log = LoggerFactory.getLogger(ProcessServiceImpl.class);
    @Autowired
    protected RepositoryService repositoryService;
    @Autowired
    protected HistoryService historyService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private ProcessEngine processEngine;
    @Autowired
    private ProcessTemplateNodeUserTaskService processTemplateNodeUserTaskService;
    @Autowired
    private ProcessTemplateNodeService processTemplateNodeService;
    @Autowired
    private ProcessTaskLogService processTaskLogService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private ProcessTemplateService processTemplateService;
    @Autowired
    private ProcessInstanceService processInstanceService;
    @Autowired
    private ProcessTaskService processTaskService;
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired
    private TaskMultiCacheVoService taskMultiCacheVoService;

    @Override
    public List<String> getAssigneeByTask(String templateId, String taskId, String taskDefKey, String processInstanceId, String startUserName) {
        ProcessTemplateNodeVo nodeVo = this.processTemplateNodeService.findByTemplateIdAndTaskId(templateId, taskDefKey);
        return Lists.newArrayList(this.processTaskService.findAssigneesByTaskNodeIdAndTaskId(nodeVo.getId(), taskId, processInstanceId, taskDefKey, startUserName));
    }

    @Override
    public List<UserVo> getUserVoByTask(String processTemplateId, String taskId, String taskDefKey, String processInstanceId, String startUserName) {
        ProcessTemplateNodeVo nodeVo = this.processTemplateNodeService.findByTemplateIdAndTaskId(processTemplateId, taskDefKey);
        return Lists.newArrayList(this.processTaskService.findUserVoByTaskNodeIdAndTaskId(nodeVo.getId(), taskId, processInstanceId, taskDefKey, startUserName));
    }

    @Override
    public String getAssigneeByTask(String taskDefinitionKey, List<BpmValidateUserTaskVo> taskVos) {
        if (CollectionUtils.isEmpty(taskVos)) {
            return null;
        }
        for (BpmValidateUserTaskVo task : taskVos) {
            if (!task.getNodeId().equals(taskDefinitionKey) || !CollectionUtils.isNotEmpty(task.getUserVos())) continue;
            return ((UserVo)task.getUserVos().stream().findAny().get()).getUserName();
        }
        return null;
    }

    @Override
    public ProcessDefinition deploy(BpmnModel bpmn) {
        Process process = (Process)bpmn.getProcesses().get(0);
        String deployName = process.getId() + ".bpmn";
        Deployment deployment = this.repositoryService.createDeployment().addBpmnModel(deployName, bpmn).name(process.getId()).key(process.getId()).deploy();
        return (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(deployment.getId()).singleResult();
    }

    @Override
    public boolean isProcessEnd(String processInstanceId) {
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).finished().singleResult();
        return historicProcessInstance != null;
    }

    @Override
    public BpmnModel xmlToBpmnModel(String xmlStr) {
        try {
            ByteArrayInputStream bpmnStream = new ByteArrayInputStream(xmlStr.getBytes());
            XMLInputFactory xif = XMLInputFactory.newInstance();
            InputStreamReader in = new InputStreamReader((InputStream)bpmnStream, "UTF-8");
            XMLStreamReader xtr = xif.createXMLStreamReader(in);
            return new BpmnXMLConverter().convertToBpmnModel(xtr);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(String.format("\u6d41\u7a0bXML\u8f6c\u6362\u5931\u8d25:%s", e.getMessage()), e);
        }
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void addSignTask(String taskId, List<String> signUser) {
        org.flowable.task.api.Task task = (org.flowable.task.api.Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        Validate.notNull((Object)task, (String)"\u4efb\u52a1id\u4e0d\u5408\u6cd5", (Object[])new Object[0]);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(signUser), (String)"\u8bf7\u9009\u62e9\u52a0\u7b7e\u7528\u6237", (Object[])new Object[0]);
        String dynamicUserId = "dynamicUserTask-" + UUID.randomUUID().toString().replaceAll("-", "");
        DynamicUserTaskBuilder dynamicUserTaskBuilder = new DynamicUserTaskBuilder();
        dynamicUserTaskBuilder.setId(dynamicUserId);
        dynamicUserTaskBuilder.setName("\u4e34\u65f6\u5411\u540e\u52a0\u7b7e");
        ManagementService managementService = this.processEngine.getManagementService();
        List<FlowElement> nextUserTasks = this.getNextUserTasks(this.repositoryService, task);
        FlowElement next = null;
        if (CollectionUtils.isNotEmpty(nextUserTasks)) {
            next = nextUserTasks.get(0);
        }
        EndEvent endEvent = this.getEndEvent(this.repositoryService, task);
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).processInstanceTenantId(TenantUtils.getTenantCode()).singleResult();
        managementService.executeCommand((Command)new AfterSignUserTaskCmd(processInstance, dynamicUserTaskBuilder, task.getId(), next, endEvent));
        ProcessInstanceEntity instanceEntity = this.processInstanceService.findByProcessInstanceId(task.getProcessInstanceId());
        Validate.notNull((Object)((Object)instanceEntity), (String)"\u6d41\u7a0b\u5b9e\u4f8b\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        ProcessTemplate processTemplate = this.processTemplateService.findById(instanceEntity.getProcessTemplateId());
        Validate.notNull((Object)((Object)processTemplate), (String)"\u6d41\u7a0b\u53d1\u5e03\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        ProcessTemplateNodeVo processTemplateNodeVo = this.processTemplateNodeService.findByProcessInstanceIdAndTaskDefinitionKey(task.getProcessInstanceId(), task.getTaskDefinitionKey());
        Validate.notNull((Object)processTemplateNodeVo, (String)"\u6d41\u7a0b\u8282\u70b9\u914d\u7f6e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        processTemplateNodeVo = this.processTemplateNodeService.findById(processTemplateNodeVo.getId());
        processTemplateNodeVo.setId(null);
        processTemplateNodeVo.setProcessTaskId(dynamicUserTaskBuilder.getId());
        processTemplateNodeVo.setProcessTaskName(dynamicUserTaskBuilder.getName());
        ProcessTemplateNodeDto nodeDto = (ProcessTemplateNodeDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)processTemplateNodeVo, ProcessTemplateNodeDto.class, HashSet.class, ArrayList.class, new String[0]);
        this.createDefaultNodeAssignee(nodeDto, signUser);
        this.processTemplateNodeService.create(nodeDto);
    }

    private void createDefaultNodeAssignee(ProcessTemplateNodeDto nodeDto, List<String> positionCodes) {
        nodeDto.setId(null);
        JSONObject data = nodeDto.getAttributes().getJSONObject("userTask");
        ProcessTemplateNodeUserTaskDto taskDto = (ProcessTemplateNodeUserTaskDto)JSON.toJavaObject((JSON)data, ProcessTemplateNodeUserTaskDto.class);
        taskDto.getProcessTemplateNodeAssignees().clear();
        taskDto.setNodeId(null);
        taskDto.setId(null);
        taskDto.setSignOptional(Boolean.valueOf(false));
        ProcessTemplateNodeAssigneeDto dto = new ProcessTemplateNodeAssigneeDto();
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setTemplateId(nodeDto.getTemplateId());
        dto.setSort(Integer.valueOf(1));
        dto.setStrategyCode("PositionTracingStrategy");
        dto.setStrategyName("\u56fa\u5b9a\u804c\u4f4d");
        ArrayList assigneeVars = Lists.newArrayList();
        positionCodes.forEach(positionCode -> {
            ProcessTemplateNodeAssigneeVarDto assigneeVarDto = new ProcessTemplateNodeAssigneeVarDto();
            assigneeVarDto.setCode(positionCode);
            assigneeVarDto.setTenantCode(TenantUtils.getTenantCode());
            assigneeVarDto.setSort(Integer.valueOf(1));
            assigneeVarDto.setName(positionCode);
            assigneeVars.add(assigneeVarDto);
        });
        dto.setProcessTemplateNodeAssigneeVars((Collection)assigneeVars);
        taskDto.setProcessTemplateNodeAssignees((Collection)Lists.newArrayList((Object[])new ProcessTemplateNodeAssigneeDto[]{dto}));
        taskDto.getProcessTaskButtons().forEach(processTaskButtonDto -> processTaskButtonDto.setId(null));
        taskDto.getProcessTaskIndicators().forEach(processTaskIndicatorsDto -> processTaskIndicatorsDto.setId(null));
        taskDto.getProcessTaskCopyConfigs().forEach(processTaskCopyConfigDto -> processTaskCopyConfigDto.setId(null));
        JSONObject userTask = new JSONObject();
        userTask.put("userTask", (Object)taskDto);
        nodeDto.setAttributes(userTask);
    }

    @Override
    public void delegateTask(TaskDto taskDto) {
        org.flowable.task.api.Task task = (org.flowable.task.api.Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskDto.getTaskId())).singleResult();
        Validate.notNull((Object)task, (String)"\u5f53\u524d\u4efb\u52a1\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        UserIdentity userIdentity = this.loginUserService.getLoginUser();
        ProcessInstanceEntity processInstance = this.processInstanceService.findByProcessInstanceId(task.getProcessInstanceId());
        Validate.notNull((Object)((Object)processInstance), (String)"\u6570\u636e\u5f02\u5e38\uff0c\u672a\u627e\u5230\u6d41\u7a0b\u5b9e\u4f8b\u5bf9\u8c61", (Object[])new Object[0]);
        Validate.notNull((Object)userIdentity, (String)"\u5f53\u524d\u767b\u5f55\u4eba\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        String currentUserCode = StringUtils.join((Object[])new String[]{userIdentity.getIdentityType(), ":", userIdentity.getAccount()});
        this.taskService.setVariable(taskDto.getTaskId(), "currentOperateBtn", (Object)taskDto.getProcessButtonCode());
        this.taskService.addCandidateUser(taskDto.getTaskId(), taskDto.getTargetUserName());
        this.taskService.deleteCandidateUser(taskDto.getTaskId(), currentUserCode);
        this.runtimeService.deleteUserIdentityLink(processInstance.getProcessInstanceId(), currentUserCode, "participant");
        ProcessTaskLogDto processTaskLogDto = new ProcessTaskLogDto();
        processTaskLogDto.setTaskId(taskDto.getTaskId());
        processTaskLogDto.setProcessInstanceId(taskDto.getProcessInstanceId());
        processTaskLogDto.setOperateType(ProcessOperateTypeEnum.ASSIGNEE.getDictCode());
        processTaskLogDto.setOperateRemark("\u6d41\u7a0b\u8f6c\u529e");
        processTaskLogDto.setTaskDefinitionKey(task.getTaskDefinitionKey());
        processTaskLogDto.setDelegateUserName(taskDto.getTargetUserName());
        processTaskLogDto.setUserName(currentUserCode);
        this.addLog(processTaskLogDto);
    }

    @Override
    public void processIntervene(ProcessInterveneDto processInterveneDto) {
        List list = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInterveneDto.getProcessInstanceId())).list();
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)list) ? 1 : 0) != 0, (String)"\u4f20\u5165\u5b9e\u4f8bid\u6ca1\u6709\u5728\u8fd0\u884c\u7684\u4efb\u52a1\uff01", (Object[])new Object[0]);
        List taskList = list.stream().filter(s -> s.getId().equals(processInterveneDto.getTaskId())).collect(Collectors.toList());
        Validate.isTrue((!CollectionUtils.isEmpty(taskList) ? 1 : 0) != 0, (String)"\u4f20\u5165\u4efb\u52a1id\u548c\u5b9e\u4f8bid\u6ca1\u6709\u5bf9\u5e94\u5728\u8fd0\u884c\u7684\u4efb\u52a1\uff01", (Object[])new Object[0]);
        ProcessInstanceEntity processInstance = this.processInstanceService.findByProcessInstanceId(processInterveneDto.getProcessInstanceId());
        Validate.notNull((Object)((Object)processInstance), (String)"\u6570\u636e\u5f02\u5e38\uff0c\u672a\u627e\u5230\u6d41\u7a0b\u5b9e\u4f8b\u5bf9\u8c61", (Object[])new Object[0]);
        List currentIds = list.stream().map(TaskInfo::getTaskDefinitionKey).collect(Collectors.toList());
        this.runtimeService.createChangeActivityStateBuilder().processInstanceId(processInterveneDto.getProcessInstanceId()).moveActivityIdsToSingleActivityId(currentIds, processInterveneDto.getTaskKey()).changeState();
        ProcessTaskLogDto processTaskLogDto = new ProcessTaskLogDto();
        processTaskLogDto.setTaskId(processInterveneDto.getTaskId());
        processTaskLogDto.setProcessInstanceId(processInterveneDto.getProcessInstanceId());
        processTaskLogDto.setOperateType(ProcessOperateTypeEnum.INTERVENE.getDictCode());
        this.addLog(processTaskLogDto);
    }

    protected void addLog(ProcessTaskLogDto processTaskLogDto) {
        ProcessInstanceEntity processInstanceEntity = this.processInstanceService.findByProcessInstanceId(processTaskLogDto.getProcessInstanceId());
        Validate.notNull((Object)((Object)processInstanceEntity), (String)"\u65e5\u5fd7\u8bb0\u5f55\u6d41\u7a0b\u5b9e\u4f8b\u6570\u636e\u5f02\u5e38", (Object[])new Object[0]);
        if (!StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{processTaskLogDto.getProcessInstanceId(), processTaskLogDto.getTaskDefinitionKey()})) {
            ProcessTemplateNodeVo processTemplateNodeVo = this.processTemplateNodeService.findByProcessInstanceIdAndTaskDefinitionKey(processInstanceEntity.getProcessInstanceId(), processTaskLogDto.getTaskDefinitionKey());
            Validate.notNull((Object)processTemplateNodeVo, (String)"\u65e5\u5fd7\u8bb0\u5f55\u8282\u70b9\u6570\u636e\u5f02\u5e38", (Object[])new Object[0]);
            processTaskLogDto.setTaskNodeId(processTemplateNodeVo.getId());
            processTaskLogDto.setTaskNodeName(processTemplateNodeVo.getProcessTaskName());
        }
        processTaskLogDto.setProcessKey(processInstanceEntity.getProcessKey());
        processTaskLogDto.setTenantCode(TenantUtils.getTenantCode());
        this.processTaskLogService.create(processTaskLogDto);
    }

    @Override
    public List<ProcessTemplateNodeVo> findFutureNodesByProcessInstanceId(String processInstanceId, org.flowable.task.api.Task task) {
        List entities;
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).processInstanceTenantId(TenantUtils.getTenantCode()).singleResult();
        Validate.notNull((Object)processInstance, (String)"\u6d41\u7a0bid[%s]\u5bf9\u5e94\u6d41\u7a0b\u5b9e\u4f8b\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[]{processInstanceId});
        ProcessInstanceEntity processInstanceEntity = this.processInstanceService.findByProcessInstanceId(processInstanceId);
        ArrayList list = Lists.newArrayList();
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processInstance.getProcessDefinitionId());
        FlowNode flowNode = (FlowNode)bpmnModel.getFlowElement(task.getTaskDefinitionKey());
        List outFlows = flowNode.getOutgoingFlows();
        for (SequenceFlow sequenceFlow : outFlows) {
            FlowElement targetFlow = sequenceFlow.getTargetFlowElement();
            if (targetFlow instanceof UserTask) {
                list.add(targetFlow.getId());
            }
            if (!(targetFlow instanceof EndEvent)) continue;
            break;
        }
        if (CollectionUtils.isNotEmpty((Collection)list) && CollectionUtils.isNotEmpty((Collection)(entities = this.processTemplateNodeService.findByProcessInstanceId(processInstanceId)))) {
            Map map = entities.stream().collect(Collectors.toMap(ProcessTemplateNodeVo::getProcessTaskId, Function.identity()));
            Collections.reverse(list);
            return list.stream().filter(map::containsKey).map(map::get).collect(Collectors.toList());
        }
        return Lists.newArrayList();
    }

    @Override
    @Transactional
    public void processIntervention(ProcessInterventionDto processInterventionDto) {
        List list = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInterventionDto.getProcessInstanceId())).list();
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)list) ? 1 : 0) != 0, (String)"\u4f20\u5165\u5b9e\u4f8bid\u6ca1\u6709\u5728\u8fd0\u884c\u7684\u4efb\u52a1\uff01", (Object[])new Object[0]);
        List taskList = list.stream().filter(l -> l.getId().equals(processInterventionDto.getTaskId())).collect(Collectors.toList());
        Validate.isTrue((!CollectionUtils.isEmpty(taskList) ? 1 : 0) != 0, (String)"\u4f20\u5165\u4efb\u52a1id\u6ca1\u6709\u5bf9\u5e94\u5728\u8fd0\u884c\u7684\u4efb\u52a1\uff01", (Object[])new Object[0]);
        ProcessInstanceEntity processInstance = this.processInstanceService.findByProcessInstanceId(processInterventionDto.getProcessInstanceId());
        Validate.notNull((Object)((Object)processInstance), (String)"\u6570\u636e\u5f02\u5e38\uff0c\u672a\u627e\u5230\u6d41\u7a0b\u5b9e\u4f8b\u5bf9\u8c61\uff01", (Object[])new Object[0]);
        List taskDefinitionKey = list.stream().map(TaskInfo::getTaskDefinitionKey).distinct().collect(Collectors.toList());
        UserIdentity loginUser = this.loginUserService.getLoginUser();
        String identityType = loginUser.getIdentityType();
        HashSet userNames = new HashSet();
        processInterventionDto.getApprovedUsers().forEach(userName -> {
            String username = StringUtils.join((Object[])new String[]{identityType, ":", userName});
            userNames.add(username);
        });
        this.taskMultiCacheVoService.remove(processInterventionDto.getProcessInstanceId() + ":" + processInterventionDto.getTaskKey() + "_Intervention");
        this.taskService.setVariableLocal(processInterventionDto.getTaskId(), "_Intervention", userNames);
        this.runtimeService.createChangeActivityStateBuilder().processInstanceId(processInterventionDto.getProcessInstanceId()).moveActivityIdsToSingleActivityId(taskDefinitionKey, processInterventionDto.getTaskKey()).changeState();
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInterventionDto.getProcessInstanceId())).list();
        String taskNodeName = StringUtils.join((Object[])new String[]{"\u5e72\u9884\u524d\u8282\u70b9:", ((org.flowable.task.api.Task)list.get(0)).getName(), ",", "\u5e72\u9884\u540e\u8282\u70b9:", ((org.flowable.task.api.Task)tasks.get(0)).getName()});
        StringBuffer stringBuffer = new StringBuffer();
        list.forEach(l -> stringBuffer.append(l.getId()).append(","));
        ProcessTaskLogDto processTaskLogDto = new ProcessTaskLogDto();
        processTaskLogDto.setTaskId(stringBuffer.toString());
        processTaskLogDto.setProcessInstanceId(processInterventionDto.getProcessInstanceId());
        processTaskLogDto.setOperateType(ProcessOperateTypeEnum.INTERVENTION.getDictCode());
        processTaskLogDto.setTaskNodeName(taskNodeName);
        processTaskLogDto.setOperateRemark("\u6d41\u7a0b\u5e72\u9884");
        this.addLog(processTaskLogDto);
    }

    public List<FlowElement> getNextUserTasks(RepositoryService repositoryService, org.flowable.task.api.Task task) {
        ArrayList<FlowElement> data = new ArrayList<FlowElement>();
        ProcessDefinition processDefinition = (ProcessDefinition)repositoryService.createProcessDefinitionQuery().processDefinitionId(task.getProcessDefinitionId()).singleResult();
        BpmnModel bpmnModel = repositoryService.getBpmnModel(processDefinition.getId());
        Process mainProcess = bpmnModel.getMainProcess();
        Collection flowElements = mainProcess.getFlowElements();
        String key = task.getTaskDefinitionKey();
        FlowElement flowElement = bpmnModel.getFlowElement(key);
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map vars = (Map)this.taskService.getVariable(task.getId(), ProcessConstant.PROCESS_INSTANCE_FORM_DATA_CODE);
        if (ObjectUtils.isNotEmpty((Object)vars) && vars.size() > 0) {
            map.put(ProcessConstant.PROCESS_INSTANCE_FORM_DATA_CODE, vars);
        }
        ProcessServiceImpl.next(flowElements, flowElement, map, data, Lists.newArrayList());
        return data;
    }

    public EndEvent getEndEvent(RepositoryService repositoryService, org.flowable.task.api.Task task) {
        ArrayList<FlowElement> data = new ArrayList<FlowElement>();
        ProcessDefinition processDefinition = (ProcessDefinition)repositoryService.createProcessDefinitionQuery().processDefinitionId(task.getProcessDefinitionId()).singleResult();
        BpmnModel bpmnModel = repositoryService.getBpmnModel(processDefinition.getId());
        Process mainProcess = bpmnModel.getMainProcess();
        Collection flowElements = mainProcess.getFlowElements();
        String key = task.getTaskDefinitionKey();
        FlowElement flowElement = bpmnModel.getFlowElement(key);
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map vars = (Map)this.taskService.getVariable(task.getId(), ProcessConstant.PROCESS_INSTANCE_FORM_DATA_CODE);
        if (ObjectUtils.isNotEmpty((Object)vars) && vars.size() > 0) {
            map.put(ProcessConstant.PROCESS_INSTANCE_FORM_DATA_CODE, vars);
        }
        ArrayList endEvent = Lists.newArrayList();
        ProcessServiceImpl.next(flowElements, flowElement, map, data, endEvent);
        if (CollectionUtils.isEmpty((Collection)endEvent)) {
            return null;
        }
        return (EndEvent)endEvent.stream().findFirst().orElseGet(null);
    }

    public static void next(Collection<FlowElement> flowElements, FlowElement flowElement, Map<String, Object> map, List<FlowElement> nextUser, List<EndEvent> endEvent) {
        if (flowElement instanceof EndEvent && ProcessServiceImpl.getSubProcess(flowElements, flowElement) != null) {
            flowElement = ProcessServiceImpl.getSubProcess(flowElements, flowElement);
        }
        List outGoingFlows = null;
        if (flowElement instanceof Task) {
            outGoingFlows = ((Task)flowElement).getOutgoingFlows();
        } else if (flowElement instanceof Gateway) {
            outGoingFlows = ((Gateway)flowElement).getOutgoingFlows();
        } else if (flowElement instanceof StartEvent) {
            outGoingFlows = ((StartEvent)flowElement).getOutgoingFlows();
        } else if (flowElement instanceof SubProcess) {
            outGoingFlows = ((SubProcess)flowElement).getOutgoingFlows();
        } else if (flowElement instanceof CallActivity) {
            outGoingFlows = ((CallActivity)flowElement).getOutgoingFlows();
        }
        if (outGoingFlows != null && outGoingFlows.size() > 0) {
            for (SequenceFlow sequenceFlow : outGoingFlows) {
                String nextFlowElementID;
                String expression = sequenceFlow.getConditionExpression();
                Boolean checkFormDataByRuleEl = ProcessServiceImpl.checkFormDataByRuleEl(expression, map);
                if (expression != null && !checkFormDataByRuleEl.booleanValue() || ProcessServiceImpl.checkSubProcess(nextFlowElementID = sequenceFlow.getTargetRef(), flowElements, nextUser).booleanValue()) continue;
                FlowElement nextFlowElement = ProcessServiceImpl.getFlowElementById(nextFlowElementID, flowElements);
                if (nextFlowElement instanceof CallActivity) {
                    CallActivity ca = (CallActivity)nextFlowElement;
                    if (ca.getLoopCharacteristics() != null) {
                        UserTask userTask = new UserTask();
                        userTask.setId(ca.getId());
                        userTask.setId(ca.getId());
                        userTask.setLoopCharacteristics(ca.getLoopCharacteristics());
                        userTask.setName(ca.getName());
                        nextUser.add((FlowElement)userTask);
                    }
                    ProcessServiceImpl.next(flowElements, nextFlowElement, map, nextUser, endEvent);
                }
                if (nextFlowElement instanceof UserTask) {
                    nextUser.add(nextFlowElement);
                    ProcessServiceImpl.next(flowElements, nextFlowElement, map, nextUser, endEvent);
                    continue;
                }
                if (nextFlowElement instanceof ExclusiveGateway) {
                    nextUser.add(nextFlowElement);
                    ProcessServiceImpl.next(flowElements, nextFlowElement, map, nextUser, endEvent);
                    continue;
                }
                if (nextFlowElement instanceof ParallelGateway) {
                    nextUser.add(nextFlowElement);
                    ProcessServiceImpl.next(flowElements, nextFlowElement, map, nextUser, endEvent);
                    continue;
                }
                if (nextFlowElement instanceof ReceiveTask) {
                    nextUser.add(nextFlowElement);
                    ProcessServiceImpl.next(flowElements, nextFlowElement, map, nextUser, endEvent);
                    continue;
                }
                if (nextFlowElement instanceof ServiceTask) {
                    nextUser.add(nextFlowElement);
                    ProcessServiceImpl.next(flowElements, nextFlowElement, map, nextUser, endEvent);
                    continue;
                }
                if (nextFlowElement instanceof StartEvent) {
                    nextUser.add(nextFlowElement);
                    ProcessServiceImpl.next(flowElements, nextFlowElement, map, nextUser, endEvent);
                    continue;
                }
                if (!(nextFlowElement instanceof EndEvent)) continue;
                endEvent.add((EndEvent)nextFlowElement);
            }
        }
    }

    public static FlowElement getSubProcess(Collection<FlowElement> flowElements, FlowElement flowElement) {
        for (FlowElement flowElement1 : flowElements) {
            if (!(flowElement1 instanceof SubProcess)) continue;
            for (FlowElement flowElement2 : ((SubProcess)flowElement1).getFlowElements()) {
                if (!flowElement.equals(flowElement2)) continue;
                return flowElement1;
            }
        }
        return null;
    }

    private static Boolean checkFormDataByRuleEl(String el, Map<String, Object> formData) {
        if (el == null) {
            return false;
        }
        ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
        SimpleContext context = new SimpleContext();
        for (String k : formData.keySet()) {
            if (formData.get(k) == null) continue;
            context.setVariable(k.toString(), factory.createValueExpression(formData.get(k), formData.get(k).getClass()));
        }
        ValueExpression e = factory.createValueExpression((ELContext)context, el, Boolean.class);
        return (Boolean)e.getValue((ELContext)context);
    }

    public static Boolean checkSubProcess(String Id, Collection<FlowElement> flowElements, List<FlowElement> nextUser) {
        for (FlowElement flowElement1 : flowElements) {
            SubProcess sp;
            if (!(flowElement1 instanceof SubProcess) || !flowElement1.getId().equals(Id) || (sp = (SubProcess)flowElement1).getLoopCharacteristics() == null) continue;
            String inputDataItem = sp.getLoopCharacteristics().getInputDataItem();
            UserTask userTask = new UserTask();
            userTask.setId(sp.getId());
            userTask.setLoopCharacteristics(sp.getLoopCharacteristics());
            userTask.setName(sp.getName());
            nextUser.add((FlowElement)userTask);
            return true;
        }
        return false;
    }

    public static FlowElement getFlowElementById(String Id, Collection<FlowElement> flowElements) {
        for (FlowElement flowElement : flowElements) {
            FlowElement flowElement1;
            if (flowElement.getId().equals(Id)) {
                if (flowElement instanceof SubProcess) {
                    return ProcessServiceImpl.getStartFlowElement(((SubProcess)flowElement).getFlowElements());
                }
                return flowElement;
            }
            if (!(flowElement instanceof SubProcess) || (flowElement1 = ProcessServiceImpl.getFlowElementById(Id, ((SubProcess)flowElement).getFlowElements())) == null) continue;
            return flowElement1;
        }
        return null;
    }

    public static FlowElement getStartFlowElement(Collection<FlowElement> flowElements) {
        for (FlowElement flowElement : flowElements) {
            if (!(flowElement instanceof StartEvent)) continue;
            return flowElement;
        }
        return null;
    }
}

