/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.service.internal;

import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.workflow.local.entity.ProcessInstanceEntity;
import com.biz.crm.workflow.local.entity.ProcessTaskButtonEntity;
import com.biz.crm.workflow.local.entity.ProcessTemplate;
import com.biz.crm.workflow.local.repository.ProcessTaskButtonRepository;
import com.biz.crm.workflow.local.service.ProcessInstanceService;
import com.biz.crm.workflow.local.service.ProcessTaskButtonService;
import com.biz.crm.workflow.local.service.ProcessTemplateService;
import com.biz.crm.workflow.sdk.dto.ProcessTaskButtonDto;
import com.biz.crm.workflow.sdk.service.ProcessTemplateNodeService;
import com.biz.crm.workflow.sdk.vo.ProcessTaskButtonVo;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateNodeVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.Validate;
import org.flowable.engine.RuntimeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="processTaskButtonService")
public class ProcessTaskButtonServiceImpl
implements ProcessTaskButtonService {
    @Autowired
    private ProcessTaskButtonRepository processTaskButtonRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private ProcessTemplateNodeService processTemplateNodeService;
    @Autowired
    private ProcessInstanceService processInstanceService;
    @Autowired
    private ProcessTemplateService processTemplateService;

    @Override
    public List<ProcessTaskButtonVo> findByNodeId(String nodeId) {
        List<ProcessTaskButtonEntity> entities = this.processTaskButtonRepository.findByNodeIds(Lists.newArrayList((Object[])new String[]{nodeId}));
        if (CollectionUtils.isEmpty(entities)) {
            return Lists.newArrayList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(entities, ProcessTaskButtonEntity.class, ProcessTaskButtonVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Override
    public List<ProcessTaskButtonVo> findByProcessInstanceId(String processInstanceId) {
        ProcessInstanceEntity processInstanceEntity = this.processInstanceService.findByProcessInstanceId(processInstanceId);
        String processTemplateId = processInstanceEntity.getProcessTemplateId();
        ProcessTemplate processTemplate = this.processTemplateService.findById(processTemplateId);
        String processDefinitionId = processTemplate.getProcessDefinitionId();
        List activeActivityIds = this.runtimeService.getActiveActivityIds(processInstanceId);
        if (!CollectionUtils.isEmpty((Collection)activeActivityIds)) {
            ProcessTemplateNodeVo processTemplateNodeVo = this.processTemplateNodeService.findByProcessInstanceIdAndTaskDefinitionKey(processInstanceId, (String)activeActivityIds.get(0));
            return this.findByNodeId(processTemplateNodeVo.getId());
        }
        return null;
    }

    @Override
    @Transactional
    public ProcessTaskButtonVo create(ProcessTaskButtonDto processTaskButtonDto) {
        this.createValidate(processTaskButtonDto);
        ProcessTaskButtonEntity ProcessTaskButtonEntity2 = (ProcessTaskButtonEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)processTaskButtonDto, ProcessTaskButtonEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        ProcessTaskButtonEntity2.setTenantCode(TenantUtils.getTenantCode());
        this.processTaskButtonRepository.saveOrUpdate((Object)ProcessTaskButtonEntity2);
        ProcessTaskButtonVo processTaskButtonVo = (ProcessTaskButtonVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)ProcessTaskButtonEntity2, ProcessTaskButtonVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        processTaskButtonVo.setId(ProcessTaskButtonEntity2.getId());
        return processTaskButtonVo;
    }

    @Override
    @Transactional
    public List<ProcessTaskButtonVo> createBatch(Collection<ProcessTaskButtonDto> processTaskButtonDtos) {
        if (CollectionUtils.isEmpty(processTaskButtonDtos)) {
            return Lists.newArrayList();
        }
        ArrayList processTaskButtonVos = Lists.newArrayList();
        for (ProcessTaskButtonDto processTaskButtonDto : processTaskButtonDtos) {
            ProcessTaskButtonVo processTaskButtonVo = this.create(processTaskButtonDto);
            processTaskButtonVos.add(processTaskButtonVo);
        }
        return processTaskButtonVos;
    }

    @Override
    @Transactional
    public void delete(List<String> nodeIds) {
        Validate.isTrue((!CollectionUtils.isEmpty(nodeIds) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4efb\u52a1\u8282\u70b9id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<ProcessTaskButtonEntity> processTaskButtons = this.processTaskButtonRepository.findByNodeIds(nodeIds);
        if (CollectionUtils.isEmpty(processTaskButtons)) {
            return;
        }
        this.processTaskButtonRepository.removeByIdsAndTenantCode(processTaskButtons.stream().map(UuidEntity::getId).collect(Collectors.toList()), TenantUtils.getTenantCode());
    }

    private void createValidate(ProcessTaskButtonDto processTaskButtonDto) {
        Validate.notNull((Object)processTaskButtonDto, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        processTaskButtonDto.setId(null);
        Validate.notBlank((CharSequence)processTaskButtonDto.getTaskNodeId(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u4efb\u52a1\u8282\u70b9nodeId\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processTaskButtonDto.getButtonCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6309\u94aecode\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }
}

