/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.workflow.local.entity.ProcessInstanceEntity;
import com.biz.crm.workflow.local.entity.ProcessTaskCommunicateEntity;
import com.biz.crm.workflow.local.repository.ProcessTaskCommunicateRepository;
import com.biz.crm.workflow.local.service.ProcessInstanceService;
import com.biz.crm.workflow.local.service.ProcessTaskCommunicateService;
import com.biz.crm.workflow.sdk.dto.ProcessTaskCommunicateDto;
import com.biz.crm.workflow.sdk.dto.TaskDto;
import com.biz.crm.workflow.sdk.dto.UserInfoEventDto;
import com.biz.crm.workflow.sdk.enums.ProcessCommunicateStatusEnum;
import com.biz.crm.workflow.sdk.listener.UserInfoListener;
import com.biz.crm.workflow.sdk.vo.ProcessTaskCommunicateVo;
import com.biz.crm.workflow.sdk.vo.UserVo;
import com.biz.crm.workflow.sdk.vo.response.UserInfoResponse;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import javax.transaction.Transactional;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.flowable.engine.TaskService;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="processTaskCommunicateService")
public class ProcessTaskCommunicateServiceImpl
implements ProcessTaskCommunicateService {
    @Autowired
    private ProcessTaskCommunicateRepository processTaskCommunicateRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired
    private TaskService taskService;
    @Autowired
    private ProcessInstanceService processInstanceService;
    @Autowired
    private LoginUserService loginUserService;

    @Override
    public Page<ProcessTaskCommunicateVo> findByConditions(Pageable pageable, ProcessTaskCommunicateDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(dto)) {
            dto = new ProcessTaskCommunicateDto();
        }
        UserIdentity userIdentity = this.loginUserService.getLoginUser();
        dto.setUserCode(userIdentity.getAccount());
        return this.processTaskCommunicateRepository.findByConditions(pageable, dto);
    }

    @Override
    public ProcessTaskCommunicateVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        ProcessTaskCommunicateEntity processTaskCommunicate = this.processTaskCommunicateRepository.findByIdAndTenantCode(id, TenantUtils.getTenantCode());
        if (processTaskCommunicate == null) {
            return null;
        }
        return (ProcessTaskCommunicateVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)processTaskCommunicate, ProcessTaskCommunicateVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    @Override
    public List<ProcessTaskCommunicateVo> findByIds(Collection<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        List<ProcessTaskCommunicateEntity> processTaskCommunicates = this.processTaskCommunicateRepository.findByIds(ids);
        Collection processTaskCommunicateVos = this.nebulaToolkitService.copyCollectionByWhiteList(processTaskCommunicates, ProcessTaskCommunicateEntity.class, ProcessTaskCommunicateVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)processTaskCommunicateVos);
    }

    @Override
    @Transactional
    public ProcessTaskCommunicateVo create(ProcessTaskCommunicateDto processTaskCommunicateDto) {
        this.createValidate(processTaskCommunicateDto);
        ProcessTaskCommunicateEntity processTaskCommunicate = (ProcessTaskCommunicateEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)processTaskCommunicateDto, ProcessTaskCommunicateEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        processTaskCommunicate.setTenantCode(TenantUtils.getTenantCode());
        this.processTaskCommunicateRepository.saveOrUpdate((Object)processTaskCommunicate);
        return (ProcessTaskCommunicateVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)processTaskCommunicate, ProcessTaskCommunicateVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    @Override
    @Transactional
    public List<ProcessTaskCommunicateVo> createBatch(Collection<ProcessTaskCommunicateDto> processTaskCommunicates) {
        if (CollectionUtils.isEmpty(processTaskCommunicates)) {
            return Lists.newArrayList();
        }
        ArrayList processTaskCommunicateVos = Lists.newArrayList();
        for (ProcessTaskCommunicateDto processTaskCommunicateDto : processTaskCommunicates) {
            ProcessTaskCommunicateVo processTaskCommunicateVo = this.create(processTaskCommunicateDto);
            processTaskCommunicateVos.add(processTaskCommunicateVo);
        }
        return processTaskCommunicateVos;
    }

    @Override
    @Transactional
    public ProcessTaskCommunicateVo update(ProcessTaskCommunicateDto processTaskCommunicateDto) {
        this.updateValidate(processTaskCommunicateDto);
        ProcessTaskCommunicateEntity processTaskCommunicate = this.processTaskCommunicateRepository.findByIdAndTenantCode(processTaskCommunicateDto.getId(), TenantUtils.getTenantCode());
        Validate.notNull((Object)((Object)processTaskCommunicate), (String)"\u4fee\u6539\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        processTaskCommunicate.setTenantCode(TenantUtils.getTenantCode());
        this.processTaskCommunicateRepository.saveOrUpdate((Object)processTaskCommunicate);
        return (ProcessTaskCommunicateVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)processTaskCommunicate, ProcessTaskCommunicateVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    @Override
    @Transactional
    public void delete(Collection<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<ProcessTaskCommunicateEntity> processTaskCommunicates = this.processTaskCommunicateRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(processTaskCommunicates)) {
            return;
        }
        this.processTaskCommunicateRepository.removeByIdsAndTenantCode(ids, TenantUtils.getTenantCode());
    }

    @Override
    @Transactional
    public void commitCommunicateDto(TaskDto dto) {
        Validate.notNull((Object)dto, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getProcessInstanceId(), (String)"\u6d41\u7a0b\u5b9e\u4f8bid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<ProcessTaskCommunicateEntity> communicateEntity = this.processTaskCommunicateRepository.findByTaskIdAndStatus(dto.getTaskId(), ProcessCommunicateStatusEnum.untreated.getKey());
        Validate.isTrue((boolean)CollectionUtils.isEmpty(communicateEntity), (String)"\u6b64\u4efb\u52a1\u5b58\u5728\u5c1a\u672a\u56de\u590d\u7684\u6c9f\u901a\u4fe1\u606f\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u6b21\u8fdb\u884c\u6c9f\u901a", (Object[])new Object[0]);
        SerializableBiConsumer & Serializable sf = UserInfoListener::findByPositionCodes;
        UserInfoResponse userInfoResponse = (UserInfoResponse)this.nebulaNetEventClient.directPublish((NebulaEventDto)UserInfoEventDto.builder().positionCodes((Collection)Lists.newArrayList((Object[])new String[]{dto.getPositionCode()})).build(), UserInfoListener.class, (SerializableBiConsumer)sf);
        Validate.isTrue((!Objects.isNull(userInfoResponse) && !CollectionUtils.isEmpty((Collection)userInfoResponse.getUserVos()) ? 1 : 0) != 0, (String)"\u5f85\u6c9f\u901a\u7684\u4eba\u5458\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        UserVo userVo = (UserVo)userInfoResponse.getUserVos().stream().findFirst().get();
        ProcessInstanceEntity instanceEntity = this.processInstanceService.findByProcessInstanceId(dto.getProcessInstanceId());
        Validate.notNull((Object)((Object)instanceEntity), (String)"\u6d41\u7a0b\u5b9e\u4f8b\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(dto.getTaskId())).singleResult();
        Validate.notNull((Object)task, (String)"\u5f53\u524d\u4efb\u52a1\u5df2\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        ProcessTaskCommunicateDto communicateDto = new ProcessTaskCommunicateDto();
        communicateDto.setProcessKey(instanceEntity.getProcessKey());
        communicateDto.setProcessInstanceId(dto.getProcessInstanceId());
        communicateDto.setContent(dto.getCommunicationContent());
        communicateDto.setTaskId(dto.getTaskId());
        communicateDto.setBusinessFormNo(instanceEntity.getBusinessFormNo());
        communicateDto.setTaskDefKey(task.getTaskDefinitionKey());
        communicateDto.setStatus(ProcessCommunicateStatusEnum.untreated.getKey());
        communicateDto.setTargetPosCode(dto.getPositionCode());
        communicateDto.setTargetUserCode(userVo.getUserCode());
        communicateDto.setTargetUserName(userVo.getUserName());
        communicateDto.setTenantCode(TenantUtils.getTenantCode());
        communicateDto.setNeedComplete(dto.getNeedComplete());
        this.create(communicateDto);
    }

    @Override
    @Transactional
    public void completeCommunicateDto(TaskDto dto) {
        Validate.notNull((Object)dto, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getTaskId(), (String)"\u4efb\u52a1id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<ProcessTaskCommunicateEntity> communicateEntities = this.processTaskCommunicateRepository.findByTaskIdAndStatus(dto.getTaskId(), ProcessCommunicateStatusEnum.untreated.getKey());
        Validate.notNull(communicateEntities, (String)"\u5f85\u786e\u8ba4\u7684\u6c9f\u901a\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        ProcessTaskCommunicateEntity communicateEntity = communicateEntities.get(0);
        AbstractCrmUserIdentity loginUser = this.loginUserService.getAbstractLoginUser();
        Validate.isTrue((boolean)loginUser.getPostCode().equals(communicateEntity.getTargetPosCode()), (String)"\u5f53\u524d\u767b\u5f55\u4eba\u65e0\u6743\u8fdb\u884c\u786e\u8ba4\u6c9f\u901a\u64cd\u4f5c", (Object[])new Object[0]);
        communicateEntity.setReplyContent(dto.getContent());
        communicateEntity.setStatus(ProcessCommunicateStatusEnum.complete.getKey());
        this.processTaskCommunicateRepository.updateByIdAndTenantCode(communicateEntity, TenantUtils.getTenantCode());
    }

    @Override
    public List<ProcessTaskCommunicateVo> findByTaskIdAndStatus(String taskId, String status) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{taskId, status})) {
            return Lists.newArrayList();
        }
        List<ProcessTaskCommunicateEntity> processTaskCommunicateEntities = this.processTaskCommunicateRepository.findByTaskIdAndStatus(taskId, status);
        Collection processTaskCommunicateVos = this.nebulaToolkitService.copyCollectionByWhiteList(processTaskCommunicateEntities, ProcessTaskCommunicateEntity.class, ProcessTaskCommunicateVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)processTaskCommunicateVos);
    }

    @Override
    public List<ProcessTaskCommunicateVo> findByProcessInstanceIdAndStatus(String processInstanceId, String status) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{processInstanceId, status})) {
            return Lists.newArrayList();
        }
        List<ProcessTaskCommunicateEntity> processTaskCommunicateEntities = this.processTaskCommunicateRepository.findByProcessInstanceIdAndStatus(processInstanceId, status);
        Collection processTaskCommunicateVos = this.nebulaToolkitService.copyCollectionByWhiteList(processTaskCommunicateEntities, ProcessTaskCommunicateEntity.class, ProcessTaskCommunicateVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)processTaskCommunicateVos);
    }

    private void createValidate(ProcessTaskCommunicateDto processTaskCommunicateDto) {
        Validate.notNull((Object)processTaskCommunicateDto, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((processTaskCommunicateDto.getId() == null ? 1 : 0) != 0, (String)"\u65b0\u589e\u6570\u636e\u65f6,\u6570\u636e\u4e3b\u952e\u4e0d\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processTaskCommunicateDto.getContent(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6c9f\u901a\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private void updateValidate(ProcessTaskCommunicateDto processTaskCommunicateDto) {
        Validate.notNull((Object)processTaskCommunicateDto, (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processTaskCommunicateDto.getId(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }
}

