/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.workflow.local.entity.ProcessInstanceEntity;
import com.biz.crm.workflow.local.entity.ProcessTaskCopyEntity;
import com.biz.crm.workflow.local.entity.ProcessTemplate;
import com.biz.crm.workflow.local.repository.ProcessTaskCopyRepository;
import com.biz.crm.workflow.local.service.ProcessCopyConfigService;
import com.biz.crm.workflow.local.service.ProcessInstanceCopyConfigService;
import com.biz.crm.workflow.local.service.ProcessInstanceService;
import com.biz.crm.workflow.local.service.ProcessTaskCopyService;
import com.biz.crm.workflow.local.service.ProcessTaskCopyStrategyService;
import com.biz.crm.workflow.local.service.ProcessTaskService;
import com.biz.crm.workflow.local.service.ProcessTemplateService;
import com.biz.crm.workflow.sdk.dto.ProcessTaskCopyDto;
import com.biz.crm.workflow.sdk.dto.TaskDto;
import com.biz.crm.workflow.sdk.dto.UserInfoEventDto;
import com.biz.crm.workflow.sdk.listener.UserInfoListener;
import com.biz.crm.workflow.sdk.service.ProcessTemplateNodeService;
import com.biz.crm.workflow.sdk.vo.ProcessInstanceCopyConfigVo;
import com.biz.crm.workflow.sdk.vo.ProcessTaskCopyConfigVo;
import com.biz.crm.workflow.sdk.vo.ProcessTaskCopyStrategyVo;
import com.biz.crm.workflow.sdk.vo.ProcessTaskCopyVo;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateNodeVo;
import com.biz.crm.workflow.sdk.vo.response.UserInfoResponse;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.flowable.engine.TaskService;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="processTaskCopyService")
public class ProcessTaskCopyServiceImpl
implements ProcessTaskCopyService {
    @Autowired
    private ProcessTaskCopyRepository processTaskCopyRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private ProcessInstanceService processInstanceService;
    @Autowired
    private ProcessTemplateService processTemplateService;
    @Autowired
    private ProcessTemplateNodeService processTemplateNodeService;
    @Autowired
    private ProcessCopyConfigService processCopyConfigService;
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired
    private ProcessInstanceCopyConfigService processInstanceCopyConfigService;
    @Autowired
    private ProcessTaskCopyStrategyService processTaskCopyStrategyService;
    @Autowired
    private ProcessTaskService processTaskService;

    @Override
    public Page<ProcessTaskCopyVo> findByConditions(Pageable pageable, ProcessTaskCopyDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(dto)) {
            dto = new ProcessTaskCopyDto();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        UserIdentity userIdentity = this.loginUserService.getLoginUser();
        String userCode = StringUtils.join((Object[])new String[]{userIdentity.getIdentityType(), ":", userIdentity.getAccount()});
        dto.setUserCode(userCode);
        return this.processTaskCopyRepository.findByConditions(pageable, dto);
    }

    @Override
    @Transactional
    public ProcessTaskCopyVo create(ProcessTaskCopyDto processTaskCopyDto) {
        this.createValidate(processTaskCopyDto);
        ProcessTaskCopyEntity processTaskCopy = (ProcessTaskCopyEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)processTaskCopyDto, ProcessTaskCopyEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        processTaskCopy.setTenantCode(TenantUtils.getTenantCode());
        this.processTaskCopyRepository.saveOrUpdate((Object)processTaskCopy);
        ProcessTaskCopyVo processTaskCopyVo = (ProcessTaskCopyVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)processTaskCopy, ProcessTaskCopyVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return processTaskCopyVo;
    }

    @Override
    @Transactional
    public List<ProcessTaskCopyVo> createBatch(Collection<ProcessTaskCopyDto> processTaskCopyDtos) {
        if (CollectionUtils.isEmpty(processTaskCopyDtos)) {
            return Lists.newArrayList();
        }
        ArrayList processTaskCopyVos = Lists.newArrayList();
        for (ProcessTaskCopyDto processTaskCopyDto : processTaskCopyDtos) {
            ProcessTaskCopyVo processTaskCopyVo = this.create(processTaskCopyDto);
            processTaskCopyVos.add(processTaskCopyVo);
        }
        return processTaskCopyVos;
    }

    @Override
    @Transactional
    public void delete(Collection<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<ProcessTaskCopyEntity> processTaskCopys = this.processTaskCopyRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(processTaskCopys)) {
            return;
        }
        Collection processTaskCopyVos = this.nebulaToolkitService.copyCollectionByWhiteList(processTaskCopys, ProcessTaskCopyEntity.class, ProcessTaskCopyVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.processTaskCopyRepository.removeByIdsAndTenantCode(ids, TenantUtils.getTenantCode());
    }

    @Override
    @Transactional
    public void createByTask(TaskDto dto) {
        Collection<ProcessTaskCopyStrategyVo> processTaskCopyStrategyVos;
        List<String> positionCodes;
        Validate.notNull((Object)dto, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getProcessInstanceId(), (String)"\u6d41\u7a0b\u5b9e\u4f8bid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ProcessInstanceEntity instanceEntity = this.processInstanceService.findByProcessInstanceId(dto.getProcessInstanceId());
        if (ObjectUtils.isEmpty((Object)((Object)instanceEntity))) {
            return;
        }
        ProcessTemplate processTemplate = this.processTemplateService.findById(instanceEntity.getProcessTemplateId());
        Validate.notNull((Object)((Object)processTemplate), (String)"\u6d41\u7a0b\u53d1\u5e03\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        String taskId = null;
        String taskName = null;
        ProcessTemplateNodeVo nodeVo = null;
        ArrayList userNames = Lists.newArrayList();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dto.getTaskId()})) {
            Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(dto.getTaskId())).singleResult();
            Validate.notNull((Object)task, (String)"\u5f53\u524d\u4efb\u52a1\u5df2\u4e0d\u5b58\u5728", (Object[])new Object[0]);
            taskId = task.getId();
            taskName = task.getName();
            nodeVo = this.processTemplateNodeService.findByProcessInstanceIdAndTaskDefinitionKey(instanceEntity.getProcessInstanceId(), task.getTaskDefinitionKey());
            List<ProcessTaskCopyConfigVo> configVos = this.processCopyConfigService.findByNodeId(nodeVo.getId());
            if (!CollectionUtils.isEmpty(configVos)) {
                positionCodes = configVos.stream().map(ProcessTaskCopyConfigVo::getPositionCode).collect(Collectors.toList());
                userNames.addAll(this.getUserNamesByPositionCodes(positionCodes));
            }
            if (!CollectionUtils.isEmpty(processTaskCopyStrategyVos = this.processTaskCopyStrategyService.findByNodeId(nodeVo.getId()))) {
                Collection<String> copyNames = this.processTaskService.findCopyByTaskNodeIdAndTaskId(nodeVo.getId(), taskId, instanceEntity.getProcessInstanceId(), task.getTaskDefinitionKey(), null);
                userNames.addAll(copyNames);
            }
        } else {
            List collect;
            Validate.isTrue((StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dto.getTaskId()}) || StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dto.getTaskDefinitionKey()}) ? 1 : 0) != 0, (String)"\u6284\u9001\u65f6\uff0c\u4efb\u52a1id\u548c\u4efb\u52a1key\u4e0d\u80fd\u90fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            nodeVo = this.processTemplateNodeService.findByProcessInstanceIdAndTaskDefinitionKey(instanceEntity.getProcessInstanceId(), dto.getTaskDefinitionKey());
            List<ProcessTaskCopyConfigVo> configVos = this.processCopyConfigService.findByNodeId(nodeVo.getId());
            Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().executionId(dto.getExecutionId())).singleResult();
            if (!CollectionUtils.isEmpty(configVos)) {
                Validate.notNull((Object)task, (String)"\u5f53\u524d\u4efb\u52a1\u5df2\u4e0d\u5b58\u5728", (Object[])new Object[0]);
                taskId = task.getId();
                taskName = task.getName();
                positionCodes = configVos.stream().map(ProcessTaskCopyConfigVo::getPositionCode).collect(Collectors.toList());
                userNames.addAll(this.getUserNamesByPositionCodes(positionCodes));
            } else {
                processTaskCopyStrategyVos = this.processTaskCopyStrategyService.findByNodeId(nodeVo.getId());
                if (!CollectionUtils.isEmpty(processTaskCopyStrategyVos)) {
                    Collection<String> copyNames = this.processTaskService.findCopyByTaskNodeIdAndTaskId(nodeVo.getId(), taskId, instanceEntity.getProcessInstanceId(), task.getTaskDefinitionKey(), null);
                    userNames.addAll(copyNames);
                }
            }
            List<ProcessInstanceCopyConfigVo> list = this.processInstanceCopyConfigService.findByProcessInstanceId(instanceEntity.getProcessInstanceId());
            if (!CollectionUtils.isEmpty(list) && !CollectionUtils.isEmpty(collect = list.stream().filter(processInstanceCopyConfigVo -> processInstanceCopyConfigVo.getProcessTaskId().equals(dto.getTaskDefinitionKey())).collect(Collectors.toList()))) {
                taskName = "\u7ed3\u675f\u6284\u9001";
                List users = collect.stream().map(ProcessInstanceCopyConfigVo::getUserName).collect(Collectors.toList());
                userNames.addAll(users);
            }
        }
        Validate.notNull((Object)nodeVo, (String)"\u4efb\u52a1\u5bf9\u5e94\u8282\u70b9\u4fe1\u606f\u5df2\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        if (!CollectionUtils.isEmpty((Collection)dto.getPositionCodes())) {
            userNames.addAll(this.getUserNamesByPositionCodes(dto.getPositionCodes()));
        }
        if (CollectionUtils.isEmpty((Collection)userNames)) {
            return;
        }
        ArrayList processTaskCopyDtoList = Lists.newArrayList();
        String finalTaskId = taskId;
        String finalTaskName = taskName;
        userNames.forEach(userName -> {
            ProcessTaskCopyDto copyDto = new ProcessTaskCopyDto();
            copyDto.setProcessName(processTemplate.getProcessName());
            copyDto.setProcessInstanceId(instanceEntity.getProcessInstanceId());
            copyDto.setCommitTime(instanceEntity.getCreateTime());
            copyDto.setCommitUserCode(instanceEntity.getCreateAccount());
            copyDto.setCommitUserName(instanceEntity.getCreateName());
            copyDto.setBusinessFormNo(instanceEntity.getBusinessFormNo());
            copyDto.setProcessTitle(instanceEntity.getProcessTitle());
            copyDto.setProcessKey(processTemplate.getProcessKey());
            copyDto.setTenantCode(TenantUtils.getTenantCode());
            copyDto.setTaskId(finalTaskId);
            copyDto.setTaskName(finalTaskName);
            copyDto.setUserCode(userName);
            processTaskCopyDtoList.add(copyDto);
        });
        this.createBatch(processTaskCopyDtoList);
    }

    private List<String> getUserNamesByPositionCodes(List<String> positionCodes) {
        SerializableBiConsumer & Serializable sf = UserInfoListener::findByPositionCodes;
        UserInfoEventDto userInfoEventDto = UserInfoEventDto.builder().positionCodes(positionCodes).build();
        UserInfoResponse userInfoResponse = (UserInfoResponse)this.nebulaNetEventClient.directPublish((NebulaEventDto)userInfoEventDto, UserInfoListener.class, (SerializableBiConsumer)sf);
        if (!Objects.isNull(userInfoResponse) && !CollectionUtils.isEmpty((Collection)userInfoResponse.getUserVos())) {
            Collection userVos = userInfoResponse.getUserVos();
            ArrayList<String> userNames = new ArrayList<String>();
            userVos.forEach(userVo -> userNames.add(userVo.getIdentityType() + ":" + userVo.getUserName()));
            return userNames;
        }
        return Lists.newArrayList();
    }

    private void createValidate(ProcessTaskCopyDto processTaskCopyDto) {
        Validate.notNull((Object)processTaskCopyDto, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((processTaskCopyDto.getId() == null ? 1 : 0) != 0, (String)"\u65b0\u589e\u6570\u636e\u65f6,\u6570\u636e\u4e3b\u952e\u4e0d\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processTaskCopyDto.getProcessName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d41\u7a0b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processTaskCopyDto.getProcessInstanceId(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d41\u7a0b\u5b9e\u4f8bid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processTaskCopyDto.getBusinessFormNo(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0cbusiness_form_no\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processTaskCopyDto.getProcessTitle(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d41\u7a0b\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processTaskCopyDto.getProcessKey(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d41\u7a0bkey\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }
}

