/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.service.internal;

import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.workflow.local.entity.ProcessTaskCopyStrategyEntity;
import com.biz.crm.workflow.local.repository.ProcessTaskCopyStrategyRepository;
import com.biz.crm.workflow.local.service.ProcessTaskCopyStrategyService;
import com.biz.crm.workflow.local.service.ProcessTaskCopyStrategyVarService;
import com.biz.crm.workflow.sdk.dto.ProcessTaskCopyStrategyDto;
import com.biz.crm.workflow.sdk.vo.ProcessTaskCopyStrategyVarVo;
import com.biz.crm.workflow.sdk.vo.ProcessTaskCopyStrategyVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ProcessTaskCopyStrategyServiceImpl
implements ProcessTaskCopyStrategyService {
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private ProcessTaskCopyStrategyRepository processTaskCopyStrategyRepository;
    @Autowired
    private ProcessTaskCopyStrategyVarService processTaskCopyStrategyVarService;

    @Override
    @Transactional
    public List<ProcessTaskCopyStrategyVo> createBatch(Collection<ProcessTaskCopyStrategyDto> processTaskCopyStrategy) {
        if (CollectionUtils.isEmpty(processTaskCopyStrategy)) {
            return Collections.emptyList();
        }
        ArrayList<ProcessTaskCopyStrategyVo> processTaskCopyStrategyVos = new ArrayList<ProcessTaskCopyStrategyVo>();
        processTaskCopyStrategy.forEach(process -> {
            ProcessTaskCopyStrategyVo processTaskCopyStrategyVo = this.create((ProcessTaskCopyStrategyDto)process);
            processTaskCopyStrategyVos.add(processTaskCopyStrategyVo);
        });
        return processTaskCopyStrategyVos;
    }

    @Override
    @Transactional
    public ProcessTaskCopyStrategyVo create(ProcessTaskCopyStrategyDto processTaskCopyStrategyDto) {
        this.createStrategyValidate(processTaskCopyStrategyDto);
        ProcessTaskCopyStrategyEntity processTaskCopyStrategyEntity = (ProcessTaskCopyStrategyEntity)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)processTaskCopyStrategyDto, ProcessTaskCopyStrategyEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        this.processTaskCopyStrategyRepository.saveOrUpdate((Object)processTaskCopyStrategyEntity);
        ProcessTaskCopyStrategyVo processTaskCopyStrategyVo = (ProcessTaskCopyStrategyVo)this.nebulaToolkitService.copyObjectByBlankList((Object)processTaskCopyStrategyEntity, ProcessTaskCopyStrategyVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        processTaskCopyStrategyVo.setId(processTaskCopyStrategyEntity.getId());
        Collection processTaskCopyStrategyVars = processTaskCopyStrategyDto.getProcessTaskCopyStrategyVars();
        if (!CollectionUtils.isEmpty((Collection)processTaskCopyStrategyVars)) {
            processTaskCopyStrategyVars.forEach(processTaskCopyStrategyVar -> {
                processTaskCopyStrategyVar.setNodeCopyId(processTaskCopyStrategyVo.getId());
                processTaskCopyStrategyVar.setTenantCode(TenantUtils.getTenantCode());
            });
            List<ProcessTaskCopyStrategyVarVo> processTaskCopyStrategyVarVos = this.processTaskCopyStrategyVarService.createBatch(processTaskCopyStrategyVars);
            processTaskCopyStrategyVo.setProcessTaskCopyStrategyVars(processTaskCopyStrategyVarVos);
        }
        return processTaskCopyStrategyVo;
    }

    @Override
    @Transactional
    public void deleteByNodeIds(Collection<String> nodeIds) {
        Validate.notNull(nodeIds, (String)"\u5220\u9664\u6d41\u7a0b\u4efb\u52a1\u6284\u9001\u914d\u7f6e\u65f6\uff0c\u8282\u70b9id\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<ProcessTaskCopyStrategyEntity> processTaskCopyStrategyEntities = this.processTaskCopyStrategyRepository.findByNodeIds(nodeIds);
        if (CollectionUtils.isEmpty(processTaskCopyStrategyEntities)) {
            return;
        }
        processTaskCopyStrategyEntities.forEach(processTaskCopyStrategy -> {
            List<ProcessTaskCopyStrategyVarVo> processTaskCopyStrategyVarVos = this.processTaskCopyStrategyVarService.findByNodeCopyId(processTaskCopyStrategy.getId());
            if (!CollectionUtils.isEmpty(processTaskCopyStrategyVarVos)) {
                List<String> nodeCopyIds = processTaskCopyStrategyVarVos.stream().map(ProcessTaskCopyStrategyVarVo::getNodeCopyId).distinct().collect(Collectors.toList());
                this.processTaskCopyStrategyVarService.deleteByNodeCopyIds(nodeCopyIds);
            }
        });
        List ids = processTaskCopyStrategyEntities.stream().map(UuidEntity::getId).distinct().collect(Collectors.toList());
        this.processTaskCopyStrategyRepository.removeByIds(ids);
    }

    @Override
    public Collection<ProcessTaskCopyStrategyVo> findByNodeId(String nodeId) {
        Validate.notNull((Object)nodeId, (String)"\u67e5\u8be2\u6d41\u7a0b\u6284\u9001\u914d\u7f6e\u65f6\u8282\u70b9id\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<ProcessTaskCopyStrategyEntity> processTaskCopyStrategyEntities = this.processTaskCopyStrategyRepository.findByNodeIds(Collections.singleton(nodeId));
        if (CollectionUtils.isEmpty(processTaskCopyStrategyEntities)) {
            return Collections.emptyList();
        }
        List processTaskCopyStrategyVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(processTaskCopyStrategyEntities, ProcessTaskCopyStrategyEntity.class, ProcessTaskCopyStrategyVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        processTaskCopyStrategyVos.forEach(this::fillDetail);
        return processTaskCopyStrategyVos;
    }

    private void fillDetail(ProcessTaskCopyStrategyVo processTaskCopyStrategyVo) {
        List<ProcessTaskCopyStrategyVarVo> processTaskCopyStrategyVarVos = this.processTaskCopyStrategyVarService.findByNodeCopyId(processTaskCopyStrategyVo.getId());
        if (CollectionUtils.isEmpty(processTaskCopyStrategyVarVos)) {
            processTaskCopyStrategyVo.setProcessTaskCopyStrategyVars(new ArrayList());
        } else {
            processTaskCopyStrategyVo.setProcessTaskCopyStrategyVars(processTaskCopyStrategyVarVos);
        }
    }

    private void createStrategyValidate(ProcessTaskCopyStrategyDto processTaskCopyStrategyDto) {
        Validate.notNull((Object)processTaskCopyStrategyDto, (String)"\u65b0\u589e\u7b56\u7565\u914d\u7f6e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processTaskCopyStrategyDto.getNodeId(), (String)"\u65b0\u589e\u7b56\u7565\u914d\u7f6e\u65f6\uff0c\u4efb\u52a1\u8282\u70b9nodeId\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processTaskCopyStrategyDto.getTemplateId(), (String)"\u65b0\u589e\u7b56\u7565\u914d\u7f6e\u65f6\uff0c\u4efb\u52a1\u6a21\u677ftemplateId\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processTaskCopyStrategyDto.getStrategyCode(), (String)"\u65b0\u589e\u7b56\u7565\u914d\u7f6e\u65f6\uff0c\u7b56\u7565\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processTaskCopyStrategyDto.getStrategyName(), (String)"\u65b0\u589e\u7b56\u7565\u914d\u7f6e\u65f6\uff0c\u7b56\u7565\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)processTaskCopyStrategyDto.getSort(), (String)"\u65b0\u589e\u7b56\u7565\u914d\u7f6e\u65f6\uff0c\u6392\u5e8f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        processTaskCopyStrategyDto.setId(null);
    }
}

