/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.workflow.local.entity.ProcessTaskIndicatorsEntity;
import com.biz.crm.workflow.local.repository.ProcessTaskIndicatorsRepository;
import com.biz.crm.workflow.local.service.ProcessTaskIndicatorsService;
import com.biz.crm.workflow.sdk.dto.ProcessTaskIndicatorsDto;
import com.biz.crm.workflow.sdk.vo.ProcessTaskIndicatorsVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import javax.transaction.Transactional;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="processTaskIndicatorsService")
public class ProcessTaskIndicatorsServiceImpl
implements ProcessTaskIndicatorsService {
    @Autowired
    private ProcessTaskIndicatorsRepository processTaskIndicatorsRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public Page<ProcessTaskIndicatorsVo> findByConditions(Pageable pageable, ProcessTaskIndicatorsDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(dto)) {
            dto = new ProcessTaskIndicatorsDto();
        }
        return this.processTaskIndicatorsRepository.findByConditions(pageable, dto);
    }

    @Override
    public List<ProcessTaskIndicatorsVo> findByTaskNodeId(String taskNodeId) {
        if (StringUtils.isBlank((CharSequence)taskNodeId)) {
            return null;
        }
        List<ProcessTaskIndicatorsEntity> processTaskIndicators = this.processTaskIndicatorsRepository.findByTaskNodeIds(Collections.singletonList(taskNodeId));
        if (processTaskIndicators == null) {
            return null;
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(processTaskIndicators, ProcessTaskIndicatorsEntity.class, ProcessTaskIndicatorsVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    @Override
    public List<ProcessTaskIndicatorsVo> findByTaskNodeIds(Collection<String> taskNodeIds) {
        if (CollectionUtils.isEmpty(taskNodeIds)) {
            return null;
        }
        List<ProcessTaskIndicatorsEntity> processTaskIndicators = this.processTaskIndicatorsRepository.findByTaskNodeIds((List)taskNodeIds);
        if (processTaskIndicators == null) {
            return null;
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(processTaskIndicators, ProcessTaskIndicatorsEntity.class, ProcessTaskIndicatorsVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    @Override
    @Transactional
    public ProcessTaskIndicatorsVo create(ProcessTaskIndicatorsDto processTaskIndicatorsDto) {
        this.createValidate(processTaskIndicatorsDto);
        ProcessTaskIndicatorsEntity processTaskIndicators = (ProcessTaskIndicatorsEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)processTaskIndicatorsDto, ProcessTaskIndicatorsEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        processTaskIndicators.setTenantCode(TenantUtils.getTenantCode());
        this.processTaskIndicatorsRepository.saveOrUpdate((Object)processTaskIndicators);
        return (ProcessTaskIndicatorsVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)processTaskIndicators, ProcessTaskIndicatorsVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    @Override
    @Transactional
    public List<ProcessTaskIndicatorsVo> createBatch(Collection<ProcessTaskIndicatorsDto> processTaskIndicatorsDtos) {
        if (CollectionUtils.isEmpty(processTaskIndicatorsDtos)) {
            return Lists.newArrayList();
        }
        ArrayList processTaskIndicatorsVos = Lists.newArrayList();
        for (ProcessTaskIndicatorsDto processTaskIndicatorsDto : processTaskIndicatorsDtos) {
            ProcessTaskIndicatorsVo processTaskIndicatorsVo = this.create(processTaskIndicatorsDto);
            processTaskIndicatorsVos.add(processTaskIndicatorsVo);
        }
        return processTaskIndicatorsVos;
    }

    @Override
    @Transactional
    public void delete(Collection<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<ProcessTaskIndicatorsEntity> processTaskIndicators = this.processTaskIndicatorsRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(processTaskIndicators)) {
            return;
        }
        this.processTaskIndicatorsRepository.removeByIdsAndTenantCode(ids, TenantUtils.getTenantCode());
    }

    @Override
    public void deleteByNodeIds(List<String> nodeIds) {
        Validate.isTrue((!CollectionUtils.isEmpty(nodeIds) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.processTaskIndicatorsRepository.deleteByTaskNodeIds(nodeIds);
    }

    private void createValidate(ProcessTaskIndicatorsDto processTaskIndicatorsDto) {
        Validate.notNull((Object)processTaskIndicatorsDto, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        processTaskIndicatorsDto.setId(null);
        Validate.notBlank((CharSequence)processTaskIndicatorsDto.getTaskNodeId(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u4efb\u52a1\u8282\u70b9nodeId\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processTaskIndicatorsDto.getFunctionSubCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u4e1a\u52a1\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processTaskIndicatorsDto.getIndicatorCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5173\u952e\u6307\u6807code\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processTaskIndicatorsDto.getIndicatorName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5173\u952e\u6307\u6807\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }
}

