/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.service.internal;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.alibaba.nacos.common.utils.MapUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.workflow.local.dto.ProcessTaskLogDto;
import com.biz.crm.workflow.local.entity.ProcessInstanceEntity;
import com.biz.crm.workflow.local.entity.ProcessTaskLogEntity;
import com.biz.crm.workflow.local.repository.ProcessTaskLogRepository;
import com.biz.crm.workflow.local.service.ProcessDelegateConfigService;
import com.biz.crm.workflow.local.service.ProcessInstanceService;
import com.biz.crm.workflow.local.service.ProcessService;
import com.biz.crm.workflow.local.service.ProcessTaskLogService;
import com.biz.crm.workflow.local.service.ProcessTemplateNodeAssigneeService;
import com.biz.crm.workflow.local.service.TaskMultiCacheVoService;
import com.biz.crm.workflow.local.vo.ProcessTaskLogVo;
import com.biz.crm.workflow.sdk.dto.ProcessDelegateCopyDto;
import com.biz.crm.workflow.sdk.enums.ProcessOperateTypeEnum;
import com.biz.crm.workflow.sdk.vo.ProcessInstanceVo;
import com.biz.crm.workflow.sdk.vo.ProcessInterventionLogsVo;
import com.biz.crm.workflow.sdk.vo.ProcessLogRecordVo;
import com.biz.crm.workflow.sdk.vo.ProcessLogsVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.flowable.engine.TaskService;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="processTaskLogService")
public class ProcessTaskLogServiceImpl
implements ProcessTaskLogService {
    @Autowired
    private ProcessTaskLogRepository processTaskLogRepository;
    @Autowired
    private ProcessInstanceService processInstanceService;
    @Autowired
    private ProcessTemplateNodeAssigneeService processTemplateNodeAssigneeService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private ProcessService processService;
    @Autowired
    private ProcessDelegateConfigService processDelegateConfigService;
    @Autowired
    private TaskMultiCacheVoService taskMultiCacheVoService;

    @Override
    public Page<ProcessTaskLogVo> findByConditions(Pageable pageable, ProcessTaskLogDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull((Object)dto)) {
            dto = new ProcessTaskLogDto();
        }
        return this.processTaskLogRepository.findByConditions(pageable, dto);
    }

    @Override
    public List<ProcessTaskLogVo> findByBusinessFormId(String businessFormId) {
        if (StringUtils.isBlank((CharSequence)businessFormId)) {
            return null;
        }
        List<ProcessTaskLogEntity> processTaskLog = this.processTaskLogRepository.findByBusinessFormId(businessFormId);
        if (processTaskLog == null) {
            return null;
        }
        List processTaskLogVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(processTaskLog, ProcessTaskLogEntity.class, ProcessTaskLogVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return processTaskLogVos;
    }

    @Override
    public List<ProcessLogsVo> findByProcessInstanceId(String processInstanceId) {
        if (StringUtils.isBlank((CharSequence)processInstanceId)) {
            return null;
        }
        List<ProcessTaskLogEntity> processTaskLog = this.processTaskLogRepository.findByProcessInstanceIds(Lists.newArrayList((Object[])new String[]{processInstanceId}));
        if (processTaskLog == null) {
            return null;
        }
        ArrayList logsVos = Lists.newArrayList();
        ProcessInstanceEntity processInstanceEntity = this.processInstanceService.findByProcessInstanceId(processInstanceId);
        List processTaskLogVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(processTaskLog, ProcessTaskLogEntity.class, ProcessTaskLogVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        logsVos.addAll(this.convertTodoLogs(processInstanceId, processInstanceEntity, processTaskLog));
        logsVos.addAll(this.convertLogs(processTaskLogVos, processInstanceEntity));
        return logsVos;
    }

    private List<ProcessLogsVo> convertTodoLogs(String processInstanceId, ProcessInstanceEntity processInstanceEntity, List<ProcessTaskLogEntity> processTaskLog) {
        ArrayList logVos = Lists.newArrayList();
        List taskList = ((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).orderByTaskCreateTime()).desc()).list();
        if (!CollectionUtils.isEmpty((Collection)taskList)) {
            ProcessLogsVo optLogsRspVO = new ProcessLogsVo();
            ArrayList collect = Lists.newArrayList();
            Task task = (Task)taskList.get(0);
            ProcessLogRecordVo rspVO = new ProcessLogRecordVo();
            this.initLogVo(rspVO, processInstanceEntity);
            rspVO.setCreateTime(new Date());
            rspVO.setTaskDefKey(task.getTaskDefinitionKey());
            rspVO.setTaskName(task.getName());
            rspVO.setTaskId(task.getId());
            rspVO.setContent("\u5f53\u524d\u5f85\u529e\u8282\u70b9");
            List<Object> as = new ArrayList();
            List<String> interventions = this.taskMultiCacheVoService.get(task.getProcessInstanceId() + ":" + task.getTaskDefinitionKey() + "_Intervention");
            if (CollectionUtils.isEmpty(interventions)) {
                as = this.processService.getAssigneeByTask(processInstanceEntity.getProcessTemplateId(), task.getId(), task.getTaskDefinitionKey(), processInstanceId, null);
            } else {
                as.addAll(interventions.stream().collect(Collectors.toList()));
            }
            ProcessDelegateCopyDto processDelegateCopyDto = new ProcessDelegateCopyDto();
            processDelegateCopyDto.setUserNames(as);
            processDelegateCopyDto.setProcessTemplateId(processInstanceEntity.getProcessTemplateId());
            processDelegateCopyDto.setCreateTime(processInstanceEntity.getCreateTime());
            processDelegateCopyDto.setSaveLog(false);
            Collection<String> assignees = this.processDelegateConfigService.getUserName(processDelegateCopyDto);
            if (!CollectionUtils.isEmpty(assignees)) {
                List processTaskLogEntities;
                HashMap<String, String> stringMap = new HashMap<String, String>();
                if (!CollectionUtils.isEmpty(processTaskLog) && !CollectionUtils.isEmpty(processTaskLogEntities = processTaskLog.stream().filter(processTaskLogEntity -> ProcessOperateTypeEnum.ASSIGNEE.getDictCode().equals(processTaskLogEntity.getOperateType()) && processTaskLogEntity.getTaskId().equals(task.getId())).collect(Collectors.toList()))) {
                    stringMap.putAll(processTaskLogEntities.stream().collect(Collectors.toMap(ProcessTaskLogEntity::getUserName, ProcessTaskLogEntity::getDelegateUserName, (k1, k2) -> k2)));
                }
                ArrayList<String> assigneeList = new ArrayList<String>();
                for (String assignee : assignees) {
                    String assigneeNew = (String)stringMap.get(assignee);
                    if (StringUtils.isNotBlank((CharSequence)assigneeNew)) {
                        assigneeList.add(assigneeNew.split(":")[1]);
                        continue;
                    }
                    assigneeList.add(assignee.split(":")[1]);
                }
                rspVO.setCurrentAccounts(((Object)assigneeList).toString());
            }
            rspVO.setOperationStr("\u5f85\u5904\u7406");
            rspVO.setUserName(Optional.ofNullable(rspVO.getCurrentAccounts()).orElse(""));
            collect.add(rspVO);
            String date = DateTime.now().toDateStr();
            optLogsRspVO.setLogDate(date);
            optLogsRspVO.setProcessLogRecordVos((List)collect);
            logVos.add(optLogsRspVO);
        }
        return logVos;
    }

    private List<ProcessLogsVo> convertLogs(List<ProcessTaskLogVo> processTaskLogVos, ProcessInstanceEntity processInstanceEntity) {
        ArrayList logVos = Lists.newArrayList();
        Set createDateSets = processTaskLogVos.stream().map(logsVo -> DateUtil.date((Date)logsVo.getCreateTime()).toDateStr()).collect(Collectors.toSet());
        List<String> createDateList = createDateSets.stream().sorted(Comparator.reverseOrder()).collect(Collectors.toList());
        Map<String, List<ProcessTaskLogVo>> map = processTaskLogVos.stream().collect(Collectors.groupingBy(logsVo -> DateUtil.date((Date)logsVo.getCreateTime()).toDateStr()));
        if (MapUtils.isNotEmpty(map)) {
            createDateList.forEach(key -> {
                ProcessLogsVo optLogsRspVO = new ProcessLogsVo();
                optLogsRspVO.setLogDate(key);
                List value = (List)map.get(key);
                List recordRspVOS = value.stream().map(r -> {
                    ProcessLogRecordVo rspVO = new ProcessLogRecordVo();
                    this.initLogVo(rspVO, processInstanceEntity);
                    rspVO.setCreateTime(r.getCreateTime());
                    rspVO.setUserCode(r.getCreateAccount());
                    rspVO.setUserName(r.getCreateName());
                    rspVO.setTaskName(r.getTaskNodeName());
                    rspVO.setContent(r.getOperateRemark());
                    rspVO.setOperation(r.getOperateType());
                    rspVO.setOperationStr(ProcessOperateTypeEnum.getOperateNameByKey((String)r.getOperateType()));
                    return rspVO;
                }).collect(Collectors.toList());
                optLogsRspVO.setProcessLogRecordVos(recordRspVOS);
                logVos.add(optLogsRspVO);
            });
        }
        return logVos;
    }

    private void initLogVo(ProcessLogRecordVo recordVo, ProcessInstanceEntity instance) {
        recordVo.setProcessKey(instance.getProcessKey());
        recordVo.setProcessName(instance.getProcessName());
        recordVo.setTitle(instance.getProcessTitle());
        recordVo.setApplierName(instance.getCreateName());
        recordVo.setFormNo(instance.getBusinessFormNo());
    }

    @Override
    public List<ProcessLogsVo> findByFormNo(String formNo) {
        List<ProcessInstanceEntity> instanceEntities = this.processInstanceService.findByFromNo(formNo);
        if (CollectionUtils.isEmpty(instanceEntities)) {
            return null;
        }
        List<ProcessTaskLogEntity> processTaskLog = this.processTaskLogRepository.findByProcessInstanceIds(instanceEntities.stream().map(ProcessInstanceEntity::getProcessInstanceId).collect(Collectors.toList()));
        if (processTaskLog == null) {
            return null;
        }
        List processTaskLogVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(processTaskLog, ProcessTaskLogEntity.class, ProcessTaskLogVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        ArrayList logsVos = Lists.newArrayList();
        logsVos.addAll(this.convertTodoLogs(instanceEntities.get(0).getProcessInstanceId(), instanceEntities.get(0), processTaskLog));
        logsVos.addAll(this.convertLogs(processTaskLogVos, instanceEntities.get(0)));
        return logsVos;
    }

    @Override
    public List<ProcessLogsVo> findByProcessNo(String processNo) {
        ProcessInstanceVo processInstanceVo = this.processInstanceService.findByProcessNo(processNo);
        if (Objects.isNull(processInstanceVo)) {
            return null;
        }
        return this.findByProcessInstanceId(processInstanceVo.getProcessInstanceId());
    }

    @Override
    @Transactional
    public ProcessTaskLogVo create(ProcessTaskLogDto processTaskLogDto) {
        this.createValidate(processTaskLogDto);
        ProcessTaskLogEntity processTaskLog = (ProcessTaskLogEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)processTaskLogDto, ProcessTaskLogEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        processTaskLog.setTenantCode(TenantUtils.getTenantCode());
        this.processTaskLogRepository.saveOrUpdate((Object)processTaskLog);
        ProcessTaskLogVo processTaskLogVo = (ProcessTaskLogVo)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)processTaskLog, ProcessTaskLogVo.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        return processTaskLogVo;
    }

    @Override
    @Transactional
    public List<ProcessTaskLogVo> createBatch(Collection<ProcessTaskLogDto> processTaskLogDtos) {
        if (CollectionUtils.isEmpty(processTaskLogDtos)) {
            return Lists.newArrayList();
        }
        ArrayList processTaskLogVos = Lists.newArrayList();
        for (ProcessTaskLogDto processTaskLogDto : processTaskLogDtos) {
            ProcessTaskLogVo processTaskLogVo = this.create(processTaskLogDto);
            processTaskLogVos.add(processTaskLogVo);
        }
        return processTaskLogVos;
    }

    @Override
    public List<ProcessInterventionLogsVo> findInterventionLogByProcessInstanceId(String processInstanceId) {
        List<ProcessTaskLogEntity> processTaskLogEntities = this.processTaskLogRepository.findByProcessInstanceIds(Lists.newArrayList((Object[])new String[]{processInstanceId}));
        String operateType = "Intervention";
        List processTaskLogEntitySet = processTaskLogEntities.stream().filter(processTaskLogEntity -> processTaskLogEntity.getOperateType().equals("Intervention")).distinct().collect(Collectors.toList());
        List processInterventionLogsVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(processTaskLogEntitySet, ProcessTaskLogEntity.class, ProcessInterventionLogsVo.class, HashSet.class, ArrayList.class, new String[0]);
        return processInterventionLogsVos;
    }

    @Override
    public List<ProcessTaskLogVo> findByProcessInstanceIdAndOperateType(String processInstanceId, String operateType) {
        Validate.notBlank((CharSequence)processInstanceId, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d41\u7a0b\u5b9e\u4f8bid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processInstanceId, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<ProcessTaskLogEntity> processTaskLogEntities = this.processTaskLogRepository.findByProcessInstanceIdAndOperateType(processInstanceId, operateType);
        if (CollectionUtils.isEmpty(processTaskLogEntities)) {
            return new ArrayList<ProcessTaskLogVo>();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(processTaskLogEntities, ProcessTaskLogEntity.class, ProcessTaskLogVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    private void createValidate(ProcessTaskLogDto processTaskLogDto) {
        Validate.notNull((Object)((Object)processTaskLogDto), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((processTaskLogDto.getId() == null ? 1 : 0) != 0, (String)"\u65b0\u589e\u6570\u636e\u65f6,\u6570\u636e\u4e3b\u952e\u4e0d\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processTaskLogDto.getProcessInstanceId(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d41\u7a0b\u5b9e\u4f8bid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processTaskLogDto.getOperateType(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }
}

