/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.workflow.local.dto.ProcessTaskLogDto;
import com.biz.crm.workflow.local.entity.ProcessInstanceEntity;
import com.biz.crm.workflow.local.entity.ProcessTemplateNodeUserTask;
import com.biz.crm.workflow.local.repository.ProcessTaskListRepository;
import com.biz.crm.workflow.local.service.ProcessInstanceAssigneeService;
import com.biz.crm.workflow.local.service.ProcessInstanceService;
import com.biz.crm.workflow.local.service.ProcessRetrieveService;
import com.biz.crm.workflow.local.service.ProcessTaskCopyStrategyService;
import com.biz.crm.workflow.local.service.ProcessTaskCopyStrategyVarService;
import com.biz.crm.workflow.local.service.ProcessTaskLogService;
import com.biz.crm.workflow.local.service.ProcessTaskService;
import com.biz.crm.workflow.local.service.ProcessTemplateNodeAssigneeService;
import com.biz.crm.workflow.local.service.ProcessTemplateNodeAssigneeVarService;
import com.biz.crm.workflow.local.service.ProcessTemplateNodeUserTaskService;
import com.biz.crm.workflow.local.service.TaskMultiCacheVoService;
import com.biz.crm.workflow.sdk.constant.ProcessConstant;
import com.biz.crm.workflow.sdk.dto.ProcessTaskListDto;
import com.biz.crm.workflow.sdk.dto.TaskDto;
import com.biz.crm.workflow.sdk.dto.UserInfoEventDto;
import com.biz.crm.workflow.sdk.enums.ProcessOperateTypeEnum;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.listener.UserInfoListener;
import com.biz.crm.workflow.sdk.register.ProcessTemplateRegister;
import com.biz.crm.workflow.sdk.service.ProcessTemplateNodeService;
import com.biz.crm.workflow.sdk.strategy.button.ProcessButtonStrategy;
import com.biz.crm.workflow.sdk.strategy.tracing.TracingStrategy;
import com.biz.crm.workflow.sdk.vo.ProcessInstanceAssigneeVo;
import com.biz.crm.workflow.sdk.vo.ProcessTaskCopyStrategyVarVo;
import com.biz.crm.workflow.sdk.vo.ProcessTaskCopyStrategyVo;
import com.biz.crm.workflow.sdk.vo.ProcessTaskListVo;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateNodeAssigneeVarVo;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateNodeAssigneeVo;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateNodeVo;
import com.biz.crm.workflow.sdk.vo.UserVo;
import com.biz.crm.workflow.sdk.vo.response.UserInfoResponse;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.flowable.bpmn.model.ExclusiveGateway;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.InclusiveGateway;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.bpmn.model.ServiceTask;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.bpmn.model.UserTask;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.TaskService;
import org.flowable.engine.runtime.Execution;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ProcessTaskServiceImpl
implements ProcessTaskService {
    private static final Logger log = LoggerFactory.getLogger(ProcessTaskServiceImpl.class);
    @Autowired
    private TaskService taskService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private ProcessTemplateRegister processTemplateRegister;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired
    private ProcessInstanceService processInstanceService;
    @Autowired
    private ProcessTemplateNodeAssigneeService processTemplateNodeAssigneeService;
    @Autowired
    private ProcessTemplateNodeAssigneeVarService processTemplateNodeAssigneeVarService;
    @Autowired(required=false)
    private List<TracingStrategy> tracingStrategies;
    @Autowired
    private ProcessTaskLogService processTaskLogService;
    @Autowired
    private ProcessTemplateNodeService processTemplateNodeService;
    @Autowired
    private ProcessRetrieveService processRetrieveService;
    @Autowired
    private ProcessInstanceAssigneeService processInstanceAssigneeService;
    @Autowired
    private TaskMultiCacheVoService taskMultiCacheVoService;
    @Autowired
    private ProcessTaskListRepository processTaskListRepository;
    @Autowired
    private ProcessTemplateNodeUserTaskService processTemplateNodeUserTaskService;
    @Autowired
    private ProcessTaskCopyStrategyService processTaskCopyStrategyService;
    @Autowired
    private ProcessTaskCopyStrategyVarService processTaskCopyStrategyVarService;

    @Override
    public List<Task> findByInstanceId(String instanceId) {
        List tasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskTenantId(TenantUtils.getTenantCode())).processInstanceId(instanceId)).list();
        tasks.forEach(item -> {
            log.debug("item:{}", (Object)item.toString());
            String assignee = item.getAssignee();
            log.debug("assignee:{}", (Object)assignee);
        });
        return tasks;
    }

    @Override
    public List<Task> findByProcessDefinitionKey(String key) {
        return ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskTenantId(TenantUtils.getTenantCode())).processDefinitionKey(key)).list();
    }

    @Override
    public Page<ProcessTaskListVo> findTodoListByConditions(@PageableDefault(value=50) Pageable pageable, ProcessTaskListDto dto) {
        if (ObjectUtils.isEmpty((Object)dto)) {
            dto = new ProcessTaskListDto();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        UserIdentity userIdentity = this.loginUserService.getLoginUser();
        String userCode = StringUtils.join((Object[])new String[]{userIdentity.getIdentityType(), ":", userIdentity.getAccount()});
        dto.setUserAccount(userCode);
        return this.processTaskListRepository.findTodoLitByConditions(pageable, dto);
    }

    @Override
    public Page<ProcessTaskListVo> findCompleteListByConditions(Pageable pageable, ProcessTaskListDto dto) {
        if (ObjectUtils.isEmpty((Object)dto)) {
            dto = new ProcessTaskListDto();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        UserIdentity userIdentity = this.loginUserService.getLoginUser();
        String userCode = StringUtils.join((Object[])new String[]{userIdentity.getIdentityType(), ":", userIdentity.getAccount()});
        dto.setUserAccount(userCode);
        return this.processTaskListRepository.findCompleteLitByConditions(pageable, dto);
    }

    @Override
    public Page<ProcessTaskListVo> findCommitListByConditions(Pageable pageable, ProcessTaskListDto dto) {
        if (ObjectUtils.isEmpty((Object)dto)) {
            dto = new ProcessTaskListDto();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        UserIdentity userIdentity = this.loginUserService.getLoginUser();
        String userCode = userIdentity.getAccount();
        dto.setUserAccount(userCode);
        return this.processTaskListRepository.findCommitLitByConditions(pageable, dto);
    }

    @Override
    @Transactional
    public void handleTask(TaskDto dto) {
        Validate.notNull((Object)dto, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getProcessButtonCode(), (String)"\u4efb\u52a1\u6309\u94ae\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getProcessInstanceId(), (String)"\u4efb\u52a1\u5b9e\u4f8bid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        ProcessButtonStrategy processButtonStrategy = this.getProcessButtonStrategy(dto.getProcessButtonCode());
        Validate.notNull((Object)processButtonStrategy, (String)"\u901a\u8fc7\u6309\u94ae\u7f16\u7801,\u83b7\u53d6\u7b56\u7565\u5931\u8d25\uff01", (Object[])new Object[0]);
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(dto.getTaskId())).singleResult();
        if (ObjectUtils.isNotEmpty((Object)task)) {
            this.taskMultiCacheVoService.set(dto.getProcessInstanceId() + ":" + task.getTaskDefinitionKey(), new ArrayList<String>());
        }
        processButtonStrategy.handleTask(dto);
    }

    @Override
    @Transactional
    public void handleTaskRetrieve(TaskDto dto) {
        this.processRetrieveService.handleTask(dto);
    }

    @Override
    @Transactional
    public void handleTaskRecover(TaskDto dto) {
        ProcessInstanceEntity processInstanceEntity = this.processInstanceService.findByProcessInstanceId(dto.getProcessInstanceId());
        Validate.notNull((Object)((Object)processInstanceEntity), (String)"\u6d41\u7a0b\u7f16\u53f7[%s]\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[]{dto.getProcessInstanceId()});
        Validate.isTrue((boolean)ProcessStatusEnum.COMMIT.getDictCode().equals(processInstanceEntity.getProcessStatus()), (String)"\u53ea\u6709\u5ba1\u6279\u4e2d\u7684\u6570\u636e\u624d\u80fd\u8ffd\u56de\uff01", (Object[])new Object[0]);
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(dto.getProcessInstanceId()).singleResult();
        Validate.notNull((Object)processInstance, (String)"\u6d41\u7a0b\u7f16\u53f7[%s]\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[]{dto.getProcessInstanceId()});
        List list = this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getId()).list();
        Set<Execution> executions = list.stream().filter(execution -> execution.getActivityId() != null).collect(Collectors.toSet());
        executions.forEach(execution -> {
            Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().executionId(execution.getId())).singleResult();
            String comment = String.format("\u3010%s\u3011\u8ffd\u56de\u4e86\u8be5\u7533\u8bf7", this.loginUserService.getLoginAccountName());
            this.taskService.addComment(task.getId(), task.getProcessInstanceId(), comment);
            this.taskService.setVariable(task.getId(), ProcessConstant.PROCESS_INSTANCE_OPERATE_CODE, (Object)ProcessStatusEnum.RECOVER.getDictCode());
        });
        this.runtimeService.deleteProcessInstance(processInstance.getProcessInstanceId(), ProcessStatusEnum.RECOVER.getDictCode());
        ProcessTaskLogDto processTaskLogDto = new ProcessTaskLogDto();
        processTaskLogDto.setTaskId(dto.getTaskId());
        processTaskLogDto.setProcessInstanceId(dto.getProcessInstanceId());
        processTaskLogDto.setOperateType(ProcessOperateTypeEnum.RECOVER.getDictCode());
        this.addLog(processTaskLogDto);
    }

    @Override
    public Collection<String> findAssigneesByTaskNodeIdAndTaskId(String templateNodeId, String taskId, String processInstanceId, String taskDefKey, String startUserName) {
        List<ProcessTemplateNodeAssigneeVo> processTemplateNodeAssigneeVos = this.processTemplateNodeAssigneeService.findByNodeId(templateNodeId);
        List<ProcessInstanceAssigneeVo> processInstanceAssigneeVos = this.processInstanceAssigneeService.findByProcessInstanceIdAndTaskId(processInstanceId, taskDefKey);
        HashSet userCodeColl = Sets.newHashSet();
        processTemplateNodeAssigneeVos.forEach(assigneeVo -> {
            List<ProcessTemplateNodeAssigneeVarVo> processTemplateNodeAssigneeVarVos;
            Set codes;
            String strategyCode = assigneeVo.getStrategyCode();
            TracingStrategy tracingStrategy = this.findCurrentTracingStrategy(strategyCode);
            Set userCodes = tracingStrategy.onHandle(codes = (processTemplateNodeAssigneeVarVos = this.processTemplateNodeAssigneeVarService.findByNodeAssigneeId(assigneeVo.getId())).stream().map(ProcessTemplateNodeAssigneeVarVo::getCode).collect(Collectors.toSet()), taskDefKey, taskId, processInstanceId, startUserName);
            if (!CollectionUtils.isEmpty((Collection)userCodes)) {
                userCodeColl.add(userCodes);
            }
        });
        Optional result = userCodeColl.parallelStream().reduce((c1, c2) -> {
            c1.retainAll((Collection<?>)c2);
            return c1;
        });
        Set assigneeCodes = result.orElse(Sets.newHashSet());
        if (CollectionUtils.isEmpty((Collection)assigneeCodes) && !CollectionUtils.isEmpty(processInstanceAssigneeVos)) {
            assigneeCodes.addAll(processInstanceAssigneeVos.stream().map(ProcessInstanceAssigneeVo::getAssigneeName).collect(Collectors.toSet()));
        }
        return assigneeCodes;
    }

    @Override
    public Collection<UserVo> findUserVoByTaskNodeIdAndTaskId(String templateNodeId, String taskId, String processInstanceId, String taskDefKey, String startUserName) {
        List<ProcessTemplateNodeAssigneeVo> processTemplateNodeAssigneeVos = this.processTemplateNodeAssigneeService.findByNodeId(templateNodeId);
        List<ProcessInstanceAssigneeVo> processInstanceAssigneeVos = this.processInstanceAssigneeService.findByProcessInstanceIdAndTaskId(processInstanceId, taskDefKey);
        HashSet userCodeColl = Sets.newHashSet();
        processTemplateNodeAssigneeVos.forEach(assigneeVo -> {
            List<ProcessTemplateNodeAssigneeVarVo> processTemplateNodeAssigneeVarVos;
            Set codes;
            String strategyCode = assigneeVo.getStrategyCode();
            TracingStrategy tracingStrategy = this.findCurrentTracingStrategy(strategyCode);
            Set userCodes = tracingStrategy.onHandleUserVos(codes = (processTemplateNodeAssigneeVarVos = this.processTemplateNodeAssigneeVarService.findByNodeAssigneeId(assigneeVo.getId())).stream().map(ProcessTemplateNodeAssigneeVarVo::getCode).collect(Collectors.toSet()), taskId, processInstanceId, startUserName);
            if (!CollectionUtils.isEmpty((Collection)userCodes)) {
                userCodeColl.add(userCodes);
            }
        });
        Optional result = userCodeColl.parallelStream().reduce((c1, c2) -> {
            c1.retainAll((Collection<?>)c2);
            return c1;
        });
        Set assigneeCodes = result.orElse(Sets.newHashSet());
        if (!CollectionUtils.isEmpty(processInstanceAssigneeVos)) {
            for (ProcessInstanceAssigneeVo processInstanceAssigneeVo : processInstanceAssigneeVos) {
                UserVo userVo = new UserVo();
                userVo.setUserName(processInstanceAssigneeVo.getAssigneeName().split(":")[1]);
                userVo.setUserCode(processInstanceAssigneeVo.getAssigneeCode());
                userVo.setIdentityType(processInstanceAssigneeVo.getAssigneeName().split(":")[0]);
                assigneeCodes.add(userVo);
            }
        }
        return assigneeCodes;
    }

    @Override
    public Collection<UserVo> findUserVoByTaskNodeId(String templateNodeId, String startUserName) {
        List<ProcessTemplateNodeAssigneeVo> processTemplateNodeAssigneeVos = this.processTemplateNodeAssigneeService.findByNodeId(templateNodeId);
        HashSet userCodeColl = Sets.newHashSet();
        processTemplateNodeAssigneeVos.forEach(assigneeVo -> {
            Set userCodes;
            String strategyCode = assigneeVo.getStrategyCode();
            TracingStrategy tracingStrategy = this.findCurrentTracingStrategy(strategyCode);
            Collection processTemplateNodeAssigneeVarVos = assigneeVo.getProcessTemplateNodeAssigneeVars();
            Set<Object> codes = Sets.newHashSet();
            if (!CollectionUtils.isEmpty((Collection)processTemplateNodeAssigneeVarVos)) {
                codes = processTemplateNodeAssigneeVarVos.stream().map(ProcessTemplateNodeAssigneeVarVo::getCode).collect(Collectors.toSet());
            }
            if (!CollectionUtils.isEmpty((Collection)(userCodes = tracingStrategy.onHandleUserVos((Collection)codes, null, null, startUserName)))) {
                userCodeColl.add(userCodes);
            }
        });
        Optional result = userCodeColl.parallelStream().reduce((c1, c2) -> {
            c1.retainAll((Collection<?>)c2);
            return c1;
        });
        Set assigneeCodes = result.orElse(Sets.newHashSet());
        return assigneeCodes;
    }

    @Override
    public void updateFormData(TaskDto dto) {
        Validate.notNull((Object)dto, (String)"\u4e1a\u52a1\u64cd\u4f5c\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getProcessInstanceId(), (String)"\u4fee\u6539\u4e1a\u52a1\u8868\u5355\u6570\u636e\uff0c\u6d41\u7a0b\u5b9e\u4f8bid\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getTaskId(), (String)"\u4fee\u6539\u4e1a\u52a1\u8868\u5355\u6570\u636e\uff0c\u4efb\u52a1id\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getFormDataJson(), (String)"\u4fee\u6539\u4e1a\u52a1\u8868\u5355\u6570\u636e\uff0c\u4e1a\u52a1\u8868\u5355\u6570\u636e\u4e3a\u7a7a", (Object[])new Object[0]);
        Task task = (Task)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskTenantId(TenantUtils.getTenantCode())).taskId(dto.getTaskId())).singleResult();
        Validate.notNull((Object)task, (String)"\u4fee\u6539\u4e1a\u52a1\u8868\u5355\u6570\u636e\uff0c\u6d41\u7a0b\u8282\u70b9\u6570\u636e\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        this.taskService.setVariable(task.getId(), ProcessConstant.PROCESS_INSTANCE_FORM_DATA_CODE, (Object)dto.getFormDataJson());
    }

    @Override
    @Deprecated
    public Set<UserVo> findUserVoAllByTaskNodeId(String nodeId, Collection<FlowElement> flowElements, String processInstanceId) {
        ProcessTemplateNodeVo processTemplateNodeVo;
        Validate.notNull((Object)nodeId, (String)"\u8282\u70b9\u5bfb\u4eba\u65f6\uff0c\u8282\u70b9id\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<ProcessTemplateNodeAssigneeVo> processTemplateNodeAssigneeVos = this.processTemplateNodeAssigneeService.findByNodeId(nodeId);
        List<Object> processInstanceAssigneeVos = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)processInstanceId) && ObjectUtils.isNotEmpty((Object)(processTemplateNodeVo = this.processTemplateNodeService.findById(nodeId))) && StringUtils.isNotBlank((CharSequence)processTemplateNodeVo.getProcessTaskId())) {
            processInstanceAssigneeVos = this.processInstanceAssigneeService.findByProcessInstanceIdAndTaskId(processInstanceId, processTemplateNodeVo.getProcessTaskId());
        }
        HashSet userCodeColl = Sets.newHashSet();
        processTemplateNodeAssigneeVos.forEach(assigneeVo -> {
            String strategyCode = assigneeVo.getStrategyCode();
            if (strategyCode.equals("PreNodeApproverUpperTracingStrategy")) {
                Collection<Set<UserVo>> userVos = this.findUserVoByPreStrategy(flowElements, nodeId, (ProcessTemplateNodeAssigneeVo)assigneeVo, processInstanceId);
                if (!CollectionUtils.isEmpty(userVos)) {
                    userCodeColl.addAll(userVos);
                }
            } else {
                Collection<Set<UserVo>> userVos = this.findUserVoByStrategy(strategyCode, (ProcessTemplateNodeAssigneeVo)assigneeVo, processInstanceId);
                if (!CollectionUtils.isEmpty(userVos)) {
                    userCodeColl.addAll(userVos);
                }
            }
        });
        Optional result = userCodeColl.parallelStream().reduce((c1, c2) -> {
            c1.retainAll((Collection<?>)c2);
            return c1;
        });
        Set assigneeCodes = result.orElse(Sets.newHashSet());
        if (CollectionUtils.isEmpty((Collection)assigneeCodes) && !CollectionUtils.isEmpty(processInstanceAssigneeVos)) {
            processInstanceAssigneeVos.forEach(processInstanceAssigneeVo -> {
                UserVo userVo = new UserVo();
                userVo.setUserCode(processInstanceAssigneeVo.getAssigneeCode());
                userVo.setUserName(processInstanceAssigneeVo.getAssigneeName().split(":")[1]);
                userVo.setIdentityType(processInstanceAssigneeVo.getAssigneeName().split(":")[0]);
                assigneeCodes.add(userVo);
            });
        }
        return assigneeCodes;
    }

    private Collection<Set<UserVo>> findUserVoByStrategy(String strategyCode, ProcessTemplateNodeAssigneeVo assigneeVo, String processInstanceId) {
        Set userCodes;
        HashSet userCodeColl = Sets.newHashSet();
        TracingStrategy tracingStrategy = this.findCurrentTracingStrategy(strategyCode);
        Collection processTemplateNodeAssigneeVarVos = assigneeVo.getProcessTemplateNodeAssigneeVars();
        Set<Object> codes = Sets.newHashSet();
        if (!CollectionUtils.isEmpty((Collection)processTemplateNodeAssigneeVarVos)) {
            codes = processTemplateNodeAssigneeVarVos.stream().map(ProcessTemplateNodeAssigneeVarVo::getCode).collect(Collectors.toSet());
        }
        if (!CollectionUtils.isEmpty((Collection)(userCodes = tracingStrategy.onHandleUserVos((Collection)codes, null, processInstanceId, null)))) {
            userCodeColl.add(userCodes);
        }
        return userCodeColl;
    }

    private Collection<Set<UserVo>> findUserVoByPreStrategy(Collection<FlowElement> flowElements, String nodeId, ProcessTemplateNodeAssigneeVo assigneeVo, String processInstanceId) {
        HashSet userCodeColl = Sets.newHashSet();
        ProcessTemplateNodeVo processTemplateNodeVo = this.processTemplateNodeService.findById(nodeId);
        String processDefinitionKey = processTemplateNodeVo.getProcessTaskId();
        for (FlowElement flowElement : flowElements) {
            List incomingFlows;
            if (!(flowElement instanceof UserTask) || !flowElement.getId().equals(processDefinitionKey) || (incomingFlows = ((UserTask)flowElement).getIncomingFlows()).size() <= 0) continue;
            for (SequenceFlow incomingFlow : incomingFlows) {
                Set<UserVo> userVos;
                Set<UserVo> userVos2;
                FlowElement sourceFlowElement = incomingFlow.getSourceFlowElement();
                if (sourceFlowElement instanceof UserTask) {
                    List<String> assignees;
                    Set<UserVo> userVoSet;
                    String taskDefinitionKey = sourceFlowElement.getId();
                    processTemplateNodeVo = this.processTemplateNodeService.findByTemplateIdAndTaskId(assigneeVo.getTemplateId(), taskDefinitionKey);
                    if (ObjectUtils.isEmpty((Object)processTemplateNodeVo)) continue;
                    userVos2 = Sets.newHashSet();
                    if (StringUtils.isNotBlank((CharSequence)processInstanceId)) {
                        userVoSet = this.findOptionalApproveByNodeId(processTemplateNodeVo.getId(), processInstanceId);
                        if (!CollectionUtils.isEmpty(userVoSet)) {
                            assignees = userVoSet.stream().map(UserVo::getUserName).collect(Collectors.toList());
                            userVos2 = this.findTracingEvent(assignees);
                        } else {
                            userVoSet = this.findUserVoAllByTaskNodeId(processTemplateNodeVo.getId(), flowElements, processInstanceId);
                            if (!CollectionUtils.isEmpty(userVoSet)) {
                                assignees = userVoSet.stream().map(UserVo::getUserName).collect(Collectors.toList());
                                userVos2 = this.findTracingEvent(assignees);
                            }
                        }
                    } else if (CollectionUtils.isEmpty(userVos2) && !CollectionUtils.isEmpty(userVoSet = this.findUserVoAllByTaskNodeId(processTemplateNodeVo.getId(), flowElements, processInstanceId))) {
                        assignees = userVoSet.stream().map(UserVo::getUserName).collect(Collectors.toList());
                        userVos2 = this.findTracingEvent(assignees);
                    }
                    userCodeColl.add(userVos2);
                    continue;
                }
                if (sourceFlowElement instanceof ExclusiveGateway) {
                    List<UserTask> previousFlowElementExclusive = this.findPreviousFlowElementExclusive((ExclusiveGateway)sourceFlowElement);
                    if (previousFlowElementExclusive.size() <= 0) continue;
                    for (UserTask previousFlowElement : previousFlowElementExclusive) {
                        userVos = this.buildTracing(previousFlowElement, assigneeVo, flowElements, processInstanceId);
                        if (CollectionUtils.isEmpty(userVos)) continue;
                        userCodeColl.add(userVos);
                    }
                    continue;
                }
                if (sourceFlowElement instanceof InclusiveGateway) {
                    List<UserTask> previousFlowElementInclusive = this.findPreviousFlowElementInclusive((InclusiveGateway)sourceFlowElement);
                    if (previousFlowElementInclusive.size() <= 0) continue;
                    for (UserTask previousFlowElement : previousFlowElementInclusive) {
                        userVos = this.buildTracing(previousFlowElement, assigneeVo, flowElements, processInstanceId);
                        if (CollectionUtils.isEmpty(userVos)) continue;
                        userCodeColl.add(userVos);
                    }
                    continue;
                }
                if (sourceFlowElement instanceof ServiceTask) {
                    List<UserTask> previousFlowElementServiceTask = this.findPreviousFlowServiceTask((ServiceTask)sourceFlowElement);
                    if (previousFlowElementServiceTask.size() <= 0) continue;
                    for (UserTask previousFlowElement : previousFlowElementServiceTask) {
                        userVos = this.buildTracing(previousFlowElement, assigneeVo, flowElements, processInstanceId);
                        if (CollectionUtils.isEmpty(userVos)) continue;
                        userCodeColl.add(userVos);
                    }
                    continue;
                }
                if (!(sourceFlowElement instanceof StartEvent)) continue;
                if (StringUtils.isBlank((CharSequence)processInstanceId)) {
                    String account = this.loginUserService.getLoginUser().getAccount();
                    userVos2 = this.findTracingEvent(Collections.singletonList(account));
                    if (CollectionUtils.isEmpty((Collection)userVos2)) continue;
                    userCodeColl.add(userVos2);
                    continue;
                }
                ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceTenantId(TenantUtils.getTenantCode()).processInstanceId(processInstanceId).singleResult();
                String account = processInstance.getStartUserId().split(":")[1];
                Set<UserVo> userVos3 = this.findTracingEvent(Collections.singletonList(account));
                if (CollectionUtils.isEmpty(userVos3)) continue;
                userCodeColl.add(userVos3);
            }
        }
        return userCodeColl;
    }

    private Set<UserVo> buildTracing(UserTask previousFlowElement, ProcessTemplateNodeAssigneeVo assigneeVo, Collection<FlowElement> flowElements, String processInstanceId) {
        Set<UserVo> userVoSet;
        String taskDefinitionKey = previousFlowElement.getId();
        Set<UserVo> userVos = new HashSet<UserVo>();
        ProcessTemplateNodeVo processTemplateNodeVo = this.processTemplateNodeService.findByTemplateIdAndTaskId(assigneeVo.getTemplateId(), taskDefinitionKey);
        if (!ObjectUtils.isEmpty((Object)processTemplateNodeVo) && !CollectionUtils.isEmpty(userVoSet = this.findUserVoAllByTaskNodeId(processTemplateNodeVo.getId(), flowElements, processInstanceId))) {
            List<String> assignees = userVoSet.stream().map(UserVo::getUserName).collect(Collectors.toList());
            userVos = this.findTracingEvent(assignees);
        }
        return userVos;
    }

    private Set<UserVo> findTracingEvent(List<String> assignees) {
        SerializableBiConsumer & Serializable sf = UserInfoListener::findByPositionUpperByUserCodes;
        UserInfoEventDto userInfoEventDto = UserInfoEventDto.builder().userCodes(assignees).build();
        UserInfoResponse userInfoResponse = (UserInfoResponse)this.nebulaNetEventClient.directPublish((NebulaEventDto)userInfoEventDto, UserInfoListener.class, (SerializableBiConsumer)sf);
        if (!Objects.isNull(userInfoResponse) && !CollectionUtils.isEmpty((Collection)userInfoResponse.getUserVos())) {
            Collection userVos = userInfoResponse.getUserVos();
            Set<UserVo> userVoList = userVos.stream().filter(userVo -> DelFlagStatusEnum.NORMAL.getCode().equals(userVo.getDelFlag()) && EnableStatusEnum.ENABLE.getCode().equals(userVo.getEnableStatus())).collect(Collectors.toSet());
            if (!CollectionUtils.isEmpty(userVoList)) {
                return userVoList;
            }
            return Collections.emptySet();
        }
        return Collections.emptySet();
    }

    private Set<UserVo> findOptionalApproveByNodeId(String nodeId, String processInstanceId) {
        ProcessTemplateNodeVo processTemplateNodeVo;
        Validate.notNull((Object)nodeId, (String)"\u67e5\u8be2\u81ea\u9009\u5ba1\u6279\u4eba\u4fe1\u606f\u65f6\uff0c\u8282\u70b9id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (StringUtils.isEmpty((CharSequence)processInstanceId)) {
            return null;
        }
        HashSet userVos = Sets.newHashSet();
        ProcessTemplateNodeUserTask processTemplateNodeUserTask = this.processTemplateNodeUserTaskService.findUserTaskByNodeId(nodeId);
        if (ObjectUtils.isEmpty((Object)((Object)processTemplateNodeUserTask))) {
            return null;
        }
        if (BooleanUtils.isTrue((Boolean)processTemplateNodeUserTask.getSignOptional()) && ObjectUtils.isNotEmpty((Object)(processTemplateNodeVo = this.processTemplateNodeService.findById(nodeId)))) {
            String processTaskId = processTemplateNodeVo.getProcessTaskId();
            List<ProcessInstanceAssigneeVo> processInstanceAssigneeVos = this.processInstanceAssigneeService.findByProcessInstanceIdAndTaskId(processInstanceId, processTaskId);
            if (CollectionUtils.isEmpty(processInstanceAssigneeVos)) {
                return null;
            }
            processInstanceAssigneeVos.forEach(processInstanceAssigneeVo -> {
                UserVo userVo = new UserVo();
                userVo.setUserCode(processInstanceAssigneeVo.getAssigneeCode());
                userVo.setUserName(processInstanceAssigneeVo.getAssigneeName().split(":")[1]);
                userVo.setIdentityType(processInstanceAssigneeVo.getAssigneeName().split(":")[0]);
                userVos.add(userVo);
            });
        }
        return userVos;
    }

    private List<UserTask> findPreviousFlowServiceTask(ServiceTask serviceTask) {
        List<UserTask> previousFlowElements = new ArrayList<UserTask>();
        List incomingFlows = serviceTask.getIncomingFlows();
        for (SequenceFlow incomingFlow : incomingFlows) {
            FlowElement sourceFlowElement = incomingFlow.getSourceFlowElement();
            if (sourceFlowElement instanceof UserTask) {
                UserTask userTask = (UserTask)sourceFlowElement;
                previousFlowElements.add(userTask);
                continue;
            }
            if (sourceFlowElement instanceof ExclusiveGateway) {
                previousFlowElements = this.findPreviousFlowElementExclusive((ExclusiveGateway)sourceFlowElement);
                continue;
            }
            if (sourceFlowElement instanceof InclusiveGateway) {
                previousFlowElements = this.findPreviousFlowElementInclusive((InclusiveGateway)sourceFlowElement);
                continue;
            }
            if (!(sourceFlowElement instanceof ServiceTask)) continue;
            previousFlowElements = this.findPreviousFlowServiceTask((ServiceTask)sourceFlowElement);
        }
        return previousFlowElements;
    }

    private List<UserTask> findPreviousFlowElementInclusive(InclusiveGateway inclusiveGateway) {
        List<UserTask> previousFlowElements = new ArrayList<UserTask>();
        List incomingFlows = inclusiveGateway.getIncomingFlows();
        for (SequenceFlow incomingFlow : incomingFlows) {
            FlowElement sourceFlowElement = incomingFlow.getSourceFlowElement();
            if (sourceFlowElement instanceof UserTask) {
                UserTask userTask = (UserTask)sourceFlowElement;
                previousFlowElements.add(userTask);
                continue;
            }
            if (sourceFlowElement instanceof ExclusiveGateway) {
                previousFlowElements = this.findPreviousFlowElementExclusive((ExclusiveGateway)sourceFlowElement);
                continue;
            }
            if (sourceFlowElement instanceof InclusiveGateway) {
                previousFlowElements = this.findPreviousFlowElementInclusive((InclusiveGateway)sourceFlowElement);
                continue;
            }
            if (!(sourceFlowElement instanceof ServiceTask)) continue;
            previousFlowElements = this.findPreviousFlowServiceTask((ServiceTask)sourceFlowElement);
        }
        return previousFlowElements;
    }

    private List<UserTask> findPreviousFlowElementExclusive(ExclusiveGateway exclusiveGateway) {
        List<UserTask> previousFlowElements = new ArrayList<UserTask>();
        List incomingFlows = exclusiveGateway.getIncomingFlows();
        for (SequenceFlow incomingFlow : incomingFlows) {
            FlowElement sourceFlowElement = incomingFlow.getSourceFlowElement();
            if (sourceFlowElement instanceof UserTask) {
                UserTask userTask = (UserTask)sourceFlowElement;
                previousFlowElements.add(userTask);
                continue;
            }
            if (sourceFlowElement instanceof ExclusiveGateway) {
                previousFlowElements = this.findPreviousFlowElementExclusive((ExclusiveGateway)sourceFlowElement);
                continue;
            }
            if (sourceFlowElement instanceof InclusiveGateway) {
                previousFlowElements = this.findPreviousFlowElementInclusive((InclusiveGateway)sourceFlowElement);
                continue;
            }
            if (!(sourceFlowElement instanceof ServiceTask)) continue;
            previousFlowElements = this.findPreviousFlowServiceTask((ServiceTask)sourceFlowElement);
        }
        return previousFlowElements;
    }

    @Override
    public Collection<String> findCopyByTaskNodeIdAndTaskId(String templateNodeId, String taskId, String processInstanceId, String taskDefinitionKey, String startUserName) {
        Collection<ProcessTaskCopyStrategyVo> processTaskCopyStrategyVos = this.processTaskCopyStrategyService.findByNodeId(templateNodeId);
        if (CollectionUtils.isEmpty(processTaskCopyStrategyVos)) {
            return new ArrayList<String>();
        }
        HashSet userCodeColl = Sets.newHashSet();
        processTaskCopyStrategyVos.forEach(copyVo -> {
            List<ProcessTaskCopyStrategyVarVo> processTaskCopyStrategyVarVos;
            Set codes;
            String strategyCode = copyVo.getStrategyCode();
            TracingStrategy tracingStrategy = this.findCurrentTracingStrategy(strategyCode);
            Set userCodes = tracingStrategy.onHandle(codes = (processTaskCopyStrategyVarVos = this.processTaskCopyStrategyVarService.findByNodeCopyId(copyVo.getId())).stream().map(ProcessTaskCopyStrategyVarVo::getCode).collect(Collectors.toSet()), taskDefinitionKey, taskId, processInstanceId, startUserName);
            if (!CollectionUtils.isEmpty((Collection)userCodes)) {
                userCodeColl.add(userCodes);
            }
        });
        Optional result = userCodeColl.parallelStream().reduce((c1, c2) -> {
            c1.retainAll((Collection<?>)c2);
            return c1;
        });
        Set assigneeCodes = result.orElse(Sets.newHashSet());
        return assigneeCodes;
    }

    private ProcessButtonStrategy getProcessButtonStrategy(String processButtonCode) {
        Collection processButtonStrategies = this.processTemplateRegister.getProcessButtonStrategies();
        ArrayList list = Lists.newArrayList();
        processButtonStrategies.forEach(aClass -> {
            ProcessButtonStrategy processButtonStrategy = (ProcessButtonStrategy)this.applicationContext.getBean(aClass);
            if (processButtonStrategy.getProcessButtonCode().equals(processButtonCode)) {
                list.add(processButtonStrategy);
            }
        });
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        return (ProcessButtonStrategy)list.get(0);
    }

    private TracingStrategy findCurrentTracingStrategy(String code) {
        if (CollectionUtils.isEmpty(this.tracingStrategies)) {
            return null;
        }
        return this.tracingStrategies.stream().filter(item -> item.getCode().equals(code)).findFirst().orElse(null);
    }

    private void addLog(ProcessTaskLogDto processTaskLogDto) {
        ProcessInstanceEntity processInstanceEntity = this.processInstanceService.findByProcessInstanceId(processTaskLogDto.getProcessInstanceId());
        Validate.notNull((Object)((Object)processInstanceEntity), (String)"\u65e5\u5fd7\u8bb0\u5f55\u6d41\u7a0b\u5b9e\u4f8b\u6570\u636e\u5f02\u5e38", (Object[])new Object[0]);
        if (!StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{processTaskLogDto.getProcessDefinitionId(), processTaskLogDto.getTaskDefinitionKey()})) {
            ProcessTemplateNodeVo processTemplateNodeVo = this.processTemplateNodeService.findByProcessInstanceIdAndTaskDefinitionKey(processInstanceEntity.getProcessInstanceId(), processTaskLogDto.getTaskDefinitionKey());
            Validate.notNull((Object)processTemplateNodeVo, (String)"\u65e5\u5fd7\u8bb0\u5f55\u8282\u70b9\u6570\u636e\u5f02\u5e38", (Object[])new Object[0]);
            processTaskLogDto.setTaskNodeId(processTemplateNodeVo.getId());
        }
        processTaskLogDto.setProcessKey(processInstanceEntity.getProcessKey());
        processTaskLogDto.setTenantCode(TenantUtils.getTenantCode());
        this.processTaskLogService.create(processTaskLogDto);
    }
}

