/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.service.internal;

import com.biz.crm.workflow.local.entity.ProcessTemplateBusiness;
import com.biz.crm.workflow.local.repository.ProcessTemplateBusinessRepository;
import com.biz.crm.workflow.local.service.ProcessTemplateBusinessService;
import com.biz.crm.workflow.sdk.dto.ProcessTemplateBusinessDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProcessTemplateBusinessServiceImpl
implements ProcessTemplateBusinessService {
    private static final Logger log = LoggerFactory.getLogger(ProcessTemplateBusinessServiceImpl.class);
    @Autowired
    private ProcessTemplateBusinessRepository processTemplateBusinessRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional
    public void create(ProcessTemplateBusinessDto processTemplateBusinessDto) {
        Validate.notNull((Object)processTemplateBusinessDto, (String)"\u6d41\u7a0b\u5173\u8054\u4e1a\u52a1\uff0c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processTemplateBusinessDto.getBusinessCode(), (String)"\u65b0\u589e\u65f6\uff0c\u4e1a\u52a1\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processTemplateBusinessDto.getFormCode(), (String)"\u65b0\u589e\u65f6\uff0c\u4e1a\u52a1\u8868\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processTemplateBusinessDto.getFormName(), (String)"\u65b0\u589e\u65f6\uff0c\u4e1a\u52a1\u8868\u5355\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processTemplateBusinessDto.getEffectiveScope(), (String)"\u65b0\u589e\u65f6\uff0c\u751f\u6548\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)processTemplateBusinessDto.getProcessTemplateId(), (String)"\u65b0\u589e\u65f6\uff0c\u6a21\u677fid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processTemplateBusinessDto.getProcessTheme(), (String)"\u65b0\u589e\u65f6\uff0c\u6d41\u7a0b\u4e3b\u9898\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        ProcessTemplateBusiness processTemplateBusiness = (ProcessTemplateBusiness)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)processTemplateBusinessDto, ProcessTemplateBusiness.class, HashSet.class, ArrayList.class, new String[0]));
        this.processTemplateBusinessRepository.save((Object)processTemplateBusiness);
    }

    @Override
    @Transactional
    public void deleteByProcessTemplateId(String processTemplateId) {
        Validate.notBlank((CharSequence)processTemplateId, (String)"\u6d41\u7a0b\u6a21\u677fid\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.processTemplateBusinessRepository.deleteByProcessTemplateId(processTemplateId);
    }

    @Override
    public ProcessTemplateBusiness findByProcessTemplateId(String processTemplateId) {
        if (StringUtils.isBlank((CharSequence)processTemplateId)) {
            return null;
        }
        return this.processTemplateBusinessRepository.findByProcessTemplateId(processTemplateId);
    }
}

