/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.workflow.local.entity.ProcessTemplateNodeAssignee;
import com.biz.crm.workflow.local.repository.ProcessTemplateNodeAssigneeRepository;
import com.biz.crm.workflow.local.service.ProcessTemplateNodeAssigneeService;
import com.biz.crm.workflow.local.service.ProcessTemplateNodeAssigneeVarService;
import com.biz.crm.workflow.sdk.dto.ProcessTemplateNodeAssigneeDto;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateNodeAssigneeVarVo;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateNodeAssigneeVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="processTemplateNodeAssigneeService")
public class ProcessTemplateNodeAssigneeServiceImpl
implements ProcessTemplateNodeAssigneeService {
    @Autowired
    private ProcessTemplateNodeAssigneeRepository processTemplateNodeAssigneeRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private ProcessTemplateNodeAssigneeVarService processTemplateNodeAssigneeVarService;

    @Override
    public Page<ProcessTemplateNodeAssigneeVo> findByConditions(Pageable pageable, ProcessTemplateNodeAssigneeDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(dto)) {
            dto = new ProcessTemplateNodeAssigneeDto();
        }
        return this.processTemplateNodeAssigneeRepository.findByConditions(pageable, dto);
    }

    @Override
    public ProcessTemplateNodeAssigneeVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        ProcessTemplateNodeAssignee processTemplateNodeAssignee = this.processTemplateNodeAssigneeRepository.findByIdAndTenantCode(id, TenantUtils.getTenantCode());
        if (processTemplateNodeAssignee == null) {
            return null;
        }
        ProcessTemplateNodeAssigneeVo processTemplateNodeAssigneeVo = (ProcessTemplateNodeAssigneeVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)processTemplateNodeAssignee, ProcessTemplateNodeAssigneeVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.fillDetail(processTemplateNodeAssigneeVo);
        return processTemplateNodeAssigneeVo;
    }

    @Override
    public List<ProcessTemplateNodeAssigneeVo> findByIds(Collection<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        List<ProcessTemplateNodeAssignee> processTemplateNodeAssignees = this.processTemplateNodeAssigneeRepository.findByIds(ids);
        Collection processTemplateNodeAssigneeVos = this.nebulaToolkitService.copyCollectionByWhiteList(processTemplateNodeAssignees, ProcessTemplateNodeAssignee.class, ProcessTemplateNodeAssigneeVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        processTemplateNodeAssigneeVos.forEach(this::fillDetail);
        return Lists.newArrayList((Iterable)processTemplateNodeAssigneeVos);
    }

    @Override
    public List<ProcessTemplateNodeAssigneeVo> findByTemplateId(String templateId) {
        if (StringUtils.isBlank((CharSequence)templateId)) {
            return Collections.emptyList();
        }
        List<ProcessTemplateNodeAssignee> processTemplateNodeAssignees = this.processTemplateNodeAssigneeRepository.findByTemplateId(templateId);
        if (CollectionUtils.isEmpty(processTemplateNodeAssignees)) {
            return Collections.emptyList();
        }
        Collection processTemplateNodeAssigneeVos = this.nebulaToolkitService.copyCollectionByWhiteList(processTemplateNodeAssignees, ProcessTemplateNodeAssignee.class, ProcessTemplateNodeAssigneeVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        processTemplateNodeAssigneeVos.forEach(this::fillDetail);
        return Lists.newArrayList((Iterable)processTemplateNodeAssigneeVos);
    }

    @Override
    public List<ProcessTemplateNodeAssigneeVo> findByTemplateIds(Collection<String> templateIds) {
        if (CollectionUtils.isEmpty(templateIds)) {
            return Collections.emptyList();
        }
        List<ProcessTemplateNodeAssignee> processTemplateNodeAssignees = this.processTemplateNodeAssigneeRepository.findByTemplateIds(templateIds);
        if (CollectionUtils.isEmpty(processTemplateNodeAssignees)) {
            return Collections.emptyList();
        }
        Collection processTemplateNodeAssigneeVos = this.nebulaToolkitService.copyCollectionByWhiteList(processTemplateNodeAssignees, ProcessTemplateNodeAssignee.class, ProcessTemplateNodeAssigneeVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        processTemplateNodeAssigneeVos.forEach(this::fillDetail);
        return Lists.newArrayList((Iterable)processTemplateNodeAssigneeVos);
    }

    @Override
    public List<ProcessTemplateNodeAssigneeVo> findByNodeId(String nodeId) {
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            return Collections.emptyList();
        }
        List<ProcessTemplateNodeAssignee> processTemplateNodeAssignees = this.processTemplateNodeAssigneeRepository.findByNodeId(nodeId);
        if (CollectionUtils.isEmpty(processTemplateNodeAssignees)) {
            return Collections.emptyList();
        }
        Collection processTemplateNodeAssigneeVos = this.nebulaToolkitService.copyCollectionByWhiteList(processTemplateNodeAssignees, ProcessTemplateNodeAssignee.class, ProcessTemplateNodeAssigneeVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        processTemplateNodeAssigneeVos.forEach(this::fillDetail);
        return Lists.newArrayList((Iterable)processTemplateNodeAssigneeVos);
    }

    @Override
    public List<ProcessTemplateNodeAssigneeVo> findByNodeIds(Collection<String> nodeIds) {
        if (CollectionUtils.isEmpty(nodeIds)) {
            return Collections.emptyList();
        }
        List<ProcessTemplateNodeAssignee> processTemplateNodeAssignees = this.processTemplateNodeAssigneeRepository.findByNodeIds(nodeIds);
        if (CollectionUtils.isEmpty(processTemplateNodeAssignees)) {
            return Collections.emptyList();
        }
        Collection processTemplateNodeAssigneeVos = this.nebulaToolkitService.copyCollectionByWhiteList(processTemplateNodeAssignees, ProcessTemplateNodeAssignee.class, ProcessTemplateNodeAssigneeVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        processTemplateNodeAssigneeVos.forEach(this::fillDetail);
        return Lists.newArrayList((Iterable)processTemplateNodeAssigneeVos);
    }

    @Override
    @Transactional
    public ProcessTemplateNodeAssigneeVo create(ProcessTemplateNodeAssigneeDto processTemplateNodeAssigneeDto) {
        this.createValidate(processTemplateNodeAssigneeDto);
        ProcessTemplateNodeAssignee processTemplateNodeAssignee = (ProcessTemplateNodeAssignee)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)processTemplateNodeAssigneeDto, ProcessTemplateNodeAssignee.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        processTemplateNodeAssignee.setTenantCode(TenantUtils.getTenantCode());
        this.processTemplateNodeAssigneeRepository.saveOrUpdate((Object)processTemplateNodeAssignee);
        ProcessTemplateNodeAssigneeVo processTemplateNodeAssigneeVo = (ProcessTemplateNodeAssigneeVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)processTemplateNodeAssignee, ProcessTemplateNodeAssigneeVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        processTemplateNodeAssigneeVo.setId(processTemplateNodeAssignee.getId());
        Collection processTemplateNodeAssignees = processTemplateNodeAssigneeDto.getProcessTemplateNodeAssigneeVars();
        if (!CollectionUtils.isEmpty((Collection)processTemplateNodeAssignees)) {
            processTemplateNodeAssignees.forEach(item -> {
                item.setNodeAssigneeId(processTemplateNodeAssigneeVo.getId());
                item.setTenantCode(TenantUtils.getTenantCode());
            });
            List<ProcessTemplateNodeAssigneeVarVo> processTemplateNodeAssigneeVarVos = this.processTemplateNodeAssigneeVarService.createBatch(processTemplateNodeAssignees);
            processTemplateNodeAssigneeVo.setProcessTemplateNodeAssigneeVars(processTemplateNodeAssigneeVarVos);
        }
        return processTemplateNodeAssigneeVo;
    }

    @Override
    @Transactional
    public List<ProcessTemplateNodeAssigneeVo> createBatch(Collection<ProcessTemplateNodeAssigneeDto> processTemplateNodeAssigneeDtos) {
        if (CollectionUtils.isEmpty(processTemplateNodeAssigneeDtos)) {
            return Lists.newArrayList();
        }
        ArrayList processTemplateNodeAssigneeVos = Lists.newArrayList();
        for (ProcessTemplateNodeAssigneeDto processTemplateNodeAssigneeDto : processTemplateNodeAssigneeDtos) {
            ProcessTemplateNodeAssigneeVo processTemplateNodeAssigneeVo = this.create(processTemplateNodeAssigneeDto);
            processTemplateNodeAssigneeVos.add(processTemplateNodeAssigneeVo);
        }
        return processTemplateNodeAssigneeVos;
    }

    @Override
    @Transactional
    public void deleteByNodeIds(Collection<String> nodeIds) {
        Validate.isTrue((!CollectionUtils.isEmpty(nodeIds) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<ProcessTemplateNodeAssignee> processTemplateNodeAssignees = this.processTemplateNodeAssigneeRepository.findByNodeIds(nodeIds);
        if (CollectionUtils.isEmpty(processTemplateNodeAssignees)) {
            return;
        }
        processTemplateNodeAssignees.forEach(processTemplateNodeAssignee -> {
            List<ProcessTemplateNodeAssigneeVarVo> processTemplateNodeAssigneeVarVos = this.processTemplateNodeAssigneeVarService.findByNodeAssigneeId(processTemplateNodeAssignee.getId());
            if (!CollectionUtils.isEmpty(processTemplateNodeAssigneeVarVos)) {
                this.processTemplateNodeAssigneeVarService.delete(processTemplateNodeAssigneeVarVos.stream().map(ProcessTemplateNodeAssigneeVarVo::getNodeAssigneeId).collect(Collectors.toSet()));
            }
        });
        this.processTemplateNodeAssigneeRepository.removeByIdsAndTenantCode(processTemplateNodeAssignees.stream().map(UuidEntity::getId).collect(Collectors.toSet()), TenantUtils.getTenantCode());
    }

    private void createValidate(ProcessTemplateNodeAssigneeDto processTemplateNodeAssigneeDto) {
        Validate.notNull((Object)processTemplateNodeAssigneeDto, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        processTemplateNodeAssigneeDto.setId(null);
        Validate.notBlank((CharSequence)processTemplateNodeAssigneeDto.getTemplateId(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d41\u7a0b\u6a21\u677f\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processTemplateNodeAssigneeDto.getNodeId(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d41\u7a0b\u8282\u70b9\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processTemplateNodeAssigneeDto.getStrategyCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u7b56\u7565\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processTemplateNodeAssigneeDto.getStrategyName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u7b56\u7565\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)processTemplateNodeAssigneeDto.getSort(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6392\u5e8f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private void fillDetail(ProcessTemplateNodeAssigneeVo processTemplateNodeAssigneeVo) {
        List<ProcessTemplateNodeAssigneeVarVo> processTemplateNodeAssigneeVarVos = this.processTemplateNodeAssigneeVarService.findByNodeAssigneeId(processTemplateNodeAssigneeVo.getId());
        if (!CollectionUtils.isEmpty(processTemplateNodeAssigneeVarVos)) {
            processTemplateNodeAssigneeVo.setProcessTemplateNodeAssigneeVars(processTemplateNodeAssigneeVarVos);
        }
    }
}

