/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.workflow.local.entity.ProcessTemplateNodeEmail;
import com.biz.crm.workflow.local.repository.ProcessTemplateNodeEmailRepository;
import com.biz.crm.workflow.local.service.ProcessTemplateNodeEmailFilesService;
import com.biz.crm.workflow.local.service.ProcessTemplateNodeEmailService;
import com.biz.crm.workflow.sdk.dto.ProcessTemplateNodeEmailDto;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateNodeEmailFilesVo;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateNodeEmailVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import javax.transaction.Transactional;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="processTemplateNodeEmailService")
public class ProcessTemplateNodeEmailServiceImpl
implements ProcessTemplateNodeEmailService {
    @Autowired
    private ProcessTemplateNodeEmailRepository processTemplateNodeEmailRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private ProcessTemplateNodeEmailFilesService processTemplateNodeEmailFilesService;
    @Value(value="${spring.mail.username}")
    private String mailUserName;

    @Override
    public Page<ProcessTemplateNodeEmailVo> findByConditions(Pageable pageable, ProcessTemplateNodeEmailDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(dto)) {
            dto = new ProcessTemplateNodeEmailDto();
        }
        return this.processTemplateNodeEmailRepository.findByConditions(pageable, dto);
    }

    @Override
    public ProcessTemplateNodeEmailVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        ProcessTemplateNodeEmail processTemplateNodeEmail = this.processTemplateNodeEmailRepository.findByIdAndTenantCode(id, TenantUtils.getTenantCode());
        if (processTemplateNodeEmail == null) {
            return null;
        }
        ProcessTemplateNodeEmailVo processTemplateNodeEmailVo = (ProcessTemplateNodeEmailVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)processTemplateNodeEmail, ProcessTemplateNodeEmailVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.fillDetail(processTemplateNodeEmailVo);
        return processTemplateNodeEmailVo;
    }

    @Override
    public List<ProcessTemplateNodeEmailVo> findByIds(Collection<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        List<ProcessTemplateNodeEmail> processTemplateNodeEmails = this.processTemplateNodeEmailRepository.findByIds(ids);
        Collection processTemplateNodeEmailVos = this.nebulaToolkitService.copyCollectionByWhiteList(processTemplateNodeEmails, ProcessTemplateNodeEmail.class, ProcessTemplateNodeEmailVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        processTemplateNodeEmailVos.forEach(item -> this.fillDetail((ProcessTemplateNodeEmailVo)item));
        return Lists.newArrayList((Iterable)processTemplateNodeEmailVos);
    }

    @Override
    public ProcessTemplateNodeEmailVo findByNodeId(String nodeId) {
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            return null;
        }
        ProcessTemplateNodeEmail processTemplateNodeEmail = this.processTemplateNodeEmailRepository.findByNodeId(nodeId);
        if (processTemplateNodeEmail == null) {
            return null;
        }
        ProcessTemplateNodeEmailVo processTemplateNodeEmailVo = (ProcessTemplateNodeEmailVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)processTemplateNodeEmail, ProcessTemplateNodeEmailVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.fillDetail(processTemplateNodeEmailVo);
        return processTemplateNodeEmailVo;
    }

    @Override
    @Transactional
    public ProcessTemplateNodeEmailVo create(ProcessTemplateNodeEmailDto processTemplateNodeEmailDto) {
        this.createValidate(processTemplateNodeEmailDto);
        ProcessTemplateNodeEmail processTemplateNodeEmail = (ProcessTemplateNodeEmail)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)processTemplateNodeEmailDto, ProcessTemplateNodeEmail.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        processTemplateNodeEmail.setTenantCode(TenantUtils.getTenantCode());
        this.processTemplateNodeEmailRepository.saveOrUpdate((Object)processTemplateNodeEmail);
        ProcessTemplateNodeEmailVo processTemplateNodeEmailVo = (ProcessTemplateNodeEmailVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)processTemplateNodeEmail, ProcessTemplateNodeEmailVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        processTemplateNodeEmailVo.setId(processTemplateNodeEmail.getId());
        Collection processTemplateNodeEmailFilesDtos = processTemplateNodeEmailDto.getProcessTemplateNodeEmailFiles();
        if (!CollectionUtils.isEmpty((Collection)processTemplateNodeEmailFilesDtos)) {
            processTemplateNodeEmailFilesDtos.forEach(item -> {
                item.setTenantCode(TenantUtils.getTenantCode());
                item.setTemplateId(processTemplateNodeEmailVo.getTemplateId());
                item.setNodeId(processTemplateNodeEmailVo.getNodeId());
                item.setNodeEmailId(processTemplateNodeEmailVo.getId());
            });
            List<ProcessTemplateNodeEmailFilesVo> processTemplateNodeEmailFilesVos = this.processTemplateNodeEmailFilesService.createBatch(processTemplateNodeEmailFilesDtos);
            processTemplateNodeEmailVo.setProcessTemplateNodeEmailFiles(processTemplateNodeEmailFilesVos);
        }
        return processTemplateNodeEmailVo;
    }

    @Override
    @Transactional
    public void delete(Collection<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<ProcessTemplateNodeEmail> processTemplateNodeEmails = this.processTemplateNodeEmailRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(processTemplateNodeEmails)) {
            return;
        }
        processTemplateNodeEmails.forEach(item -> this.processTemplateNodeEmailFilesService.findByNodeEmailId(item.getId()));
        this.processTemplateNodeEmailRepository.removeByIdsAndTenantCode(ids, TenantUtils.getTenantCode());
    }

    @Override
    @Transactional
    public void deleteByNodeId(String nodeId) {
        ProcessTemplateNodeEmailVo processTemplateNodeEmailVo = this.findByNodeId(nodeId);
        this.processTemplateNodeEmailFilesService.findByNodeEmailId(processTemplateNodeEmailVo.getId());
        this.processTemplateNodeEmailRepository.deleteByNodeId(nodeId);
    }

    private void createValidate(ProcessTemplateNodeEmailDto processTemplateNodeEmailDto) {
        Validate.notNull((Object)processTemplateNodeEmailDto, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        processTemplateNodeEmailDto.setId(null);
        processTemplateNodeEmailDto.setFromUser(this.mailUserName);
        Validate.notBlank((CharSequence)processTemplateNodeEmailDto.getTemplateId(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d41\u7a0b\u6a21\u677f\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processTemplateNodeEmailDto.getNodeId(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d41\u7a0b\u8282\u70b9\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processTemplateNodeEmailDto.getFromUser(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u53d1\u4ef6\u4eba\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processTemplateNodeEmailDto.getToUser(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6536\u4ef6\u4eba\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processTemplateNodeEmailDto.getSubject(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u4e3b\u9898\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processTemplateNodeEmailDto.getContent(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private void fillDetail(ProcessTemplateNodeEmailVo processTemplateNodeEmailVo) {
        List<ProcessTemplateNodeEmailFilesVo> processTemplateNodeEmailFilesVos = this.processTemplateNodeEmailFilesService.findByNodeEmailId(processTemplateNodeEmailVo.getId());
        processTemplateNodeEmailVo.setProcessTemplateNodeEmailFiles(processTemplateNodeEmailFilesVos);
    }
}

