/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.service.internal;

import com.biz.crm.workflow.local.entity.ProcessTemplateNodeEndTask;
import com.biz.crm.workflow.local.repository.ProcessTemplateNodeEndTaskRepository;
import com.biz.crm.workflow.local.service.ProcessTemplateNodeEndTaskService;
import com.biz.crm.workflow.sdk.dto.ProcessTemplateNodeEndTaskDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Collection;
import java.util.List;
import javax.transaction.Transactional;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ProcessTemplateNodeEndTaskServiceImpl
implements ProcessTemplateNodeEndTaskService {
    @Autowired(required=false)
    private ProcessTemplateNodeEndTaskRepository processTemplateNodeEndTaskRepository;

    @Override
    public List<ProcessTemplateNodeEndTask> findByTemplateId(String templateId) {
        Validate.notNull((Object)templateId, (String)"\u67e5\u8be2\u7ed3\u675f\u8282\u70b9\u6570\u636e\u65f6\uff0c\u6a21\u677fid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        return this.processTemplateNodeEndTaskRepository.findByTemplateId(templateId);
    }

    @Override
    public List<ProcessTemplateNodeEndTask> findByTemplateIds(Collection<String> templateIds) {
        Validate.notNull(templateIds, (String)"\u67e5\u8be2\u7ed3\u675f\u8282\u70b9\u6570\u636e\u65f6\uff0c\u6a21\u677fid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        return this.processTemplateNodeEndTaskRepository.findByTemplateIds(templateIds);
    }

    @Override
    @Transactional
    public boolean deleteByTemplateId(String templateId) {
        Validate.notNull((Object)templateId, (String)"\u67e5\u8be2\u7ed3\u675f\u8282\u70b9\u6570\u636e\u65f6\uff0c\u6a21\u677fid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<ProcessTemplateNodeEndTask> processTemplateNodeEndTasks = this.processTemplateNodeEndTaskRepository.findByTemplateId(templateId);
        if (CollectionUtils.isEmpty(processTemplateNodeEndTasks)) {
            return false;
        }
        return this.processTemplateNodeEndTaskRepository.deleteByTemplateId(templateId);
    }

    @Override
    @Transactional
    public void deleteByIds(Collection<String> ids, String tenantCode) {
        Validate.notNull(ids, (String)"\u67e5\u8be2\u7ed3\u675f\u8282\u70b9\u6570\u636e\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<ProcessTemplateNodeEndTask> processTemplateNodeEndTasks = this.processTemplateNodeEndTaskRepository.findByIds(ids);
        if (!CollectionUtils.isEmpty(processTemplateNodeEndTasks)) {
            this.processTemplateNodeEndTaskRepository.deleteByIds(ids, tenantCode);
        }
    }

    @Override
    @Transactional
    public void create(ProcessTemplateNodeEndTaskDto dto) {
        this.createValidate(dto);
        ProcessTemplateNodeEndTask processTemplateNodeEndTask = new ProcessTemplateNodeEndTask();
        processTemplateNodeEndTask.setNodeId(dto.getNodeId());
        processTemplateNodeEndTask.setTemplateId(dto.getTemplateId());
        processTemplateNodeEndTask.setTenantCode(TenantUtils.getTenantCode());
        processTemplateNodeEndTask.setCopyOptional(dto.getCopyOptional());
        this.processTemplateNodeEndTaskRepository.saveOrUpdate((Object)processTemplateNodeEndTask);
    }

    @Override
    @Transactional
    public void deleteByNodeIds(List<String> nodeIds) {
        Validate.notNull(nodeIds, (String)"\u5220\u9664\u6d41\u7a0b\u7ed3\u675f\u8282\u70b9\u914d\u7f6e\u4fe1\u606f\u65f6\u8282\u70b9id\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.processTemplateNodeEndTaskRepository.deleteByNodeIds(nodeIds);
    }

    @Override
    public ProcessTemplateNodeEndTask findByNodeId(String nodeId) {
        Validate.notNull((Object)nodeId, (String)"\u67e5\u8be2\u7ed3\u675f\u8282\u70b9\u6570\u636e\u65f6\uff0c\u8282\u70b9id\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        return this.processTemplateNodeEndTaskRepository.findByNodeId(nodeId);
    }

    private void createValidate(ProcessTemplateNodeEndTaskDto dto) {
        Validate.notNull((Object)dto, (String)"\u65b0\u589e\u65f6\u53c2\u6570dto\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getNodeId(), (String)"\u65b0\u589e\u65f6\u6d41\u7a0b\u8282\u70b9\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getTemplateId(), (String)"\u65b0\u589e\u65f6\u6d41\u7a0b\u6a21\u677f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }
}

