/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.workflow.local.entity.ProcessInstanceEntity;
import com.biz.crm.workflow.local.entity.ProcessTemplateNode;
import com.biz.crm.workflow.local.repository.ProcessTemplateNodeRepository;
import com.biz.crm.workflow.local.service.ProcessInstanceService;
import com.biz.crm.workflow.sdk.dto.ProcessTemplateNodeDto;
import com.biz.crm.workflow.sdk.register.ProcessTemplateRegister;
import com.biz.crm.workflow.sdk.service.ProcessTemplateNodeService;
import com.biz.crm.workflow.sdk.service.process.ProcessNode;
import com.biz.crm.workflow.sdk.service.process.ProcessNodeGroup;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateNodeVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.transaction.Transactional;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.flowable.engine.HistoryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="processTemplateNodeService")
public class ProcessTemplateNodeServiceImpl
implements ProcessTemplateNodeService {
    @Autowired
    private ProcessTemplateNodeRepository processTemplateNodeRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private ProcessTemplateRegister processTemplateRegister;
    @Autowired
    private ProcessInstanceService processInstanceService;
    @Autowired
    private HistoryService historyService;
    @Autowired(required=false)
    private ApplicationContext ac;
    private static List<ProcessNode> processNodes = Lists.newArrayList();

    public Page<ProcessTemplateNodeVo> findByConditions(Pageable pageable, ProcessTemplateNodeDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(dto)) {
            dto = new ProcessTemplateNodeDto();
        }
        return this.processTemplateNodeRepository.findByConditions(pageable, dto);
    }

    public ProcessTemplateNodeVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        ProcessTemplateNode processTemplateNode = this.processTemplateNodeRepository.findByIdAndTenantCode(id, TenantUtils.getTenantCode());
        if (processTemplateNode == null) {
            return null;
        }
        ProcessTemplateNodeVo processTemplateNodeVo = (ProcessTemplateNodeVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)processTemplateNode, ProcessTemplateNodeVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.extendSelectHandle(processTemplateNodeVo);
        return processTemplateNodeVo;
    }

    public List<ProcessTemplateNodeVo> findByIds(Collection<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        List<ProcessTemplateNode> processTemplateNodes = this.processTemplateNodeRepository.findByIds(ids);
        Collection processTemplateNodeVos = this.nebulaToolkitService.copyCollectionByWhiteList(processTemplateNodes, ProcessTemplateNode.class, ProcessTemplateNodeVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        processTemplateNodeVos.forEach(this::extendSelectHandle);
        return Lists.newArrayList((Iterable)processTemplateNodeVos);
    }

    @Transactional
    public ProcessTemplateNodeVo create(ProcessTemplateNodeDto processTemplateNodeDto) {
        this.createValidate(processTemplateNodeDto);
        ProcessTemplateNode processTemplateNode = (ProcessTemplateNode)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)processTemplateNodeDto, ProcessTemplateNode.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        processTemplateNode.setTenantCode(TenantUtils.getTenantCode());
        this.processTemplateNodeRepository.saveOrUpdate((Object)processTemplateNode);
        ProcessTemplateNodeVo processTemplateNodeVo = (ProcessTemplateNodeVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)processTemplateNode, ProcessTemplateNodeVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        processTemplateNodeVo.setId(processTemplateNode.getId());
        processTemplateNodeDto.setId(processTemplateNode.getId());
        this.extendSaveHandle(processTemplateNodeDto);
        this.extendSelectHandle(processTemplateNodeVo);
        return processTemplateNodeVo;
    }

    @Transactional
    public List<ProcessTemplateNodeVo> createBatch(Collection<ProcessTemplateNodeDto> processTemplateNodeDtos) {
        if (CollectionUtils.isEmpty(processTemplateNodeDtos)) {
            return Lists.newArrayList();
        }
        ArrayList processTemplateNodeVos = Lists.newArrayList();
        for (ProcessTemplateNodeDto processTemplateNodeDto : processTemplateNodeDtos) {
            ProcessTemplateNodeVo processTemplateNodeVo = this.create(processTemplateNodeDto);
            processTemplateNodeVos.add(processTemplateNodeVo);
        }
        return processTemplateNodeVos;
    }

    @Transactional
    public void delete(Collection<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<ProcessTemplateNode> processTemplateNodes = this.processTemplateNodeRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(processTemplateNodes)) {
            return;
        }
        Collection processTemplateNodeVos = this.nebulaToolkitService.copyCollectionByWhiteList(processTemplateNodes, ProcessTemplateNode.class, ProcessTemplateNodeVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.processTemplateNodeRepository.removeByIdsAndTenantCode(ids, TenantUtils.getTenantCode());
    }

    @Transactional
    public void deleteByTemplateId(String templateId) {
        List<ProcessTemplateNodeVo> processTemplateNodeVos = this.findByTemplateId(templateId);
        if (CollectionUtils.isEmpty(processTemplateNodeVos)) {
            return;
        }
        Collection processTemplateNodeDtos = this.nebulaToolkitService.copyCollectionByWhiteList(processTemplateNodeVos, ProcessTemplateNodeVo.class, ProcessTemplateNodeDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.processTemplateNodeRepository.deleteByTemplateId(templateId);
        for (ProcessTemplateNodeDto processTemplateNodeDto : processTemplateNodeDtos) {
            this.extendRemoveHandle(processTemplateNodeDto);
        }
    }

    public List<ProcessTemplateNodeVo> findByTemplateId(String templateId) {
        List<ProcessTemplateNode> processTemplateNodes = this.processTemplateNodeRepository.findByTemplateId(templateId);
        Collection processTemplateNodeVos = this.nebulaToolkitService.copyCollectionByWhiteList(processTemplateNodes, ProcessTemplateNode.class, ProcessTemplateNodeVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        processTemplateNodeVos.forEach(this::extendSelectHandle);
        return Lists.newArrayList((Iterable)processTemplateNodeVos);
    }

    public ProcessTemplateNodeVo findByTemplateIdAndTaskId(String templateId, String taskId) {
        ProcessTemplateNode processTemplateNode = this.processTemplateNodeRepository.findByTemplateIdAndTaskId(templateId, taskId);
        if (processTemplateNode == null) {
            return null;
        }
        ProcessTemplateNodeVo processTemplateNodeVo = (ProcessTemplateNodeVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)processTemplateNode, ProcessTemplateNodeVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.extendSelectHandle(processTemplateNodeVo);
        return processTemplateNodeVo;
    }

    public List<ProcessTemplateNodeVo> findByProcessDefinitionId(String processDefinitionId) {
        List<ProcessTemplateNode> processTemplateNodes = this.processTemplateNodeRepository.findByProcessDefinitionId(processDefinitionId);
        Collection processTemplateNodeVos = this.nebulaToolkitService.copyCollectionByWhiteList(processTemplateNodes, ProcessTemplateNode.class, ProcessTemplateNodeVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        processTemplateNodeVos.forEach(this::extendSelectHandle);
        return Lists.newArrayList((Iterable)processTemplateNodeVos);
    }

    public List<ProcessTemplateNodeVo> findByProcessInstanceId(String processInstanceId) {
        ProcessInstanceEntity processInstanceEntity = this.processInstanceService.findByProcessInstanceId(processInstanceId);
        return this.findByTemplateId(processInstanceEntity.getProcessTemplateId());
    }

    public ProcessTemplateNodeVo findByProcessDefinitionIdAndTaskDefinitionKey(String processDefinitionId, String taskDefinitionKey) {
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{processDefinitionId, taskDefinitionKey})) {
            return null;
        }
        ProcessTemplateNode processTemplateNode = this.processTemplateNodeRepository.findByProcessDefinitionIdAndTaskId(processDefinitionId, taskDefinitionKey);
        Validate.notNull((Object)((Object)processTemplateNode), (String)"\u8282\u70b9\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        ProcessTemplateNodeVo processTemplateNodeVo = (ProcessTemplateNodeVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)processTemplateNode, ProcessTemplateNodeVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return processTemplateNodeVo;
    }

    public ProcessTemplateNodeVo findByProcessInstanceIdAndTaskDefinitionKey(String processInstanceId, String taskDefinitionKey) {
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{processInstanceId, taskDefinitionKey})) {
            return null;
        }
        ProcessTemplateNode processTemplateNode = this.processTemplateNodeRepository.findByProcessProcessInstanceIdAndTaskId(processInstanceId, taskDefinitionKey);
        if (ObjectUtils.isEmpty((Object)((Object)processTemplateNode))) {
            return null;
        }
        ProcessTemplateNodeVo processTemplateNodeVo = (ProcessTemplateNodeVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)processTemplateNode, ProcessTemplateNodeVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return processTemplateNodeVo;
    }

    public List<ProcessTemplateNodeVo> findByTemplateIds(Collection<String> templateIds) {
        List<ProcessTemplateNode> processTemplateNodes = this.processTemplateNodeRepository.findByTemplateIds(templateIds);
        Collection processTemplateNodeVos = this.nebulaToolkitService.copyCollectionByWhiteList(processTemplateNodes, ProcessTemplateNode.class, ProcessTemplateNodeVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)processTemplateNodeVos);
    }

    private void createValidate(ProcessTemplateNodeDto processTemplateNodeDto) {
        processTemplateNodeDto.setId(null);
        Validate.notNull((Object)processTemplateNodeDto, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processTemplateNodeDto.getProcessTaskId(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d41\u7a0b\u4efb\u52a1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private void extendSaveHandle(ProcessTemplateNodeDto nodeDto) {
        ProcessNode processNode = this.getCurrentProcessNode(nodeDto.getCode());
        if (processNode != null) {
            processNode.onSaveHandle(nodeDto);
        }
    }

    private void extendSelectHandle(ProcessTemplateNodeVo nodeVo) {
        ProcessNode processNode = this.getCurrentProcessNode(nodeVo.getCode());
        if (processNode != null) {
            processNode.onRequestHandle(nodeVo);
        }
    }

    private void extendRemoveHandle(ProcessTemplateNodeDto nodeDto) {
        ProcessNode processNode = this.getCurrentProcessNode(nodeDto.getCode());
        if (processNode != null) {
            processNode.onRemoveHandle(nodeDto.getId());
        }
    }

    private ProcessNode getCurrentProcessNode(String nodeCode) {
        if (StringUtils.isBlank((CharSequence)nodeCode)) {
            return null;
        }
        Collection processNodeGroups = this.processTemplateRegister.getProcessNodeGroups();
        if (CollectionUtils.isEmpty(processNodes)) {
            ArrayList nodeGroups = Lists.newArrayList();
            processNodeGroups.forEach(clazz -> {
                ProcessNodeGroup processNodeGroup = (ProcessNodeGroup)this.ac.getBean(clazz);
                if (processNodeGroup != null) {
                    nodeGroups.add(processNodeGroup);
                }
            });
            nodeGroups.stream().forEach(item -> processNodes.addAll(item.getProcessNodes()));
        }
        if (!CollectionUtils.isEmpty(processNodes)) {
            Optional<ProcessNode> op = processNodes.stream().filter(item -> item.getCode().equals(nodeCode)).findFirst();
            return op.orElse(null);
        }
        return null;
    }

    private ProcessNode findCurrentProcessNode(String code) {
        if (CollectionUtils.isEmpty(processNodes)) {
            return null;
        }
        return processNodes.stream().filter(item -> item.getCode().equals(code)).findFirst().orElse(null);
    }
}

