/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.workflow.local.entity.ProcessTemplateNodeSms;
import com.biz.crm.workflow.local.repository.ProcessTemplateNodeSmsRepository;
import com.biz.crm.workflow.local.service.ProcessTemplateNodeSmsService;
import com.biz.crm.workflow.local.service.ProcessTemplateNodeSmsUserService;
import com.biz.crm.workflow.sdk.dto.ProcessTemplateNodeSmsDto;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateNodeSmsUserVo;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateNodeSmsVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import javax.transaction.Transactional;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ProcessTemplateNodeSmsServiceImpl
implements ProcessTemplateNodeSmsService {
    @Autowired
    private ProcessTemplateNodeSmsRepository processTemplateNodeSmsRepository;
    @Autowired
    private ProcessTemplateNodeSmsUserService processTemplateNodeSmsUserService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public Page<ProcessTemplateNodeSmsVo> findByConditions(Pageable pageable, ProcessTemplateNodeSmsDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(dto)) {
            dto = new ProcessTemplateNodeSmsDto();
        }
        return this.processTemplateNodeSmsRepository.findByConditions(pageable, dto);
    }

    @Override
    public ProcessTemplateNodeSmsVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        ProcessTemplateNodeSms processTemplateNodeSms = this.processTemplateNodeSmsRepository.findByIdAndTenantCode(id, TenantUtils.getTenantCode());
        if (processTemplateNodeSms == null) {
            return null;
        }
        ProcessTemplateNodeSmsVo processTemplateNodeSmsVo = (ProcessTemplateNodeSmsVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)processTemplateNodeSms, ProcessTemplateNodeSmsVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.fillDetail(processTemplateNodeSmsVo);
        return processTemplateNodeSmsVo;
    }

    @Override
    public List<ProcessTemplateNodeSmsVo> findByIds(Collection<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        List<ProcessTemplateNodeSms> processTemplateNodeSmss = this.processTemplateNodeSmsRepository.findByIds(ids);
        Collection processTemplateNodeSmsVos = this.nebulaToolkitService.copyCollectionByWhiteList(processTemplateNodeSmss, ProcessTemplateNodeSms.class, ProcessTemplateNodeSmsVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        processTemplateNodeSmsVos.forEach(item -> this.fillDetail((ProcessTemplateNodeSmsVo)item));
        return Lists.newArrayList((Iterable)processTemplateNodeSmsVos);
    }

    @Override
    public ProcessTemplateNodeSmsVo findByNodeId(String nodeId) {
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            return null;
        }
        ProcessTemplateNodeSms processTemplateNodeSms = this.processTemplateNodeSmsRepository.findByNodeId(nodeId);
        if (processTemplateNodeSms == null) {
            return null;
        }
        ProcessTemplateNodeSmsVo processTemplateNodeSmsVo = (ProcessTemplateNodeSmsVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)processTemplateNodeSms, ProcessTemplateNodeSmsVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.fillDetail(processTemplateNodeSmsVo);
        return processTemplateNodeSmsVo;
    }

    @Override
    @Transactional
    public ProcessTemplateNodeSmsVo create(ProcessTemplateNodeSmsDto processTemplateNodeSmsDto) {
        this.createValidate(processTemplateNodeSmsDto);
        ProcessTemplateNodeSms processTemplateNodeSms = (ProcessTemplateNodeSms)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)processTemplateNodeSmsDto, ProcessTemplateNodeSms.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        processTemplateNodeSms.setTenantCode(TenantUtils.getTenantCode());
        this.processTemplateNodeSmsRepository.saveOrUpdate((Object)processTemplateNodeSms);
        ProcessTemplateNodeSmsVo processTemplateNodeSmsVo = (ProcessTemplateNodeSmsVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)processTemplateNodeSms, ProcessTemplateNodeSmsVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        processTemplateNodeSmsVo.setId(processTemplateNodeSms.getId());
        Collection processTemplateNodeSmsUserDtos = processTemplateNodeSmsDto.getProcessTemplateNodeSmsUsers();
        if (!CollectionUtils.isEmpty((Collection)processTemplateNodeSmsUserDtos)) {
            processTemplateNodeSmsUserDtos.forEach(item -> {
                item.setTenantCode(TenantUtils.getTenantCode());
                item.setTemplateId(processTemplateNodeSmsVo.getTemplateId());
                item.setNodeId(processTemplateNodeSmsVo.getNodeId());
                item.setNodeSmsId(processTemplateNodeSmsVo.getId());
                item.setToUserType(processTemplateNodeSmsVo.getToUserType());
            });
            List<ProcessTemplateNodeSmsUserVo> processTemplateNodeSmsUserVos = this.processTemplateNodeSmsUserService.createBatch(processTemplateNodeSmsUserDtos);
            processTemplateNodeSmsVo.setProcessTemplateNodeSmsUsers(processTemplateNodeSmsUserVos);
        }
        return processTemplateNodeSmsVo;
    }

    @Override
    @Transactional
    public void delete(Collection<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<ProcessTemplateNodeSms> processTemplateNodeSmss = this.processTemplateNodeSmsRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(processTemplateNodeSmss)) {
            return;
        }
        this.processTemplateNodeSmsRepository.removeByIdsAndTenantCode(ids, TenantUtils.getTenantCode());
    }

    @Override
    @Transactional
    public void deleteByNodeId(String nodeId) {
        this.processTemplateNodeSmsRepository.deleteByNodeId(nodeId);
    }

    private void createValidate(ProcessTemplateNodeSmsDto processTemplateNodeSmsDto) {
        Validate.notNull((Object)processTemplateNodeSmsDto, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        processTemplateNodeSmsDto.setId(null);
        Validate.notBlank((CharSequence)processTemplateNodeSmsDto.getTemplateId(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d41\u7a0b\u6a21\u677f\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processTemplateNodeSmsDto.getToUserType(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d41\u7a0b\u8282\u70b9\u6536\u4ef6\u4eba\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processTemplateNodeSmsDto.getSmsTemplateCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u77ed\u4fe1\u6a21\u677f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processTemplateNodeSmsDto.getContent(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private void fillDetail(ProcessTemplateNodeSmsVo processTemplateNodeSmsVo) {
        List<ProcessTemplateNodeSmsUserVo> processTemplateNodeSmsUserVos = this.processTemplateNodeSmsUserService.findByNodeSmsId(processTemplateNodeSmsVo.getId());
        processTemplateNodeSmsVo.setProcessTemplateNodeSmsUsers(processTemplateNodeSmsUserVos);
    }
}

