/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.workflow.local.entity.ProcessTemplateNodeUserTask;
import com.biz.crm.workflow.local.repository.ProcessTemplateNodeUserTaskRepository;
import com.biz.crm.workflow.local.service.ProcessCanEditService;
import com.biz.crm.workflow.local.service.ProcessCopyConfigService;
import com.biz.crm.workflow.local.service.ProcessTaskButtonService;
import com.biz.crm.workflow.local.service.ProcessTaskCopyStrategyService;
import com.biz.crm.workflow.local.service.ProcessTaskIndicatorsService;
import com.biz.crm.workflow.local.service.ProcessTemplateNodeAssigneeService;
import com.biz.crm.workflow.local.service.ProcessTemplateNodeUserTaskService;
import com.biz.crm.workflow.sdk.dto.ProcessTaskCanEditDto;
import com.biz.crm.workflow.sdk.dto.ProcessTemplateNodeUserTaskDto;
import com.biz.crm.workflow.sdk.enums.ProcessCopyEnum;
import com.biz.crm.workflow.sdk.vo.ProcessTaskButtonVo;
import com.biz.crm.workflow.sdk.vo.ProcessTaskCanEditVo;
import com.biz.crm.workflow.sdk.vo.ProcessTaskCopyConfigVo;
import com.biz.crm.workflow.sdk.vo.ProcessTaskCopyStrategyVo;
import com.biz.crm.workflow.sdk.vo.ProcessTaskIndicatorsVo;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateNodeAssigneeVo;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateNodeUserTaskVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="processTemplateNodeUserTaskService")
public class ProcessTemplateNodeUserTaskServiceImpl
implements ProcessTemplateNodeUserTaskService {
    @Autowired
    private ProcessTemplateNodeUserTaskRepository processTemplateNodeUserTaskRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private ProcessTemplateNodeAssigneeService processTemplateNodeAssigneeService;
    @Autowired
    private ProcessTaskButtonService processTaskButtonService;
    @Autowired
    private ProcessCopyConfigService processCopyConfigService;
    @Autowired
    private ProcessTaskCopyStrategyService processTaskCopyStrategyService;
    @Autowired
    private ProcessTaskIndicatorsService processTaskIndicatorsService;
    @Autowired
    private ProcessCanEditService processCanEditService;

    @Override
    public Page<ProcessTemplateNodeUserTaskVo> findByConditions(Pageable pageable, ProcessTemplateNodeUserTaskDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(dto)) {
            dto = new ProcessTemplateNodeUserTaskDto();
        }
        return this.processTemplateNodeUserTaskRepository.findByConditions(pageable, dto);
    }

    @Override
    public ProcessTemplateNodeUserTaskVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        ProcessTemplateNodeUserTask processTemplateNodeUserTask = this.processTemplateNodeUserTaskRepository.findByIdAndTenantCode(id, TenantUtils.getTenantCode());
        if (processTemplateNodeUserTask == null) {
            return null;
        }
        ProcessTemplateNodeUserTaskVo processTemplateNodeUserTaskVo = (ProcessTemplateNodeUserTaskVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)processTemplateNodeUserTask, ProcessTemplateNodeUserTaskVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return processTemplateNodeUserTaskVo;
    }

    @Override
    public List<ProcessTemplateNodeUserTaskVo> findByIds(Collection<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        List<ProcessTemplateNodeUserTask> processTemplateNodeUserTasks = this.processTemplateNodeUserTaskRepository.findByIds(ids);
        Collection processTemplateNodeUserTaskVos = this.nebulaToolkitService.copyCollectionByWhiteList(processTemplateNodeUserTasks, ProcessTemplateNodeUserTask.class, ProcessTemplateNodeUserTaskVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)processTemplateNodeUserTaskVos);
    }

    @Override
    public List<ProcessTemplateNodeUserTaskVo> findByTemplateId(String templateId) {
        if (StringUtils.isBlank((CharSequence)templateId)) {
            return null;
        }
        List<ProcessTemplateNodeUserTask> processTemplateNodeUserTasks = this.processTemplateNodeUserTaskRepository.findByTemplateId(templateId);
        if (CollectionUtils.isEmpty(processTemplateNodeUserTasks)) {
            return Collections.emptyList();
        }
        Collection processTemplateNodeUserTaskVos = this.nebulaToolkitService.copyCollectionByWhiteList(processTemplateNodeUserTasks, ProcessTemplateNodeUserTask.class, ProcessTemplateNodeUserTaskVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)processTemplateNodeUserTaskVos);
    }

    @Override
    public List<ProcessTemplateNodeUserTaskVo> findByTemplateIds(Collection<String> templateIds) {
        if (CollectionUtils.isEmpty(templateIds)) {
            return Collections.emptyList();
        }
        List<ProcessTemplateNodeUserTask> processTemplateNodeUserTasks = this.processTemplateNodeUserTaskRepository.findByTemplateIds(templateIds);
        if (CollectionUtils.isEmpty(processTemplateNodeUserTasks)) {
            return Collections.emptyList();
        }
        Collection processTemplateNodeUserTaskVos = this.nebulaToolkitService.copyCollectionByWhiteList(processTemplateNodeUserTasks, ProcessTemplateNodeUserTask.class, ProcessTemplateNodeUserTaskVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)processTemplateNodeUserTaskVos);
    }

    @Override
    public ProcessTemplateNodeUserTaskVo findByNodeId(String nodeId) {
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            return null;
        }
        ProcessTemplateNodeUserTask processTemplateNodeUserTask = this.processTemplateNodeUserTaskRepository.findByNodeId(nodeId);
        if (processTemplateNodeUserTask == null) {
            return null;
        }
        ProcessTemplateNodeUserTaskVo processTemplateNodeUserTaskVo = (ProcessTemplateNodeUserTaskVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)processTemplateNodeUserTask, ProcessTemplateNodeUserTaskVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        processTemplateNodeUserTaskVo.setProcessTemplateNodeAssignees(this.processTemplateNodeAssigneeService.findByNodeId(nodeId));
        processTemplateNodeUserTaskVo.setProcessTaskButtons(this.processTaskButtonService.findByNodeId(nodeId));
        List<ProcessTaskCopyConfigVo> processTaskCopyConfigVos = this.processCopyConfigService.findByNodeId(nodeId);
        processTemplateNodeUserTaskVo.setProcessTaskCopyConfigs(processTaskCopyConfigVos);
        processTemplateNodeUserTaskVo.setProcessTaskCopyStrategy(this.processTaskCopyStrategyService.findByNodeId(nodeId));
        processTemplateNodeUserTaskVo.setProcessTaskIndicators(this.processTaskIndicatorsService.findByTaskNodeId(nodeId));
        if (!CollectionUtils.isEmpty(processTaskCopyConfigVos)) {
            processTemplateNodeUserTaskVo.setCopyOptional(ProcessCopyEnum.COPY_OPTIONAL.getDictCode());
        }
        ProcessTaskCanEditVo processTaskCanEditVo = this.processCanEditService.findByTaskNodeId(nodeId);
        ArrayList<String> processTaskEditFields = new ArrayList<String>();
        if (ObjectUtils.isNotEmpty((Object)processTaskCanEditVo)) {
            String[] canEditFields;
            for (String field : canEditFields = processTaskCanEditVo.getCanEditField().split(",")) {
                processTaskEditFields.add(field);
            }
            processTemplateNodeUserTaskVo.setProcessTaskEditFields(processTaskEditFields);
        } else {
            processTemplateNodeUserTaskVo.setProcessTaskEditFields(processTaskEditFields);
        }
        return processTemplateNodeUserTaskVo;
    }

    @Override
    public List<ProcessTemplateNodeUserTaskVo> findByNodeIds(Collection<String> nodeIds) {
        if (CollectionUtils.isEmpty(nodeIds)) {
            return Collections.emptyList();
        }
        List<ProcessTemplateNodeUserTask> processTemplateNodeUserTasks = this.processTemplateNodeUserTaskRepository.findByNodeIds(nodeIds);
        if (CollectionUtils.isEmpty(processTemplateNodeUserTasks)) {
            return Collections.emptyList();
        }
        Collection processTemplateNodeUserTaskVos = this.nebulaToolkitService.copyCollectionByWhiteList(processTemplateNodeUserTasks, ProcessTemplateNodeUserTask.class, ProcessTemplateNodeUserTaskVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)processTemplateNodeUserTaskVos);
    }

    @Override
    @Transactional
    public ProcessTemplateNodeUserTaskVo create(ProcessTemplateNodeUserTaskDto processTemplateNodeUserTaskDto) {
        Collection processTaskEditFields;
        this.createValidate(processTemplateNodeUserTaskDto);
        ProcessTemplateNodeUserTask processTemplateNodeUserTask = (ProcessTemplateNodeUserTask)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)processTemplateNodeUserTaskDto, ProcessTemplateNodeUserTask.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        processTemplateNodeUserTask.setTenantCode(TenantUtils.getTenantCode());
        this.processTemplateNodeUserTaskRepository.saveOrUpdate((Object)processTemplateNodeUserTask);
        ProcessTemplateNodeUserTaskVo processTemplateNodeUserTaskVo = (ProcessTemplateNodeUserTaskVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)processTemplateNodeUserTask, ProcessTemplateNodeUserTaskVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        processTemplateNodeUserTaskVo.setId(processTemplateNodeUserTask.getId());
        Collection processTemplateNodeAssignees = processTemplateNodeUserTaskDto.getProcessTemplateNodeAssignees();
        processTemplateNodeAssignees.forEach(item -> {
            item.setNodeId(processTemplateNodeUserTaskDto.getNodeId());
            item.setTemplateId(processTemplateNodeUserTaskDto.getTemplateId());
            item.setTenantCode(TenantUtils.getTenantCode());
        });
        List<ProcessTemplateNodeAssigneeVo> processTemplateNodeAssigneeVos = this.processTemplateNodeAssigneeService.createBatch(processTemplateNodeAssignees);
        processTemplateNodeUserTaskVo.setProcessTemplateNodeAssignees(processTemplateNodeAssigneeVos);
        Collection processTaskButtons = processTemplateNodeUserTaskDto.getProcessTaskButtons();
        processTaskButtons.forEach(processTaskButton -> {
            processTaskButton.setTaskNodeId(processTemplateNodeUserTaskDto.getNodeId());
            processTaskButton.setTenantCode(TenantUtils.getTenantCode());
        });
        List<ProcessTaskButtonVo> processTaskButtonVos = this.processTaskButtonService.createBatch(processTaskButtons);
        processTemplateNodeUserTaskVo.setProcessTaskButtons(processTaskButtonVos);
        if (Objects.equals(processTemplateNodeUserTaskDto.getCopyOptional(), ProcessCopyEnum.COPY_OPTIONAL.getDictCode()) || StringUtils.isBlank((CharSequence)processTemplateNodeUserTaskDto.getCopyOptional())) {
            Collection processTaskCopyConfigs = processTemplateNodeUserTaskDto.getProcessTaskCopyConfigs();
            processTaskCopyConfigs.forEach(config -> {
                config.setTaskNodeId(processTemplateNodeUserTaskDto.getNodeId());
                config.setTenantCode(TenantUtils.getTenantCode());
            });
            List<ProcessTaskCopyConfigVo> configVos = this.processCopyConfigService.createBatch(processTaskCopyConfigs);
            processTemplateNodeUserTaskVo.setProcessTaskCopyConfigs(configVos);
        } else {
            Collection processTaskCopyStrategy = processTemplateNodeUserTaskDto.getProcessTaskCopyStrategy();
            processTaskCopyStrategy.forEach(processTaskCopy -> {
                processTaskCopy.setNodeId(processTemplateNodeUserTaskDto.getNodeId());
                processTaskCopy.setTenantCode(TenantUtils.getTenantCode());
                processTaskCopy.setTemplateId(processTemplateNodeUserTaskDto.getTemplateId());
            });
            List<ProcessTaskCopyStrategyVo> processTaskCopyStrategyVos = this.processTaskCopyStrategyService.createBatch(processTaskCopyStrategy);
            processTemplateNodeUserTaskVo.setProcessTaskCopyStrategy(processTaskCopyStrategyVos);
        }
        Collection processTaskIndicators = processTemplateNodeUserTaskDto.getProcessTaskIndicators();
        processTaskIndicators.forEach(indicators -> {
            indicators.setTaskNodeId(processTemplateNodeUserTaskDto.getNodeId());
            indicators.setTenantCode(TenantUtils.getTenantCode());
        });
        List<ProcessTaskIndicatorsVo> indicatorsVos = this.processTaskIndicatorsService.createBatch(processTaskIndicators);
        processTemplateNodeUserTaskVo.setProcessTaskIndicators(indicatorsVos);
        if (processTemplateNodeUserTaskDto.getCanEdit().equals(true) && !CollectionUtils.isEmpty((Collection)(processTaskEditFields = processTemplateNodeUserTaskDto.getProcessTaskEditFields()))) {
            ProcessTaskCanEditDto processTaskCanEditDto = new ProcessTaskCanEditDto();
            processTaskCanEditDto.setTaskNodeId(processTemplateNodeUserTaskDto.getNodeId());
            processTaskCanEditDto.setTenantCode(TenantUtils.getTenantCode());
            StringBuffer stringBuffer = new StringBuffer();
            processTaskEditFields.forEach(processTaskEditField -> stringBuffer.append(",").append((String)processTaskEditField));
            String editFields = stringBuffer.deleteCharAt(0).toString();
            processTaskCanEditDto.setCanEditField(editFields);
            ProcessTaskCanEditVo processTaskCanEditVo = this.processCanEditService.create(processTaskCanEditDto);
            if (ObjectUtils.isNotEmpty((Object)processTaskCanEditVo)) {
                String[] canEditFields;
                ArrayList<String> processTaskCanEdits = new ArrayList<String>();
                for (String canEditField : canEditFields = processTaskCanEditVo.getCanEditField().split(",")) {
                    processTaskCanEdits.add(canEditField);
                }
                processTemplateNodeUserTaskVo.setProcessTaskEditFields(processTaskCanEdits);
            }
        }
        return processTemplateNodeUserTaskVo;
    }

    @Override
    @Transactional
    public void delete(Collection<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<ProcessTemplateNodeUserTask> processTemplateNodeUserTasks = this.processTemplateNodeUserTaskRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(processTemplateNodeUserTasks)) {
            return;
        }
        List<String> nodeIds = processTemplateNodeUserTasks.stream().map(ProcessTemplateNodeUserTask::getNodeId).collect(Collectors.toList());
        this.processTemplateNodeAssigneeService.deleteByNodeIds(nodeIds);
        this.processTaskButtonService.delete(nodeIds);
        this.processCopyConfigService.deleteByNodeIds(nodeIds);
        this.processTaskIndicatorsService.deleteByNodeIds(nodeIds);
        this.processTemplateNodeUserTaskRepository.removeByIdsAndTenantCode(ids, TenantUtils.getTenantCode());
    }

    @Override
    public void deleteByNodeIds(Collection<String> nodeIds) {
        this.processTemplateNodeAssigneeService.deleteByNodeIds(nodeIds);
        this.processTaskButtonService.delete(Lists.newArrayList(nodeIds));
        this.processCopyConfigService.deleteByNodeIds(nodeIds);
        this.processTaskCopyStrategyService.deleteByNodeIds(nodeIds);
        this.processTaskIndicatorsService.deleteByNodeIds(Lists.newArrayList(nodeIds));
        this.processCanEditService.deleteByNodeIds(nodeIds);
        this.processTemplateNodeUserTaskRepository.deleteByNodeIds(nodeIds);
    }

    @Override
    public ProcessTemplateNodeUserTask findUserTaskByNodeId(String nodeId) {
        Validate.notNull((Object)nodeId, (String)"\u67e5\u8be2\u7528\u6237\u4efb\u52a1\u8282\u70b9\u65f6\uff0c\u8282\u70b9id\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        return this.processTemplateNodeUserTaskRepository.findByNodeId(nodeId);
    }

    private void createValidate(ProcessTemplateNodeUserTaskDto processTemplateNodeUserTaskDto) {
        Validate.notNull((Object)processTemplateNodeUserTaskDto, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        processTemplateNodeUserTaskDto.setId(null);
        Validate.notBlank((CharSequence)processTemplateNodeUserTaskDto.getTemplateId(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d41\u7a0b\u6a21\u677f\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processTemplateNodeUserTaskDto.getNodeId(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d41\u7a0b\u8282\u70b9\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)processTemplateNodeUserTaskDto.getSponsorRepeatSkip(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u53d1\u8d77\u4eba\u91cd\u590d\u8df3\u8fc7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)processTemplateNodeUserTaskDto.getApproverRepeatSkip(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5ba1\u6279\u4eba\u91cd\u590d\u8df3\u8fc7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)processTemplateNodeUserTaskDto.getNullSkip(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u4e3a\u7a7a\u8df3\u8fc7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)processTemplateNodeUserTaskDto.getCanBack(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u662f\u5426\u53ef\u56de\u9000\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)processTemplateNodeUserTaskDto.getCanEdit(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u662f\u5426\u53ef\u7f16\u8f91\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processTemplateNodeUserTaskDto.getSignType(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5ba1\u6279\u7b7e\u6279\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)processTemplateNodeUserTaskDto.getSignOptional(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u81ea\u9009\u5ba1\u6279\u4eba\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (Boolean.FALSE.equals(processTemplateNodeUserTaskDto.getSignOptional())) {
            Validate.notEmpty((Collection)processTemplateNodeUserTaskDto.getProcessTemplateNodeAssignees(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5ba1\u6279\u4eba\u9009\u62e9\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        }
        Validate.notEmpty((Collection)processTemplateNodeUserTaskDto.getProcessTaskButtons(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5ba1\u6279\u6309\u94ae\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }
}

