/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.service.internal;

import com.biz.crm.workflow.local.entity.ProcessTemplate;
import com.biz.crm.workflow.local.service.ProcessTemplateNodeUserTaskService;
import com.biz.crm.workflow.local.service.ProcessTemplateService;
import com.biz.crm.workflow.sdk.service.ProcessTemplateNodeService;
import com.biz.crm.workflow.sdk.service.ProcessTemplateNodeUserVoService;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateNodeUserTaskVo;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateNodeVo;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ProcessTemplateNodeUserVoServiceImpl
implements ProcessTemplateNodeUserVoService {
    @Autowired
    private ProcessTemplateService processTemplateService;
    @Autowired
    private ProcessTemplateNodeUserTaskService processTemplateNodeUserTaskService;
    @Autowired
    private ProcessTemplateNodeService processTemplateNodeService;

    public List<ProcessTemplateNodeUserTaskVo> findByProcessKey(String processKey) {
        Validate.notBlank((CharSequence)processKey, (String)"\u6d41\u7a0b\u7ed8\u5236\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        ProcessTemplate processTemplate = this.processTemplateService.findLastVersionByProcessKey(processKey);
        Validate.notNull((Object)((Object)processTemplate), (String)"\u4e0d\u5b58\u5728,\u6d41\u7a0b\u7ed8\u5236\u7f16\u7801\u4e3a\uff1a%s\u7684\u6d41\u7a0b\uff01", (Object[])new Object[]{processKey});
        List<ProcessTemplateNodeUserTaskVo> processTemplateNodeUserTaskVos = this.processTemplateNodeUserTaskService.findByTemplateId(processTemplate.getId());
        if (!CollectionUtils.isEmpty(processTemplateNodeUserTaskVos)) {
            Set nodeIds = processTemplateNodeUserTaskVos.stream().map(processTemplateNodeUserTaskVo -> processTemplateNodeUserTaskVo.getNodeId()).collect(Collectors.toSet());
            List processTemplateNodeVos = this.processTemplateNodeService.findByIds(nodeIds);
            Map processTemplateNodeVoMap = processTemplateNodeVos.stream().collect(Collectors.toMap(ProcessTemplateNodeVo::getId, Function.identity()));
            processTemplateNodeUserTaskVos.forEach(processTemplateNodeUserTaskVo -> {
                ProcessTemplateNodeVo processTemplateNodeVo = (ProcessTemplateNodeVo)processTemplateNodeVoMap.get(processTemplateNodeUserTaskVo.getNodeId());
                String processTaskId = processTemplateNodeVo.getProcessTaskId();
                String processTaskName = processTemplateNodeVo.getProcessTaskName();
                processTemplateNodeUserTaskVo.setProcessTaskId(processTaskId);
                processTemplateNodeUserTaskVo.setProcessTaskName(processTaskName);
            });
        }
        return processTemplateNodeUserTaskVos;
    }
}

