/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.service.internal;

import com.biz.crm.workflow.local.entity.ProcessTemplateScope;
import com.biz.crm.workflow.local.repository.ProcessTemplateScopeRepository;
import com.biz.crm.workflow.local.service.ProcessTemplateScopeService;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ProcessTemplateScopeServiceImpl
implements ProcessTemplateScopeService {
    private static final Logger log = LoggerFactory.getLogger(ProcessTemplateScopeServiceImpl.class);
    @Autowired
    private ProcessTemplateScopeRepository ProcessTemplateScopeRepository;

    @Override
    @Transactional
    public void createBatch(List<ProcessTemplateScope> list) {
        this.validateData(list);
        this.ProcessTemplateScopeRepository.saveBatch(list);
    }

    @Override
    @Transactional
    public void deleteByProcessTemplateId(String processTemplateId) {
        Validate.notBlank((CharSequence)processTemplateId, (String)"\u5220\u9664\u6d41\u7a0b\u9002\u7528\u8303\u56f4\u65f6\uff0c\u6d41\u7a0bkey\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.ProcessTemplateScopeRepository.deleteByProcessTemplateId(processTemplateId);
    }

    @Override
    public Set<String> findProcessTemplateIdsByScopeCode(Set<String> scopeCodes, String processUserScopeType) {
        if (CollectionUtils.isEmpty(scopeCodes) || StringUtils.isBlank((CharSequence)processUserScopeType)) {
            return null;
        }
        List<ProcessTemplateScope> managementApplicationScopeList = this.ProcessTemplateScopeRepository.findByScopeCodes(scopeCodes, processUserScopeType);
        if (CollectionUtils.isEmpty(managementApplicationScopeList)) {
            return null;
        }
        return managementApplicationScopeList.stream().map(ProcessTemplateScope::getProcessTemplateId).collect(Collectors.toSet());
    }

    @Override
    public List<ProcessTemplateScope> findByScopeCode(Set<String> scopeCodes, String processUserScopeType) {
        if (CollectionUtils.isEmpty(scopeCodes) || StringUtils.isBlank((CharSequence)processUserScopeType)) {
            return null;
        }
        List<ProcessTemplateScope> managementApplicationScopeList = this.ProcessTemplateScopeRepository.findByScopeCodes(scopeCodes, processUserScopeType);
        return managementApplicationScopeList;
    }

    @Override
    public List<ProcessTemplateScope> findByProcessTemplateId(String processTemplateId, String processUserScopeType) {
        if (StringUtils.isBlank((CharSequence)processTemplateId)) {
            return null;
        }
        List<ProcessTemplateScope> managementApplicationScopeList = this.ProcessTemplateScopeRepository.findByProcessTemplateId(processTemplateId, processUserScopeType);
        return managementApplicationScopeList;
    }

    private void validateData(List<ProcessTemplateScope> list) {
        Validate.isTrue((!CollectionUtils.isEmpty(list) ? 1 : 0) != 0, (String)"\u65b0\u589e\u6d41\u7a0b\u9002\u7528\u8303\u56f4\u65f6\uff0c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        for (ProcessTemplateScope ProcessTemplateScope2 : list) {
            Validate.notBlank((CharSequence)ProcessTemplateScope2.getProcessTemplateId(), (String)"\u65b0\u589e\u6d41\u7a0b\u9002\u7528\u8303\u56f4\u65f6,\u6d41\u7a0b\u6a21\u677fid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)ProcessTemplateScope2.getProcessUserScopeType(), (String)"\u65b0\u589e\u6d41\u7a0b\u9002\u7528\u8303\u56f4\u65f6,\u9002\u7528\u8303\u56f4\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)ProcessTemplateScope2.getScopeCode(), (String)"\u65b0\u589e\u6d41\u7a0b\u9002\u7528\u8303\u56f4\u65f6,\u8303\u56f4\u4e1a\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)ProcessTemplateScope2.getScopeName(), (String)"\u65b0\u589e\u6d41\u7a0b\u9002\u7528\u8303\u56f4\u65f6,\u8303\u56f4\u4e1a\u52a1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            ProcessTemplateScope2.setId(null);
        }
        Map<String, List<ProcessTemplateScope>> collect = list.stream().collect(Collectors.groupingBy(item -> item.getProcessUserScopeType() + "_" + item.getScopeCode()));
        collect.forEach((k, v) -> Validate.isTrue((!CollectionUtils.isEmpty((Collection)v) && v.size() == 1 ? 1 : 0) != 0, (String)"\u65b0\u589e\u65f6\u5b58\u5728\u91cd\u590d\u7684\u9002\u7528\u8303\u56f4\u4e1a\u52a1\u7f16\u7801\uff01", (Object[])new Object[0]));
    }
}

