/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.workflow.local.entity.ProcessTemplate;
import com.biz.crm.workflow.local.repository.ProcessTemplateRepository;
import com.biz.crm.workflow.local.service.ProcessService;
import com.biz.crm.workflow.local.service.ProcessTemplateBusinessService;
import com.biz.crm.workflow.local.service.ProcessTemplateScopeService;
import com.biz.crm.workflow.local.service.ProcessTemplateService;
import com.biz.crm.workflow.local.service.ProcessTemplateVoService;
import com.biz.crm.workflow.local.service.ProcessTemplateXmlService;
import com.biz.crm.workflow.sdk.constant.ProcessConstant;
import com.biz.crm.workflow.sdk.dto.ProcessTemplateBusinessDto;
import com.biz.crm.workflow.sdk.dto.ProcessTemplateDto;
import com.biz.crm.workflow.sdk.dto.ProcessTemplateNodeDto;
import com.biz.crm.workflow.sdk.dto.ProcessTemplatePageDto;
import com.biz.crm.workflow.sdk.dto.ProcessTemplateScopeDto;
import com.biz.crm.workflow.sdk.dto.ProcessTemplateXmlDto;
import com.biz.crm.workflow.sdk.listener.ProcessTemplateEventListener;
import com.biz.crm.workflow.sdk.register.ProcessTemplateRegister;
import com.biz.crm.workflow.sdk.service.ProcessTemplateNodeService;
import com.biz.crm.workflow.sdk.strategy.scope.ApplicationUserScopeStrategy;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateNodeVo;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateScopeVo;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.repository.Deployment;
import org.flowable.engine.repository.ProcessDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ProcessTemplateServiceImpl
implements ProcessTemplateService {
    private static final Logger log = LoggerFactory.getLogger(ProcessTemplateServiceImpl.class);
    @Autowired
    private ProcessTemplateRepository processTemplateRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private ProcessTemplateRegister processTemplateRegister;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired(required=false)
    private List<ProcessTemplateEventListener> listeners;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private ProcessTemplateXmlService processTemplateXmlService;
    @Autowired
    private ProcessTemplateNodeService processTemplateNodeService;
    @Autowired
    private ProcessTemplateBusinessService processTemplateBusinessService;
    @Autowired
    private ProcessTemplateScopeService processTemplateScopeService;
    @Autowired
    private ProcessTemplateVoService processTemplateVoService;
    @Autowired
    private ProcessService processService;

    @Override
    public Page<ProcessTemplate> findByConditions(Pageable pageable, ProcessTemplatePageDto processTemplatePageDto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(processTemplatePageDto)) {
            processTemplatePageDto = new ProcessTemplatePageDto();
        }
        processTemplatePageDto.setTenantCode(TenantUtils.getTenantCode());
        processTemplatePageDto.setNewest(Boolean.valueOf(true));
        return this.processTemplateRepository.findByConditions(pageable, processTemplatePageDto);
    }

    @Override
    @Transactional
    public ProcessTemplate create(ProcessTemplateDto processTemplateDto) {
        this.createValidate(processTemplateDto);
        ProcessTemplate processTemplate = this.transformCreate(processTemplateDto);
        processTemplate.setProcessKey((String)this.generateCodeService.generateCode(ProcessConstant.process_key, 1).get(0));
        return this.saveNewProcessTemplateAndDetail(processTemplateDto, processTemplate, 1);
    }

    @Override
    @Transactional
    public ProcessTemplate update(ProcessTemplateDto processTemplateDto) {
        ProcessTemplate processTemplateNew;
        this.updateValidate(processTemplateDto);
        ProcessTemplate processTemplateOld = this.findById(processTemplateDto.getId());
        Validate.notNull((Object)((Object)processTemplateOld), (String)"\u9700\u8981\u7f16\u8f91\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        List<ProcessTemplate> processTemplates = this.findByProcessKey(processTemplateDto.getProcessKey());
        Integer cversion = this.getVersion(processTemplates);
        List processTemplateOldList = processTemplates.stream().filter(process -> !process.getId().equals(processTemplateOld.getId())).collect(Collectors.toList());
        ArrayList<ProcessTemplate> needChangeNewestList = new ArrayList<ProcessTemplate>();
        if (processTemplateDto.getReleaseStatus().equals(EnableStatusEnum.ENABLE.getCode())) {
            if (EnableStatusEnum.ENABLE.getCode().equals(processTemplateOld.getReleaseStatus())) {
                processTemplateNew = this.transformCreate(processTemplateDto);
                if (!CollectionUtils.isEmpty(processTemplates)) {
                    needChangeNewestList.addAll(processTemplates);
                }
                this.saveNewProcessTemplateAndDetail(processTemplateDto, processTemplateNew, cversion);
            } else {
                this.removeNewProcessTemplateAndDetail(processTemplateOld.getId());
                if (!CollectionUtils.isEmpty(processTemplateOldList)) {
                    needChangeNewestList.addAll(processTemplateOldList);
                }
                processTemplateNew = this.transformCreate(processTemplateDto);
                this.saveNewProcessTemplateAndDetail(processTemplateDto, processTemplateNew, cversion);
            }
        } else if (EnableStatusEnum.ENABLE.getCode().equals(processTemplateOld.getReleaseStatus())) {
            processTemplateNew = this.transformCreate(processTemplateDto);
            if (!CollectionUtils.isEmpty(processTemplates)) {
                needChangeNewestList.addAll(processTemplates);
            }
            this.saveNewProcessTemplateAndDetail(processTemplateDto, processTemplateNew, null);
        } else {
            processTemplateNew = this.transformCreate(processTemplateDto);
            if (!CollectionUtils.isEmpty(processTemplateOldList)) {
                needChangeNewestList.addAll(processTemplateOldList);
            }
            this.removeNewProcessTemplateAndDetail(processTemplateOld.getId());
            this.saveNewProcessTemplateAndDetail(processTemplateDto, processTemplateNew, null);
        }
        if (!CollectionUtils.isEmpty(needChangeNewestList)) {
            List<String> ids = needChangeNewestList.stream().map(UuidEntity::getId).collect(Collectors.toList());
            this.processTemplateRepository.updateNewestByIdAndTenantCode(ids, TenantUtils.getTenantCode());
        }
        return processTemplateNew;
    }

    @Override
    @Transactional
    public void deleteBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u7f3a\u5931id", (Object[])new Object[0]);
        List<ProcessTemplate> entities = this.processTemplateRepository.listByIdsAndTenantCode(ids, TenantUtils.getTenantCode());
        Validate.isTrue((!CollectionUtils.isEmpty(entities) && entities.size() == ids.size() ? 1 : 0) != 0, (String)"\u6570\u636e\u5220\u9664\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        this.processTemplateRepository.updateDelFlagByIds(ids);
        if (!CollectionUtils.isEmpty(this.listeners)) {
            List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(entities, ProcessTemplate.class, ProcessTemplateVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.listeners.forEach(listener -> listener.onDelete(voList));
        }
    }

    @Override
    public ProcessTemplate findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.processTemplateRepository.findByIdAndTenantCode(id, TenantUtils.getTenantCode());
    }

    @Override
    public ProcessTemplate findByProcessDefinitionId(String processDefinitionId) {
        return this.processTemplateRepository.findByProcessDefinitionId(processDefinitionId);
    }

    @Override
    public List<ProcessTemplate> findByProcessKey(String processKey) {
        if (StringUtils.isBlank((CharSequence)processKey)) {
            return null;
        }
        return this.processTemplateRepository.findByProcessKey(TenantUtils.getTenantCode(), processKey);
    }

    @Override
    public ProcessTemplate findLastVersionByProcessKey(String processKey) {
        if (StringUtils.isBlank((CharSequence)processKey)) {
            return null;
        }
        return this.processTemplateRepository.findLastVersionByProcessKey(TenantUtils.getTenantCode(), processKey);
    }

    @Override
    public ProcessTemplate findUseProcessByProcessKey(String processKey) {
        if (StringUtils.isBlank((CharSequence)processKey)) {
            return null;
        }
        ProcessTemplatePageDto processTemplatePageDto = new ProcessTemplatePageDto();
        processTemplatePageDto.setProcessKeyPrecise(processKey);
        List<ProcessTemplate> useProcessByConditions = this.processTemplateRepository.findUseProcessByConditions(processTemplatePageDto);
        if (CollectionUtils.isEmpty(useProcessByConditions)) {
            return null;
        }
        return useProcessByConditions.get(0);
    }

    @Override
    public List<ProcessTemplate> findListByLoginDetailConditions(ProcessTemplatePageDto processTemplatePageDto) {
        Validate.notNull((Object)processTemplatePageDto, (String)"\u767b\u5f55\u4eba\u67e5\u8be2\u9002\u7528\u6d41\u7a0b\u65f6\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processTemplatePageDto.getBusinessCode(), (String)"\u767b\u5f55\u4eba\u67e5\u8be2\u9002\u7528\u6d41\u7a0b\u65f6\uff0c\u4e1a\u52a1\u83dc\u5355\u7f16\u7801\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processTemplatePageDto.getEffectiveScope(), (String)"\u767b\u5f55\u4eba\u67e5\u8be2\u9002\u7528\u6d41\u7a0b\u65f6\uff0c\u751f\u6548\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Set<String> processkeys = this.getProcessKeysByLoginDetailCondition();
        if (CollectionUtils.isEmpty(processkeys)) {
            return null;
        }
        processTemplatePageDto.setTenantCode(TenantUtils.getTenantCode());
        processTemplatePageDto.setProcessKeySet(processkeys);
        processTemplatePageDto.setReleaseStatus(EnableStatusEnum.ENABLE.getCode());
        List<ProcessTemplate> processTemplates = this.processTemplateRepository.findUseProcessByConditions(processTemplatePageDto);
        if (CollectionUtils.isEmpty(processTemplates)) {
            return new ArrayList<ProcessTemplate>();
        }
        List collect = processTemplates.stream().filter(processTemplate -> BooleanUtils.isTrue((Boolean)processTemplate.getNewest()) && processTemplate.getDelFlag().equals(DelFlagStatusEnum.NORMAL.getCode()) && processTemplate.getEnableStatus().equals(EnableStatusEnum.ENABLE.getCode())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect)) {
            return new ArrayList<ProcessTemplate>();
        }
        ArrayList<ProcessTemplate> processTemplateList = new ArrayList<ProcessTemplate>();
        for (ProcessTemplate processTemplate2 : collect) {
            if (processTemplate2.getReleaseStatus().equals(EnableStatusEnum.DISABLE.getCode())) {
                List<ProcessTemplate> itemList = this.processTemplateRepository.findByProcessKeyAndReleaseStatus(processTemplate2.getProcessKey(), EnableStatusEnum.ENABLE.getCode(), processTemplatePageDto.getBusinessCode());
                if (CollectionUtils.isEmpty(itemList) || !ObjectUtils.isNotEmpty((Object)((Object)itemList.get(0)))) continue;
                processTemplateList.add(itemList.get(0));
                continue;
            }
            processTemplateList.add(processTemplate2);
        }
        return processTemplateList;
    }

    @Override
    public Page<ProcessTemplate> findByLoginDetailConditions(Pageable pageable, ProcessTemplatePageDto processTemplatePageDto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        Validate.notNull((Object)processTemplatePageDto, (String)"\u767b\u5f55\u4eba\u67e5\u8be2\u9002\u7528\u6d41\u7a0b\u65f6\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processTemplatePageDto.getBusinessCode(), (String)"\u767b\u5f55\u4eba\u67e5\u8be2\u9002\u7528\u6d41\u7a0b\u65f6\uff0c\u4e1a\u52a1\u83dc\u5355\u7f16\u7801\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Set<String> processKeys = this.getProcessKeysByLoginDetailCondition();
        if (CollectionUtils.isEmpty(processKeys)) {
            return null;
        }
        processTemplatePageDto.setTenantCode(TenantUtils.getTenantCode());
        processTemplatePageDto.setProcessKeySet(processKeys);
        processTemplatePageDto.setReleaseStatus(EnableStatusEnum.ENABLE.getCode());
        return this.processTemplateRepository.findUseProcessByConditions(pageable, processTemplatePageDto);
    }

    @Override
    public void releaseVersion(String processTemplateId) {
        Validate.notNull((Object)processTemplateId, (String)"\u8bf7\u6307\u5b9a\u9700\u8981\u5207\u6362\u7684\u6d41\u7a0b\u7248\u672c", (Object[])new Object[0]);
        ProcessTemplateVo detail = this.processTemplateVoService.findDetailById(processTemplateId, false);
        Validate.notNull((Object)detail, (String)"\u6307\u5b9a\u7684\u6d41\u7a0b\u7248\u672c\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)detail.getCversion(), (String)"\u6307\u5b9a\u7684\u7248\u672c\u672a\u53d1\u5e03\uff0c\u65e0\u6cd5\u8fdb\u884c\u5207\u6362", (Object[])new Object[0]);
        ProcessTemplateDto dto = (ProcessTemplateDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)detail, ProcessTemplateDto.class, HashSet.class, ArrayList.class, new String[0]);
        dto.setProcessTemplateBusinessDto((ProcessTemplateBusinessDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)detail.getProcessTemplateBusinessVo(), ProcessTemplateBusinessDto.class, HashSet.class, ArrayList.class, new String[0]));
        dto.setProcessTemplateNodes((List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)detail.getProcessTemplateNodes(), ProcessTemplateNodeVo.class, ProcessTemplateNodeDto.class, HashSet.class, ArrayList.class, new String[0]));
        dto.setProcessTemplateXmlDto((ProcessTemplateXmlDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)detail.getProcessTemplateXmlVo(), ProcessTemplateXmlDto.class, HashSet.class, ArrayList.class, new String[0]));
        dto.setProcessTemplateScopeDtos((List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)detail.getProcessTemplateScopes(), ProcessTemplateScopeVo.class, ProcessTemplateScopeDto.class, HashSet.class, ArrayList.class, new String[0]));
        this.update(dto);
    }

    @Override
    public void publish(List<String> processTemplateIds) {
        Validate.notNull((Object)CollectionUtils.isEmpty(processTemplateIds), (String)"\u8bf7\u6307\u5b9a\u53d1\u5e03\u7684\u6d41\u7a0b", (Object[])new Object[0]);
        processTemplateIds.forEach(processTemplateId -> {
            ProcessTemplateVo detail = this.processTemplateVoService.findDetailById((String)processTemplateId, false);
            Validate.notNull((Object)detail, (String)"\u6307\u5b9a\u7684\u6d41\u7a0b\u7248\u672c\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
            Validate.isTrue((!EnableStatusEnum.ENABLE.getCode().equals(detail.getReleaseStatus()) ? 1 : 0) != 0, (String)"[%s]\u6d41\u7a0b\u5df2\u53d1\u5e03", (Object[])new Object[]{detail.getProcessName()});
            Validate.isTrue((boolean)detail.getNewest(), (String)"[%s]\u6d41\u7a0b\u4e0d\u662f\u6700\u65b0\u72b6\u6001", (Object[])new Object[]{detail.getProcessName()});
            ProcessTemplateDto dto = (ProcessTemplateDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)detail, ProcessTemplateDto.class, HashSet.class, ArrayList.class, new String[0]);
            dto.setProcessTemplateBusinessDto((ProcessTemplateBusinessDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)detail.getProcessTemplateBusinessVo(), ProcessTemplateBusinessDto.class, HashSet.class, ArrayList.class, new String[0]));
            dto.setProcessTemplateNodes((List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)detail.getProcessTemplateNodes(), ProcessTemplateNodeVo.class, ProcessTemplateNodeDto.class, HashSet.class, ArrayList.class, new String[0]));
            dto.setProcessTemplateXmlDto((ProcessTemplateXmlDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)detail.getProcessTemplateXmlVo(), ProcessTemplateXmlDto.class, HashSet.class, ArrayList.class, new String[0]));
            dto.setProcessTemplateScopeDtos((List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)detail.getProcessTemplateScopes(), ProcessTemplateScopeVo.class, ProcessTemplateScopeDto.class, HashSet.class, ArrayList.class, new String[0]));
            dto.setReleaseStatus(EnableStatusEnum.ENABLE.getCode());
            this.update(dto);
        });
    }

    @Override
    public List<ProcessTemplate> findByProcessKeyAndReleaseStatus(String processKey, String code) {
        Validate.notNull((Object)processKey, (String)"\u67e5\u8be2\u6d41\u7a0b\u6a21\u677f\u65f6,\u6d41\u7a0bkey\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<ProcessTemplate> processTemplates = this.processTemplateRepository.findByProcessKeyAndReleaseStatus(processKey, code, null);
        return processTemplates;
    }

    private void updateValidate(ProcessTemplateDto processTemplateDto) {
        Validate.notNull((Object)processTemplateDto, (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processTemplateDto.getId(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processTemplateDto.getProcessName(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u6d41\u7a0b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processTemplateDto.getProcessKey(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u4e1a\u52a1\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processTemplateDto.getReleaseStatus(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u4e1a\u52a1\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)(!CollectionUtils.isEmpty((Collection)processTemplateDto.getProcessTemplateNodes()) ? 1 : 0), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u6d41\u7a0b\u8282\u70b9\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)processTemplateDto.getProcessTemplateScopeDtos()) ? 1 : 0) != 0, (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u6d41\u7a0b\u8303\u56f4\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)processTemplateDto.getProcessTemplateXmlDto(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u6d41\u7a0b\u56fe\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)processTemplateDto.getProcessTemplateBusinessDto(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u6d41\u7a0b\u5173\u8054\u4e1a\u52a1\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private void createValidate(ProcessTemplateDto processTemplateDto) {
        Validate.notNull((Object)processTemplateDto, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)processTemplateDto.getId()), (String)"\u65b0\u589e\u6570\u636e\u65f6,\u6570\u636e\u4e3b\u952e\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processTemplateDto.getProcessName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d41\u7a0b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)processTemplateDto.getReleaseStatus(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d41\u7a0b\u72b6\u6001\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)(!CollectionUtils.isEmpty((Collection)processTemplateDto.getProcessTemplateNodes()) ? 1 : 0), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d41\u7a0b\u8282\u70b9\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)processTemplateDto.getProcessTemplateScopeDtos()) ? 1 : 0) != 0, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d41\u7a0b\u8303\u56f4\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)processTemplateDto.getProcessTemplateXmlDto(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d41\u7a0b\u56fe\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)processTemplateDto.getProcessTemplateBusinessDto(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d41\u7a0b\u5173\u8054\u4e1a\u52a1\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private ProcessTemplate transformCreate(ProcessTemplateDto processTemplateDto) {
        ProcessTemplate entity = (ProcessTemplate)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)processTemplateDto, ProcessTemplate.class, HashSet.class, ArrayList.class, new String[0]));
        entity.setTenantCode(TenantUtils.getTenantCode());
        entity.setId(null);
        entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        return entity;
    }

    private Set<String> getProcessKeysByLoginDetailCondition() {
        HashSet<String> processKeys = new HashSet<String>();
        Collection applicationUserScopeStrategies = this.processTemplateRegister.getApplicationUserScopeStrategies();
        applicationUserScopeStrategies.forEach(aClass -> {
            ApplicationUserScopeStrategy applicationUserScopeStrategy = (ApplicationUserScopeStrategy)this.applicationContext.getBean(aClass);
            Set set = applicationUserScopeStrategy.onRequestProcessByLoginDetail();
            if (!CollectionUtils.isEmpty((Collection)set)) {
                processKeys.addAll(set);
            }
        });
        return processKeys;
    }

    private void saveDetailUserScope(ProcessTemplateVo processTemplateVo) {
        ApplicationUserScopeStrategy applicationUserScopeStrategy = this.getApplicationUserScopeStrategy(processTemplateVo);
        applicationUserScopeStrategy.onSaveApplicationUserScopeInfo(false, processTemplateVo, null);
    }

    private ApplicationUserScopeStrategy getApplicationUserScopeStrategy(ProcessTemplateVo processTemplateVo) {
        Collection applicationUserScopeStrategies = this.processTemplateRegister.getApplicationUserScopeStrategies();
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)applicationUserScopeStrategies) ? 1 : 0) != 0, (String)"\u6a21\u677f\u4e2d\u9002\u7528\u8303\u56f4\u4e0d\u5b58\u5728\u5bf9\u5e94\u7b56\u7565\u7c7b\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01", (Object[])new Object[0]);
        List processTemplateScopeVos = processTemplateVo.getProcessTemplateScopes();
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)processTemplateScopeVos) ? 1 : 0) != 0, (String)"\u6d41\u7a0b\u4f7f\u7528\u8303\u56f4\u6570\u636e\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        List processUserScopeTypes = processTemplateScopeVos.stream().filter(s -> StringUtils.isNotBlank((CharSequence)s.getProcessUserScopeType())).map(ProcessTemplateScopeVo::getProcessUserScopeType).distinct().collect(Collectors.toList());
        Validate.isTrue((!CollectionUtils.isEmpty(processUserScopeTypes) ? 1 : 0) != 0, (String)"\u6a21\u677f\u4e2d\u9002\u7528\u8303\u56f4\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((processUserScopeTypes.size() == 1 ? 1 : 0) != 0, (String)"\u6a21\u677f\u4e2d\u9002\u7528\u8303\u56f4\u7c7b\u578b\u53ea\u80fd\u4e3a\u4e00\u79cd\uff01", (Object[])new Object[0]);
        ArrayList listNew = new ArrayList();
        applicationUserScopeStrategies.forEach(aClass -> {
            ApplicationUserScopeStrategy applicationUserScopeStrategy = (ApplicationUserScopeStrategy)this.applicationContext.getBean(aClass);
            if (applicationUserScopeStrategy.getProcessUserScopeType().equals(processUserScopeTypes.get(0))) {
                listNew.add(applicationUserScopeStrategy);
            }
        });
        Validate.isTrue((!CollectionUtils.isEmpty(listNew) ? 1 : 0) != 0, (String)"\u9002\u7528\u8303\u56f4\u5b58\u6ca1\u6709\u5bf9\u5e94\u7b56\u7565\u7c7b\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01", (Object[])new Object[0]);
        Validate.isTrue((listNew.size() == 1 ? 1 : 0) != 0, (String)"\u9002\u7528\u8303\u56f4\u5b58\u5728\u591a\u4e2a\u5bf9\u5e94\u7b56\u7565\u7c7b\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01", (Object[])new Object[0]);
        return (ApplicationUserScopeStrategy)listNew.get(0);
    }

    private ProcessTemplate saveNewProcessTemplateAndDetail(ProcessTemplateDto processTemplateDto, ProcessTemplate processTemplate, Integer cversion) {
        if (EnableStatusEnum.ENABLE.getCode().equals(processTemplateDto.getReleaseStatus())) {
            try {
                BpmnModel bpmn = this.processService.xmlToBpmnModel(processTemplateDto.getProcessTemplateXmlDto().getProcessDesc());
                String deployName = processTemplate.getProcessKey() + ".bpmn";
                Deployment deployment = this.repositoryService.createDeployment().addBpmnModel(deployName, bpmn).tenantId(TenantUtils.getTenantCode()).name(processTemplateDto.getProcessName()).key(processTemplate.getProcessKey()).addString(processTemplate.getProcessKey(), processTemplateDto.getProcessTemplateXmlDto().getProcessDesc()).deploy();
                ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(deployment.getId()).singleResult();
                processTemplate.setProcessDefinitionId(processDefinition.getId());
                processTemplate.setCversion(cversion);
            }
            catch (Exception e) {
                throw new RuntimeException(" \u7ed8\u5236\u6d41\u7a0b\u56fe\u9519\u8bef,\u8bf7\u68c0\u67e5!");
            }
        }
        processTemplate.setNewest(true);
        processTemplate.setId(null);
        processTemplate.setTenantCode(TenantUtils.getTenantCode());
        this.processTemplateRepository.save((Object)processTemplate);
        ProcessTemplateVo processTemplateVo = (ProcessTemplateVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)processTemplate, ProcessTemplateVo.class, HashSet.class, ArrayList.class, new String[0]);
        List processTemplateScopeDtos = processTemplateDto.getProcessTemplateScopeDtos();
        List processTemplateScopeVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)processTemplateScopeDtos, ProcessTemplateScopeDto.class, ProcessTemplateScopeVo.class, HashSet.class, ArrayList.class, new String[0]);
        processTemplateVo.setProcessTemplateScopes(processTemplateScopeVos);
        this.saveDetailUserScope(processTemplateVo);
        ProcessTemplateBusinessDto processTemplateBusinessDto = processTemplateDto.getProcessTemplateBusinessDto();
        processTemplateBusinessDto.setProcessTemplateId(processTemplate.getId());
        processTemplateBusinessDto.setId(null);
        this.processTemplateBusinessService.create(processTemplateDto.getProcessTemplateBusinessDto());
        processTemplateDto.getProcessTemplateXmlDto().setProcessTemplateId(processTemplate.getId());
        processTemplateDto.getProcessTemplateXmlDto().setId(null);
        this.processTemplateXmlService.create(processTemplateDto.getProcessTemplateXmlDto());
        List processTemplateNodeDtos = processTemplateDto.getProcessTemplateNodes();
        if (!CollectionUtils.isEmpty((Collection)processTemplateNodeDtos)) {
            processTemplateNodeDtos.forEach(item -> {
                item.setTemplateId(processTemplate.getId());
                item.setId(null);
                item.setTenantCode(TenantUtils.getTenantCode());
            });
            this.processTemplateNodeService.createBatch((Collection)processTemplateNodeDtos);
        }
        return processTemplate;
    }

    private Integer getVersion(List<ProcessTemplate> processTemplates) {
        Integer cversion = 1;
        List processTemplateList = processTemplates.stream().filter(process -> Objects.nonNull(process.getCversion())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(processTemplateList)) {
            return cversion;
        }
        ProcessTemplate processTem = processTemplateList.stream().max(Comparator.comparing(processTemplate -> processTemplate.getCversion())).get();
        return processTem.getCversion() + 1;
    }

    private void removeNewProcessTemplateAndDetail(String id) {
        this.processTemplateRepository.removeById((Serializable)((Object)id));
        this.processTemplateXmlService.deleteByProcessTemplateId(id);
        this.processTemplateBusinessService.deleteByProcessTemplateId(id);
        this.processTemplateScopeService.deleteByProcessTemplateId(id);
        this.processTemplateNodeService.deleteByTemplateId(id);
    }
}

