/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.service.internal;

import com.biz.crm.workflow.local.entity.ProcessTemplate;
import com.biz.crm.workflow.local.entity.ProcessTemplateBusiness;
import com.biz.crm.workflow.local.entity.ProcessTemplateScope;
import com.biz.crm.workflow.local.entity.ProcessTemplateXml;
import com.biz.crm.workflow.local.service.ProcessTemplateBusinessService;
import com.biz.crm.workflow.local.service.ProcessTemplateScopeService;
import com.biz.crm.workflow.local.service.ProcessTemplateService;
import com.biz.crm.workflow.local.service.ProcessTemplateVoService;
import com.biz.crm.workflow.local.service.ProcessTemplateXmlService;
import com.biz.crm.workflow.sdk.service.ProcessTemplateNodeService;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateBusinessVo;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateScopeVo;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateVo;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateXmlVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ProcessTemplateVoServiceImpl
implements ProcessTemplateVoService {
    private static final Logger log = LoggerFactory.getLogger(ProcessTemplateVoServiceImpl.class);
    @Autowired
    private ProcessTemplateService processTemplateService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private ProcessTemplateScopeService processTemplateScopeService;
    @Autowired
    private ProcessTemplateXmlService processTemplateXmlService;
    @Autowired
    private ProcessTemplateBusinessService processTemplateBusinessService;
    @Autowired
    private ProcessTemplateNodeService processTemplateNodeService;

    @Override
    public ProcessTemplateVo findDetailById(String id, boolean dynamicUserTask) {
        ProcessTemplate processTemplate = this.processTemplateService.findById(id);
        if (Objects.isNull((Object)processTemplate)) {
            return null;
        }
        ProcessTemplateVo processTemplateVo = (ProcessTemplateVo)this.nebulaToolkitService.copyObjectByBlankList((Object)processTemplate, ProcessTemplateVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.assembleDetail(processTemplateVo, dynamicUserTask);
        return processTemplateVo;
    }

    @Override
    public ProcessTemplateVo handleCopyById(String id) {
        ProcessTemplate processTemplate = this.processTemplateService.findById(id);
        if (Objects.isNull((Object)processTemplate)) {
            return null;
        }
        ProcessTemplateVo processTemplateVo = (ProcessTemplateVo)this.nebulaToolkitService.copyObjectByBlankList((Object)processTemplate, ProcessTemplateVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.assembleDetail(processTemplateVo, false);
        this.assembleCopyData(processTemplateVo);
        return processTemplateVo;
    }

    private void assembleDetail(ProcessTemplateVo processTemplateVo, boolean dynamicUserTask) {
        List processTemplateNodeVos;
        ProcessTemplateBusiness processTemplateBusiness;
        ProcessTemplateXml processTemplateXml;
        List<ProcessTemplateScope> processTemplateScopes = this.processTemplateScopeService.findByProcessTemplateId(processTemplateVo.getId(), null);
        if (!CollectionUtils.isEmpty(processTemplateScopes)) {
            List processTemplateScopeVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(processTemplateScopes, ProcessTemplateScope.class, ProcessTemplateScopeVo.class, HashSet.class, ArrayList.class, new String[0]);
            processTemplateVo.setProcessTemplateScopes(processTemplateScopeVos);
        }
        if (Objects.nonNull((Object)(processTemplateXml = this.processTemplateXmlService.findByProcessTemplateId(processTemplateVo.getId())))) {
            ProcessTemplateXmlVo processTemplateXmlVo = (ProcessTemplateXmlVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)processTemplateXml, ProcessTemplateXmlVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            processTemplateVo.setProcessTemplateXmlVo(processTemplateXmlVo);
        }
        if (Objects.nonNull((Object)(processTemplateBusiness = this.processTemplateBusinessService.findByProcessTemplateId(processTemplateVo.getId())))) {
            ProcessTemplateBusinessVo processTemplateBusinessVo = (ProcessTemplateBusinessVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)processTemplateBusiness, ProcessTemplateBusinessVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            processTemplateVo.setProcessTemplateBusinessVo(processTemplateBusinessVo);
        }
        if (!CollectionUtils.isEmpty((Collection)(processTemplateNodeVos = this.processTemplateNodeService.findByTemplateId(processTemplateVo.getId())))) {
            if (dynamicUserTask) {
                processTemplateVo.setProcessTemplateNodes(processTemplateNodeVos);
            } else {
                List vos = processTemplateNodeVos.stream().filter(processTemplateNodeVo -> !processTemplateNodeVo.getProcessTaskId().contains("dynamicUserTask")).collect(Collectors.toList());
                processTemplateVo.setProcessTemplateNodes(vos);
            }
        }
    }

    private void assembleCopyData(ProcessTemplateVo processTemplateVo) {
        if (!Objects.isNull(processTemplateVo)) {
            processTemplateVo.setId(null);
            processTemplateVo.setProcessDefinitionId(null);
            processTemplateVo.setLastTime(null);
            processTemplateVo.setProcessKey(null);
        }
    }
}

