/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.service.internal;

import com.biz.crm.workflow.local.entity.ProcessTemplateXml;
import com.biz.crm.workflow.local.repository.ProcessTemplateXmlRepository;
import com.biz.crm.workflow.local.service.ProcessTaskLogService;
import com.biz.crm.workflow.local.service.ProcessTemplateXmlService;
import com.biz.crm.workflow.local.service.process.node.task.AbstractServiceTaskProcessNode;
import com.biz.crm.workflow.sdk.dto.ProcessTemplateXmlDto;
import com.biz.crm.workflow.sdk.service.ProcessTemplateNodeService;
import com.biz.crm.workflow.sdk.vo.ProcessHistoricVo;
import com.biz.crm.workflow.sdk.vo.ProcessInterventionLogsVo;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateNodeVo;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateXmlVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.flowable.bpmn.converter.BpmnXMLConverter;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.engine.HistoryService;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.TaskService;
import org.flowable.engine.history.HistoricActivityInstance;
import org.flowable.engine.history.HistoricProcessInstance;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.task.api.TaskQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ProcessTemplateXmlServiceImpl
implements ProcessTemplateXmlService {
    private static final Logger log = LoggerFactory.getLogger(ProcessTemplateXmlServiceImpl.class);
    @Autowired
    private ProcessTemplateXmlRepository processTemplateXmlRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private ProcessTemplateNodeService processTemplateNodeService;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired(required=false)
    private List<AbstractServiceTaskProcessNode> abstractServiceTaskProcessNodes;
    @Autowired
    private ProcessTaskLogService processTaskLogService;

    @Override
    public ProcessTemplateXml findByProcessTemplateId(String processTemplateId) {
        if (StringUtils.isBlank((CharSequence)processTemplateId)) {
            return null;
        }
        return this.processTemplateXmlRepository.findByProcessTemplateId(processTemplateId);
    }

    @Override
    public void deleteByProcessTemplateId(String processTemplateId) {
        Validate.notBlank((CharSequence)processTemplateId, (String)"\u6d41\u7a0b\u6a21\u677fid\u4e0d\u5b58\u5728\uff0c\u4e0d\u80fd\u5220\u9664", (Object[])new Object[0]);
        this.processTemplateXmlRepository.deleteByProcessTemplateId(processTemplateId);
    }

    @Override
    public ProcessTemplateXml create(ProcessTemplateXmlDto processTemplateXmlDto) {
        Validate.notNull((Object)processTemplateXmlDto, (String)"\u6d41\u7a0bxml\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)processTemplateXmlDto.getProcessTemplateId(), (String)"\u6d41\u7a0b\u6a21\u677fid,\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)processTemplateXmlDto.getProcessDesc(), (String)"\u6d41\u7a0bxml\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        ProcessTemplateXml processTemplateXml = (ProcessTemplateXml)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)processTemplateXmlDto, ProcessTemplateXml.class, HashSet.class, ArrayList.class, new String[0]));
        this.processTemplateXmlRepository.save((Object)processTemplateXml);
        return processTemplateXml;
    }

    @Override
    public ProcessTemplateXmlVo findByProcessInstanceId(String processInstanceId) {
        Validate.notBlank((CharSequence)processInstanceId, (String)"\u6d41\u7a0b\u5b9e\u4f8bid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        Validate.isTrue((Objects.nonNull(processInstance) || Objects.nonNull(historicProcessInstance) ? 1 : 0) != 0);
        String processDefinitionId = Objects.nonNull(processInstance) ? processInstance.getProcessDefinitionId() : historicProcessInstance.getProcessDefinitionId();
        Validate.notBlank((CharSequence)processDefinitionId, (String)"\u6d41\u7a0b\u5b9e\u4f8b\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinitionId);
        List processTemplateNodeVos = this.processTemplateNodeService.findByProcessInstanceId(processInstanceId);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)processTemplateNodeVos) ? 1 : 0) != 0, (String)"\u6d41\u7a0b\u8282\u70b9\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        Map<String, String> nodeMap = processTemplateNodeVos.stream().collect(Collectors.toMap(ProcessTemplateNodeVo::getProcessTaskId, ProcessTemplateNodeVo::getCode, (k1, k2) -> k2));
        HashMap<String, String> nodeNewMap = new HashMap<String, String>();
        for (String key : nodeMap.keySet()) {
            AbstractServiceTaskProcessNode processNode;
            String strategyCode = nodeMap.get(key);
            if (!StringUtils.isNotBlank((CharSequence)strategyCode) || !Objects.nonNull(processNode = (AbstractServiceTaskProcessNode)this.abstractServiceTaskProcessNodes.stream().filter(item -> item.getCode().equals(strategyCode)).findFirst().orElse(null))) continue;
            String type = processNode.getType();
            nodeNewMap.put(key, type);
        }
        String processXml = this.addDataTypetoBpmnmodel(bpmnModel, nodeNewMap);
        List list = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).activityTenantId(TenantUtils.getTenantCode()).finished().list();
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).list();
        ProcessTemplateXmlVo processTemplateXmlVo = new ProcessTemplateXmlVo();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            processTemplateXmlVo.setProcessDesc(processXml);
            HashSet<ProcessHistoricVo> processHistoricVos = new HashSet<ProcessHistoricVo>();
            List<ProcessInterventionLogsVo> processInterventionLogsVos = this.processTaskLogService.findInterventionLogByProcessInstanceId(processInstanceId);
            if (!CollectionUtils.isEmpty(processInterventionLogsVos)) {
                List<HistoricActivityInstance> historicActivityInstances;
                List<String> taskIds = processInterventionLogsVos.stream().map(ProcessInterventionLogsVo::getTaskId).distinct().collect(Collectors.toList());
                ArrayList taskIdList = new ArrayList();
                taskIds.forEach(taskId -> {
                    List ids = Arrays.stream(taskId.split(",")).distinct().collect(Collectors.toList());
                    taskIdList.addAll(ids);
                });
                taskIdList.removeAll(Collections.singleton(null));
                List collect = list.stream().filter(l -> StringUtils.isNotEmpty((CharSequence)l.getTaskId())).distinct().collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(collect) && !CollectionUtils.isEmpty(historicActivityInstances = list.stream().filter(l -> !taskIdList.contains(l.getTaskId())).distinct().collect(Collectors.toList()))) {
                    this.buildHistoric(historicActivityInstances, processHistoricVos);
                }
            } else {
                this.buildHistoric(list, processHistoricVos);
            }
            if (!CollectionUtils.isEmpty((Collection)tasks)) {
                tasks.forEach(task -> {
                    ProcessHistoricVo processHistoricVo = new ProcessHistoricVo();
                    processHistoricVo.setActivityId(task.getTaskDefinitionKey());
                    processHistoricVo.setPresent(Boolean.valueOf(true));
                    processHistoricVos.add(processHistoricVo);
                });
            }
            processTemplateXmlVo.setProcessHistorics(processHistoricVos);
        }
        return processTemplateXmlVo;
    }

    private void buildHistoric(List<HistoricActivityInstance> list, Set<ProcessHistoricVo> processHistoricVos) {
        Set<String> activityIds = list.stream().filter(historicActivityInstance -> StringUtils.isNotBlank((CharSequence)historicActivityInstance.getActivityId()) && !historicActivityInstance.getActivityType().equals("sequenceFlow")).map(HistoricActivityInstance::getActivityId).collect(Collectors.toSet());
        activityIds.forEach(activityId -> {
            ProcessHistoricVo processHistoricVo = new ProcessHistoricVo();
            processHistoricVo.setActivityId(activityId);
            processHistoricVo.setPresent(Boolean.valueOf(false));
            processHistoricVos.add(processHistoricVo);
        });
    }

    private String addDataTypetoBpmnmodel(BpmnModel bpmnModel, Map<String, String> nodeNewMap) {
        String processxml;
        try {
            Document document = DocumentHelper.parseText((String)new String(new BpmnXMLConverter().convertToXML(bpmnModel)));
            Element rootElement = document.getRootElement();
            this.getNodes(rootElement, nodeNewMap);
            processxml = document.asXML();
        }
        catch (DocumentException e) {
            throw new RuntimeException(String.format("\u6d41\u7a0b\u56fe\u8f6c\u6362\u5931\u8d25:%s", e.getMessage()), e);
        }
        return processxml;
    }

    private void getNodes(Element node, Map<String, String> nodeNewMap) {
        List list = node.attributes();
        if ("serviceTask".equals(node.getName())) {
            Attribute att = list.stream().filter(attribute -> "id".equals(attribute.getName())).findFirst().orElse(null);
            String value = nodeNewMap.get(att.getValue());
            node.addAttribute("dataType", value);
        }
        List listElement = node.elements();
        for (Element e : listElement) {
            this.getNodes(e, nodeNewMap);
        }
    }
}

