/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.service.internal;

import com.biz.crm.workflow.local.entity.ProcessTodoDelegateDetailEntity;
import com.biz.crm.workflow.local.repository.ProcessTodoDelegateDetailRepository;
import com.biz.crm.workflow.local.service.ProcessTodoDelegateDetailService;
import com.biz.crm.workflow.sdk.dto.ProcessTodoDelegateDetailDto;
import com.biz.crm.workflow.sdk.vo.ProcessTodoDelegateDetailVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="processTodoDelegateDetailService")
public class ProcessTodoDelegateDetailServiceImpl
implements ProcessTodoDelegateDetailService {
    @Autowired
    private ProcessTodoDelegateDetailRepository processTodoDelegateDetailRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public ProcessTodoDelegateDetailVo findByDelegateId(String delegateId) {
        if (StringUtils.isBlank((CharSequence)delegateId)) {
            return null;
        }
        List<ProcessTodoDelegateDetailEntity> processTodoDelegateDetail = this.processTodoDelegateDetailRepository.findByDelegateId(delegateId);
        if (processTodoDelegateDetail == null) {
            return null;
        }
        return (ProcessTodoDelegateDetailVo)this.nebulaToolkitService.copyObjectByWhiteList(processTodoDelegateDetail, ProcessTodoDelegateDetailVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    @Override
    @Transactional
    public ProcessTodoDelegateDetailVo create(ProcessTodoDelegateDetailDto processTodoDelegateDetailDto) {
        ProcessTodoDelegateDetailEntity processTodoDelegateDetail = (ProcessTodoDelegateDetailEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)processTodoDelegateDetailDto, ProcessTodoDelegateDetailEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        this.processTodoDelegateDetailRepository.saveOrUpdate((Object)processTodoDelegateDetail);
        ProcessTodoDelegateDetailVo processTodoDelegateDetailVo = (ProcessTodoDelegateDetailVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)processTodoDelegateDetail, ProcessTodoDelegateDetailVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        processTodoDelegateDetailVo.setId(processTodoDelegateDetail.getId());
        return processTodoDelegateDetailVo;
    }

    @Override
    @Transactional
    public List<ProcessTodoDelegateDetailVo> createBatch(Collection<ProcessTodoDelegateDetailDto> processTodoDelegateDetailDtos) {
        if (CollectionUtils.isEmpty(processTodoDelegateDetailDtos)) {
            return Lists.newArrayList();
        }
        ArrayList processTodoDelegateDetailVos = Lists.newArrayList();
        for (ProcessTodoDelegateDetailDto processTodoDelegateDetailDto : processTodoDelegateDetailDtos) {
            ProcessTodoDelegateDetailVo processTodoDelegateDetailVo = this.create(processTodoDelegateDetailDto);
            processTodoDelegateDetailVos.add(processTodoDelegateDetailVo);
        }
        return processTodoDelegateDetailVos;
    }

    @Override
    public void deleteDelegateDetailsByDelegateId(String delegateId) {
        this.processTodoDelegateDetailRepository.deleteByDelegateId(delegateId);
    }
}

