/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.workflow.local.entity.ProcessTodoDelegateEntity;
import com.biz.crm.workflow.local.repository.ProcessTodoDelegateRepository;
import com.biz.crm.workflow.local.service.ProcessTodoDelegateDetailService;
import com.biz.crm.workflow.local.service.ProcessTodoDelegateService;
import com.biz.crm.workflow.sdk.dto.ProcessTodoDelegateDto;
import com.biz.crm.workflow.sdk.enums.ProcessDelegateTypeEnum;
import com.biz.crm.workflow.sdk.vo.ProcessTodoDelegateVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import javax.transaction.Transactional;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="processTodoDelegateService")
public class ProcessTodoDelegateServiceImpl
implements ProcessTodoDelegateService {
    @Autowired
    private ProcessTodoDelegateRepository processTodoDelegateRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private ProcessTodoDelegateDetailService processTodoDelegateDetailService;
    private static final SimpleDateFormat formatMonth = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @Override
    public Page<ProcessTodoDelegateVo> findByConditions(Pageable pageable, ProcessTodoDelegateDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(dto)) {
            dto = new ProcessTodoDelegateDto();
        }
        Validate.notBlank((CharSequence)dto.getDelegateType(), (String)"\u8bf7\u4f20\u5165\u59d4\u6258\u7c7b\u578b\uff01", (Object[])new Object[0]);
        AbstractCrmUserIdentity loginUser = this.loginUserService.getAbstractLoginUser();
        Validate.notNull((Object)loginUser, (String)"\u7528\u6237\u5c1a\u672a\u767b\u5f55", (Object[])new Object[0]);
        dto.setCreateAccount(loginUser.getAccount());
        dto.setUserName(loginUser.getIdentityType() + ":" + loginUser.getAccount());
        return this.processTodoDelegateRepository.findByConditions(pageable, dto);
    }

    @Override
    @Transactional
    public ProcessTodoDelegateVo create(ProcessTodoDelegateDto processTodoDelegateDto) {
        AbstractCrmUserIdentity loginUser = this.loginUserService.getAbstractLoginUser();
        Validate.notNull((Object)loginUser, (String)"\u7528\u6237\u5c1a\u672a\u767b\u5f55", (Object[])new Object[0]);
        this.createValidate(processTodoDelegateDto, loginUser);
        ProcessTodoDelegateEntity processTodoDelegate = (ProcessTodoDelegateEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)processTodoDelegateDto, ProcessTodoDelegateEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        processTodoDelegate.setTenantCode(TenantUtils.getTenantCode());
        List<ProcessTodoDelegateEntity> entityList = this.processTodoDelegateRepository.findByUserCodeAndTime(processTodoDelegateDto);
        Validate.isTrue((boolean)CollectionUtils.isEmpty(entityList), (String)"\u6b64\u65f6\u95f4\u6bb5\u5185\u5df2\u7ecf\u5b58\u5728\u59d4\u6258", (Object[])new Object[0]);
        this.processTodoDelegateRepository.saveOrUpdate((Object)processTodoDelegate);
        processTodoDelegateDto.getDetailDtoList().forEach(detail -> detail.setDelegateId(processTodoDelegate.getId()));
        this.processTodoDelegateDetailService.createBatch(processTodoDelegateDto.getDetailDtoList());
        ProcessTodoDelegateVo processTodoDelegateVo = (ProcessTodoDelegateVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)processTodoDelegate, ProcessTodoDelegateVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        processTodoDelegateVo.setId(processTodoDelegate.getId());
        return processTodoDelegateVo;
    }

    @Override
    public void cancelDelegate(String id) {
        ProcessTodoDelegateEntity processTodoDelegateEntity = this.processTodoDelegateRepository.findByIdAndTenantCode(id, TenantUtils.getTenantCode());
        if (ObjectUtils.isEmpty((Object)((Object)processTodoDelegateEntity))) {
            return;
        }
        this.processTodoDelegateRepository.cancelDelegate(id);
        this.processTodoDelegateDetailService.deleteDelegateDetailsByDelegateId(id);
    }

    @Override
    public Integer countByAccount(String account) {
        Validate.notNull((Object)account, (String)"\u67e5\u8be2\u5f85\u5904\u7406\u6d41\u7a0b\u65f6\u7528\u6237\u8d26\u6237\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        return this.processTodoDelegateRepository.countByAccount(account);
    }

    private void createValidate(ProcessTodoDelegateDto processTodoDelegateDto, AbstractCrmUserIdentity loginUser) {
        Validate.notNull((Object)processTodoDelegateDto, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((processTodoDelegateDto.getId() == null ? 1 : 0) != 0, (String)"\u65b0\u589e\u6570\u636e\u65f6,\u6570\u636e\u4e3b\u952e\u4e0d\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processTodoDelegateDto.getDelegateType(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u59d4\u6258\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)processTodoDelegateDto.getDetailDtoList(), (String)"\u88ab\u59d4\u6d3e\u4eba\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        processTodoDelegateDto.getDetailDtoList().forEach(detail -> {
            Validate.notNull((Object)detail.getDelegateUserCode(), (String)"\u88ab\u59d4\u6258\u4eba\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)detail.getDelegateUserName(), (String)"\u88ab\u59d4\u6258\u4eba\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        });
        if (ProcessDelegateTypeEnum.SUPERIOR.getDictCode().equals(processTodoDelegateDto.getDelegateType())) {
            Validate.notNull((Object)processTodoDelegateDto.getStartTime(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)processTodoDelegateDto.getEndTime(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)processTodoDelegateDto.getUserName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u7528\u6237\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        } else if (ProcessDelegateTypeEnum.PERSONAL.getDictCode().equals(processTodoDelegateDto.getDelegateType())) {
            Validate.notNull((Object)processTodoDelegateDto.getStartTime(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)processTodoDelegateDto.getEndTime(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            processTodoDelegateDto.setUserName(loginUser.getIdentityType() + ":" + loginUser.getAccount());
        } else if (ProcessDelegateTypeEnum.DIMISSION.getDictCode().equals(processTodoDelegateDto.getDelegateType())) {
            Validate.notBlank((CharSequence)processTodoDelegateDto.getUserName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u7528\u6237\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            try {
                Date startDate = formatMonth.parse("2022-08-01 00:00:00");
                Date EndDate = formatMonth.parse("2099-12-31 23:59:59");
                processTodoDelegateDto.setStartTime(startDate);
                processTodoDelegateDto.setEndTime(EndDate);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("\u65e5\u671f\u8f6c\u6362\u5931\u8d25\uff01");
            }
        } else {
            throw new IllegalArgumentException("\u59d4\u6258\u7c7b\u578b\u4e0d\u5b58\u5728\uff01");
        }
    }
}

