/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.service.internal;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.workflow.local.entity.ProcessTemplate;
import com.biz.crm.workflow.local.service.ProcessTaskService;
import com.biz.crm.workflow.local.service.ProcessTemplateNodeAssigneeService;
import com.biz.crm.workflow.local.service.ProcessTemplateNodeUserTaskService;
import com.biz.crm.workflow.local.service.ProcessTemplateService;
import com.biz.crm.workflow.local.service.ProcessTracingStrategyService;
import com.biz.crm.workflow.local.service.TaskMultiCacheVoService;
import com.biz.crm.workflow.local.vo.ProcessPreExecutionLogVo;
import com.biz.crm.workflow.local.vo.ProcessTracingStrategyVo;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateNodeAssigneeVo;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateNodeUserTaskVo;
import com.biz.crm.workflow.sdk.vo.UserVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.ExclusiveGateway;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.InclusiveGateway;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.bpmn.model.ServiceTask;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.bpmn.model.UserTask;
import org.flowable.engine.RepositoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ProcessTracingStrategyServiceImpl
implements ProcessTracingStrategyService {
    private static final Logger log = LoggerFactory.getLogger(ProcessTracingStrategyServiceImpl.class);
    @Autowired
    private ProcessTemplateNodeUserTaskService processTemplateNodeUserTaskService;
    @Autowired
    private ProcessTemplateNodeAssigneeService processTemplateNodeAssigneeService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private ProcessTaskService processTaskService;
    @Autowired
    private ProcessTemplateService processTemplateService;
    @Autowired
    private TaskMultiCacheVoService taskMultiCacheVoService;
    @Autowired
    private LoginUserService loginUserService;

    public List<ProcessTracingStrategyVo> findProcessTracingByTemplateId(String processTemplateId) {
        Validate.notEmpty((CharSequence)processTemplateId, (String)"\u6a21\u677fid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ArrayList<ProcessTracingStrategyVo> strategyVoList = new ArrayList<ProcessTracingStrategyVo>();
        List<ProcessTemplateNodeUserTaskVo> processTemplateNodeVos = this.processTemplateNodeUserTaskService.findByTemplateId(processTemplateId);
        if (CollectionUtils.isEmpty(processTemplateNodeVos)) {
            return null;
        }
        Map processTemplateNodeVoMap = processTemplateNodeVos.stream().collect(Collectors.toMap(ProcessTemplateNodeUserTaskVo::getNodeId, Function.identity()));
        if (!CollectionUtils.isEmpty(processTemplateNodeVoMap)) {
            List<ProcessTemplateNodeAssigneeVo> processTemplateNodeAssigneeVos = this.processTemplateNodeAssigneeService.findByNodeIds(processTemplateNodeVoMap.keySet());
            if (CollectionUtils.isEmpty(processTemplateNodeAssigneeVos)) {
                return null;
            }
            Map<String, List<ProcessTemplateNodeAssigneeVo>> nodeAssigneeMap = processTemplateNodeAssigneeVos.stream().collect(Collectors.groupingBy(ProcessTemplateNodeAssigneeVo::getNodeId));
            processTemplateNodeVoMap.forEach((k, vo) -> {
                Collection<UserVo> userVos = this.processTaskService.findUserVoByTaskNodeId((String)k, null);
                ProcessTracingStrategyVo processTracingStrategyVo = new ProcessTracingStrategyVo();
                processTracingStrategyVo.setSignType(vo.getSignType());
                if (!CollectionUtils.isEmpty((Collection)vo.getProcessTemplateNodeAssignees())) {
                    Collection processTemplateNodeAssignees = vo.getProcessTemplateNodeAssignees();
                    List<String> collect = processTemplateNodeAssignees.stream().map(ProcessTemplateNodeAssigneeVo::getStrategyName).collect(Collectors.toList());
                    processTracingStrategyVo.setSignConditions(collect);
                }
                processTracingStrategyVo.setUserVos(userVos);
                processTracingStrategyVo.setNodeId((String)k);
                strategyVoList.add(processTracingStrategyVo);
            });
        }
        return strategyVoList;
    }

    public List<ProcessTracingStrategyVo> findProcessTracingAllByTemplateId(String processTemplateId, String processInstanceId) {
        List<ProcessTracingStrategyVo> strategyVos;
        Validate.notNull((Object)processTemplateId, (String)"\u6a21\u677fid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        String account = this.loginUserService.getLoginUser().getAccount();
        if (StringUtils.isBlank((CharSequence)processInstanceId) && !CollectionUtils.isEmpty(strategyVos = this.taskMultiCacheVoService.gets(account + tenantCode + processTemplateId))) {
            return strategyVos;
        }
        ArrayList<ProcessTracingStrategyVo> strategyVoList = new ArrayList<ProcessTracingStrategyVo>();
        List<ProcessTemplateNodeUserTaskVo> processTemplateNodeUserTaskVos = this.processTemplateNodeUserTaskService.findByTemplateId(processTemplateId);
        if (CollectionUtils.isEmpty(processTemplateNodeUserTaskVos)) {
            return new ArrayList<ProcessTracingStrategyVo>();
        }
        List<String> processTemplateNodeIds = processTemplateNodeUserTaskVos.stream().map(ProcessTemplateNodeUserTaskVo::getNodeId).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(processTemplateNodeIds)) {
            return new ArrayList<ProcessTracingStrategyVo>();
        }
        List<ProcessTemplateNodeAssigneeVo> processTemplateNodeAssigneeVos = this.processTemplateNodeAssigneeService.findByNodeIds(processTemplateNodeIds);
        if (CollectionUtils.isEmpty(processTemplateNodeAssigneeVos)) {
            return new ArrayList<ProcessTracingStrategyVo>();
        }
        Map<String, List<ProcessTemplateNodeAssigneeVo>> nodeAssigneeMap = processTemplateNodeAssigneeVos.stream().collect(Collectors.groupingBy(ProcessTemplateNodeAssigneeVo::getNodeId));
        String processDefinitionId = this.processTemplateService.findById(processTemplateId).getProcessDefinitionId();
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinitionId);
        Collection flowElements = bpmnModel.getMainProcess().getFlowElements();
        processTemplateNodeUserTaskVos.forEach(processTemplateNodeUserTaskVo -> {
            Set<UserVo> userVos = this.processTaskService.findUserVoAllByTaskNodeId(processTemplateNodeUserTaskVo.getNodeId(), flowElements, processInstanceId);
            ProcessTracingStrategyVo processTracingStrategyVo = new ProcessTracingStrategyVo();
            processTracingStrategyVo.setSignType(processTemplateNodeUserTaskVo.getSignType());
            if (!CollectionUtils.isEmpty((Collection)((Collection)nodeAssigneeMap.get(processTemplateNodeUserTaskVo.getNodeId())))) {
                List<String> collect = ((List)nodeAssigneeMap.get(processTemplateNodeUserTaskVo.getNodeId())).stream().map(ProcessTemplateNodeAssigneeVo::getStrategyName).collect(Collectors.toList());
                processTracingStrategyVo.setSignConditions(collect);
            }
            processTracingStrategyVo.setUserVos(userVos);
            processTracingStrategyVo.setNodeId(processTemplateNodeUserTaskVo.getNodeId());
            strategyVoList.add(processTracingStrategyVo);
        });
        if (!CollectionUtils.isEmpty(strategyVoList) && StringUtils.isBlank((CharSequence)processInstanceId)) {
            this.taskMultiCacheVoService.sets(account + tenantCode + processTemplateId, strategyVoList);
        }
        return strategyVoList;
    }

    @Override
    public List<?> findProcessTracingsByTemplateId(String processTemplateId) {
        Validate.notNull((Object)processTemplateId, (String)"\u67e5\u8be2\u6d41\u7a0b\u6a21\u677f\u5bfb\u4eba\u7ed3\u679c\u65f6\uff0c\u6a21\u677fid\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        ProcessTemplate processTemplate = this.processTemplateService.findById(processTemplateId);
        Validate.notNull((Object)((Object)processTemplate), (String)"\u672a\u5339\u914d\u5230\u5bf9\u5e94\u5f97\u6d41\u7a0b\u6a21\u677f\uff01", (Object[])new Object[0]);
        String processDefinitionId = processTemplate.getProcessDefinitionId();
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinitionId);
        Validate.notNull((Object)bpmnModel, (String)"\u5f53\u524d\u6a21\u677f\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        Collection flowElements = bpmnModel.getMainProcess().getFlowElements();
        ArrayList<UserTask> previousElements = new ArrayList<UserTask>();
        ArrayList<ProcessPreExecutionLogVo> preExecutionLogVos = new ArrayList<ProcessPreExecutionLogVo>();
        if (CollectionUtils.isEmpty((Collection)flowElements)) {
            return new ArrayList();
        }
        block0: for (FlowElement flowElement : flowElements) {
            if (!(flowElement instanceof StartEvent)) continue;
            List outgoingFlows = ((StartEvent)flowElement).getOutgoingFlows();
            for (SequenceFlow outgoingFlow : outgoingFlows) {
                List<UserTask> userTasks;
                FlowElement targetFlowElement = outgoingFlow.getTargetFlowElement();
                if (targetFlowElement instanceof UserTask) {
                    previousElements.add((UserTask)targetFlowElement);
                    userTasks = this.findUserTasksByUserTask((UserTask)targetFlowElement);
                    previousElements.addAll(userTasks);
                    continue block0;
                }
                if (targetFlowElement instanceof ExclusiveGateway) {
                    userTasks = this.findUserTasksByExclusiveGateway((ExclusiveGateway)targetFlowElement);
                    previousElements.addAll(userTasks);
                    continue block0;
                }
                if (targetFlowElement instanceof InclusiveGateway) {
                    userTasks = this.findUserTasksByInclusiveGateway((InclusiveGateway)targetFlowElement);
                    previousElements.addAll(userTasks);
                    continue block0;
                }
                if (!(targetFlowElement instanceof ServiceTask)) continue;
                userTasks = this.findUserTasksByServiceTask((ServiceTask)targetFlowElement);
                previousElements.addAll(userTasks);
                continue block0;
            }
        }
        previousElements.removeAll(Collections.singleton(null));
        Collections.reverse(previousElements);
        List result = previousElements.stream().distinct().collect(Collectors.toList());
        Collections.reverse(result);
        for (int i = 0; i < result.size(); ++i) {
            ProcessPreExecutionLogVo processPreExecutionLogVo = new ProcessPreExecutionLogVo();
            processPreExecutionLogVo.setNodeName(((UserTask)result.get(i)).getName());
            processPreExecutionLogVo.setTaskDefinitionKey(((UserTask)result.get(i)).getId());
            processPreExecutionLogVo.setSort(i);
            preExecutionLogVos.add(processPreExecutionLogVo);
        }
        return preExecutionLogVos;
    }

    private List<UserTask> findUserTasksByServiceTask(ServiceTask serviceTask) {
        ArrayList<UserTask> itemList = new ArrayList<UserTask>();
        List outgoingFlows = serviceTask.getOutgoingFlows();
        for (SequenceFlow outgoingFlow : outgoingFlows) {
            List<UserTask> userTasks;
            FlowElement targetFlowElement = outgoingFlow.getTargetFlowElement();
            if (targetFlowElement instanceof UserTask) {
                itemList.add((UserTask)targetFlowElement);
                userTasks = this.findUserTasksByUserTask((UserTask)targetFlowElement);
                itemList.addAll(userTasks);
                continue;
            }
            if (targetFlowElement instanceof ExclusiveGateway) {
                userTasks = this.findUserTasksByExclusiveGateway((ExclusiveGateway)targetFlowElement);
                itemList.addAll(userTasks);
                continue;
            }
            if (targetFlowElement instanceof InclusiveGateway) {
                userTasks = this.findUserTasksByInclusiveGateway((InclusiveGateway)targetFlowElement);
                itemList.addAll(userTasks);
                continue;
            }
            if (!(targetFlowElement instanceof ServiceTask)) continue;
            userTasks = this.findUserTasksByServiceTask((ServiceTask)targetFlowElement);
            itemList.addAll(userTasks);
        }
        return itemList;
    }

    private List<UserTask> findUserTasksByUserTask(UserTask userTask) {
        ArrayList<UserTask> itemList = new ArrayList<UserTask>();
        List outgoingFlows = userTask.getOutgoingFlows();
        for (SequenceFlow outgoingFlow : outgoingFlows) {
            List<UserTask> userTasks;
            FlowElement targetFlowElement = outgoingFlow.getTargetFlowElement();
            if (targetFlowElement instanceof UserTask) {
                itemList.add((UserTask)targetFlowElement);
                userTasks = this.findUserTasksByUserTask((UserTask)targetFlowElement);
                itemList.addAll(userTasks);
                continue;
            }
            if (targetFlowElement instanceof ExclusiveGateway) {
                userTasks = this.findUserTasksByExclusiveGateway((ExclusiveGateway)targetFlowElement);
                itemList.addAll(userTasks);
                continue;
            }
            if (targetFlowElement instanceof InclusiveGateway) {
                userTasks = this.findUserTasksByInclusiveGateway((InclusiveGateway)targetFlowElement);
                itemList.addAll(userTasks);
                continue;
            }
            if (!(targetFlowElement instanceof ServiceTask)) continue;
            userTasks = this.findUserTasksByServiceTask((ServiceTask)targetFlowElement);
            itemList.addAll(userTasks);
        }
        return itemList;
    }

    private List<UserTask> findUserTasksByInclusiveGateway(InclusiveGateway inclusiveGateway) {
        ArrayList<UserTask> itemList = new ArrayList<UserTask>();
        List outgoingFlows = inclusiveGateway.getOutgoingFlows();
        for (SequenceFlow outgoingFlow : outgoingFlows) {
            List<UserTask> userTasks;
            FlowElement targetFlowElement = outgoingFlow.getTargetFlowElement();
            if (targetFlowElement instanceof UserTask) {
                itemList.add((UserTask)targetFlowElement);
                userTasks = this.findUserTasksByUserTask((UserTask)targetFlowElement);
                itemList.addAll(userTasks);
                continue;
            }
            if (targetFlowElement instanceof ExclusiveGateway) {
                userTasks = this.findUserTasksByExclusiveGateway((ExclusiveGateway)targetFlowElement);
                itemList.addAll(userTasks);
                continue;
            }
            if (targetFlowElement instanceof InclusiveGateway) {
                userTasks = this.findUserTasksByInclusiveGateway((InclusiveGateway)targetFlowElement);
                itemList.addAll(userTasks);
                continue;
            }
            if (!(targetFlowElement instanceof ServiceTask)) continue;
            userTasks = this.findUserTasksByServiceTask((ServiceTask)targetFlowElement);
            itemList.addAll(userTasks);
        }
        return itemList;
    }

    private List<UserTask> findUserTasksByExclusiveGateway(ExclusiveGateway exclusiveGateway) {
        ArrayList<UserTask> itemList = new ArrayList<UserTask>();
        List outgoingFlows = exclusiveGateway.getOutgoingFlows();
        for (SequenceFlow outgoingFlow : outgoingFlows) {
            List<UserTask> userTasks;
            FlowElement targetFlowElement = outgoingFlow.getTargetFlowElement();
            if (targetFlowElement instanceof UserTask) {
                itemList.add((UserTask)targetFlowElement);
                userTasks = this.findUserTasksByUserTask((UserTask)targetFlowElement);
                itemList.addAll(userTasks);
                continue;
            }
            if (targetFlowElement instanceof ExclusiveGateway) {
                userTasks = this.findUserTasksByExclusiveGateway((ExclusiveGateway)targetFlowElement);
                itemList.addAll(userTasks);
                continue;
            }
            if (targetFlowElement instanceof InclusiveGateway) {
                userTasks = this.findUserTasksByInclusiveGateway((InclusiveGateway)targetFlowElement);
                itemList.addAll(userTasks);
                continue;
            }
            if (!(targetFlowElement instanceof ServiceTask)) continue;
            userTasks = this.findUserTasksByServiceTask((ServiceTask)targetFlowElement);
            itemList.addAll(userTasks);
        }
        return itemList;
    }
}

