/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.service.internal;

import com.biz.crm.workflow.sdk.service.ProcessTemplateNodeService;
import com.biz.crm.workflow.sdk.service.ServiceTaskService;
import com.biz.crm.workflow.sdk.service.process.ProcessNode;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateNodeVo;
import java.util.List;
import java.util.Objects;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.flowable.engine.delegate.DelegateExecution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="serviceTaskService")
public class ServiceTaskServiceImpl
implements ServiceTaskService {
    private static final Logger log = LoggerFactory.getLogger(ServiceTaskServiceImpl.class);
    @Autowired(required=false)
    private List<ProcessNode> processNodes;
    @Autowired
    private ProcessTemplateNodeService processTemplateNodeService;

    @Transactional
    public void execute(DelegateExecution delegateExecution) {
        String strategyCode;
        if (CollectionUtils.isEmpty(this.processNodes)) {
            return;
        }
        String taskDefinitionKey = delegateExecution.getCurrentActivityId();
        String processDefinitionId = delegateExecution.getProcessDefinitionId();
        ProcessTemplateNodeVo processTemplateNodeVo = this.processTemplateNodeService.findByProcessInstanceIdAndTaskDefinitionKey(delegateExecution.getProcessInstanceId(), taskDefinitionKey);
        if (Objects.isNull(processTemplateNodeVo)) {
            processTemplateNodeVo = this.processTemplateNodeService.findByProcessDefinitionIdAndTaskDefinitionKey(processDefinitionId, taskDefinitionKey);
        }
        if (StringUtils.isNotBlank((CharSequence)(strategyCode = processTemplateNodeVo.getCode()))) {
            ProcessNode processNode = this.processNodes.stream().filter(item -> strategyCode.equals(item.getCode())).findFirst().orElse(null);
            Validate.notNull((Object)processNode, (String)"\u8282\u70b9\u7b56\u7565\u7f16\u53f7[%s]\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{strategyCode});
            processNode.autoExecute(delegateExecution);
        }
    }
}

