/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.service.process.group;

import com.biz.crm.workflow.sdk.enums.EffectiveScopeEnum;
import com.biz.crm.workflow.sdk.service.process.ProcessNode;
import com.biz.crm.workflow.sdk.service.process.ProcessNodeGroup;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.util.CollectionUtils;

public class TaskProcessNodeGroup
implements ProcessNodeGroup {
    private static final Logger log = LoggerFactory.getLogger(TaskProcessNodeGroup.class);
    private List<ProcessNode> processNodes;
    private List<Class<? extends ProcessNode>> processNodeClasses;
    @Autowired(required=false)
    private ApplicationContext ac;

    public boolean getDisplay() {
        return true;
    }

    public String getGroupCode() {
        return this.getClass().getSimpleName();
    }

    public TaskProcessNodeGroup(Class<? extends ProcessNode> ... processNodes) {
        this.processNodeClasses = Lists.newArrayList((Object[])processNodes);
    }

    public String getGroupName() {
        return "\u4efb\u52a1\u5143\u4ef6";
    }

    public Collection<ProcessNode> getProcessNodes() {
        if (CollectionUtils.isEmpty(this.processNodes)) {
            this.processNodes = Lists.newArrayList();
            this.processNodeClasses.forEach(clazz -> {
                ProcessNode processNode = (ProcessNode)this.ac.getBean(clazz);
                this.processNodes.add(processNode);
            });
        }
        return this.processNodes;
    }

    public String getProcessNodeType() {
        return EffectiveScopeEnum.ALL.getDictCode();
    }
}

