/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.service.process.node.event;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.workflow.local.entity.ProcessTemplateNodeEndTask;
import com.biz.crm.workflow.local.service.ProcessCopyConfigService;
import com.biz.crm.workflow.local.service.ProcessTaskCopyStrategyService;
import com.biz.crm.workflow.local.service.ProcessTemplateNodeEndTaskService;
import com.biz.crm.workflow.local.service.process.node.event.AbstractEventProcessNode;
import com.biz.crm.workflow.sdk.dto.ProcessTemplateNodeDto;
import com.biz.crm.workflow.sdk.dto.ProcessTemplateNodeEndTaskDto;
import com.biz.crm.workflow.sdk.enums.EffectiveScopeEnum;
import com.biz.crm.workflow.sdk.enums.ProcessCopyEnum;
import com.biz.crm.workflow.sdk.vo.ProcessTaskCopyConfigVo;
import com.biz.crm.workflow.sdk.vo.ProcessTaskCopyStrategyVo;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateNodeEndTaskVo;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateNodeVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.transaction.Transactional;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class EndProcessNode
extends AbstractEventProcessNode {
    @Autowired
    private ProcessCopyConfigService processCopyConfigService;
    @Autowired
    private ProcessTaskCopyStrategyService processTaskCopyStrategyService;
    @Autowired
    private ProcessTemplateNodeEndTaskService processTemplateNodeEndTaskService;

    @Override
    public final String getXmlElement() {
        return "endEvent";
    }

    public String getCode() {
        return this.getClass().getSimpleName();
    }

    @Override
    public String getLabel() {
        return "\u7ed3\u675f";
    }

    @Override
    public String getVarName() {
        return "endTask";
    }

    @Override
    @Transactional
    public void onSaveHandle(ProcessTemplateNodeDto nodeDto) {
        JSONObject data = this.getData(nodeDto);
        ProcessTemplateNodeEndTaskDto dto = (ProcessTemplateNodeEndTaskDto)JSON.toJavaObject((JSON)data, ProcessTemplateNodeEndTaskDto.class);
        dto.setNodeId(nodeDto.getId());
        dto.setTemplateId(nodeDto.getTemplateId());
        String tenantCode = TenantUtils.getTenantCode();
        this.processTemplateNodeEndTaskService.create(dto);
        if (Objects.equals(dto.getCopyOptional(), ProcessCopyEnum.COPY_OPTIONAL.getDictCode()) || StringUtils.isBlank((CharSequence)dto.getCopyOptional())) {
            if (!CollectionUtils.isEmpty((Collection)dto.getProcessTaskCopyConfigs())) {
                dto.getProcessTaskCopyConfigs().forEach(item -> {
                    item.setTaskNodeId(nodeDto.getId());
                    item.setTenantCode(tenantCode);
                });
                this.processCopyConfigService.createBatch(dto.getProcessTaskCopyConfigs());
            }
        } else if (!CollectionUtils.isEmpty((Collection)dto.getProcessTaskCopyStrategy())) {
            dto.getProcessTaskCopyStrategy().forEach(item -> {
                item.setNodeId(nodeDto.getId());
                item.setTemplateId(nodeDto.getTemplateId());
                item.setTenantCode(tenantCode);
            });
            this.processTaskCopyStrategyService.createBatch(dto.getProcessTaskCopyStrategy());
        }
    }

    @Override
    public void onRequestHandle(ProcessTemplateNodeVo nodeVo) {
        String nodeId = nodeVo.getId();
        List<ProcessTaskCopyConfigVo> processTaskCopyConfigVos = this.processCopyConfigService.findByNodeId(nodeId);
        Collection<ProcessTaskCopyStrategyVo> processTaskCopyStrategyVos = this.processTaskCopyStrategyService.findByNodeId(nodeId);
        ProcessTemplateNodeEndTask processTemplateNodeEndTask = this.processTemplateNodeEndTaskService.findByNodeId(nodeId);
        ProcessTemplateNodeEndTaskVo processTemplateNodeEndTaskVo = new ProcessTemplateNodeEndTaskVo();
        processTemplateNodeEndTaskVo.setNodeId(nodeVo.getId());
        processTemplateNodeEndTaskVo.setProcessTaskCopyConfigs(processTaskCopyConfigVos);
        processTemplateNodeEndTaskVo.setTenantCode(nodeVo.getTenantCode());
        processTemplateNodeEndTaskVo.setProcessTaskCopyStrategy(processTaskCopyStrategyVos);
        if (ObjectUtils.isNotEmpty((Object)((Object)processTemplateNodeEndTask))) {
            processTemplateNodeEndTaskVo.setCopyOptional(processTemplateNodeEndTask.getCopyOptional());
        }
        if (!CollectionUtils.isEmpty(processTaskCopyConfigVos)) {
            processTemplateNodeEndTaskVo.setCopyOptional(ProcessCopyEnum.COPY_OPTIONAL.getDictCode());
        }
        this.setData(nodeVo, processTemplateNodeEndTaskVo);
    }

    public String getProcessNodeType() {
        return EffectiveScopeEnum.ALL.getDictCode();
    }

    @Override
    @Transactional
    public void onRemoveHandle(String nodeId) {
        this.processCopyConfigService.deleteByNodeIds(Lists.newArrayList((Object[])new String[]{nodeId}));
        this.processTaskCopyStrategyService.deleteByNodeIds(Lists.newArrayList((Object[])new String[]{nodeId}));
        this.processTemplateNodeEndTaskService.deleteByNodeIds(Lists.newArrayList((Object[])new String[]{nodeId}));
    }
}

