/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.service.process.node.other;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.workflow.local.service.ProcessTemplateNodeExtensionFieldService;
import com.biz.crm.workflow.local.service.process.node.other.AbstractSequenceProcessNode;
import com.biz.crm.workflow.sdk.dto.ProcessTemplateNodeDto;
import com.biz.crm.workflow.sdk.dto.ProcessTemplateNodeExtensionFieldDto;
import com.biz.crm.workflow.sdk.enums.EffectiveScopeEnum;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateNodeExtensionFieldVo;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateNodeVo;
import com.google.common.collect.Lists;
import java.util.Objects;
import javax.transaction.Transactional;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SequenceProcessNode
extends AbstractSequenceProcessNode {
    @Autowired
    private ProcessTemplateNodeExtensionFieldService processTemplateNodeExtensionFieldService;

    public String getCode() {
        return this.getClass().getSimpleName();
    }

    public String getProcessNodeType() {
        return EffectiveScopeEnum.ALL.getDictCode();
    }

    @Override
    public String getVarName() {
        return "sequenceCondition";
    }

    @Override
    @Transactional
    public void onSaveHandle(ProcessTemplateNodeDto nodeDto) {
        Validate.notNull((Object)nodeDto, (String)"\u8282\u70b9\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        if (ObjectUtils.isEmpty((Object)nodeDto.getAttributes())) {
            return;
        }
        JSONObject data = nodeDto.getAttributes().getJSONObject(this.getVarName());
        if (Objects.nonNull(data)) {
            ProcessTemplateNodeExtensionFieldDto dto = (ProcessTemplateNodeExtensionFieldDto)JSON.toJavaObject((JSON)data, ProcessTemplateNodeExtensionFieldDto.class);
            dto.setTemplateId(nodeDto.getTemplateId());
            dto.setNodeId(nodeDto.getId());
            dto.setId(null);
            this.processTemplateNodeExtensionFieldService.create(dto);
        }
    }

    @Override
    @Transactional
    public void onRemoveHandle(String nodeId) {
        this.processTemplateNodeExtensionFieldService.deleteByNodeIds(Lists.newArrayList((Object[])new String[]{nodeId}));
    }

    @Override
    public void onRequestHandle(ProcessTemplateNodeVo nodeVo) {
        String nodeId = nodeVo.getId();
        ProcessTemplateNodeExtensionFieldVo processTemplateNodeExtensionFieldVo = this.processTemplateNodeExtensionFieldService.findByNodeId(nodeId);
        this.setData(nodeVo, processTemplateNodeExtensionFieldVo);
    }
}

