/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.service.process.node.task;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.workflow.local.service.EmailService;
import com.biz.crm.workflow.local.service.ProcessTemplateNodeEmailService;
import com.biz.crm.workflow.local.service.process.node.task.AbstractServiceTaskProcessNode;
import com.biz.crm.workflow.sdk.dto.ProcessTemplateNodeDto;
import com.biz.crm.workflow.sdk.dto.ProcessTemplateNodeEmailDto;
import com.biz.crm.workflow.sdk.enums.EffectiveScopeEnum;
import com.biz.crm.workflow.sdk.service.ProcessTemplateNodeService;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateNodeEmailVo;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateNodeVo;
import java.util.Collection;
import java.util.Objects;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.flowable.engine.TaskService;
import org.flowable.engine.delegate.DelegateExecution;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EmailProcessNode
extends AbstractServiceTaskProcessNode {
    @Autowired
    private ProcessTemplateNodeEmailService processTemplateNodeEmailService;
    @Autowired
    private ProcessTemplateNodeService processTemplateNodeService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private EmailService emailService;
    private static final String EMAIL_SPITE = ";";

    @Override
    public String getType() {
        return "email";
    }

    public String getCode() {
        return this.getClass().getSimpleName();
    }

    @Override
    public String getLabel() {
        return "\u90ae\u4ef6\u4efb\u52a1";
    }

    @Override
    public String getVarName() {
        return "emailTask";
    }

    @Override
    @Transactional
    public void onSaveHandle(ProcessTemplateNodeDto nodeDto) {
        JSONObject data = this.getData(nodeDto);
        ProcessTemplateNodeEmailDto dto = (ProcessTemplateNodeEmailDto)JSON.toJavaObject((JSON)data, ProcessTemplateNodeEmailDto.class);
        dto.setTemplateId(nodeDto.getTemplateId());
        dto.setNodeId(nodeDto.getId());
        dto.setId(null);
        this.processTemplateNodeEmailService.create(dto);
    }

    @Transactional
    public void onRemoveHandle(String nodeId) {
        this.processTemplateNodeEmailService.deleteByNodeId(nodeId);
    }

    public void onRequestHandle(ProcessTemplateNodeVo nodeVo) {
        String nodeId = nodeVo.getId();
        ProcessTemplateNodeEmailVo processTemplateNodeEmailVo = this.processTemplateNodeEmailService.findByNodeId(nodeId);
        this.setData(nodeVo, processTemplateNodeEmailVo);
    }

    @Transactional
    public void autoExecute(DelegateExecution delegateExecution) {
        String processDefinitionId = delegateExecution.getProcessDefinitionId();
        String taskDefinitionKey = delegateExecution.getCurrentActivityId();
        ProcessTemplateNodeVo processTemplateNodeVo = this.processTemplateNodeService.findByProcessInstanceIdAndTaskDefinitionKey(delegateExecution.getProcessInstanceId(), taskDefinitionKey);
        if (Objects.isNull(processTemplateNodeVo)) {
            processTemplateNodeVo = this.processTemplateNodeService.findByProcessDefinitionIdAndTaskDefinitionKey(processDefinitionId, taskDefinitionKey);
        }
        Validate.notNull((Object)processTemplateNodeVo, (String)"\u90ae\u4ef6\u8282\u70b9\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        ProcessTemplateNodeEmailVo processTemplateNodeEmailVo = this.processTemplateNodeEmailService.findByNodeId(processTemplateNodeVo.getId());
        Collection processTemplateNodeEmailFilesVos = processTemplateNodeEmailVo.getProcessTemplateNodeEmailFiles();
        String from = processTemplateNodeEmailVo.getFromUser();
        String content = processTemplateNodeEmailVo.getContent();
        String subject = processTemplateNodeEmailVo.getSubject();
        String toStr = processTemplateNodeEmailVo.getToUser();
        String ccStr = processTemplateNodeEmailVo.getCcUser();
        String[] to = StringUtils.split((String)toStr, (String)EMAIL_SPITE);
        String[] cc = StringUtils.split((String)ccStr, (String)EMAIL_SPITE);
        this.emailService.sendMail(from, to, cc, subject, content, processTemplateNodeEmailFilesVos);
    }

    public String getProcessNodeType() {
        return EffectiveScopeEnum.ALL.getDictCode();
    }
}

