/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.service.process.node.task;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.workflow.local.service.ProcessTemplateNodeSmsService;
import com.biz.crm.workflow.local.service.process.node.task.AbstractServiceTaskProcessNode;
import com.biz.crm.workflow.sdk.constant.ProcessConstant;
import com.biz.crm.workflow.sdk.dto.ProcessInstanceDto;
import com.biz.crm.workflow.sdk.dto.ProcessTemplateNodeDto;
import com.biz.crm.workflow.sdk.dto.ProcessTemplateNodeSmsDto;
import com.biz.crm.workflow.sdk.enums.EffectiveScopeEnum;
import com.biz.crm.workflow.sdk.register.ProcessTemplateRegister;
import com.biz.crm.workflow.sdk.service.ProcessTemplateNodeService;
import com.biz.crm.workflow.sdk.strategy.sms.SmsStrategy;
import com.biz.crm.workflow.sdk.strategy.sms.SmsToUserStrategy;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateNodeSmsVo;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateNodeVo;
import com.bizunited.nebula.common.util.JsonUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.flowable.engine.delegate.DelegateExecution;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class SmsProcessNode
extends AbstractServiceTaskProcessNode {
    @Autowired
    private ProcessTemplateNodeSmsService processTemplateNodeSmsService;
    @Autowired
    private ProcessTemplateRegister processTemplateRegister;
    @Autowired
    private ProcessTemplateNodeService processTemplateNodeService;
    @Autowired(required=false)
    private ApplicationContext ac;

    @Override
    public String getType() {
        return "sms";
    }

    public String getCode() {
        return this.getClass().getSimpleName();
    }

    @Override
    public String getLabel() {
        return "\u77ed\u4fe1\u4efb\u52a1";
    }

    @Override
    public String getVarName() {
        return "smsTask";
    }

    @Override
    public void onSaveHandle(ProcessTemplateNodeDto nodeDto) {
        JSONObject data = this.getData(nodeDto);
        ProcessTemplateNodeSmsDto dto = (ProcessTemplateNodeSmsDto)JSON.toJavaObject((JSON)data, ProcessTemplateNodeSmsDto.class);
        dto.setTemplateId(nodeDto.getTemplateId());
        dto.setNodeId(nodeDto.getId());
        dto.setId(null);
        this.processTemplateNodeSmsService.create(dto);
    }

    public void onRemoveHandle(String nodeId) {
        this.processTemplateNodeSmsService.deleteByNodeId(nodeId);
    }

    public void onRequestHandle(ProcessTemplateNodeVo nodeVo) {
        String nodeId = nodeVo.getId();
        ProcessTemplateNodeSmsVo processTemplateNodeEmailVo = this.processTemplateNodeSmsService.findByNodeId(nodeId);
        this.setData(nodeVo, processTemplateNodeEmailVo);
    }

    public void autoExecute(DelegateExecution delegateExecution) {
        String toUserType;
        SmsToUserStrategy smsToUserStrategy;
        Set smsPhone;
        String processDefinitionId = delegateExecution.getProcessDefinitionId();
        String taskDefinitionKey = delegateExecution.getCurrentActivityId();
        ProcessInstanceDto processInstanceDto = (ProcessInstanceDto)delegateExecution.getVariable(ProcessConstant.PROCESS_INSTANCE_PARAM_CODE);
        if (ObjectUtils.isEmpty((Object)processInstanceDto) || StringUtils.isBlank((CharSequence)processInstanceDto.getFormData())) {
            return;
        }
        ProcessTemplateNodeVo processTemplateNodeVo = this.processTemplateNodeService.findByProcessInstanceIdAndTaskDefinitionKey(delegateExecution.getProcessInstanceId(), taskDefinitionKey);
        if (Objects.isNull(processTemplateNodeVo)) {
            processTemplateNodeVo = this.processTemplateNodeService.findByProcessDefinitionIdAndTaskDefinitionKey(processDefinitionId, taskDefinitionKey);
        }
        Validate.notNull((Object)processTemplateNodeVo, (String)"\u77ed\u4fe1\u8282\u70b9\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        ProcessTemplateNodeSmsVo processTemplateNodeSmsVo = this.processTemplateNodeSmsService.findByNodeId(processTemplateNodeVo.getId());
        if (Objects.nonNull(processTemplateNodeSmsVo) && !CollectionUtils.isEmpty((Collection)(smsPhone = (smsToUserStrategy = this.getSmsToUserStrategy(toUserType = processTemplateNodeSmsVo.getToUserType())).getSmsPhone(processTemplateNodeSmsVo.getProcessTemplateNodeSmsUsers())))) {
            SmsStrategy smsStrategy = this.getSmsStrategy();
            String smsTemplateCode = processTemplateNodeSmsVo.getSmsTemplateCode();
            JSONObject jsonObject = JSON.parseObject((String)processInstanceDto.getFormData());
            String sendContent = this.getSendContent(processTemplateNodeSmsVo, jsonObject);
            smsPhone.forEach(phone -> smsStrategy.sendSms(phone, smsTemplateCode, sendContent));
        }
    }

    public String getProcessNodeType() {
        return EffectiveScopeEnum.ALL.getDictCode();
    }

    private SmsStrategy getSmsStrategy() {
        Class smsStrategyStrategies = this.processTemplateRegister.getSmsStrategyStrategies();
        Validate.notNull((Object)smsStrategyStrategies, (String)"\u6d41\u7a0b\u6a21\u677f\u4e2d\u4e0d\u5b58\u5728\u77ed\u4fe1\u5e73\u53f0\u7b56\u7565\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01", (Object[])new Object[0]);
        SmsStrategy smsStrategy = (SmsStrategy)this.ac.getBean(smsStrategyStrategies);
        return smsStrategy;
    }

    private SmsToUserStrategy getSmsToUserStrategy(String toUserType) {
        Collection smsToUserStrategies = this.processTemplateRegister.getSmsToUserStrategies();
        Validate.notNull((Object)(!CollectionUtils.isEmpty((Collection)smsToUserStrategies) ? 1 : 0), (String)"\u6d41\u7a0b\u6a21\u677f\u4e2d\u4e0d\u5b58\u5728\u77ed\u4fe1\u5e73\u53f0\u6536\u4ef6\u4eba\u7b56\u7565\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01", (Object[])new Object[0]);
        ArrayList smsToUserStrategyArrayList = Lists.newArrayList();
        smsToUserStrategies.forEach(clazz -> {
            SmsToUserStrategy smsToUserStrategy = (SmsToUserStrategy)this.ac.getBean(clazz);
            if (smsToUserStrategy.getSmsToUserTypeCode().equals(toUserType)) {
                smsToUserStrategyArrayList.add(smsToUserStrategy);
            }
        });
        return (SmsToUserStrategy)smsToUserStrategyArrayList.get(0);
    }

    private String getSendContent(ProcessTemplateNodeSmsVo processTemplateNodeSmsVo, JSONObject businessJson) {
        Validate.notNull((Object)businessJson, (String)"\u53d1\u9001\u77ed\u4fe1\u65f6\uff0c\u4e1a\u52a1\u6570\u636e\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        String contentJsonStr = processTemplateNodeSmsVo.getContentJsonStr();
        if (StringUtils.isEmpty((CharSequence)contentJsonStr)) {
            return null;
        }
        JSONObject jsonObject = JsonUtils.toJSONObject((Object)contentJsonStr);
        JSONObject sendJson = new JSONObject();
        for (String key : jsonObject.keySet()) {
            String oldValue = (String)jsonObject.get((Object)key);
            String[] businessCodes = oldValue.split(",");
            StringBuilder value = new StringBuilder();
            for (String businessCode : businessCodes) {
                Validate.notBlank((CharSequence)businessCode, (String)"\u6d41\u7a0b\u6a21\u677f\u77ed\u4fe1\u914d\u7f6e,\u53d8\u91cf\u4e3a\u7a7a\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
                String businessValue = StringUtils.isNotBlank((CharSequence)((String)businessJson.get((Object)businessCode))) ? (String)businessJson.get((Object)businessCode) : businessCode;
                value.append(businessValue);
            }
            sendJson.put(key, (Object)value);
        }
        return sendJson.toString();
    }
}

