/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.service.process.node.task;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.workflow.local.service.ProcessTemplateNodeUserTaskService;
import com.biz.crm.workflow.local.service.process.node.task.AbstractTaskProcessNode;
import com.biz.crm.workflow.sdk.dto.ProcessTemplateNodeDto;
import com.biz.crm.workflow.sdk.dto.ProcessTemplateNodeUserTaskDto;
import com.biz.crm.workflow.sdk.enums.EffectiveScopeEnum;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateNodeUserTaskVo;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateNodeVo;
import com.google.common.collect.Lists;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserTaskProcessNode
extends AbstractTaskProcessNode {
    @Autowired
    private ProcessTemplateNodeUserTaskService processTemplateNodeUserTaskService;

    @Override
    public final String getXmlElement() {
        return "userTask";
    }

    public String getCode() {
        return this.getClass().getSimpleName();
    }

    @Override
    public String getLabel() {
        return "\u7528\u6237\u4efb\u52a1";
    }

    @Override
    public String getVarName() {
        return "userTask";
    }

    @Transactional
    public void onSaveHandle(ProcessTemplateNodeDto nodeDto) {
        JSONObject data = this.getData(nodeDto);
        ProcessTemplateNodeUserTaskDto dto = (ProcessTemplateNodeUserTaskDto)JSON.toJavaObject((JSON)data, ProcessTemplateNodeUserTaskDto.class);
        dto.setTemplateId(nodeDto.getTemplateId());
        dto.setNodeId(nodeDto.getId());
        dto.setId(null);
        this.processTemplateNodeUserTaskService.create(dto);
    }

    @Transactional
    public void onRemoveHandle(String nodeId) {
        this.processTemplateNodeUserTaskService.deleteByNodeIds(Lists.newArrayList((Object[])new String[]{nodeId}));
    }

    public void onRequestHandle(ProcessTemplateNodeVo nodeVo) {
        String nodeId = nodeVo.getId();
        ProcessTemplateNodeUserTaskVo userTaskVo = this.processTemplateNodeUserTaskService.findByNodeId(nodeId);
        this.setData(nodeVo, userTaskVo);
    }

    public String getProcessNodeType() {
        return EffectiveScopeEnum.ALL.getDictCode();
    }
}

