/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.strategy.button;

import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.workflow.local.dto.ProcessTaskLogDto;
import com.biz.crm.workflow.local.service.ProcessTaskCommunicateService;
import com.biz.crm.workflow.local.strategy.button.AbstractLogButtonStrategy;
import com.biz.crm.workflow.sdk.constant.ProcessConstant;
import com.biz.crm.workflow.sdk.dto.TaskDto;
import com.biz.crm.workflow.sdk.enums.EffectiveScopeEnum;
import com.biz.crm.workflow.sdk.enums.ProcessCommunicateStatusEnum;
import com.biz.crm.workflow.sdk.enums.ProcessOperateTypeEnum;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.vo.ProcessTaskCommunicateVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import java.util.List;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.flowable.engine.TaskService;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ApproveProcessButtonStrategy
extends AbstractLogButtonStrategy {
    @Autowired
    private TaskService taskService;
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private ProcessTaskCommunicateService taskCommunicateService;
    private static final String PROCESS_BUTTON_DESC = "\u5ba1\u6279\u901a\u8fc7";

    public String getProcessButtonCode() {
        return StringUtils.uncapitalize((String)this.getClass().getSimpleName());
    }

    public String getProcessButtonDesc() {
        return PROCESS_BUTTON_DESC;
    }

    public Integer getIndex() {
        return 1;
    }

    @Transactional
    public void handleTask(TaskDto taskDto) {
        ProcessTaskCommunicateVo processTaskCommunicateVo;
        Validate.notNull((Object)taskDto, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)taskDto.getTaskId(), (String)"\u4efb\u52a1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Task task = (Task)((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskTenantId(TenantUtils.getTenantCode())).processInstanceId(taskDto.getProcessInstanceId())).taskId(taskDto.getTaskId())).singleResult();
        Validate.notNull((Object)task, (String)"\u7f16\u53f7[%s]\u4efb\u52a1\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5", (Object[])new Object[]{taskDto.getTaskId()});
        UserIdentity userIdentity = this.loginUserService.getLoginUser();
        Validate.notNull((Object)userIdentity, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)userIdentity.getTenantCode(), (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)userIdentity.getAccount(), (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<ProcessTaskCommunicateVo> processTaskCommunicateVos = this.taskCommunicateService.findByTaskIdAndStatus(task.getId(), ProcessCommunicateStatusEnum.untreated.getKey());
        if (!CollectionUtils.isEmpty(processTaskCommunicateVos) && StringUtils.isNotBlank((CharSequence)(processTaskCommunicateVo = processTaskCommunicateVos.get(0)).getNeedComplete())) {
            Validate.isTrue((boolean)processTaskCommunicateVo.getNeedComplete().equals(EnableStatusEnum.DISABLE.getCode()), (String)"\u5f53\u524d\u4efb\u52a1\u6709\u5f85\u786e\u8ba4\u7684\u6c9f\u901a\u4e8b\u9879", (Object[])new Object[0]);
        }
        String currentUserCode = StringUtils.join((Object[])new String[]{userIdentity.getIdentityType(), ":", userIdentity.getAccount()});
        this.taskService.setVariable(task.getId(), ProcessConstant.PROCESS_INSTANCE_OPERATE_CODE, (Object)ProcessStatusEnum.PASS.getDictCode());
        this.taskService.claim(taskDto.getTaskId(), currentUserCode);
        if (StringUtils.isNotBlank((CharSequence)taskDto.getContent())) {
            this.taskService.addComment(taskDto.getTaskId(), task.getProcessInstanceId(), taskDto.getContent());
        }
        this.taskService.setAssignee(taskDto.getTaskId(), currentUserCode);
        this.taskService.complete(taskDto.getTaskId());
        ProcessTaskLogDto processTaskLogDto = new ProcessTaskLogDto();
        processTaskLogDto.setTaskId(taskDto.getTaskId());
        processTaskLogDto.setProcessInstanceId(taskDto.getProcessInstanceId());
        processTaskLogDto.setOperateType(ProcessOperateTypeEnum.APPROVED.getDictCode());
        processTaskLogDto.setTaskDefinitionKey(task.getTaskDefinitionKey());
        processTaskLogDto.setOperateRemark(taskDto.getContent());
        this.addLog(processTaskLogDto);
    }

    public String getProcessButtonType() {
        return EffectiveScopeEnum.ALL.getDictCode();
    }
}

