/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.strategy.button;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.workflow.local.service.ProcessService;
import com.biz.crm.workflow.local.strategy.button.AbstractLogButtonStrategy;
import com.biz.crm.workflow.sdk.dto.TaskDto;
import com.biz.crm.workflow.sdk.enums.EffectiveScopeEnum;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.flowable.engine.TaskService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class AssigneeProcessButtonStrategy
extends AbstractLogButtonStrategy {
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private ProcessService processService;
    @Autowired
    private TaskService taskService;
    private static final String PROCESS_BUTTON_DESC = "\u8f6c\u529e";

    public String getProcessButtonCode() {
        return StringUtils.uncapitalize((String)this.getClass().getSimpleName());
    }

    public String getProcessButtonDesc() {
        return PROCESS_BUTTON_DESC;
    }

    public Integer getIndex() {
        return 5;
    }

    @Transactional
    public void handleTask(TaskDto taskDto) {
        Validate.notNull((Object)taskDto, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)taskDto.getTaskId(), (String)"\u7f16\u53f7\u4efb\u52a1\u4e3a\u7a7a,\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Validate.notNull((Object)taskDto.getTargetUserName(), (String)"\u76ee\u6807\u8d26\u53f7\u4e3a\u7a7a,\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        UserIdentity userIdentity = this.loginUserService.getLoginUser();
        Validate.notNull((Object)userIdentity, (String)"\u767b\u5f55\u4eba\u4fe1\u606f\uff0c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)userIdentity.getTenantCode(), (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)userIdentity.getAccount(), (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String currentUserCode = StringUtils.join((Object[])new String[]{userIdentity.getIdentityType(), ":", userIdentity.getAccount()});
        Validate.isTrue((!taskDto.getTargetUserName().equals(currentUserCode) ? 1 : 0) != 0, (String)"\u4efb\u52a1\u4eba\u4e0d\u80fd\u8f6c\u529e\u7ed9\u81ea\u5df1", (Object[])new Object[0]);
        this.processService.delegateTask(taskDto);
    }

    public String getProcessButtonType() {
        return EffectiveScopeEnum.ALL.getDictCode();
    }
}

