/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.strategy.button;

import com.biz.crm.workflow.local.dto.ProcessTaskLogDto;
import com.biz.crm.workflow.local.service.ProcessTaskCopyService;
import com.biz.crm.workflow.local.strategy.button.AbstractLogButtonStrategy;
import com.biz.crm.workflow.sdk.dto.TaskDto;
import com.biz.crm.workflow.sdk.enums.EffectiveScopeEnum;
import com.biz.crm.workflow.sdk.enums.ProcessOperateTypeEnum;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.flowable.engine.TaskService;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CopySendProcessButtonStrategy
extends AbstractLogButtonStrategy {
    @Autowired
    private ProcessTaskCopyService processTaskCopyService;
    private static final String PROCESS_BUTTON_DESC = "\u6284\u9001";
    @Autowired
    private TaskService taskService;

    public String getProcessButtonCode() {
        return StringUtils.uncapitalize((String)this.getClass().getSimpleName());
    }

    public String getProcessButtonDesc() {
        return PROCESS_BUTTON_DESC;
    }

    public Integer getIndex() {
        return 6;
    }

    @Transactional
    public void handleTask(TaskDto dto) {
        this.processTaskCopyService.createByTask(dto);
        Task task = (Task)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(dto.getProcessInstanceId())).taskId(dto.getTaskId())).singleResult();
        ProcessTaskLogDto processTaskLogDto = new ProcessTaskLogDto();
        processTaskLogDto.setTaskId(dto.getTaskId());
        processTaskLogDto.setProcessInstanceId(dto.getProcessInstanceId());
        processTaskLogDto.setOperateType(ProcessOperateTypeEnum.COPY_SEND.getDictCode());
        processTaskLogDto.setTaskDefinitionKey(task.getTaskDefinitionKey());
        processTaskLogDto.setOperateRemark(PROCESS_BUTTON_DESC);
        this.addLog(processTaskLogDto);
    }

    public String getProcessButtonType() {
        return EffectiveScopeEnum.ALL.getDictCode();
    }
}

