/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.strategy.button;

import com.biz.crm.workflow.local.dto.ProcessTaskLogDto;
import com.biz.crm.workflow.local.service.ProcessService;
import com.biz.crm.workflow.local.strategy.button.AbstractLogButtonStrategy;
import com.biz.crm.workflow.sdk.dto.TaskDto;
import com.biz.crm.workflow.sdk.enums.EffectiveScopeEnum;
import com.biz.crm.workflow.sdk.enums.ProcessOperateTypeEnum;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.flowable.engine.TaskService;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CountersignProcessButtonStrategy
extends AbstractLogButtonStrategy {
    @Autowired
    private ProcessService processService;
    @Autowired
    private TaskService taskService;
    private static final String PROCESS_BUTTON_DESC = "\u52a0\u7b7e";

    public String getProcessButtonCode() {
        return StringUtils.uncapitalize((String)this.getClass().getSimpleName());
    }

    public String getProcessButtonDesc() {
        return PROCESS_BUTTON_DESC;
    }

    public Integer getIndex() {
        return 5;
    }

    @Transactional
    public void handleTask(TaskDto dto) {
        this.processService.addSignTask(dto.getTaskId(), dto.getPositionCodes());
        Task task = (Task)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(dto.getProcessInstanceId())).taskId(dto.getTaskId())).singleResult();
        ProcessTaskLogDto processTaskLogDto = new ProcessTaskLogDto();
        processTaskLogDto.setTaskId(dto.getTaskId());
        processTaskLogDto.setProcessInstanceId(dto.getProcessInstanceId());
        processTaskLogDto.setOperateType(ProcessOperateTypeEnum.COUNTERSIGN.getDictCode());
        processTaskLogDto.setTaskDefinitionKey(task.getTaskDefinitionKey());
        processTaskLogDto.setOperateRemark("\u5411\u540e\u52a0\u7b7e");
        this.addLog(processTaskLogDto);
    }

    public String getProcessButtonType() {
        return EffectiveScopeEnum.ALL.getDictCode();
    }
}

